(* 

   This is a simple example how to use schoca to read a configuration file.

   The user can interact with the application in two ways:
  
     1) He can set a configuration variable.
     2) He can call a application specific function.

   Both solutions are quite simple with schoca. The best is a
   combination of both methods.


   Given this simple example configuration file:

   (set! foo "bar")
   (call-the-application "Have a nice day!")

   This configuration file sets the predefined variable `foo' to the
   value "bar" and calls the function `call-the-application'.

   At first we define the ocaml-function `scm_call_the_application.

*)

let scm_call_the_application =
  let anwser scm_arg =
    let string_arg = ScmTypes.string_of_datum scm_arg in
      print_endline ("call-the-application was called with the argument '" ^ string_arg ^ "'");
      ScmTypes.Unspecified (* the return value *)
  in ScmEval.simple_cmd_1 anwser

(* 

   The module Eval defines `simple_cmd_1', `simple_cmd_2' and `simple_cmd_3' for
   ML-function with one, two or three parameters. 


   Now  we have to create an environment for the functions and variables.
   Eval.init_environment defines the standard scheme functions like `car' or `+'.
   
*)


let env, ml_foo = 
  let null_env = ScmEval.init_environment () in
  let _ = ScmEval.register_scm_fun null_env "call-the-application" scm_call_the_application in
  let ml_foo = ScmEval.define_scm_var null_env "foo" (ScmTypes.datum_of_int 0) in
      null_env, ml_foo


(*

  Now we can open the configuration file and use the user settings.

*)

let () =
  let file = "simple-conf.scm" in
  let stream = ScmSchoca.scheme_stream_from_channel (open_in file) in
  let _ = ScmSchoca.parse_stream_with_environment env stream in
    print_endline ("foo: "  ^ (ScmTypes.string_of_datum !ml_foo))


(* 

   Quite easy, isn't it?

*)
