/**************************************************************************/
/*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    */
/*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2 of the License, or (at  */
/*  your option) any later version.                                       */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful, but   */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     */
/*  General Public License for more details.                              */
/**************************************************************************/

/* $Id: misc.c 132 2005-08-07 18:05:59Z yori $ */

#include <caml/memory.h>
#include <caml/mlvalues.h>
#include <caml/alloc.h>
#include "chalib.h"
#include "romaji.h"

value caml_romaji(value string){
  CAMLparam1 (string);
  char *roma;

  roma = romaji(String_val(string));
  CAMLreturn(copy_string(roma));
}

value caml_hiragana(value string){
  CAMLparam1 (string);
  char *s;

  s = hiragana(String_val(string));
  CAMLreturn(copy_string(s));
}

value caml_katakana(value string){
  CAMLparam1 (string);
  char *s;

  s = katakana(String_val(string));
  CAMLreturn(copy_string(s));
}

value caml_katakana2hiragana(value string){
  CAMLparam1 (string);
  char *s;

  s = katakana2hiragana(String_val(string));
  CAMLreturn(copy_string(s));
}

value caml_hiragana2katakana(value string){
  CAMLparam1 (string);
  char *s;

  s = hiragana2katakana(String_val(string));
  CAMLreturn(copy_string(s));
}

value chasen_init(value unit){
  CAMLparam1 (unit);
  cha_init();
  CAMLreturn (Val_unit);
}
