(**************************************************************************)
(*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    *)
(*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     *)
(*                                                                        *)
(*  This program is free software; you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation; either version 2 of the License, or (at  *)
(*  your option) any later version.                                       *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  General Public License for more details.                              *)
(**************************************************************************)

(* $Id: personalDict.ml 158 2005-11-21 18:16:30Z yori $ *)

let db = 
  let flags = [Gdbm.Dbm_create; Gdbm.Dbm_rdwr] in
    Gdbm.opendbm Config.personal_dict_file flags 0o600

let () =
  at_exit (fun () -> Gdbm.close db)

let get_entry_list key = 
  try
    let scanbuf = Scanf.Scanning.from_string (Gdbm.find db key) in
    let s = Scanf.bscanf scanbuf "1,[%S;" (fun s -> s) in
    let rec scan_loop () =
      try Scanf.bscanf scanbuf "%S;" (fun s -> s :: scan_loop ()) with 
	Scanf.Scan_failure _ | Failure _ | End_of_file -> [] in
    s :: scan_loop ()
  with
    Scanf.Scan_failure _ | Failure _ | End_of_file | Not_found -> []

let encode_entry_list entry_list =
  let b = Buffer.create 0 in
  Buffer.add_string b "1,[";
  List.iter (fun entry -> Printf.bprintf b "%S;" entry) entry_list;
  Buffer.add_string b "]";
  Buffer.contents b

let lookup string pos len =
  let key = EucString.sub string ~pos ~len in
  List.map 
    Chasen.deserialize_mrph (get_entry_list key)

let rec lookup_prefix string pos len =
  if len <= 0 then [] else
  (List.map (fun m -> (m, len)) (lookup string pos len)) @
  (lookup_prefix string pos (len - 1))

let add mrph =
  let keyword = Chasen.keyword mrph in
  let entry_list = get_entry_list keyword in
  let string = 
    encode_entry_list (Chasen.serialize_mrph mrph :: entry_list) in
  Gdbm.replace db keyword string
  
let remove mrph =
  let keyword = Chasen.keyword mrph in
  let mrph_list = 
    List.map Chasen.deserialize_mrph (get_entry_list keyword) in
  let mrph_list = 
    List.filter 
      (fun mrph' -> 
	Chasen.posid mrph' <> Chasen.posid mrph ||
	let mrph = Chasen.mrph_data_of_mrph mrph in
	let mrph' = Chasen.mrph_data_of_mrph mrph' in
	Chasen.headword mrph' <> Chasen.headword mrph)
      mrph_list in
  if mrph_list = [] then
    try Gdbm.remove db keyword with Gdbm.Dbm_error "dbm_delete" -> ()
  else
    Gdbm.replace db keyword 
      (encode_entry_list 
	 (List.map Chasen.serialize_mrph mrph_list))
    
let add_new_word ~kaki ~yomi =
  List.iter add (Chasen.new_word ~kaki ~yomi)

(* let incr_count mrph =*)
