/**************************************************************************/
/*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    */
/*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2 of the License, or (at  */
/*  your option) any later version.                                       */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful, but   */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     */
/*  General Public License for more details.                              */
/**************************************************************************/

/* Copyright (C) 2003,2004,2005  Yamagata Yoriyuki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdio.h>
#include <stdlib.h>
#include "romaji.h"

/*   ޻Ѵɽ */
char *k2r[][2] =
  {{"", "a"},
   {"", "i"},
   {"", "u"},
   {"", "e"},
   {"", "o"},
   {"", "ka"},
   {"", "ki"},
   {"", "ku"},
   {"", "ke"},
   {"", "ko"},
   {"å", "kka"},
   {"å", "kki"},
   {"å", "kku"},
   {"å", "kke"},
   {"å", "kko"},
   {"", "sa"},
   {"", "shi"},
   {"", "su"}, 
   {"", "se"},
   {"", "so"},
   {"å", "ssa"},
   {"å", "sshi"},
   {"å", "ssu"}, 
   {"å", "sse"},
   {"å", "sso"},
   {"", "ta"},
   {"", "chi"},
   {"", "tsu"},
   {"", "te"},
   {"", "to"},
   {"å", "tta"},
   {"å", "tchi"},
   {"å", "ttsu"},
   {"å", "tte"},
   {"å", "tto"},
   {"", "na"}, 
   {"", "ni"},
   {"", "nu"},
   {"", "ne"},
   {"", "no"},
   {"å", "nna"}, 
   {"å", "nni"},
   {"å", "nnu"},
   {"å", "nne"},
   {"å", "nno"},
   {"", "ha"}, 
   {"", "hi"},
   {"", "fu"},
   {"", "he"}, 
   {"", "ho"},
   {"å", "hha"}, 
   {"å", "hhi"},
   {"å", "ffu"},
   {"å", "hhe"}, 
   {"å", "hho"},
   {"", "ma"},
   {"", "mi"},
   {"", "mu"},
   {"", "me"},
   {"", "mo"},
   {"", "mma"},
   {"", "mmi"},
   {"", "mmu"},
   {"", "mme"},
   {"", "mmo"},
   {"å", "mma"},
   {"å", "mmi"},
   {"å", "mmu"},
   {"å", "mme"},
   {"å", "mmo"},
   {"", "ya"},
   {"", "yu"},
   {"", "yo"},
   {"å", "yya"},
   {"å", "yyu"},
   {"å", "yyo"},
   {"", "ra"},
   {"", "ri"},
   {"", "ru"},
   {"", "re"},
   {"", "ro"},
   {"å", "rra"},
   {"å", "rri"},
   {"å", "rru"},
   {"å", "rre"},
   {"å", "rro"},
   {"", "wa"},
   {"", "wi"},
   {"", "we"},
   {"", "wo"},
   {"å", "wwa"},
   {"å", "wwi"},
   {"å", "wwe"},
   {"å", "wwo"},
   {"", "n"},
   {"å", "nn"},
   {"", "ga"}, 
   {"", "gi"},
   {"", "gu"},
   {"", "ge"},
   {"", "go"},
   {"å", "gga"}, 
   {"å", "ggi"},
   {"å", "ggu"},
   {"å", "gge"},
   {"å", "ggo"},
   {"", "za"},
   {"", "ji"},
   {"", "zu"},
   {"", "ze"},
   {"", "zo"},
   {"å", "zza"},
   {"å", "zji"},
   {"å", "zzu"},
   {"å", "zze"},
   {"å", "zzo"},
   {"", "da"},
   {"", "di"},
   {"", "du"},
   {"", "de"},
   {"", "do"},
   {"å", "dda"},
   {"å", "ddi"},
   {"å", "ddu"},
   {"å", "dde"},
   {"å", "ddo"},
   {"", "ba"},
   {"", "bi"},
   {"", "bu"},
   {"", "be"},
   {"", "bo"},
   {"å", "bba"},
   {"å", "bbi"},
   {"å", "bbu"},
   {"å", "bbe"},
   {"å", "bbo"},
   {"", "mba"},
   {"", "mbi"},
   {"", "mbu"},
   {"", "mbe"},
   {"", "mbo"},
   {"", "pa"},
   {"", "pi"},
   {"", "pu"},
   {"", "pe"},
   {"", "po"},
   {"å", "ppa"},
   {"å", "ppi"},
   {"å", "ppu"},
   {"å", "ppe"},
   {"å", "ppo"},
   {"", "mpa"},
   {"", "mpi"},
   {"", "mpu"},
   {"", "mpe"},
   {"", "mpo"},
   {"", "kya"},
   {"", "kyu"},
   {"", "kyo"},
   {"å", "kkya"},
   {"å", "kkyu"},
   {"å", "kkyo"},
   {"", "sha"},
   {"", "shu"}, 
   {"", "sho"},
   {"å", "ssha"},
   {"å", "sshu"}, 
   {"å", "ssho"},
   {"", "cha"},
   {"", "chu"},
   {"", "cho"},
   {"å", "ccha"},
   {"å", "cchu"},
   {"å", "ccho"},
   {"˥", "nya"},
   {"˥", "nyu"},
   {"˥", "nyo"},
   {"å˥", "nnya"},
   {"å˥", "nnyu"},
   {"å˥", "nnyo"},
   {"ҥ", "hya"},
   {"ҥ", "hyu"},
   {"ҥ", "hyo"},
   {"åҥ", "hhya"},
   {"åҥ", "hhyu"},
   {"åҥ", "hhyo"},
   {"ߥ", "mya"},
   {"ߥ", "myu"},
   {"ߥ", "myo"},
   {"åߥ", "mmya"},
   {"åߥ", "mmyu"},
   {"åߥ", "mmyo"},
   {"ߥ", "mmya"},
   {"ߥ", "mmyu"},
   {"ߥ", "mmyo"},
   {"", "rya"},
   {"", "ryu"},
   {"", "ryo"},
   {"å", "rrya"},
   {"å", "rryu"},
   {"å", "rryo"},
   {"", "gya"},
   {"", "gyu"},
   {"", "gyo"},
   {"å", "ggya"},
   {"å", "ggyu"},
   {"å", "ggyo"},
   {"", "ja"},
   {"", "ju"},
   {"", "jo"},
   {"å", "jja"},
   {"å", "jju"},
   {"å", "jjo"},
   {"ӥ", "bya"},
   {"ӥ", "byu"},
   {"ӥ", "byo"},
   {"åӥ", "bbya"},
   {"åӥ", "bbyu"},
   {"åӥ", "bbyo"},
   {"ӥ", "mbya"},
   {"ӥ", "mbyu"},
   {"ӥ", "mbyo"},
   {"ԥ", "pya"},
   {"ԥ", "pyu"},
   {"ԥ", "pyo"},
   {"åԥ", "ppya"},
   {"åԥ", "ppyu"},
   {"åԥ", "ppyo"},
   {"ԥ", "mpya"},
   {"ԥ", "mpyu"},
   {"ԥ", "mpyo"},
   {"ե", "fa"},
   {"ե", "fi"},
   {"ե", "fe"},
   {"ե", "fo"},
   {"åե", "ffa"},
   {"åե", "ffi"},
   {"åե", "ffe"},
   {"åե", "ffo"},
   {"", "va"},
   {"", "vi"},
   {"", "vu"},
   {"", "ve"},
   {"", "vo"},
   {"å", "vva"},
   {"å", "vvi"},
   {"å", "vvu"},
   {"å", "vve"},
   {"å", "vvo"},
   {"", "xa"},
   {"", "xi"},
   {"", "xu"},
   {"", "xe"},
   {"", "xo"},
   {"", "xya"},
   {"", "xyu"},
   {"", "xyo"},
   {"", "xtsu"},
   {"", "-"},
   {"", "."},
   {"", ","},
   {"", "a"},
   {"", "i"},
   {"", "u"},
   {"", "e"},
   {"", "o"},
   {"", "ka"},
   {"", "ki"},
   {"", "ku"},
   {"", "ke"},
   {"", "ko"},
   {"ä", "kka"},
   {"ä", "kki"},
   {"ä", "kku"},
   {"ä", "kke"},
   {"ä", "kko"},
   {"", "sa"},
   {"", "shi"},
   {"", "su"}, 
   {"", "se"},
   {"", "so"},
   {"ä", "ssa"},
   {"ä", "sshi"},
   {"ä", "ssu"}, 
   {"ä", "sse"},
   {"ä", "sso"},
   {"", "ta"},
   {"", "chi"},
   {"", "tsu"},
   {"", "te"},
   {"", "to"},
   {"ä", "tta"},
   {"ä", "tchi"},
   {"ä", "ttsu"},
   {"ä", "tte"},
   {"ä", "tto"},
   {"", "na"}, 
   {"", "ni"},
   {"", "nu"},
   {"", "ne"},
   {"", "no"},
   {"ä", "nna"}, 
   {"ä", "nni"},
   {"ä", "nnu"},
   {"ä", "nne"},
   {"ä", "nno"},
   {"", "ha"}, 
   {"", "hi"},
   {"", "fu"},
   {"", "he"}, 
   {"", "ho"},
   {"ä", "hha"}, 
   {"ä", "hhi"},
   {"ä", "ffu"},
   {"ä", "hhe"}, 
   {"ä", "hho"},
   {"", "ma"},
   {"", "mi"},
   {"", "mu"},
   {"", "me"},
   {"", "mo"},
   {"", "mma"},
   {"", "mmi"},
   {"", "mmu"},
   {"", "mme"},
   {"", "mmo"},
   {"", "ya"},
   {"", "yu"},
   {"", "yo"},
   {"ä", "yya"},
   {"ä", "yyu"},
   {"ä", "yyo"},
   {"", "ra"},
   {"", "ri"},
   {"", "ru"},
   {"", "re"},
   {"", "ro"},
   {"ä", "rra"},
   {"ä", "rri"},
   {"ä", "rru"},
   {"ä", "rre"},
   {"ä", "rro"},
   {"", "wa"},
   {"", "wi"},
   {"", "we"},
   {"", "wo"},
   {"ä", "wwa"},
   {"ä", "wwi"},
   {"ä", "wwe"},
   {"ä", "wwo"},
   {"", "n"},
   {"ä", "nn"},
   {"", "ga"}, 
   {"", "gi"},
   {"", "gu"},
   {"", "ge"},
   {"", "go"},
   {"ä", "gga"}, 
   {"ä", "ggi"},
   {"ä", "ggu"},
   {"ä", "gge"},
   {"ä", "ggo"},
   {"", "za"},
   {"", "ji"},
   {"", "zu"},
   {"", "ze"},
   {"", "zo"},
   {"ä", "zza"},
   {"ä", "zji"},
   {"ä", "zzu"},
   {"ä", "zze"},
   {"ä", "zzo"},
   {"", "da"},
   {"", "di"},
   {"", "du"},
   {"", "de"},
   {"", "do"},
   {"ä", "dda"},
   {"ä", "ddi"},
   {"ä", "ddu"},
   {"ä", "dde"},
   {"ä", "ddo"},
   {"", "ba"},
   {"", "bi"},
   {"", "bu"},
   {"", "be"},
   {"", "bo"},
   {"ä", "bba"},
   {"ä", "bbi"},
   {"ä", "bbu"},
   {"ä", "bbe"},
   {"ä", "bbo"},
   {"", "mba"},
   {"", "mbi"},
   {"", "mbu"},
   {"", "mbe"},
   {"", "mbo"},
   {"", "pa"},
   {"", "pi"},
   {"", "pu"},
   {"", "pe"},
   {"", "po"},
   {"ä", "ppa"},
   {"ä", "ppi"},
   {"ä", "ppu"},
   {"ä", "ppe"},
   {"ä", "ppo"},
   {"", "mpa"},
   {"", "mpi"},
   {"", "mpu"},
   {"", "mpe"},
   {"", "mpo"},
   {"", "kya"},
   {"", "kyu"},
   {"", "kyo"},
   {"ä", "kkya"},
   {"ä", "kkyu"},
   {"ä", "kkyo"},
   {"", "sha"},
   {"", "shu"}, 
   {"", "sho"},
   {"ä", "ssha"},
   {"ä", "sshu"}, 
   {"ä", "ssho"},
   {"", "cha"},
   {"", "chu"},
   {"", "cho"},
   {"ä", "ccha"},
   {"ä", "cchu"},
   {"ä", "ccho"},
   {"ˤ", "nya"},
   {"ˤ", "nyu"},
   {"ˤ", "nyo"},
   {"äˤ", "nnya"},
   {"äˤ", "nnyu"},
   {"äˤ", "nnyo"},
   {"Ҥ", "hya"},
   {"Ҥ", "hyu"},
   {"Ҥ", "hyo"},
   {"äҤ", "hhya"},
   {"äҤ", "hhyu"},
   {"äҤ", "hhyo"},
   {"ߤ", "mya"},
   {"ߤ", "myu"},
   {"ߤ", "myo"},
   {"ߤ", "mmya"},
   {"ߤ", "mmyu"},
   {"ߤ", "mmyo"},
   {"", "rya"},
   {"", "ryu"},
   {"", "ryo"},
   {"ä", "rrya"},
   {"ä", "rryu"},
   {"ä", "rryo"},
   {"", "gya"},
   {"", "gyu"},
   {"", "gyo"},
   {"ä", "ggya"},
   {"ä", "ggyu"},
   {"ä", "ggyo"},
   {"", "ja"},
   {"", "ju"},
   {"", "jo"},
   {"ä", "jja"},
   {"ä", "jju"},
   {"ä", "jjo"},
   {"Ӥ", "bya"},
   {"Ӥ", "byu"},
   {"Ӥ", "byo"},
   {"äӤ", "bbya"},
   {"äӤ", "bbyu"},
   {"äӤ", "bbyo"},
   {"Ӥ", "mbya"},
   {"Ӥ", "mbyu"},
   {"Ӥ", "mbyo"},
   {"Ԥ", "pya"},
   {"Ԥ", "pyu"},
   {"Ԥ", "pyo"},
   {"äԤ", "ppya"},
   {"äԤ", "ppyu"},
   {"äԤ", "ppyo"},
   {"Ԥ", "mpya"},
   {"Ԥ", "mpyu"},
   {"Ԥ", "mpyo"},
   {"դ", "fa"},
   {"դ", "fi"},
   {"դ", "fe"},
   {"դ", "fo"},
   {"äդ", "ffa"},
   {"äդ", "ffi"},
   {"äդ", "ffe"},
   {"äդ", "ffo"},
   {"", "xa"},
   {"", "xi"},
   {"", "xu"},
   {"", "xe"},
   {"", "xo"},
   {"", "xya"},
   {"", "xyu"},
   {"", "xyo"},
   {"", "xtsu"},
   {NULL, NULL}};

/*  ޻  Ѵɽ */
char *r2k[][2] =
  {{"a", ""},
   {"i", ""},
   {"u", ""},
   {"e", ""},
   {"o", ""},
   {"ka", ""},
   {"ki", ""},
   {"ku", ""},
   {"ke", ""},
   {"ko", ""},
   {"kka", "å"},
   {"kki", "å"},
   {"kku", "å"},
   {"kke", "å"},
   {"kko", "å"},
   {"sa", ""},
   {"shi", ""},
   {"su", ""}, 
   {"se", ""},
   {"so", ""},
   {"ssa", "å"},
   {"sshi", "å"},
   {"ssu", "å"}, 
   {"sse", "å"},
   {"sso", "å"},
   {"ta", ""},
   {"chi", ""},
   {"tsu", ""},
   {"te", ""},
   {"to", ""},
   {"tta", "å"},
   {"tchi", "å"},
   {"ttsu", "å"},
   {"tte", "å"},
   {"tto", "å"},
   {"na", ""}, 
   {"ni", ""},
   {"nu", ""},
   {"ne", ""},
   {"no", ""},
   {"nna", "å"}, 
   {"nni", "å"},
   {"nnu", "å"},
   {"nne", "å"},
   {"nno", "å"},
   {"ha", ""}, 
   {"hi", ""},
   {"fu", ""},
   {"he", ""}, 
   {"ho", ""},
   {"hha", "å"}, 
   {"hhi", "å"},
   {"ffu", "å"},
   {"hhe", "å"}, 
   {"hho", "å"},
   {"ma", ""},
   {"mi", ""},
   {"mu", ""},
   {"me", ""},
   {"mo", ""},
   {"mma", ""},
   {"mmi", ""},
   {"mmu", ""},
   {"mme", ""},
   {"mmo", ""},
   {"ya", ""},
   {"yu", ""},
   {"yo", ""},
   {"yya", "å"},
   {"yyu", "å"},
   {"yyo", "å"},
   {"ra", ""},
   {"ri", ""},
   {"ru", ""},
   {"re", ""},
   {"ro", ""},
   {"rra", "å"},
   {"rri", "å"},
   {"rru", "å"},
   {"rre", "å"},
   {"rro", "å"},
   {"wa", ""},
   {"wi", ""},
   {"we", ""},
   {"wo", ""},
   {"wwa", "å"},
   {"wwi", "å"},
   {"wwe", "å"},
   {"wwo", "å"},
   {"n", ""},
   {"nn", "å"},
   {"ga", ""}, 
   {"gi", ""},
   {"gu", ""},
   {"ge", ""},
   {"go", ""},
   {"gga", "å"}, 
   {"ggi", "å"},
   {"ggu", "å"},
   {"gge", "å"},
   {"ggo", "å"},
   {"za", ""},
   {"ji", ""},
   {"zu", ""},
   {"ze", ""},
   {"zo", ""},
   {"zza", "å"},
   {"zji", "å"},
   {"zzu", "å"},
   {"zze", "å"},
   {"zzo", "å"},
   {"da", ""},
   {"di", ""},
   {"du", ""},
   {"de", ""},
   {"do", ""},
   {"dda", "å"},
   {"ddi", "å"},
   {"ddu", "å"},
   {"dde", "å"},
   {"ddo", "å"},
   {"ba", ""},
   {"bi", ""},
   {"bu", ""},
   {"be", ""},
   {"bo", ""},
   {"bba", "å"},
   {"bbi", "å"},
   {"bbu", "å"},
   {"bbe", "å"},
   {"bbo", "å"},
   {"mba", ""},
   {"mbi", ""},
   {"mbu", ""},
   {"mbe", ""},
   {"mbo", ""},
   {"pa", ""},
   {"pi", ""},
   {"pu", ""},
   {"pe", ""},
   {"po", ""},
   {"ppa", "å"},
   {"ppi", "å"},
   {"ppu", "å"},
   {"ppe", "å"},
   {"ppo", "å"},
   {"mpa", ""},
   {"mpi", ""},
   {"mpu", ""},
   {"mpe", ""},
   {"mpo", ""},
   {"kya", ""},
   {"kyu", ""},
   {"kyo", ""},
   {"kkya", "å"},
   {"kkyu", "å"},
   {"kkyo", "å"},
   {"sha", ""},
   {"shu", ""}, 
   {"sho", ""},
   {"ssha", "å"},
   {"sshu", "å"}, 
   {"ssho", "å"},
   {"cha", ""},
   {"chu", ""},
   {"cho", ""},
   {"ccha", "å"},
   {"cchu", "å"},
   {"ccho", "å"},
   {"nya", "˥"},
   {"nyu", "˥"},
   {"nyo", "˥"},
   {"nnya", "å˥"},
   {"nnyu", "å˥"},
   {"nnyo", "å˥"},
   {"hya", "ҥ"},
   {"hyu", "ҥ"},
   {"hyo", "ҥ"},
   {"hhya", "åҥ"},
   {"hhyu", "åҥ"},
   {"hhyo", "åҥ"},
   {"mya", "ߥ"},
   {"myu", "ߥ"},
   {"myo", "ߥ"},
   {"mmya", "åߥ"},
   {"mmyu", "åߥ"},
   {"mmyo", "åߥ"},
   {"mmya", "ߥ"},
   {"mmyu", "ߥ"},
   {"mmyo", "ߥ"},
   {"rya", ""},
   {"ryu", ""},
   {"ryo", ""},
   {"rrya", "å"},
   {"rryu", "å"},
   {"rryo", "å"},
   {"gya", ""},
   {"gyu", ""},
   {"gyo", ""},
   {"ggya", "å"},
   {"ggyu", "å"},
   {"ggyo", "å"},
   {"ja", ""},
   {"ju", ""},
   {"jo", ""},
   {"jja", "å"},
   {"jju", "å"},
   {"jjo", "å"},
   {"bya", "ӥ"},
   {"byu", "ӥ"},
   {"byo", "ӥ"},
   {"bbya", "åӥ"},
   {"bbyu", "åӥ"},
   {"bbyo", "åӥ"},
   {"mbya", "ӥ"},
   {"mbyu", "ӥ"},
   {"mbyo", "ӥ"},
   {"pya", "ԥ"},
   {"pyu", "ԥ"},
   {"pyo", "ԥ"},
   {"ppya", "åԥ"},
   {"ppyu", "åԥ"},
   {"ppyo", "åԥ"},
   {"mpya", "ԥ"},
   {"mpyu", "ԥ"},
   {"mpyo", "ԥ"},
   {"fa", "ե"},
   {"fi", "ե"},
   {"fe", "ե"},
   {"fo", "ե"},
   {"ffa", "åե"},
   {"ffi", "åե"},
   {"ffe", "åե"},
   {"ffo", "åե"},
   {"va", ""},
   {"vi", ""},
   {"vu", ""},
   {"ve", ""},
   {"vo", ""},
   {"vva", "å"},
   {"vvi", "å"},
   {"vvu", "å"},
   {"vve", "å"},
   {"vvo", "å"},
   {"xa", ""},
   {"xi", ""},
   {"xu", ""},
   {"xe", ""},
   {"xo", ""},
   {"xya", ""},
   {"xyu", ""},
   {"xyo", ""},
   {"xtsu", ""},
   {"-", ""},
   {".", ""},
   {",", ""},
   {NULL, NULL}};

/*  ޻  Ҥ餬Ѵɽ */
char *r2h[][2] =
  {{"a", ""},
   {"i", ""},
   {"u", ""},
   {"e", ""},
   {"o", ""},
   {"ka", ""},
   {"ki", ""},
   {"ku", ""},
   {"ke", ""},
   {"ko", ""},
   {"kka", "ä"},
   {"kki", "ä"},
   {"kku", "ä"},
   {"kke", "ä"},
   {"kko", "ä"},
   {"sa", ""},
   {"shi", ""},
   {"su", ""}, 
   {"se", ""},
   {"so", ""},
   {"ssa", "ä"},
   {"sshi", "ä"},
   {"ssu", "ä"}, 
   {"sse", "ä"},
   {"sso", "ä"},
   {"ta", ""},
   {"chi", ""},
   {"tsu", ""},
   {"te", ""},
   {"to", ""},
   {"tta", "ä"},
   {"tchi", "ä"},
   {"ttsu", "ä"},
   {"tte", "ä"},
   {"tto", "ä"},
   {"na", ""}, 
   {"ni", ""},
   {"nu", ""},
   {"ne", ""},
   {"no", ""},
   {"nna", "ä"}, 
   {"nni", "ä"},
   {"nnu", "ä"},
   {"nne", "ä"},
   {"nno", "ä"},
   {"ha", ""}, 
   {"hi", ""},
   {"fu", ""},
   {"he", ""}, 
   {"ho", ""},
   {"hha", "ä"}, 
   {"hhi", "ä"},
   {"ffu", "ä"},
   {"hhe", "ä"}, 
   {"hho", "ä"},
   {"ma", ""},
   {"mi", ""},
   {"mu", ""},
   {"me", ""},
   {"mo", ""},
   {"mma", ""},
   {"mmi", ""},
   {"mmu", ""},
   {"mme", ""},
   {"mmo", ""},
   {"ya", ""},
   {"yu", ""},
   {"yo", ""},
   {"yya", "ä"},
   {"yyu", "ä"},
   {"yyo", "ä"},
   {"ra", ""},
   {"ri", ""},
   {"ru", ""},
   {"re", ""},
   {"ro", ""},
   {"rra", "ä"},
   {"rri", "ä"},
   {"rru", "ä"},
   {"rre", "ä"},
   {"rro", "ä"},
   {"wa", ""},
   {"wi", ""},
   {"we", ""},
   {"wo", ""},
   {"wwa", "ä"},
   {"wwi", "ä"},
   {"wwe", "ä"},
   {"wwo", "ä"},
   {"n", ""},
   {"nn", "ä"},
   {"ga", ""}, 
   {"gi", ""},
   {"gu", ""},
   {"ge", ""},
   {"go", ""},
   {"gga", "ä"}, 
   {"ggi", "ä"},
   {"ggu", "ä"},
   {"gge", "ä"},
   {"ggo", "ä"},
   {"za", ""},
   {"ji", ""},
   {"zu", ""},
   {"ze", ""},
   {"zo", ""},
   {"zza", "ä"},
   {"zji", "ä"},
   {"zzu", "ä"},
   {"zze", "ä"},
   {"zzo", "ä"},
   {"da", ""},
   {"di", ""},
   {"du", ""},
   {"de", ""},
   {"do", ""},
   {"dda", "ä"},
   {"ddi", "ä"},
   {"ddu", "ä"},
   {"dde", "ä"},
   {"ddo", "ä"},
   {"ba", ""},
   {"bi", ""},
   {"bu", ""},
   {"be", ""},
   {"bo", ""},
   {"bba", "ä"},
   {"bbi", "ä"},
   {"bbu", "ä"},
   {"bbe", "ä"},
   {"bbo", "ä"},
   {"mba", ""},
   {"mbi", ""},
   {"mbu", ""},
   {"mbe", ""},
   {"mbo", ""},
   {"pa", ""},
   {"pi", ""},
   {"pu", ""},
   {"pe", ""},
   {"po", ""},
   {"ppa", "ä"},
   {"ppi", "ä"},
   {"ppu", "ä"},
   {"ppe", "ä"},
   {"ppo", "ä"},
   {"mpa", ""},
   {"mpi", ""},
   {"mpu", ""},
   {"mpe", ""},
   {"mpo", ""},
   {"kya", ""},
   {"kyu", ""},
   {"kyo", ""},
   {"kkya", "ä"},
   {"kkyu", "ä"},
   {"kkyo", "ä"},
   {"sha", ""},
   {"shu", ""}, 
   {"sho", ""},
   {"ssha", "ä"},
   {"sshu", "ä"}, 
   {"ssho", "ä"},
   {"cha", ""},
   {"chu", ""},
   {"cho", ""},
   {"ccha", "ä"},
   {"cchu", "ä"},
   {"ccho", "ä"},
   {"nya", "ˤ"},
   {"nyu", "ˤ"},
   {"nyo", "ˤ"},
   {"nnya", "äˤ"},
   {"nnyu", "äˤ"},
   {"nnyo", "äˤ"},
   {"hya", "Ҥ"},
   {"hyu", "Ҥ"},
   {"hyo", "Ҥ"},
   {"hhya", "äҤ"},
   {"hhyu", "äҤ"},
   {"hhyo", "äҤ"},
   {"mya", "ߤ"},
   {"myu", "ߤ"},
   {"myo", "ߤ"},
   {"mmya", "ߤ"},
   {"mmyu", "ߤ"},
   {"mmyo", "ߤ"},
   {"rya", ""},
   {"ryu", ""},
   {"ryo", ""},
   {"rrya", "ä"},
   {"rryu", "ä"},
   {"rryo", "ä"},
   {"gya", ""},
   {"gyu", ""},
   {"gyo", ""},
   {"ggya", "ä"},
   {"ggyu", "ä"},
   {"ggyo", "ä"},
   {"ja", ""},
   {"ju", ""},
   {"jo", ""},
   {"jja", "ä"},
   {"jju", "ä"},
   {"jjo", "ä"},
   {"bya", "Ӥ"},
   {"byu", "Ӥ"},
   {"byo", "Ӥ"},
   {"bbya", "äӤ"},
   {"bbyu", "äӤ"},
   {"bbyo", "äӤ"},
   {"mbya", "Ӥ"},
   {"mbyu", "Ӥ"},
   {"mbyo", "Ӥ"},
   {"pya", "Ԥ"},
   {"pyu", "Ԥ"},
   {"pyo", "Ԥ"},
   {"ppya", "äԤ"},
   {"ppyu", "äԤ"},
   {"ppyo", "äԤ"},
   {"mpya", "Ԥ"},
   {"mpyu", "Ԥ"},
   {"mpyo", "Ԥ"},
   {"fa", "դ"},
   {"fi", "դ"},
   {"fe", "դ"},
   {"fo", "դ"},
   {"ffa", "äդ"},
   {"ffi", "äդ"},
   {"ffe", "äդ"},
   {"ffo", "äդ"},
   {"xa", ""},
   {"xi", ""},
   {"xu", ""},
   {"xe", ""},
   {"xo", ""},
   {"xya", ""},
   {"xyu", ""},
   {"xyo", ""},
   {"xtsu", ""},
   {"-", ""},
   {".", ""},
   {",", ""},
   {NULL, NULL}};

char *k2h[][2] =
  {{"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""}, 
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""}, 
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""}, 
   {"", ""},
   {"", ""},
   {"", ""}, 
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""}, 
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {NULL, NULL}};

char *h2k[][2] =
  {{"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""}, 
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""}, 
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""}, 
   {"", ""},
   {"", ""},
   {"", ""}, 
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""}, 
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {"", ""},
   {NULL, NULL}};

/* str  pat Ϥޤ뤫ɤ롣*/
char *match (char *pat, char *str){
  while (*pat && *pat == *str){pat++; str++;}
  if (*pat) /* pat ǸޤǹԤäƤʤ*/
    return NULL; /*  */
  else
    return str;
}

void converter(char *tbl[][2], char *dst, char *src){
  char *p, *p0; /* ѥݥ */
  char *out;
  int i; /* ѥ */

  /*  */

  if (!*src) return;
  p0 = src;
  out = NULL;

  /* ơ֥롣*/

  for (i = 0; tbl[i][0] != NULL; i++){
    p = match (tbl[i][0], src); /* ޥå롩 */
    if (p < p0) continue;
    p0 = p;
    out = tbl[i][1];
  }

  if (!out) {
    *dst = *src;
    return converter (tbl, dst + 1, src + 1);
  } else {
    strcpy(dst, out);
    return converter (tbl, dst + strlen(out), p0);
  }
}

char *romaji(char *string){
  char *u;

  u = (char *)calloc(sizeof(char), 2 * strlen(string));
  converter (k2r, u, string);
  return u;
}

char *hiragana(char *string){
  char *u;

  u = (char *)calloc(sizeof(char), 2 * strlen(string));
  converter (r2h, u, string);
  return u;
}

char *katakana(char *string){
  char *u;

  u = (char *)calloc(sizeof(char), 2 * strlen(string));
  converter (r2k, u, string);
  return u;
}

char *katakana2hiragana(char *string){
  char *u;

  u = (char *)calloc(sizeof(char), 2 * strlen(string));
  converter (k2h, u, string);
  return u;
}

char *hiragana2katakana(char *string){
  char *u;

  u = (char *)calloc(sizeof(char), 2 * strlen(string));
  converter (h2k, u, string);
  return u;
}
