/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

/*
 *		TOPPERS/SSPJ[l Wwb_t@C
 *
 *  TOPPERS/SSPJ[lT|[gT[rXR[̐錾ƁCKvȃf[
 *  ^^C萔C}N̒`܂ރwb_t@CD
 *
 *  AZũ\[Xt@C炱̃t@CCN[h鎞
 *  ́CTOPPERS_MACRO_ONLY`ĂDɂC}N`ȊO
 *  悤ɂȂĂD
 *
 *  ̃t@CCN[hOɃCN[hĂׂt@C
 *  ͂ȂD
 */

#ifndef TOPPERS_KERNEL_H
#define TOPPERS_KERNEL_H

/*
 *	TOPPERSʂ̃f[^^E萔E}N
 */
#include <t_stddef.h>

/*
 *  ^[Qbgˑ
 */
#include "target_kernel.h"
#ifndef TOPPERS_MACRO_ONLY

/*
 *  f[^^̒`
 */

/*
 *  rbgp^[IuWFNgԍ̌^`
 */
typedef	uint_t		INTNO;		/* ݔԍ */
typedef	uint_t		INHNO;		/* ݃nhԍ */
typedef	uint_t		EXCNO;		/* CPUOnhԍ */

/*
 *  Pʂ̌^`
 */
typedef void	(*TASK)(intptr_t exinf);
typedef void	(*ISR)(intptr_t exinf);
typedef void	(*INTHDR)(void);
typedef void	(*EXCHDR)(void *p_excinf);
typedef void	(*INIRTN)(intptr_t exinf);
typedef void	(*TERRTN)(intptr_t exinf);
typedef void	(*CYCHDR)(intptr_t exinf);
typedef void	(*ALMHDR)(intptr_t exinf);

/*
 *  ̈mۂ̂߂̌^`
 */
#ifndef TOPPERS_STK_T
#define TOPPERS_STK_T	intptr_t
#endif /* TOPPERS_STK_T */
typedef	TOPPERS_STK_T	STK_T;	/* X^bN̈mۂ邽߂̌^ */


/*
 *  T[rXR[̐錾
 */

/*
 *  ^XNǗ@\
 */
extern ER		act_tsk(ID tskid);
extern ER		iact_tsk(ID tskid);

/*
 *  VXeԊǗ@\
 */
extern ER		loc_cpu(void);
extern ER		iloc_cpu(void);
extern ER		unl_cpu(void);
extern ER		iunl_cpu(void);
extern ER		dis_dsp(void);
extern ER		ena_dsp(void);
extern bool_t	sns_ctx(void);
extern bool_t	sns_loc(void);
extern bool_t	sns_dsp(void);
extern bool_t	sns_dpn(void);
extern bool_t	sns_ker(void);
extern ER		ext_ker(void);

/*
 *  ݊Ǘ@\
 */
extern ER		dis_int(INTNO intno);
extern ER		ena_int(INTNO intno);

/*
 *  nh@\
 */
extern ER		sta_cyc(ID cycid);
extern ER		stp_cyc(ID cycid);

/*
 *  A[nh@\
 */
extern ER		sta_alm(ID almid , RELTIM almtim);
extern ER		stp_alm(ID almid);

/*
 *  VXeԊǗ@\
 */
extern ER		get_tim(SYSTIM *p_systim);

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  IuWFNg̒`
 */
#define TA_RSTR			UINT_C(0x04)	/* ^XN */

#define TA_ACT			UINT_C(0x02)	/* ^XNNꂽԂŐ */

#define TA_STA			UINT_C(0x02)	/* nh𓮍ԂŐ */

#define TA_NONKERNEL	UINT_C(0x02)	/* J[lǗO̊ */

#define TA_ENAINT		UINT_C(0x01)	/* ݗv֎~tONA */
#define TA_EDGE			UINT_C(0x02)	/* GbWgK */

/*
 *  ̑̒萔̒`
 */
#define TSK_SELF		0			/* ^XNw */
#define TSK_NONE		0			/* Y^XNȂ */

#define TPRI_INI		0			/* ^XN̋NDx */

#define TIPM_ENAALL		0			/* ݗDx}XNS */

/*
 *  \萔ƃ}N
 */

/*
 *  Dx͈̔
 */
#define TMIN_TPRI		1			/* ^XNDx̍ŏliōlj*/
#ifndef TMAX_TPRI
	#define TMAX_TPRI		16			/* ^XNDx̍őliŒlj*/
#elif (TMAX_TPRI != 8) || (TMAX_TPRI != 16)
	#error "TMAX_TPRI must defined 8 or 16."
#endif	/* TMAX_TPRI */

#define TMIN_ISRPRI		1			/* ݃T[rX[`Dx̍ŏl */
#ifndef TMAX_ISRPRI
	#define TMAX_ISRPRI		16			/* ݃T[rX[`Dx̍ől */
#elif (TMAX_ISRPRI != 8) || (TMAX_ISRPRI != 16)
	#error "TMAX_ISRPRI must defined 8 or 16."
#endif	/* TMAX_ISRPRI */

/*
 *  o[W
 */
#define TKERNEL_MAKER	UINT_C(0x0118)	/* J[l̃[J[R[h */
#define TKERNEL_PRID	UINT_C(0x0007)	/* J[l̎ʔԍ */
#define TKERNEL_SPVER	UINT_C(0xf511)	/* J[ldl̃o[Wԍ */
#define TKERNEL_PRVER	UINT_C(0x1100)	/* J[l̃o[Wԍ */

/*
 *  ̈mۂ̂߂̃}N
 *
 *  ȉTOPPERS_COUNT_SZTOPPERS_ROUND_SZ̒`́Cunit2̋Џł
 *  邱Ƃ肵ĂD
 */
#ifndef TOPPERS_COUNT_SZ
#define TOPPERS_COUNT_SZ(sz, unit)	(((sz) + (unit) - 1) / (unit))
#endif /* TOPPERS_COUNT_SZ */
#ifndef TOPPERS_ROUND_SZ
#define TOPPERS_ROUND_SZ(sz, unit)	(((sz) + (unit) - 1) & ~((unit) - 1))
#endif /* TOPPERS_ROUND_SZ */

#define COUNT_STK_T(sz)		TOPPERS_COUNT_SZ(sz, sizeof(STK_T))
#define ROUND_STK_T(sz)		TOPPERS_ROUND_SZ(sz, sizeof(STK_T))


#endif /* TOPPERS_KERNEL_H */
