/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import jdbcacsess.csv.CSVLine;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.SqlAnalyze;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvExport
implements QueryExecuteListener {
    private CsvInfo csvInfo;
    private BufferedWriter ot;

    public CsvExport(CsvInfo info) {
        this.csvInfo = info;
    }

    @Override
    public void init() throws IOException, FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(this.csvInfo.getFileName());
        this.ot = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.csvInfo.getEncoding()));
    }

    @Override
    public void setResultHeader(Vector<ColumnInfoResult> rowData, SqlAnalyze sqlAnalyze) throws IOException {
        if (this.csvInfo.hasItemHeader()) {
            this.setResultDetail(rowData);
        }
    }

    @Override
    public void setResultDetail(Vector rowData) throws IOException {
        CSVLine csvline = new CSVLine();
        csvline.setToken(this.csvInfo.getColumnDelimiter());
        int i = 0;
        while (i < rowData.size()) {
            Object o = rowData.get(i);
            if (o != null) {
                csvline.addItem(o.toString());
            } else {
                csvline.addItem("#$%&NULL&%$#");
            }
            ++i;
        }
        String str = String.valueOf(csvline.getLine()) + this.csvInfo.getLineSeparator();
        this.ot.write(str, 0, str.length());
    }

    @Override
    public void completeQuery(QueryExecuteStatus breakStatus) {
        try {
            if (this.ot != null) {
                this.ot.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!breakStatus.isErr()) {
            this.csvInfo.currentDataSave();
        }
    }

    @Override
    public void status(QueryExecuteStatus breakStatus) {
    }

    @Override
    public void errorException(Exception ex) {
    }
}

