/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jdbcacsess.csv.CsvInfo;

public class CsvInfoTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -2574911637821580582L;
    private List<CsvInfo> csvInfoList;
    private Vector<String> header;
    private int columnCount = new CsvInfo().getHeader().size();

    public CsvInfoTableModel() {
        this.header = new CsvInfo().getHeader();
        this.load();
    }

    public void reLoad() {
        this.load();
        this.fireTableDataChanged();
    }

    public String getColumnName(int idx) {
        return this.header.get(idx);
    }

    private void load() {
        this.csvInfoList = new CsvInfo().getInfoList();
    }

    public int getRowCount() {
        return this.csvInfoList.size();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.csvInfoList.get(rowIndex).getData(columnIndex);
    }

    public String getKey(int rowIndex) {
        return this.csvInfoList.get(rowIndex).getFileName();
    }

    public void remove(String key) {
        for (CsvInfo ci : this.csvInfoList) {
            if (!ci.getFileName().equals(key)) continue;
            this.csvInfoList.remove(ci);
            ci.removeParameter();
            break;
        }
        this.reLoad();
        this.fireTableDataChanged();
    }

    public CsvInfo getCsvInfo(int index) {
        return this.csvInfoList.get(index);
    }
}

