/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.ProgressMonitorInputStream;
import jdbcacsess.csv.CSVTokenizer;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.gui.JDialogMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvImport {
    protected CsvInfo csvInfo;
    protected BufferedReader in;
    protected int inputCnt;

    public CsvImport(CsvInfo info) {
        this.csvInfo = info;
    }

    protected void openInputFile() throws CsvImportException {
        try {
            ProgressMonitorInputStream fos = new ProgressMonitorInputStream(new JDialog(), String.valueOf(this.csvInfo.getPropTableName().getCompleteTableName()) + "  import... ", new FileInputStream(this.csvInfo.getFileName()));
            this.in = new BufferedReader(new InputStreamReader((InputStream)fos, this.csvInfo.getEncoding()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
            throw new CsvImportException();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
            throw new CsvImportException();
        }
    }

    protected void closeInputFile() {
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
        }
    }

    protected Vector<String> readFile() throws IOException {
        Vector<String> v = new Vector<String>();
        String rec = null;
        try {
            rec = this.in.readLine();
        }
        catch (InterruptedIOException e) {
            return null;
        }
        if (rec == null) {
            return null;
        }
        ++this.inputCnt;
        CSVTokenizer csvt = new CSVTokenizer(rec);
        csvt.setToken(this.csvInfo.getColumnDelimiter());
        while (csvt.hasMoreTokens()) {
            v.add(this.enquoteJdbc(csvt.nextToken()));
        }
        return v;
    }

    private String enquoteJdbc(String str) {
        boolean prevEscapChar = false;
        StringBuffer rtnBuff = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\'') {
                prevEscapChar = !prevEscapChar;
            } else if (prevEscapChar) {
                rtnBuff.append('\'');
                prevEscapChar = false;
            }
            rtnBuff.append(c);
            ++i;
        }
        return rtnBuff.toString();
    }

    class CsvImportException
    extends Exception {
        private static final long serialVersionUID = 99816268936681456L;

        CsvImportException() {
        }
    }
}

