/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import jdbcacsess.csv.CsvImport;
import jdbcacsess.csv.CsvImportSqlExecute;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.DupliKeyActionMode;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.sql.PrepareExecUpdate;
import jdbcacsess.sql.SqlExec;

public class CsvImportDB
extends CsvImport
implements Runnable {
    private Connection con;
    private int resultCntUpdate;
    private int resultCntInsert;
    private int resultCntDelete;

    public CsvImportDB(CsvInfo info) {
        super(info);
    }

    public void run() {
        block8: {
            this.inputCnt = 0;
            this.resultCntUpdate = 0;
            this.resultCntInsert = 0;
            this.resultCntDelete = 0;
            this.in = null;
            this.con = null;
            try {
                try {
                    this.openInputFile();
                    this.connectDataBase();
                    if (this.csvInfo.getDuplicateKeyAction() == DupliKeyActionMode.ALLDELETE) {
                        this.allDelete();
                    }
                    CsvImportSqlExecute cise = this.headerCheck();
                    this.fileImport(cise);
                    JDialogMessage.infoDialog(this.msg(), "Import\u6210\u529f");
                }
                catch (CsvImport.CsvImportException cie) {
                    if (this.con == null) break block8;
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        JDialogMessage.sqlErrorDialog(e, "RollBack\u306b\u5931\u6557" + this.msg());
                    }
                }
            }
            finally {
                this.closeInputFile();
                SqlExec.disconnect(this.con);
            }
        }
    }

    private String msg() {
        return "\n" + this.csvInfo.getPropTableName().getCompleteTableName() + " \u306eImport\u7d42\u4e86" + "\n  INFILE: " + this.inputCnt + " \u30ec\u30b3\u30fc\u30c9" + "\n  UPDATE: " + this.resultCntUpdate + " \u884c" + "\n  INSERT: " + this.resultCntInsert + " \u884c" + "\n  DELETE: " + this.resultCntDelete + " \u884c" + "\n";
    }

    private void connectDataBase() throws CsvImport.CsvImportException {
        try {
            this.con = SqlExec.getNewConnection();
            if (this.csvInfo.getCommitCnt() == 0) {
                this.con.setAutoCommit(true);
            } else {
                this.con.setAutoCommit(false);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JDialogMessage.sqlErrorDialog(ex, "DB\u63a5\u7d9a\u3067\u30a8\u30e9\u30fc" + this.msg());
            throw new CsvImport.CsvImportException(this);
        }
    }

    private void allDelete() throws CsvImport.CsvImportException {
        PrepareExecUpdate peu = new PrepareExecUpdate();
        peu.addStm("DELETE FROM " + this.csvInfo.getPropTableName().getCompleteTableName());
        try {
            this.resultCntDelete = peu.prepareExecuteUpdate(this.con);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JDialogMessage.sqlErrorDialog(ex, "\u5168\u4ef6\u524a\u9664\u3067\u30a8\u30e9\u30fc" + peu.getStm() + this.msg());
            throw new CsvImport.CsvImportException(this);
        }
    }

    private CsvImportSqlExecute headerCheck() throws CsvImport.CsvImportException {
        CsvImportSqlExecute cise;
        Vector<String> header = new Vector();
        if (this.csvInfo.hasItemHeader()) {
            try {
                header = this.readFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                JDialogMessage.errorDialog(e);
                throw new CsvImport.CsvImportException(this);
            }
            if (header == null) {
                Exception e = new Exception("\u898b\u51fa\u3057\u6709\u308a\u306a\u306e\u306b\u3001\u7a7a\u30d5\u30a1\u30a4\u30eb\u3067\u3059" + this.msg());
                e.printStackTrace();
                JDialogMessage.errorDialog(e);
                throw new CsvImport.CsvImportException(this);
            }
        }
        try {
            cise = new CsvImportSqlExecute(this.con, this.csvInfo.getPropTableName(), header);
        }
        catch (SQLException e) {
            e.printStackTrace();
            JDialogMessage.sqlErrorDialog(e, "DB\u5b9a\u7fa9\u78ba\u8a8d\u4e2d\u306b\u30a8\u30e9\u30fc" + this.msg());
            throw new CsvImport.CsvImportException(this);
        }
        if (this.csvInfo.hasItemHeader()) {
            String str = cise.hasAllColumn();
            if (!str.equals("")) {
                Exception e = new Exception("CSV\u306e\u898b\u51fa\u3057\u30ab\u30e9\u30e0\u304c\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u306b\u7121\u3044\n" + str + this.msg());
                e.printStackTrace();
                JDialogMessage.errorDialog(e);
                throw new CsvImport.CsvImportException(this);
            }
            if (!(this.csvInfo.getDuplicateKeyAction() != DupliKeyActionMode.UPDATE && this.csvInfo.getDuplicateKeyAction() != DupliKeyActionMode.NONE || (str = cise.hasPrimeKey()).equals(""))) {
                Exception e = new Exception("\u4e3b\u30ad\u30fc\u5b9a\u7fa9\u30ab\u30e9\u30e0\u304cCSV\u306e\u898b\u51fa\u3057\u306b\u7121\u3044\n" + str + this.msg());
                e.printStackTrace();
                JDialogMessage.errorDialog(e);
                throw new CsvImport.CsvImportException(this);
            }
        }
        return cise;
    }

    private void fileImport(CsvImportSqlExecute cise) throws CsvImport.CsvImportException {
        int commitCnt = 1;
        try {
            Vector<String> rowData = this.readFile();
            while (rowData != null) {
                switch (this.csvInfo.getDuplicateKeyAction()) {
                    case UPDATE: {
                        int updateCnt = cise.execUpdate(rowData);
                        if (updateCnt == 0) {
                            this.resultCntInsert += cise.execInsertColumnAndValue(rowData);
                            break;
                        }
                        this.resultCntUpdate += updateCnt;
                        break;
                    }
                    case NONE: {
                        if (cise.querySelectCount(rowData) != 0) break;
                        this.resultCntInsert += cise.execInsertColumnAndValue(rowData);
                        break;
                    }
                    default: {
                        if (this.csvInfo.hasItemHeader()) {
                            this.resultCntInsert += cise.execInsertColumnAndValue(rowData);
                            break;
                        }
                        this.resultCntInsert += cise.execInsertOnlyValuePhrase(rowData);
                    }
                }
                if (this.csvInfo.getCommitCnt() == 100 && ++commitCnt > 100) {
                    this.con.commit();
                    commitCnt = 1;
                }
                rowData = this.readFile();
            }
            if (this.csvInfo.getCommitCnt() != 0) {
                this.con.commit();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JDialogMessage.errorDialog(e);
            throw new CsvImport.CsvImportException(this);
        }
        catch (SQLException e) {
            e.printStackTrace();
            JDialogMessage.sqlErrorDialog(e, "DB\u66f4\u65b0\u4e2d\u306b\u30a8\u30e9\u30fc" + this.msg());
            throw new CsvImport.CsvImportException(this);
        }
    }
}

