/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jdbcacsess.ComponentProperty;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvMode;
import jdbcacsess.csv.DupliKeyActionMode;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;

public class JDialogCsv
extends JDialog {
    private static final long serialVersionUID = 1216128860809624609L;
    private CsvInfo csvInfo;
    private CsvMode csvMode;
    private JButton jButtonCancel = null;
    private JButton jButtonFileChoice = null;
    private JButton jButtonOK = null;
    private JComboBox jComboBoxCommitTiming = null;
    private JComboBox jComboBoxCrLf = null;
    private JComboBox jComboBoxDelimiter = null;
    private JComboBox jComboBoxDuplicateKey = null;
    private JComboBox jComboBoxItemHeader = null;
    private JComboBox jComboBoxStringCode = null;
    private JComboBox jComboBoxTableName = null;
    private JPanel jContentPane = null;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JLabel jLabelModeIO = new JLabel();
    private JPanel jPanelButton = null;
    private JPanel jPanelData = null;
    private JPanel jPanelProf = null;
    private DefaultComboBoxModel modelTableName;
    private JScrollPane jScrollPane = null;
    private JTextArea jTextAreaFileName = null;

    public JDialogCsv(CsvMode mode) {
        this.csvMode = mode;
        this.csvInfo = new CsvInfo();
        this.csvInfo.currentDataLoad();
        this.initialize();
    }

    public JDialogCsv(CsvMode mode, CsvInfo csvInfo) {
        this.csvMode = mode;
        this.csvInfo = csvInfo;
        this.initialize();
    }

    public JDialogCsv(CsvMode mode, SchemaTableName tableName) {
        this.csvMode = mode;
        this.csvInfo = new CsvInfo();
        this.csvInfo.currentDataLoad();
        this.csvInfo.setPropTableName(tableName);
        this.initialize();
    }

    public CsvInfo getCsvInfo() {
        return this.csvInfo;
    }

    private void initialize() {
        new ComponentProperty().restoreWindowPosition(this, 500, 400);
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JDialogCsv.this.dialogClosing();
                JDialogCsv.this.cancel();
            }
        });
        if (this.csvMode == CsvMode.IMPORT) {
            this.jLabelModeIO.setText("\uff23\uff33\uff36\u30d5\u30a1\u30a4\u30eb->\uff24\uff22 \uff08\u30a4\u30f3\u30dd\u30fc\u30c8\uff09");
            this.setTitle("\uff23\uff33\uff36\u5165\u529b");
        }
        if (this.csvMode == CsvMode.EXPORT) {
            this.jLabelModeIO.setText("\uff24\uff22->\uff23\uff33\uff36\u30d5\u30a1\u30a4\u30eb \uff08\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\uff09");
            this.setTitle("\uff23\uff33\uff36\u51fa\u529b");
            this.jComboBoxTableName.setEnabled(false);
            this.jComboBoxDuplicateKey.setEnabled(false);
            this.jComboBoxCommitTiming.setEnabled(false);
        }
        if (this.csvMode == CsvMode.EDIT) {
            this.jLabelModeIO.setText("\u30a4\u30f3\u30dd\u30fc\u30c8\u6761\u4ef6\u7de8\u96c6");
            this.setTitle("\u7de8\u96c6");
            this.jButtonOK.setText("\u4fdd\u5b58");
        }
        if (this.csvMode == CsvMode.CREATEDATA) {
            this.jLabelModeIO.setText("\u30c7\u30fc\u30bf\u81ea\u52d5\u751f\u6210");
            this.setTitle("\uff23\uff33\uff36\u51fa\u529b");
            this.jComboBoxTableName.setEnabled(false);
            this.jComboBoxDuplicateKey.setEnabled(false);
            this.jComboBoxCommitTiming.setEnabled(false);
        }
        this.jComboBoxTableName.setModel(this.getTableLists());
        this.jComboBoxDelimiter.setModel(this.csvInfo.getModelColumnDelimiter());
        this.jComboBoxCrLf.setModel(this.csvInfo.getModelLineSeparator());
        this.jComboBoxStringCode.setModel(this.csvInfo.getModelEncoding());
        this.jComboBoxItemHeader.setModel(this.csvInfo.getModelItemHeader());
        this.jComboBoxDuplicateKey.setModel(this.csvInfo.getModelDuplicateKeyAction());
        this.jComboBoxCommitTiming.setModel(this.csvInfo.getModelCommitCnt());
        this.jTextAreaFileName.setText(this.csvInfo.getFileName());
        String completeTableName = this.csvInfo.getPropTableName().getCompleteTableName();
        this.jComboBoxTableName.setSelectedItem(completeTableName.equals("") ? null : completeTableName);
        this.jComboBoxDelimiter.setSelectedItem(this.csvInfo.getPropColumnDelimiter());
        this.jComboBoxCrLf.setSelectedItem(this.csvInfo.getPropLineSeparator());
        this.jComboBoxStringCode.setSelectedItem(this.csvInfo.getPropEncoding());
        this.jComboBoxItemHeader.setSelectedItem(this.csvInfo.getPropItemHeader());
        this.jComboBoxDuplicateKey.setSelectedItem(this.csvInfo.getPropDuplicateKeyAction());
        this.jComboBoxCommitTiming.setSelectedItem(this.csvInfo.getPropCommitCnt());
        this.jTextAreaFileName.setFont(new Font(JFrameMain.fontFamilyName, 0, 12));
        this.setModal(true);
        this.setVisible(true);
    }

    private void dialogClosing() {
        new ComponentProperty().storeWindowPosition(this);
    }

    private void actionPerformedFileChoice(ActionEvent e) {
        File file = new File(this.jTextAreaFileName.getText());
        JFileChooser jFileChooser = new JFileChooser(file.getParent());
        jFileChooser.setMultiSelectionEnabled(false);
        int ans = jFileChooser.showOpenDialog(this);
        if (ans == 0) {
            this.jTextAreaFileName.setText(jFileChooser.getSelectedFile().getPath());
        }
    }

    private void actionPerformedOK(ActionEvent e) {
        this.csvInfo.setFileName(this.jTextAreaFileName.getText());
        this.csvInfo.setPropTableName(new SchemaTableName((String)this.jComboBoxTableName.getSelectedItem()));
        this.csvInfo.setPropColumnDelimiter((String)this.jComboBoxDelimiter.getSelectedItem());
        this.csvInfo.setPropLineSeparator((String)this.jComboBoxCrLf.getSelectedItem());
        this.csvInfo.setPropEncoding((String)this.jComboBoxStringCode.getSelectedItem());
        this.csvInfo.setPropItemHeader((String)this.jComboBoxItemHeader.getSelectedItem());
        this.csvInfo.setPropDuplicateKeyAction((String)this.jComboBoxDuplicateKey.getSelectedItem());
        this.csvInfo.setPropCommitCnt((String)this.jComboBoxCommitTiming.getSelectedItem());
        if (!(this.csvInfo.getDuplicateKeyAction() != DupliKeyActionMode.UPDATE && this.csvInfo.getDuplicateKeyAction() != DupliKeyActionMode.NONE || this.csvInfo.hasItemHeader())) {
            if (JOptionPane.showConfirmDialog(null, "WHERE\u53e5\u3092\u4f5c\u6210\u3059\u308b\u70ba\u306b\u306fCSV\u30c7\u30fc\u30bf\u306b\u898b\u51fa\u3057\u304c\u5fc5\u8981\u3067\u3059\u3002" + System.getProperty("line.separator") + "\u7f6e\u63db\u7121\u3057\u3067\u51e6\u7406\u3057\u307e\u3059\u304b\uff1f", "\u91cd\u8907\u30c7\u30fc\u30bf\u306e\u7f6e\u63db\u6307\u5b9a\u7121\u52b9", 0, 3) == 0) {
                this.jComboBoxDuplicateKey.setSelectedIndex(this.csvInfo.getAllWayInsert());
                this.csvInfo.setPropDuplicateKeyAction((String)this.jComboBoxDuplicateKey.getSelectedItem());
            } else {
                return;
            }
        }
        this.dialogClosing();
        this.dispose();
    }

    private void actionPerformedCancel(ActionEvent e) {
        this.cancel();
    }

    void cancel() {
        this.csvInfo = null;
        this.dispose();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanelProf(), "North");
            this.jContentPane.add((Component)this.getJPanelData(), "Center");
            this.jContentPane.add((Component)this.getJPanelButton(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanelProf() {
        if (this.jPanelProf == null) {
            this.jPanelProf = new JPanel();
            this.jPanelProf.add(this.jLabelModeIO);
            this.jLabelModeIO.setFont(new Font("Dialog", 0, 14));
            this.jLabelModeIO.setHorizontalAlignment(0);
        }
        return this.jPanelProf;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane;
    }

    private JTextArea getJTextArea() {
        if (this.jTextAreaFileName == null) {
            this.jTextAreaFileName = new JTextArea();
            this.jTextAreaFileName.setLineWrap(true);
            this.jTextAreaFileName.setFont(new Font("Dialog", 0, 12));
            this.jTextAreaFileName.setTabSize(4);
        }
        return this.jTextAreaFileName;
    }

    private JButton getJButtonFileChoice() {
        if (this.jButtonFileChoice == null) {
            this.jButtonFileChoice = new JButton();
            this.jButtonFileChoice.setText("\u53c2\u7167...");
            this.jButtonFileChoice.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogCsv.this.actionPerformedFileChoice(e);
                }
            });
        }
        return this.jButtonFileChoice;
    }

    private JComboBox getJComboBoxCommitTiming() {
        if (this.jComboBoxCommitTiming == null) {
            this.jComboBoxCommitTiming = new JComboBox();
            this.jComboBoxCommitTiming.setFont(new Font("Dialog", 0, 12));
        }
        return this.jComboBoxCommitTiming;
    }

    private JComboBox getJComboBoxCrLf() {
        if (this.jComboBoxCrLf == null) {
            this.jComboBoxCrLf = new JComboBox();
            this.jComboBoxCrLf.setFont(new Font("Dialog", 0, 12));
        }
        return this.jComboBoxCrLf;
    }

    private JComboBox getJComboBoxDelimiter() {
        if (this.jComboBoxDelimiter == null) {
            this.jComboBoxDelimiter = new JComboBox();
            this.jComboBoxDelimiter.setFont(new Font("Dialog", 0, 12));
        }
        return this.jComboBoxDelimiter;
    }

    private JComboBox getJComboBoxDuplicateKey() {
        if (this.jComboBoxDuplicateKey == null) {
            this.jComboBoxDuplicateKey = new JComboBox();
            this.jComboBoxDuplicateKey.setFont(new Font("Dialog", 0, 12));
        }
        return this.jComboBoxDuplicateKey;
    }

    private JComboBox getJComboBoxItemHeader() {
        if (this.jComboBoxItemHeader == null) {
            this.jComboBoxItemHeader = new JComboBox();
            this.jComboBoxItemHeader.setFont(new Font("Dialog", 0, 12));
        }
        return this.jComboBoxItemHeader;
    }

    private JComboBox getJComboBoxStringCode() {
        if (this.jComboBoxStringCode == null) {
            this.jComboBoxStringCode = new JComboBox();
            this.jComboBoxStringCode.setFont(new Font("Dialog", 0, 12));
        }
        return this.jComboBoxStringCode;
    }

    private JComboBox getJComboBoxTableName() {
        if (this.jComboBoxTableName == null) {
            this.jComboBoxTableName = new JComboBox();
            this.jComboBoxTableName.setFont(new Font("Dialog", 0, 12));
        }
        return this.jComboBoxTableName;
    }

    private JPanel getJPanelData() {
        if (this.jPanelData == null) {
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 1;
            gridBagConstraints22.gridy = 0;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.weighty = 1.0;
            gridBagConstraints22.gridwidth = 2;
            gridBagConstraints22.insets = new Insets(5, 2, 5, 0);
            gridBagConstraints22.anchor = 15;
            gridBagConstraints22.gridheight = 1;
            gridBagConstraints22.gridx = 2;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0);
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.fill = 0;
            gridBagConstraints15.anchor = 13;
            gridBagConstraints15.gridheight = 1;
            gridBagConstraints15.insets = new Insets(5, 0, 5, 3);
            gridBagConstraints15.gridy = 0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0);
            gridBagConstraints14.gridy = 7;
            gridBagConstraints14.gridwidth = 2;
            gridBagConstraints14.anchor = 10;
            gridBagConstraints14.insets = new Insets(5, 2, 5, 0);
            gridBagConstraints14.gridx = 2;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0);
            gridBagConstraints13.gridy = 6;
            gridBagConstraints13.gridwidth = 2;
            gridBagConstraints13.anchor = 10;
            gridBagConstraints13.insets = new Insets(5, 2, 5, 0);
            gridBagConstraints13.gridx = 2;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0);
            gridBagConstraints12.gridy = 5;
            gridBagConstraints12.gridwidth = 2;
            gridBagConstraints12.anchor = 10;
            gridBagConstraints12.insets = new Insets(5, 2, 5, 0);
            gridBagConstraints12.gridx = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0);
            gridBagConstraints11.gridy = 4;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.anchor = 10;
            gridBagConstraints11.insets = new Insets(5, 2, 5, 0);
            gridBagConstraints11.gridx = 2;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0);
            gridBagConstraints10.gridy = 3;
            gridBagConstraints10.gridwidth = 2;
            gridBagConstraints10.anchor = 10;
            gridBagConstraints10.insets = new Insets(5, 2, 5, 0);
            gridBagConstraints10.gridx = 2;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0);
            gridBagConstraints9.gridy = 2;
            gridBagConstraints9.gridwidth = 2;
            gridBagConstraints9.anchor = 10;
            gridBagConstraints9.insets = new Insets(5, 2, 5, 0);
            gridBagConstraints9.gridx = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 1, new Insets(5, 0, 5, 0), 0, 0);
            gridBagConstraints8.gridy = 1;
            gridBagConstraints8.gridwidth = 2;
            gridBagConstraints8.anchor = 10;
            gridBagConstraints8.insets = new Insets(5, 2, 5, 0);
            gridBagConstraints8.gridx = 2;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints7.gridy = 7;
            gridBagConstraints7.anchor = 13;
            gridBagConstraints7.insets = new Insets(0, 0, 0, 3);
            gridBagConstraints7.gridx = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints6.gridy = 6;
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.insets = new Insets(0, 0, 0, 3);
            gridBagConstraints6.gridx = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints5.gridy = 5;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 3);
            gridBagConstraints5.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints4.gridy = 4;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 3);
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 3);
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0);
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(5, 0, 5, 3);
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 3);
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 7;
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.gridy = 0;
            this.jPanelData = new JPanel();
            this.jPanelData.setLayout(new GridBagLayout());
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("\u9805\u76ee\u9593\u306e\u533a\u5207\u308a\u6587\u5b57");
            this.jLabel3 = new JLabel();
            this.jLabel3.setHorizontalAlignment(0);
            this.jLabel3.setHorizontalTextPosition(0);
            this.jLabel3.setText("\u30d5\u30a1\u30a4\u30eb\u540d");
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("\u6539\u884c\u6587\u5b57");
            this.jLabel5 = new JLabel();
            this.jLabel5.setToolTipText("");
            this.jLabel5.setText("CSV\u30d5\u30a1\u30a4\u30eb\u306e\u65e5\u672c\u8a9e\u30b3\u30fc\u30c9");
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("\u9805\u76ee\u898b\u51fa\u3057");
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("\u91cd\u8907\u30c7\u30fc\u30bf\u306e\u6271\u3044");
            this.jLabel9 = new JLabel();
            this.jLabel9.setText("\u5bfe\u8c61\u30c6\u30fc\u30d6\u30eb");
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("COMMIT\u65b9\u6cd5");
            this.jPanelData.add((Component)this.getJComboBoxDelimiter(), gridBagConstraints9);
            this.jPanelData.add((Component)this.jLabel1, gridBagConstraints2);
            this.jPanelData.add((Component)this.jLabel3, gridBagConstraints15);
            this.jPanelData.add((Component)this.jLabel4, gridBagConstraints3);
            this.jPanelData.add((Component)this.getJComboBoxCrLf(), gridBagConstraints10);
            this.jPanelData.add((Component)this.jLabel5, gridBagConstraints4);
            this.jPanelData.add((Component)this.getJComboBoxStringCode(), gridBagConstraints11);
            this.jPanelData.add((Component)this.jLabel6, gridBagConstraints5);
            this.jPanelData.add((Component)this.getJComboBoxItemHeader(), gridBagConstraints12);
            this.jPanelData.add((Component)this.jLabel7, gridBagConstraints6);
            this.jPanelData.add((Component)this.getJComboBoxDuplicateKey(), gridBagConstraints13);
            this.jPanelData.add((Component)this.getJComboBoxTableName(), gridBagConstraints8);
            this.jPanelData.add((Component)this.jLabel9, gridBagConstraints1);
            this.jPanelData.add((Component)this.getJComboBoxCommitTiming(), gridBagConstraints14);
            this.jPanelData.add((Component)this.jLabel2, gridBagConstraints7);
            this.jPanelData.add((Component)this.getJButtonFileChoice(), gridBagConstraints);
            this.jPanelData.add((Component)this.getJScrollPane(), gridBagConstraints22);
        }
        return this.jPanelData;
    }

    private DefaultComboBoxModel getTableLists() {
        this.modelTableName = new DefaultComboBoxModel();
        try {
            if (!SqlExec.isConnect()) {
                JDialogMessage.notConnectErrorDialog();
                return this.modelTableName;
            }
            for (String schema : SqlExec.getSchemaNames()) {
                for (SchemaTableName table : SqlExec.getCompleteTableNames(schema)) {
                    this.modelTableName.addElement(table.getCompleteTableName());
                }
            }
        }
        catch (SQLException e) {
            JDialogMessage.sqlErrorDialog(e, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u60c5\u5831\u53d6\u5f97");
            e.printStackTrace();
            return this.modelTableName;
        }
        String tbl = this.csvInfo.getPropTableName().getCompleteTableName();
        if (!tbl.equals("") && this.modelTableName.getIndexOf(tbl) < 0) {
            this.modelTableName.addElement(tbl);
        }
        return this.modelTableName;
    }

    private JPanel getJPanelButton() {
        if (this.jPanelButton == null) {
            this.jPanelButton = new JPanel();
            this.jPanelButton.add((Component)this.getJButtonOK(), null);
            this.jPanelButton.add((Component)this.getJButtonCancel(), null);
        }
        return this.jPanelButton;
    }

    private JButton getJButtonOK() {
        if (this.jButtonOK == null) {
            this.jButtonOK = new JButton();
            this.jButtonOK.setText("\u5b9f\u884c");
            this.jButtonOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JDialogCsv.this.actionPerformedOK(e);
                }
            });
        }
        return this.jButtonOK;
    }

    private JButton getJButtonCancel() {
        this.jButtonCancel = new JButton();
        this.jButtonCancel.setText("\u53d6\u6d88");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDialogCsv.this.actionPerformedCancel(e);
            }
        });
        return this.jButtonCancel;
    }
}

