/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jdbcacsess.ColumnWidth;
import jdbcacsess.ComponentProperty;
import jdbcacsess.csv.CsvImportDB;
import jdbcacsess.csv.CsvImportDataView;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvMode;
import jdbcacsess.csv.ImportHistoryTableModel;
import jdbcacsess.csv.JDialogCsv;
import jdbcacsess.gui.JDialogMessage;
import jdbcacsess.sql.SqlExec;

public class JFrameImportHistory
extends JFrame {
    private static final long serialVersionUID = 7126241261349764262L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JPanel jPanel = null;
    private JButton jButtonOK = null;
    private ImportHistoryTableModel importHistoryTableModel;
    private JButton jButtonDelete = null;
    private JButton jButtonDisplayUpdate = null;
    private JButton jButtonEdit = null;
    private JPopupMenu jPopupMenu = null;
    private JMenuItem jMenuItemOK = null;
    private JMenuItem jMenuItemEdit = null;
    private JMenuItem jMenuItemDelete = null;
    private static JFrameImportHistory jDialogImportHistory;
    private JButton jButtonDataView = null;
    private JMenuItem jMenuItemDataView = null;

    public static JFrameImportHistory getNewInstance() {
        if (jDialogImportHistory == null) {
            jDialogImportHistory = new JFrameImportHistory();
        }
        jDialogImportHistory.setVisible(true);
        return jDialogImportHistory;
    }

    JFrameImportHistory() {
        this.initialize();
    }

    private void initialize() {
        new ComponentProperty().restoreWindowPosition(this, 800, 400);
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JFrameImportHistory.this.dialogClosing();
            }
        });
        this.setTitle("CSV\u5165\u529b\u5c65\u6b74");
        this.importHistoryTableModel = new ImportHistoryTableModel();
        this.jTable.setModel(this.importHistoryTableModel);
        this.jTable.setSelectionMode(2);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        this.jTable.setComponentPopupMenu(this.getJPopupMenu());
        this.jTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int columnIndex = JFrameImportHistory.this.jTable.getTableHeader().columnAtPoint(e.getPoint());
                JFrameImportHistory.this.importHistoryTableModel.setSortColumnIndex(columnIndex);
            }
        });
        ColumnWidth.setColumnWidth(this.jTable);
    }

    public void reLoad() {
        this.importHistoryTableModel.reLoad();
    }

    public void dialogClosing() {
        new ComponentProperty().storeWindowPosition(this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.getJPanel(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable(10, 10);
        }
        return this.jTable;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getJButtonDisplayUpdate(), null);
            this.jPanel.add((Component)this.getJButtonDataView(), null);
            this.jPanel.add((Component)this.getJButtonEdit(), null);
            this.jPanel.add((Component)this.getJButtonDelete(), null);
            this.jPanel.add((Component)this.getJButtonImport(), null);
        }
        return this.jPanel;
    }

    private JButton getJButtonImport() {
        if (this.jButtonOK == null) {
            this.jButtonOK = new JButton();
            this.jButtonOK.setText("Import\u5b9f\u884c");
            this.jButtonOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedImport();
                }
            });
        }
        return this.jButtonOK;
    }

    private JButton getJButtonDelete() {
        if (this.jButtonDelete == null) {
            this.jButtonDelete = new JButton();
            this.jButtonDelete.setText("\u6761\u4ef6\u524a\u9664");
            this.jButtonDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedDelete();
                }
            });
        }
        return this.jButtonDelete;
    }

    private void actionPerformedImport() {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        if (this.jTable.getSelectedColumnCount() == 0) {
            JDialogMessage.infoDialog("\u9078\u629e\u3055\u308c\u3066\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
            return;
        }
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int index = nArray[n];
            new Thread(new CsvImportDB(this.importHistoryTableModel.getCsvInfo(index))).start();
            ++n;
        }
    }

    private void actionPerformedDelete() {
        if (this.jTable.getSelectedColumnCount() == 0) {
            JDialogMessage.infoDialog("\u9078\u629e\u3055\u308c\u3066\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
            return;
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int idx = nArray[n];
            fileNames.add(this.importHistoryTableModel.getKey(idx));
            ++n;
        }
        for (String key : fileNames) {
            this.importHistoryTableModel.remove(key);
        }
    }

    private void actionPerformedEditCsvInfo() {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        if (this.jTable.getSelectedColumnCount() == 0) {
            JDialogMessage.infoDialog("\u9078\u629e\u3055\u308c\u3066\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
            return;
        }
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int idx = nArray[n];
            JDialogCsv dlg = new JDialogCsv(CsvMode.EDIT, this.importHistoryTableModel.getCsvInfo(idx));
            CsvInfo csvInfo = dlg.getCsvInfo();
            if (dlg.getCsvInfo() != null) {
                csvInfo.currentDataSave();
                this.importHistoryTableModel.fireTableRowsUpdated(idx, idx);
            }
            ++n;
        }
    }

    private JButton getJButtonDisplayUpdate() {
        if (this.jButtonDisplayUpdate == null) {
            this.jButtonDisplayUpdate = new JButton();
            this.jButtonDisplayUpdate.setText("\u4e00\u89a7\u3092\u66f4\u65b0");
            this.jButtonDisplayUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.reLoad();
                }
            });
        }
        return this.jButtonDisplayUpdate;
    }

    private JButton getJButtonEdit() {
        if (this.jButtonEdit == null) {
            this.jButtonEdit = new JButton();
            this.jButtonEdit.setText("\u6761\u4ef6\u7de8\u96c6...");
            this.jButtonEdit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedEditCsvInfo();
                }
            });
        }
        return this.jButtonEdit;
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJMenuItemDataView());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemEdit());
            this.jPopupMenu.add(this.getJMenuItemDelete());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemOK());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJMenuItemOK() {
        if (this.jMenuItemOK == null) {
            this.jMenuItemOK = new JMenuItem();
            this.jMenuItemOK.setText("Import\u5b9f\u884c");
            this.jMenuItemOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedImport();
                }
            });
        }
        return this.jMenuItemOK;
    }

    private JMenuItem getJMenuItemEdit() {
        if (this.jMenuItemEdit == null) {
            this.jMenuItemEdit = new JMenuItem();
            this.jMenuItemEdit.setText("\u6761\u4ef6\u7de8\u96c6...");
            this.jMenuItemEdit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedEditCsvInfo();
                }
            });
        }
        return this.jMenuItemEdit;
    }

    private JMenuItem getJMenuItemDelete() {
        if (this.jMenuItemDelete == null) {
            this.jMenuItemDelete = new JMenuItem();
            this.jMenuItemDelete.setText("\u6761\u4ef6\u524a\u9664");
            this.jMenuItemDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedDelete();
                }
            });
        }
        return this.jMenuItemDelete;
    }

    private JButton getJButtonDataView() {
        if (this.jButtonDataView == null) {
            this.jButtonDataView = new JButton();
            this.jButtonDataView.setText("\u30c7\u30fc\u30bf100\u4ef6\u53c2\u7167...");
            this.jButtonDataView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedDataView();
                }
            });
        }
        return this.jButtonDataView;
    }

    protected void actionPerformedDataView() {
        if (this.jTable.getSelectedColumnCount() == 0) {
            JDialogMessage.infoDialog("\u9078\u629e\u3055\u308c\u3066\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
            return;
        }
        int[] nArray = this.jTable.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int index = nArray[n];
            new CsvImportDataView(this.importHistoryTableModel.getCsvInfo(index));
            ++n;
        }
    }

    private JMenuItem getJMenuItemDataView() {
        if (this.jMenuItemDataView == null) {
            this.jMenuItemDataView = new JMenuItem();
            this.jMenuItemDataView.setText("\u30c7\u30fc\u30bf100\u4ef6\u53c2\u7167...");
            this.jMenuItemDataView.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.this.actionPerformedDataView();
                }
            });
        }
        return this.jMenuItemDataView;
    }
}

