/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.Color;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jdbcacsess.JPopupMenuCnageUI;
import jdbcacsess.JTextFieldEdit;
import jdbcacsess.csv.CSVLine;
import jdbcacsess.gui.CellEditorBinary;
import jdbcacsess.gui.CellEditorOracleDate;
import jdbcacsess.gui.CellMode;
import jdbcacsess.gui.CellRendererSqlTable;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.JTableSqlModel;
import jdbcacsess.gui.RowInsertValueMode;
import jdbcacsess.sql.Binary;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.OracleDate;
import jdbcacsess.sql.QueryExecuteAdapter;
import jdbcacsess.sql.SqlAnalyze;

public class JTableSql
extends JTable
implements ClipboardOwner {
    private static final long serialVersionUID = -3304832537800845261L;
    private JPopupMenuCnageUI jPopupMenu = null;
    private JMenuItem jMenuItemSetNULL = null;
    private JMenuItem jMenuItemToClipRangeComma = null;
    private JMenuItem jMenuItemRowDelete = null;
    private JMenuItem jMenuItemRowInsert = null;
    private JMenuItem jMenuItemRowInsertNull = null;
    private JMenuItem jMenuItemRowCopy = null;
    private int row;
    private int col;
    private JMenuItem jMenuItemToClipRangeTab = null;
    private JMenuItem jMenuItemDefaultInsert = null;
    private JMenuItem jMenuItemSelectRow = null;
    private JMenuItem jMenuItemSelectAll = null;

    public JTableSql() {
        this.initialize();
    }

    private void initialize() {
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(1);
        ListSelectionModel model = this.getSelectionModel();
        model.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JTableSql.this.editTable_selectionvalueChanged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                JTableSql.this.actionPerformedPopuUp(e);
            }

            public void mousePressed(MouseEvent e) {
                JTableSql.this.actionPerformedPopuUp(e);
            }
        });
        this.getJPopupMenu();
    }

    private void actionPerformedPopuUp(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JTableSqlModel model;
            this.row = this.rowAtPoint(e.getPoint());
            this.col = this.columnAtPoint(e.getPoint());
            if (!this.isCellSelected(this.row, this.col)) {
                this.setRowSelectionInterval(this.row, this.row);
            }
            if ((model = (JTableSqlModel)this.getModel()).isCellEditable(this.row, this.col)) {
                this.jMenuItemSetNULL.setEnabled(true);
                this.jMenuItemRowDelete.setEnabled(true);
                this.jMenuItemRowCopy.setEnabled(true);
            } else {
                if (model.getMode(this.row, this.col) == CellMode.CELL_INSERT) {
                    this.jMenuItemSetNULL.setEnabled(true);
                    this.jMenuItemRowDelete.setEnabled(true);
                } else {
                    this.jMenuItemSetNULL.setEnabled(false);
                    this.jMenuItemRowDelete.setEnabled(false);
                }
                this.jMenuItemRowCopy.setEnabled(false);
            }
            if (model.getMode(this.row, this.col) == CellMode.CELL_INSERT) {
                this.jMenuItemDefaultInsert.setEnabled(true);
                if (model.isDefaultInsert(this.row, this.col)) {
                    this.jMenuItemDefaultInsert.setText("Insert\u304b\u3089\u9664\u5916\u3057\u306a\u3044");
                } else {
                    this.jMenuItemDefaultInsert.setText("Insert\u304b\u3089\u9664\u5916\u3059\u308b");
                }
            } else {
                this.jMenuItemDefaultInsert.setEnabled(false);
            }
            this.jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        System.out.println("\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u6240\u6709\u6a29\u3092\u5931\u3044\u307e\u3057\u305f");
    }

    private void actionPerformedCopyRange(char delim) {
        Clipboard cb = this.getToolkit().getSystemClipboard();
        JTableSqlModel tbl = (JTableSqlModel)this.getModel();
        int countCol = this.getSelectedColumnCount();
        int countRow = this.getSelectedRowCount();
        int[] selCols = this.getSelectedColumns();
        int[] selRows = this.getSelectedRows();
        StringBuffer selectString = new StringBuffer();
        int idxCol = 0;
        while (idxCol < countCol) {
            if (idxCol != 0) {
                selectString.append(delim);
            }
            selectString.append(tbl.getColumnName(selCols[idxCol]));
            ++idxCol;
        }
        selectString.append("\n");
        int idxRow = 0;
        while (idxRow < countRow) {
            CellMode cellMode = tbl.getMode(idxRow, 0);
            if (cellMode == CellMode.CELL_NON || cellMode == CellMode.CELL_INSERT || cellMode == CellMode.CELL_UPDATE || cellMode == CellMode.CELL_INSERT_COMPLETE || cellMode == CellMode.CELL_UPDATE_COMPLETE) {
                CSVLine csvline = new CSVLine();
                csvline.setToken(delim);
                int idxCol2 = 0;
                while (idxCol2 < countCol) {
                    Object o = tbl.getValueAt(selRows[idxRow], selCols[idxCol2]);
                    if (o != null) {
                        csvline.addItem(o.toString());
                    } else {
                        csvline.addItem(JFrameMain.CSVNULLVALUE);
                    }
                    ++idxCol2;
                }
                if (csvline.size() != 0) {
                    selectString.append(csvline.getLine()).append("\n");
                }
            }
            ++idxRow;
        }
        StringSelection ss = new StringSelection(selectString.toString());
        cb.setContents(ss, this);
    }

    private void actionPerformedSetNULL(ActionEvent e) {
        TableModel tbl = this.getModel();
        int[] nArray = this.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int row = nArray[n];
            int[] nArray2 = this.getSelectedColumns();
            int n3 = 0;
            int n4 = nArray2.length;
            while (n3 < n4) {
                int col = nArray2[n3];
                tbl.setValueAt(null, row, col);
                ++n3;
            }
            ++n;
        }
    }

    private void actionPerformedDefaultInsert(ActionEvent e) {
        JTableSqlModel tbl;
        tbl.setDefaultInsert(!(tbl = (JTableSqlModel)this.getModel()).isDefaultInsert(this.row, this.col), this.row, this.col);
    }

    private void actionPerformedRowDelete(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowDelete(this.getSelectedRows());
    }

    private void actionPerformedRowInsert(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowCopy(this.getSelectedRows()[0], RowInsertValueMode.VALUEROWNEW);
    }

    private void actionPerformedRowInsertNull(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowCopy(this.getSelectedRows()[0], RowInsertValueMode.ALLNULLROWNEW);
    }

    private void actionPerformedRowCopy(ActionEvent e) {
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowCopy(this.getSelectedRows()[0], RowInsertValueMode.ROWCOPY);
    }

    private void editTable_selectionvalueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.getSelectedRow() == -1) {
            return;
        }
        JTableSqlModel sqlTableModel = (JTableSqlModel)this.getModel();
        sqlTableModel.rowInsert(this.getSelectedRow());
    }

    private JPopupMenuCnageUI getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenuCnageUI();
            this.jPopupMenu.add(this.getJMenuItemSetNULL());
            this.jPopupMenu.add(this.getJMenuItemDefaultInsert());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemRowDelete());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemRowInsert());
            this.jPopupMenu.add(this.getJMenuItemRowInsertNull());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemRowCopy());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemToClipRangeComma());
            this.jPopupMenu.add(this.getJMenuItemToClipRangeTab());
            this.jPopupMenu.addSeparator();
            this.jPopupMenu.add(this.getJMenuItemSelectRow());
            this.jPopupMenu.add(this.getJMenuItemSelectAll());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJMenuItemSetNULL() {
        if (this.jMenuItemSetNULL == null) {
            this.jMenuItemSetNULL = new JMenuItem();
            this.jMenuItemSetNULL.setText("NULL\u306b\u66f4\u65b0");
            this.jMenuItemSetNULL.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedSetNULL(e);
                }
            });
        }
        return this.jMenuItemSetNULL;
    }

    private JMenuItem getJMenuItemToClipRangeComma() {
        if (this.jMenuItemToClipRangeComma == null) {
            this.jMenuItemToClipRangeComma = new JMenuItem();
            this.jMenuItemToClipRangeComma.setText("\u30ab\u30f3\u30de\u533a\u5207\u308a\u3067\u30b3\u30d4\u30fc");
            this.jMenuItemToClipRangeComma.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedCopyRange(',');
                }
            });
        }
        return this.jMenuItemToClipRangeComma;
    }

    private JMenuItem getJMenuItemRowDelete() {
        if (this.jMenuItemRowDelete == null) {
            this.jMenuItemRowDelete = new JMenuItem();
            this.jMenuItemRowDelete.setText("\u884c\u524a\u9664");
            this.jMenuItemRowDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowDelete(e);
                }
            });
        }
        return this.jMenuItemRowDelete;
    }

    private JMenuItem getJMenuItemRowInsert() {
        if (this.jMenuItemRowInsert == null) {
            this.jMenuItemRowInsert = new JMenuItem();
            this.jMenuItemRowInsert.setText("\u5024\u8a2d\u5b9a\u6e08\u884c\u633f\u5165");
            this.jMenuItemRowInsert.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowInsert(e);
                }
            });
        }
        return this.jMenuItemRowInsert;
    }

    private JMenuItem getJMenuItemRowInsertNull() {
        if (this.jMenuItemRowInsertNull == null) {
            this.jMenuItemRowInsertNull = new JMenuItem();
            this.jMenuItemRowInsertNull.setText("null\u5024\u884c\u633f\u5165");
            this.jMenuItemRowInsertNull.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowInsertNull(e);
                }
            });
        }
        return this.jMenuItemRowInsertNull;
    }

    private JMenuItem getJMenuItemRowCopy() {
        if (this.jMenuItemRowCopy == null) {
            this.jMenuItemRowCopy = new JMenuItem();
            this.jMenuItemRowCopy.setText("\u884c\u8907\u5199");
            this.jMenuItemRowCopy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedRowCopy(e);
                }
            });
        }
        return this.jMenuItemRowCopy;
    }

    private JMenuItem getJMenuItemToClipRangeTab() {
        if (this.jMenuItemToClipRangeTab == null) {
            this.jMenuItemToClipRangeTab = new JMenuItem();
            this.jMenuItemToClipRangeTab.setText("\u30bf\u30d6\u533a\u5207\u308a\u3067\u30b3\u30d4\u30fc");
            this.jMenuItemToClipRangeTab.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedCopyRange('\t');
                }
            });
        }
        return this.jMenuItemToClipRangeTab;
    }

    private JMenuItem getJMenuItemDefaultInsert() {
        if (this.jMenuItemDefaultInsert == null) {
            this.jMenuItemDefaultInsert = new JMenuItem();
            this.jMenuItemDefaultInsert.setText("Insert\u304b\u3089\u9664\u5916");
            this.jMenuItemDefaultInsert.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.actionPerformedDefaultInsert(e);
                }
            });
        }
        return this.jMenuItemDefaultInsert;
    }

    private JMenuItem getJMenuItemSelectRow() {
        if (this.jMenuItemSelectRow == null) {
            this.jMenuItemSelectRow = new JMenuItem();
            this.jMenuItemSelectRow.setText("\u884c\u9078\u629e");
            this.jMenuItemSelectRow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.setColumnSelectionInterval(0, JTableSql.this.getColumnCount() - 1);
                }
            });
        }
        return this.jMenuItemSelectRow;
    }

    private JMenuItem getJMenuItemSelectAll() {
        if (this.jMenuItemSelectAll == null) {
            this.jMenuItemSelectAll = new JMenuItem();
            this.jMenuItemSelectAll.setText("\u5168\u3066\u9078\u629e");
            this.jMenuItemSelectAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTableSql.this.selectAll();
                }
            });
        }
        return this.jMenuItemSelectAll;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class registCellRendererAndEditor
    extends QueryExecuteAdapter {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        @Override
        public void setResultHeader(Vector<ColumnInfoResult> rowData, SqlAnalyze sqlAnalyze) {
            Enumeration<TableColumn> cols = JTableSql.this.getColumnModel().getColumns();
            int idx = 0;
            while (cols.hasMoreElements()) {
                TableColumn col = cols.nextElement();
                col.setCellRenderer(new CellRendererSqlTable());
                JTextFieldEdit textField = new JTextFieldEdit();
                textField.setBorder(new LineBorder(Color.red));
                DefaultCellEditor editor = null;
                editor = rowData.get(idx).getColumnClass() == OracleDate.class ? new CellEditorOracleDate(textField) : (rowData.get(idx).getColumnClass() == Binary.class ? new CellEditorBinary(textField) : new DefaultCellEditor(textField));
                col.setCellEditor(editor);
                ++idx;
            }
        }
    }
}

