/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.dbconnect;

import java.io.IOException;
import jdbcacsess.InfoListSetting;
import jdbcacsess.dbconnect.DBMSinfo;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectInfo
extends InfoListSetting<ConnectInfo> {
    private String profName = "";
    private DBMSinfo dbmsInfo = new DBMSinfo();
    private String hostName = "";
    private String portNumber = "";
    private String dataBaseName = "";
    private String userID = "";
    private String password = "";
    private String optionString = "";
    private String classPathTextInput = "";
    private String driverPath = "";

    public String toString() {
        String str = "DBMS=" + this.getDBMS() + ";hostName=" + this.getHostName() + ";portNumber=" + this.getPortNumber() + ";dataBaseName=" + this.getDataBaseName() + ";optionString=" + this.getOptionString() + ";userID=" + this.getUserID() + ";password=" + this.getPassword() + ";DriverPath=" + this.getDriverPath();
        return str;
    }

    @Override
    protected String getKeyValue() {
        return this.getProfName();
    }

    @Override
    protected void setKeyValue(String key) {
        this.setProfName(key);
    }

    @Override
    protected String getBaseTagName() {
        return "connectinfo";
    }

    @Override
    protected ConnectInfo getInstance() {
        return new ConnectInfo();
    }

    @Override
    public void setFromElement(Element node) {
        this.setDBMS(node.getAttribute("DBMS"));
        this.setHostName(node.getAttribute("HostName"));
        this.setPortNumber(node.getAttribute("PortNumber"));
        this.setDataBaseName(node.getAttribute("DataBaseName"));
        this.setOptionString(node.getAttribute("OptionString"));
        this.setUserID(node.getAttribute("UserID"));
        this.setPassword(node.getAttribute("Password"));
        this.setClassPathTextInput(node.getAttribute("ClassPathTextInput"));
        this.setDriverPath(node.getAttribute("DriverPath"));
    }

    @Override
    public void addToElement(Element node) {
        node.setAttribute("DBMS", this.getDBMS());
        node.setAttribute("HostName", this.getHostName());
        node.setAttribute("PortNumber", this.getPortNumber());
        node.setAttribute("DataBaseName", this.getDataBaseName());
        node.setAttribute("OptionString", this.getOptionString());
        node.setAttribute("UserID", this.getUserID());
        node.setAttribute("Password", this.getPassword());
        node.setAttribute("ClassPathTextInput", this.getClassPathTextInput());
        node.setAttribute("DriverPath", this.getDriverPath());
    }

    public void setProfName(String profName) {
        this.profName = profName;
    }

    public String getProfName() {
        return this.profName;
    }

    public void setDBMS(String dBMS) {
        try {
            this.dbmsInfo.setDBMSname(dBMS);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDBMS() {
        return this.dbmsInfo.getDBMSname();
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPortNumber(String portNumber) {
        this.portNumber = portNumber;
    }

    public String getPortNumber() {
        return this.portNumber;
    }

    public void setDataBaseName(String dataBaseName) {
        this.dataBaseName = dataBaseName;
    }

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOptionString() {
        return this.optionString;
    }

    public void setOptionString(String optionString) {
        this.optionString = optionString;
    }

    public String getUrl() {
        String url = this.dbmsInfo.getUrl();
        url = this.replaceString(url, "%HostName%", this.getHostName());
        url = this.replaceString(url, "%DataBaseName%", this.getDataBaseName());
        url = this.replaceString(url, "%PortNumber%", String.valueOf("".equals(this.getPortNumber()) ? "" : ":") + this.getPortNumber());
        url = String.valueOf(url) + this.getOptionString();
        return url;
    }

    private String replaceString(String org, String b, String a) {
        StringBuffer newString = new StringBuffer(org);
        int start = org.indexOf(b);
        if (start == -1) {
            return org;
        }
        newString.replace(start, start + b.length(), a);
        return newString.toString();
    }

    public String getClassPath() {
        return this.dbmsInfo.getClassPath();
    }

    public String getClassPathTextInput() {
        return this.classPathTextInput;
    }

    public void setClassPathTextInput(String className) {
        this.classPathTextInput = className;
    }

    public String getDriverPath() {
        return this.driverPath;
    }

    public void setDriverPath(String diverPath) {
        this.driverPath = diverPath;
    }
}

