/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.sql.DriverManager;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jdbcacsess.ComponentProperty;
import jdbcacsess.SettingFile;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.JFrameSetting;
import jdbcacsess.sql.SqlMappingInfo;

public class JdbcAcsess {
    private static boolean fource = true;
    static /* synthetic */ Class class$0;

    private static void envDisplay() {
        Logger.global.info("file.encoding:" + System.getProperty("file.encoding"));
        StringBuilder sb = new StringBuilder("defaultCharset:" + Charset.defaultCharset());
        Logger.global.info(sb.toString());
        GregorianCalendar gc = new GregorianCalendar();
        Logger.global.info("\u30ab\u30ec\u30f3\u30c0\u30fc:" + gc.toString());
        Logger.global.info("\u30bf\u30a4\u30e0\u30be\u30fc\u30f3:" + gc.getTimeZone().toString());
    }

    public static void main(String[] args) {
        try {
            FileHandler fh = new FileHandler(SettingFile.getInstance().getFileName("message.log"));
            fh.setFormatter(new SimpleFormatter());
            Logger.global.addHandler(fh);
            Logger.global.setLevel(JFrameSetting.getLoggerLevel());
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String className = new ComponentProperty().getToString(UIManager.class, "className");
        if ("".equals(className)) {
            className = UIManager.getSystemLookAndFeelClassName();
            new ComponentProperty().put(UIManager.class, "className", className);
        }
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        DriverManager.setLogWriter(new PrintWriter(System.out));
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        JdbcAcsess.saveDefaultMapping();
        new JFrameMain();
        JdbcAcsess.envDisplay();
    }

    private static void saveDefaultMapping() {
        Map map = new SqlMappingInfo().getInfoMap();
        JdbcAcsess.save(map, "Oracle", "BINARY_DOUBLE", "getDouble", "");
        JdbcAcsess.save(map, "Oracle", "BINARY_FLOAT", "getFloat", "");
        JdbcAcsess.save(map, "Oracle", "DATE", "", "jdbcacsess.sql.column.GetColumnTimestampSS");
        JdbcAcsess.save(map, "Oracle", "TIMESTAMP", "getTimestamp", "");
        JdbcAcsess.save(map, "Oracle", "TIMESTAMPTZ", "getString", "");
        JdbcAcsess.save(map, "Oracle", "TIMESTAMPLTZ", "", "jdbcacsess.sql.column.GetColumnOracleTIMESTAMPLTZ");
        JdbcAcsess.save(map, "MySQL", "BIT", "", "jdbcacsess.sql.column.GetColumnBytesOrBinaryStream");
        JdbcAcsess.save(map, "MySQL", "DATETIME", "", "jdbcacsess.sql.column.GetColumnTimestampSS");
        JdbcAcsess.save(map, "MySQL", "TIMESTAMP", "", "jdbcacsess.sql.column.GetColumnTimestampSS");
        JdbcAcsess.save(map, "MySQL", "TINYINT", "getInt", "");
        JdbcAcsess.save(map, "MySQL", "YEAR", "", "jdbcacsess.sql.column.GetColumnDateYYYY");
        JdbcAcsess.save(map, "PostgreSQL", "bit", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "cidr", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "inet", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "interval", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "macaddr", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "timestamptz", "getString", "");
        JdbcAcsess.save(map, "PostgreSQL", "varbit", "getString", "");
    }

    private static void save(Map map, String dbms, String type, String method, String cls) {
        SqlMappingInfo smi = new SqlMappingInfo();
        smi.setKey(dbms, type);
        if (map.get(smi.getKeyValue()) == null || fource) {
            smi.setResultSetMethodName(method);
            smi.setGetResultSetClassName(cls);
            smi.currentDataSave();
        }
    }
}

