/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import jdbcacsess.gui.JPanelExecSql;
import jdbcacsess.gui.SqlStatementObserver;
import jdbcacsess.gui.TabWinMode;

public class TabWinManager {
    private SqlStatementObserver sqlStatementObserver;
    private int tabCount = 0;
    private TabWinMode tabWin;
    private Vector<JPanelExecSql> jPanelExecSqlList = null;
    private JTabbedPane jTabbedPane = null;
    private JDesktopPane jDesktopPane = null;
    private HashMap<JInternalFrame, JPanelExecSql> jPanelExecSqlMap = null;

    public TabWinManager(TabWinMode tabWin, SqlStatementObserver sqlStatementObserver) {
        this.tabWin = tabWin;
        this.sqlStatementObserver = sqlStatementObserver;
        this.jPanelExecSqlList = new Vector();
        this.newPane(true);
        this.newPane(true);
        this.newPane(true);
        this.newPane(true);
    }

    public TabWinMode getTabWin() {
        return this.tabWin;
    }

    public JComponent getPane() {
        if (this.tabWin == TabWinMode.TAB) {
            return this.jTabbedPane;
        }
        if (this.tabWin == TabWinMode.WIN) {
            return this.jDesktopPane;
        }
        return null;
    }

    public void setTitle(JPanelExecSql pane, String title) {
        JInternalFrame jif;
        int idx;
        if (this.tabWin == TabWinMode.TAB && (idx = this.jTabbedPane.indexOfComponent(pane)) != -1) {
            this.jTabbedPane.setTitleAt(idx, title);
            this.jTabbedPane.revalidate();
        }
        if (this.tabWin == TabWinMode.WIN && (jif = this.searchParentFrame(pane)) != null) {
            jif.setTitle(title);
        }
    }

    public void newPane(boolean antoCommit) {
        JPanelExecSql pes = this.getJPanelExecSql(antoCommit);
        if (this.tabWin == TabWinMode.TAB) {
            if (this.jTabbedPane == null) {
                this.getJTabbedPane();
            } else {
                this.jTabbedPane.addTab(pes.getTitleName(), pes);
                this.jTabbedPane.setSelectedComponent(pes);
            }
        }
        if (this.tabWin == TabWinMode.WIN) {
            if (this.jDesktopPane == null) {
                this.getJDesktopPane();
            } else {
                JInternalFrame jif = this.getJInternalFrame(pes);
                this.jDesktopPane.add((Component)jif, null);
                jif.toFront();
                jif.setVisible(true);
                this.jDesktopPane.setSelectedFrame(jif);
            }
        }
    }

    public void sortWindow() {
        if (this.tabWin != TabWinMode.WIN) {
            return;
        }
        if (this.jDesktopPane == null) {
            return;
        }
        Dimension dim = this.jDesktopPane.getSize();
        int sizeList = 0;
        JInternalFrame[] jInternalFrameArray = this.jDesktopPane.getAllFrames();
        int n = 0;
        int n2 = jInternalFrameArray.length;
        while (n < n2) {
            JInternalFrame jif = jInternalFrameArray[n];
            if (!jif.isIcon()) {
                ++sizeList;
            }
            ++n;
        }
        int cntWidth = (int)Math.ceil((double)sizeList / Math.ceil(Math.sqrt(sizeList)));
        int cntHeight = (int)Math.ceil(Math.sqrt(sizeList));
        int winWidth = (int)dim.getWidth() / cntWidth;
        int winHeight = (int)dim.getHeight() / cntHeight;
        ArrayList<Point> points = new ArrayList<Point>();
        int width = 0;
        while (width < cntWidth) {
            int height = 0;
            while (height < cntHeight) {
                Point p = new Point(winWidth * width, winHeight * height);
                points.add(p);
                ++height;
            }
            ++width;
        }
        Iterator it = points.iterator();
        JInternalFrame[] jInternalFrameArray2 = this.jDesktopPane.getAllFrames();
        int n3 = 0;
        int n4 = jInternalFrameArray2.length;
        while (n3 < n4) {
            JInternalFrame jif = jInternalFrameArray2[n3];
            if (!jif.isIcon()) {
                jif.setSize(new Dimension(winWidth, winHeight));
                jif.setLocation((Point)it.next());
            }
            ++n3;
        }
    }

    private JPanelExecSql getSelectedExecSql() {
        if (this.tabWin == TabWinMode.TAB) {
            return (JPanelExecSql)this.jTabbedPane.getSelectedComponent();
        }
        if (this.tabWin == TabWinMode.WIN) {
            JInternalFrame jif = this.jDesktopPane.getSelectedFrame();
            return this.jPanelExecSqlMap.get(jif);
        }
        return null;
    }

    public void disposePane(JPanelExecSql pane) {
        JInternalFrame jif;
        if (this.tabWin == TabWinMode.TAB) {
            this.jTabbedPane.remove(pane);
        }
        if (this.tabWin == TabWinMode.WIN && (jif = this.searchParentFrame(pane)) != null) {
            jif.dispose();
            this.jPanelExecSqlMap.remove(jif);
        }
        this.jPanelExecSqlList.remove(pane);
    }

    public void allPaneClosed() {
        Vector<JPanelExecSql> tempList = new Vector<JPanelExecSql>();
        for (JPanelExecSql pane : this.jPanelExecSqlList) {
            tempList.add(pane);
        }
        for (JPanelExecSql pane : tempList) {
            pane.disconnect();
            this.disposePane(pane);
        }
    }

    public JComponent changeTabWin(TabWinMode tw) {
        JInternalFrame jif;
        if (this.tabWin == tw) {
            return this.getPane();
        }
        JPanelExecSql pesCurrent = null;
        if (this.jTabbedPane != null) {
            pesCurrent = (JPanelExecSql)this.jTabbedPane.getSelectedComponent();
        }
        if (this.jDesktopPane != null && (jif = this.jDesktopPane.getSelectedFrame()) != null) {
            pesCurrent = this.jPanelExecSqlMap.get(jif);
        }
        this.jTabbedPane = null;
        this.jDesktopPane = null;
        this.tabWin = tw;
        if (this.tabWin == TabWinMode.TAB) {
            this.getJTabbedPane();
            if (pesCurrent != null) {
                this.jTabbedPane.setSelectedComponent(pesCurrent);
            }
        }
        if (this.tabWin == TabWinMode.WIN) {
            this.getJDesktopPane();
            if (pesCurrent != null && (jif = this.searchParentFrame(pesCurrent)) != null) {
                jif.toFront();
                this.jDesktopPane.setSelectedFrame(jif);
            }
        }
        return this.getPane();
    }

    private JPanelExecSql getJPanelExecSql(boolean autoCommit) {
        JPanelExecSql pes = new JPanelExecSql(this, autoCommit);
        this.jPanelExecSqlList.add(pes);
        this.sqlStatementObserver.sqlStatementNotifyObservers(pes.getSqlStatement());
        ++this.tabCount;
        pes.setPaneName(Integer.toString(this.tabCount));
        return pes;
    }

    private JTabbedPane getJTabbedPane() {
        this.jTabbedPane = new JTabbedPane();
        this.jTabbedPane.setFont(new Font("Dialog", 0, 12));
        for (JPanelExecSql pane : this.jPanelExecSqlList) {
            this.jTabbedPane.addTab(pane.getTitleName(), pane);
            this.jTabbedPane.setSelectedComponent(pane);
        }
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JPanelExecSql pes;
                if (TabWinManager.this.jTabbedPane != null && (pes = (JPanelExecSql)TabWinManager.this.jTabbedPane.getSelectedComponent()) != null) {
                    TabWinManager.this.sqlStatementObserver.sqlStatementNotifyObservers(pes.getSqlStatement());
                }
            }
        });
        return this.jTabbedPane;
    }

    private JDesktopPane getJDesktopPane() {
        this.jDesktopPane = new JDesktopPane();
        this.jPanelExecSqlMap = new HashMap();
        int x = 0;
        int y = 0;
        for (JPanelExecSql pane : this.jPanelExecSqlList) {
            JInternalFrame jif = this.getJInternalFrame(pane);
            jif.setLocation(x, y);
            x += 15;
            y += 25;
            this.jDesktopPane.add((Component)jif, null);
            jif.toFront();
            jif.setVisible(true);
        }
        return this.jDesktopPane;
    }

    private JInternalFrame getJInternalFrame(JPanelExecSql pane) {
        JInternalFrame jInternalFrame = new JInternalFrame();
        jInternalFrame.setContentPane(this.getJContentPane(pane));
        jInternalFrame.setTitle(pane.getTitleName());
        jInternalFrame.setLocation(new Point(0, 0));
        jInternalFrame.setSize(pane.getPreferredSize());
        jInternalFrame.setIconifiable(true);
        jInternalFrame.setResizable(true);
        jInternalFrame.setMaximizable(true);
        this.jPanelExecSqlMap.put(jInternalFrame, pane);
        jInternalFrame.toFront();
        jInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                JPanelExecSql pes = (JPanelExecSql)TabWinManager.this.jPanelExecSqlMap.get(e.getInternalFrame());
                TabWinManager.this.sqlStatementObserver.sqlStatementNotifyObservers(pes.getSqlStatement());
            }
        });
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        return jInternalFrame;
    }

    private JPanel getJContentPane(JPanelExecSql pane) {
        JPanel jContentPane = new JPanel();
        jContentPane.setLayout(new BorderLayout());
        jContentPane.add((Component)pane, "Center");
        return jContentPane;
    }

    private JInternalFrame searchParentFrame(JPanelExecSql pes) {
        for (Map.Entry<JInternalFrame, JPanelExecSql> map : this.jPanelExecSqlMap.entrySet()) {
            if (map.getValue() != pes) continue;
            return map.getKey();
        }
        return null;
    }
}

