/*!MIT License
See Also MIT-LICENSE.txt
Copyright (c) 2013 dhrname*/


(function(){

/*本体オブジェクト。base関数の裏に隠蔽されている*/
var _base = {
    
    /*_base.objはbase関数やupメソッドで呼び出されるオブジェクトの始祖となるオブジェクト*/
    obj: {
      /*upメソッド
       * 自身をプロトタイプとして、新たにオブジェクトを生成する
       */
      up: function(name) {
        var s = Object.create(this);
        if (name) {
          this[name] = s;
          s.up = this.up;
        } else {
          /*既定値を$1としておく*/
          this.$1 = s;
        }
        return s;
      },
    
      /*mixメソッド
       * 別のオブジェクトと合成ができるメソッド
       */
      mix: function(obj) {
        if (!obj) {
          throw new Error("No arguments error");
        }
        if (typeof obj !== "function") {
          var alias = _base.__ng_;
          for (var i in obj) {
            if (!alias[i]) {
              /*hasOwnPropertyメソッドを使わないのは、プロトタイプチェーンをたどるようにするため
               *なお、Object.prototypeのプロパティなどは外した方がエラーがおきにくい
               */
              this[i] = obj[i];
            }
          }
          i = alias = void 0;
        } else {
          obj.call(this, this);
        }
        return this;
      },
    
      /*onメソッド
       * メソッドの合成ができるメソッド。
       * 指定した名前nameのメソッドが呼び出された場合、便乗して指定関数funcをメソッドとして実行することができる
       */
      on: function(name, func) {
        if (!name) {
          throw new Error("No arguments error");
        } else if (/^(?:up|on|mix|of)$/.test(name)) {
          throw new Error("Invalid method name error");
        } else if (typeof func !== "function") {
          throw new Error("Not support arguments type");
        }
        var tev = this._eventList__,
            tn = this[name];
        if (!this._eventList__) {
          tev = this._eventList__ = [];
        } else if (!this.hasOwnProperty("_eventList__")) { //祖先がすでにonメソッドを呼び出していれば
          var s = [];
          s._parent = tev;
          tev = this._eventList__ = s;
          s = void 0;
        }
        if (!this[name] || !tn.isOn) { //まだ、onメソッドが呼び出されていなければ
          /*nameで指定されたメソッドの初期化*/
          if (typeof tn === "function") {
            /*nameで指定されたメソッドがすでにある場合は、配列tevの親をたどれないようにしておく*/
            tev.push({
                name: name,
                func: tn
              });
            tev._parent = null;
          }
          this[name] = function() {
            var te = this._eventList__,
                 _name = name,    //スコープチェーンのエイリアス
                 ts = null,
                 s = null,
                 tp,
                 isCalled = false;//返り値の制御で使う
            te._child = null;
            while (tp = te._parent) { //親をさかのぼっていく
              tp._child = te;
              te = tp;
            }
            while (te) {            //子をたどっていく
              /*最初の返り値の結果はsとして記録して、後で返す*/
              for (var i=0, tli=te.length;i<tli;++i) {
                if(te[i].name === _name) {
                  ts = te[i].func.apply(this, arguments);
                  if (!isCalled) {
                    s = ts;
                    isCalled = true;
                  }
                }
              }
              te = te._child;
            }
            te = ts = _name = isCalled = void 0;
            return s;
          };
          this[name].isOn = true;
        }
        tev.push({
                name: name,
                func: func
              });
        tev = tn = func= void 0;
        return this;
      },

      /*__argsと__appプロパティは後のofメソッドで使う*/
      __args: null,
      __app: null,

      /*ofメソッド
       *　指定されたオブジェクトのプロパティを遅延処理で実行できるメソッド
       * 後述のcallメソッドと組み合わせて使う
       */
       of: function(obj) {
        if (!obj) {
          throw new Error("No arguments error");
        } else if(this.hasOwnProperty("__of")) {
          /*再代入禁止*/
          throw new Error("Reset error");
        }
        /*__appと__argsプロパティに、指定されたプロパティを記録しておく*/
        var args = this.__args || [];
        for (var i in obj) {
          if(obj.hasOwnProperty(i) && (i !== "call")) {
            /*一度登録されたプロパティは二度書きしないようにする*/
            args[i] || args.push(i);
            args[i] = this[i] = obj[i];
          }
        }
        obj.call && (this.__app = { call: obj.call });
        this.__args = args;
        this.__of = 1;
        args = i = obj = void 0;
        return this;
       },

      /*callメソッド
       *　ofメソッドで指定されているオブジェクトのcallメソッドを実行できるメソッド
       * そのさい、オブジェクトのプロパティとメソッドは、自動で実行展開される
       */
       call: function() {
         if (!this.__app) { //ofメソッドが呼び出されていないか、callメソッドが一度も設定されていない場合
           return this;
         }
         var args = this.__args,
             call = this.call; //callメソッドの一時的なキャッシュ
         /*循環参照を避けるためcallメソッドの入れ替え*/
         this.call = callFunc;
         for (var i=0, ali=args.length;i<ali;++i) {
           /*callメソッドがあるオブジェクトは展開*/
           var ai = args[i],
               argi = this[ai];
           if (argi && argi.call) {
             this[ai] = argi.call(this);
           }
         }
         this.call = call;
         args = ai = argi = call = void 0;
         return this.__app.call.apply(this, arguments);
       },
    }
};
/*callメソッドで使われる関数*/
var callFunc = function() { return this };

/*base関数でキャッシュとして使うオブジェクト*/
var baseCache = {};

base = function (name) {
    var __base = _base,
         _cache = baseCache; //エイリアス作成
    if (!name) {
      throw new Error("No arguments error");
    } else if (_cache[name]) {
      /*キャッシュに登録されている場合は、登録されたオブジェクトを返す*/
      return _cache[name];
    } else {
      var s = Object.create(__base.obj);
      this[name] = _cache[name] = s;
      /*自身が値であるようなプロパティを設定する*/
      s[name] = s;
      return s;
    }
};


/*mixメソッドで使うNGハッシュを作成*/
var hash = {},
    proto = Object.prototype;
for (var i in proto) {
  hash[i] = true;
  /*上記のキャッシュについて、すべてのプロパティをnullかundefinedにしておく*/
  baseCache[i] = null;
}
hash.constructor = false; //constructorはNGハッシュに追加しない
_base.__ng_ = hash;
hash = proto = void 0;

/*base.free関数
 *  即時関数の内部で作っていおいたオブジェクトを解放させるための関数
 */
base.free = function() {
  delete _base.obj;
  _base = baseCache = callFunc = void 0;
};

/*IE8などObject.createをサポートしていないブラウザ用*/
Object.create || (Object.create = function(obj) {
  var F = function() {};
  F.prototype = obj;
  return new F()
} );
})();
