/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public License
 *公式ページは http://sie.sourceforge.jp/
 *利用方法は <script defer="defer" type="text/javascript" src="sie.js"></script>
 *http://sie.sourceforge.jp/
 *Usage: <script defer="defer" type="text/javascript" src="sie.js"></script>
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *//*!MIT License
See Also MIT-LICENSE.txt
Copyright (c) 2013 dhrname*/


(function(){

/*本体オブジェクト。base関数の裏に隠蔽されている*/
var _base = {
    
    /*_base.objはbase関数やupメソッドで呼び出されるオブジェクトの始祖となるオブジェクト*/
    obj: {
      /*upメソッド
       * 自身をプロトタイプとして、新たにオブジェクトを生成する
       */
      up: function(name) {
        var s = Object.create(this);
        if (name) {
          this[name] = s;
          s.up = this.up;
        } else {
          /*既定値を$1としておく*/
          this.$1 = s;
        }
        return s;
      },
    
      /*mixメソッド
       * 別のオブジェクトと合成ができるメソッド
       */
      mix: function(obj) {
        if (!obj) {
          throw new Error("No arguments error");
        }
        if (typeof obj !== "function") {
          var alias = _base.__ng_;
          for (var i in obj) {
            if (!alias[i]) {
              /*hasOwnPropertyメソッドを使わないのは、プロトタイプチェーンをたどるようにするため
               *なお、Object.prototypeのプロパティなどは外した方がエラーがおきにくい
               */
              this[i] = obj[i];
            }
          }
          i = alias = void 0;
        } else {
          obj.call(this, this);
        }
        return this;
      },
    
      /*onメソッド
       * メソッドの合成ができるメソッド。
       * 指定した名前nameのメソッドが呼び出された場合、便乗して指定関数funcをメソッドとして実行することができる
       */
      on: function(name, func) {
        if (!name) {
          throw new Error("No arguments error");
        } else if (/^(?:up|on|mix|of)$/.test(name)) {
          throw new Error("Invalid method name error");
        } else if (typeof func !== "function") {
          throw new Error("Not support arguments type");
        }
        var tev = this._eventList__,
            tn = this[name];
        if (!this._eventList__) {
          tev = this._eventList__ = [];
        } else if (!this.hasOwnProperty("_eventList__")) { //祖先がすでにonメソッドを呼び出していれば
          var s = [];
          s._parent = tev;
          tev = this._eventList__ = s;
          s = void 0;
        }
        if (!this[name] || !tn.isOn) { //まだ、onメソッドが呼び出されていなければ
          /*nameで指定されたメソッドの初期化*/
          if (typeof tn === "function") {
            /*nameで指定されたメソッドがすでにある場合は、配列tevの親をたどれないようにしておく*/
            tev.push({
                name: name,
                func: tn
              });
            tev._parent = null;
          }
          this[name] = function() {
            var te = this._eventList__,
                 _name = name,    //スコープチェーンのエイリアス
                 ts = null,
                 s = null,
                 tp,
                 isCalled = false;//返り値の制御で使う
            te._child = null;
            while (tp = te._parent) { //親をさかのぼっていく
              tp._child = te;
              te = tp;
            }
            while (te) {            //子をたどっていく
              /*最初の返り値の結果はsとして記録して、後で返す*/
              for (var i=0, tli=te.length;i<tli;++i) {
                if(te[i].name === _name) {
                  ts = te[i].func.apply(this, arguments);
                  if (!isCalled) {
                    s = ts;
                    isCalled = true;
                  }
                }
              }
              te = te._child;
            }
            te = ts = _name = isCalled = void 0;
            return s;
          };
          this[name].isOn = true;
        }
        tev.push({
                name: name,
                func: func
              });
        tev = tn = func= void 0;
        return this;
      },

      /*__argsと__appプロパティは後のofメソッドで使う*/
      __args: null,
      __app: null,

      /*ofメソッド
       *　指定されたオブジェクトのプロパティを遅延処理で実行できるメソッド
       * 後述のcallメソッドと組み合わせて使う
       */
       of: function(obj) {
        if (!obj) {
          throw new Error("No arguments error");
        } else if(this.hasOwnProperty("__of")) {
          /*再代入禁止*/
          throw new Error("Reset error");
        }
        /*__appと__argsプロパティに、指定されたプロパティを記録しておく*/
        var args = this.__args || [];
        for (var i in obj) {
          if(obj.hasOwnProperty(i) && (i !== "call")) {
            /*一度登録されたプロパティは二度書きしないようにする*/
            args[i] || args.push(i);
            args[i] = this[i] = obj[i];
          }
        }
        obj.call && (this.__app = { call: obj.call });
        this.__args = args;
        this.__of = 1;
        args = i = obj = void 0;
        return this;
       },

      /*callメソッド
       *　ofメソッドで指定されているオブジェクトのcallメソッドを実行できるメソッド
       * そのさい、オブジェクトのプロパティとメソッドは、自動で実行展開される
       */
       call: function() {
         if (!this.__app) { //ofメソッドが呼び出されていないか、callメソッドが一度も設定されていない場合
           return this;
         }
         var args = this.__args,
             call = this.call; //callメソッドの一時的なキャッシュ
         /*循環参照を避けるためcallメソッドの入れ替え*/
         this.call = callFunc;
         for (var i=0, ali=args.length;i<ali;++i) {
           /*callメソッドがあるオブジェクトは展開*/
           var ai = args[i],
               argi = this[ai];
           if (argi && argi.call) {
             this[ai] = argi.call(this);
           }
         }
         this.call = call;
         args = ai = argi = call = void 0;
         return this.__app.call.apply(this, arguments);
       },
    }
};
/*callメソッドで使われる関数*/
var callFunc = function() { return this };

/*base関数でキャッシュとして使うオブジェクト*/
var baseCache = {};

base = function (name) {
    var __base = _base,
         _cache = baseCache; //エイリアス作成
    if (!name) {
      throw new Error("No arguments error");
    } else if (_cache[name]) {
      /*キャッシュに登録されている場合は、登録されたオブジェクトを返す*/
      return _cache[name];
    } else {
      var s = Object.create(__base.obj);
      this[name] = _cache[name] = s;
      /*自身が値であるようなプロパティを設定する*/
      s[name] = s;
      return s;
    }
};


/*mixメソッドで使うNGハッシュを作成*/
var hash = {},
    proto = Object.prototype;
for (var i in proto) {
  hash[i] = true;
  /*上記のキャッシュについて、すべてのプロパティをnullかundefinedにしておく*/
  baseCache[i] = null;
}
hash.constructor = false; //constructorはNGハッシュに追加しない
_base.__ng_ = hash;
hash = proto = void 0;

/*base.free関数
 *  即時関数の内部で作っていおいたオブジェクトを解放させるための関数
 */
base.free = function() {
  delete _base.obj;
  _base = baseCache = callFunc = void 0;
};

/*IE8などObject.createをサポートしていないブラウザ用*/
Object.create || (Object.create = function(obj) {
  var F = function() {};
  F.prototype = obj;
  return new F()
} );
})();



/*$frame オブジェクト
 * 全体のフレームの管理を行う
 */
base("$frame").mix ( {
  /*フレームレート。１ミリ秒何フレームか。計算を省略するためミリ秒使用*/
  fpms: 0.024,

  /*タイムラインのリスト (時間区間の設定ができる）*/
  timelines: [],

  /*開始フレーム数。アニメーションの開始条件となる
   * 単位はフレーム数であって、秒数ではない*/
  begin: 0,
  
  /*開始時刻 (文書が読み込まれたときにDate.nowなどで取得）
   * 単位はミリ秒数であって、フレーム数ではない*/
  startTime: 0,

  /*活動継続時間 (Active Duration)のフレーム数。アニメーションの継続条件となる
   * 単位はフレーム数であって、秒数ではない*/
  activeTime: Number.MAX_VALUE,
  
  /*現在のフレーム数*/
  currentFrame: 0,
  
  /*タイムラインの優先度*/
  rank: 0,
  
  /*アニメーションを開始させるメソッド*/
  startAnimation: function() {
    /*__step関数は最後に書く*/
    __step();
  },
  
  /*アニメーションが停止した状態かどうか、停止しているならばtrue*/
  isPaused: false,

  /*アニメーションを停止させるメソッド*/
  pauseAnimation: function() {
    this.isPaused = true;
  },

  /*setFrame メソッド
   * フレーム数を数値num まで進めるか、戻す*/
  setFrame: function( /*number*/ num) {
    if((num < this.begin) || (num >= (this.begin+this.activeTime))) {
      return;
    }
    this.currentFrame = num;
    var timelines = this.timelines;
    for (var i=0;i<timelines.length;++i) {
      if (timelines[i] === this) {
        /*自分自身が含まれていると、永久に再帰を繰り返して、「スタック領域が不足」してしまう*/
        continue;
      }
      timelines[i].setFrame(num);
    }
  },
  
  /*addLineメソッド
   * タイムラインを追加したあと、trueを返す
   * ただし、引数objのobj.beginとobj.activeTimeが定まっていない場合はfalseを返す*/
  addLine: function( /*$frame*/ obj ) {
    if(!obj || (!obj.begin && (obj.begin !== 0))
    || (!obj.activeTime && (obj.activeTime !== 0)) ) {
      /*どちらのプロパティも未確認の場合、タイムラインは追加されない*/
      return false;
    }
    if ( this.timelines.indexOf(obj) >= 0 ) {
      this.removeLine(obj);
    }
    this.timelines.push( obj );
    /*ランクをソートしておくことで、タイムラインを実行する順序を決める
     * 主に、begin用のタイムラインの前に、end用のタイムラインが実行されるのを防ぐのが目的*/
    this.timelines.sort( function (a, b) {
      return a.rank - b.rank;
    } )
    return true;
  },
  
  /*removeLine メソッド
   * 指定されたタイムラインのオブジェクトを、リストから削除する*/
  removeLine: function( /*$frame*/ timeline ) {
    var list = this.timelines,
        j = list.indexOf(timeline);
    if (j > -1) {
      list.splice(j, 1);      //Arrayのspliceを利用して、リストからtimelineを排除
    }
    list = j = void 0;
  }
} ).mix( function($frame) {  
  /*$begin オブジェクト
   * 開始のタイミングを計算する*/
  $frame.up("$begin").mix( {

    /*開始時刻やタイミングが書かれた文字列*/
    string: "",

    /*イベントやindefinteで未解決かどうか*/
    isResolved: false,
    
    /*イベントが適用される要素*/
    eventTarget: document.documentElement,
    
    /*現在のフレーム数を改めて初期化*/
    currentFrame: 0,
    
    /*イベント同期で使う時間差のフレーム数*/
    eventOffset: 0,
    
    /*repeat(1)など文字列内に書かれたリピート回数*/
    repeat: 0,
    
    /*accessKey(a)の"a"などキーイベントの対象となる文字列*/
    accessKey: "",

    /*trim メソッド
     * 文字列中の空白を除去*/
    trim: function(str) {
      /*strがString型以外のときは必ずエラーを出す*/
      return str.replace(/[\s\n]+/g, "");
    },

    /*offset メソッド
     * 引数に渡された文字列から、ミリ秒単位に変換した時間を、解析して返す*/
    offset: function(str) {
      str = str || "0";
      var plusminus = str.charAt(0),
          /*parseFloatのエイリアス*/
          _float = parseFloat,
          s = _float( str.match(/[\d.]+ms$/) || "0") + sec() + min() + h();
      if (plusminus === "-") {
        s *= -1;
      }
      plusminus = _float = sec = min = h = void 0;
      return s;
      
      /*00:00:0と00:0と、0sなどの文字列をミリ秒へ変換*/
      function sec() {
        return str2num( 1000, /[\d.]+s$/, /[\d.]+$/ );
      };
      function min() {
        return str2num( 60000, /[\d.]+min$/, /\d\d:[^:]+$/ );
      };
      function h() {
        return str2num( 3600000, /\d+:\d\d:/, /[\d.]+h$/ );
      };
      function str2num(s, /*RegExp*/ a, /*RegExp*/ b) {
        return s*( _float(str.match(a) || "0") || _float(str.match(b) || "0") );
      };
    },

    /*event メソッド
     * 引数の文字列から、idとイベントに相当する文字列のプロパティを持ったオブジェクトを返す
     * idがない場合や、イベントがない場合は空文字列を該当のプロパティに入れる*/
    event: function(str) {
      str = str || "";
      if (/[\+\-]/.test(str)) {
        /*数値がある場合は切り取っておく*/
        str = str.slice(0, str.search(/[\+\-]/));
      }
      if (str.indexOf(".") > -1) {
        /*ドットが見つかった場合、IDとイベントに分けておく*/
        var ide = str.split(".");
        /* エラーが起きて、idが空文字列ならば、evtも空文字列。逆も然り*/
        return {
          id: (ide[1] && ide[0]),
          event: (ide[0] && ide[1])
        };
      } else {
        return {
          id: "",
          event: str
        };
      }
    },
    
    /*parse メソッド
     * stringプロパティを解析して、フレーム数を算出し、結果を$frame.beginプロパティに出力
     * また、イベントリスナーに登録をしておく*/
    parse: function() {
      this.begin = 0;
      var str = this.trim(this.string),
          plusminus = str.search(/[\+\-]/),
          event = null,
          ele;
      if (str === "indefinite") {
        this.begin = Number.MAX_VALUE;
      } else if (plusminus > 0) {
        /*Event-Value +/- Clock-Value の場合*/
        this.begin = this.offset( str.slice(plusminus) );
        event = this.event(str);
      } else if ( /[^\+\-\d]/.test(str.charAt(0)) ) {
        /*Event-Valuen　のみの場合*/
        event = this.event(str);
      } else {
        /*+/- Clock-Value のみの場合*/
        this.begin = this.offset( str );
        /*イベントもindefiniteもないので、解決済みと考える*/
        this.isResolved = true;
      }
      /*もしもあれば、リピートの回数を求める*/
      this.repeat = /repeat\((\d+)\)/.test(str) ? +RegExp.$1 : 0;
      /*もしもあれば、押されるはずのキーを求める*/
      this.accessKey = /accessKey\(([^\)]+?)\)/.test(str) ? RegExp.$1 : "";
      this.begin = Math.floor( this.begin * this.fpms);
      if (event) {
        ele = event.id ? this.eventTarget.ownerDocument.getElementById(event.id)
                        : this.eventTarget;
        /*イベントの時間差を設定しておく*/
        this.eventOffset = this.begin;
        if (this.repeat > 0) {
          ele && ele.addEventListener("repeatEvent", (function(evt) {
            if (evt.detail === this.repeat) {
              this.listener(evt);
            } }).bind(this), true);
        } else if (this.accessKey) {
          document.documentElement.addEventListener("keydown", (function(evt) {
            if (evt.char === this.accessKey) {
                this.listener(evt);
              } }).bind(this), false);
        } else {
          var evtName = /^(?:begin|end|repeat)$/.test(event.event) ? event.event + "Event"
                          : event.event;
          ele && ele.addEventListener(evtName, this.listener.bind(this), false);
        }
      } else {
        /*イベントの影響を防ぐため
         * すでに、フレームオブジェクトのタイムラインには登録済みなので、
         * フレームではなく、自分独自のタイムラインに登録しておけばよい*/
        this.$frame = this;
      }
      s = event = str = plusminus = ele = void 0;
      return this;
    },
    
    /*イベントのリスナーとして、parseメソッドで使う*/
    listener: function(evt) {
      evt = evt || { timeStamp: this.startTime };
      if (!evt.timeStamp && (evt.timeStamp !== 0)) {
        throw new Error();
      }
      /*イベントのリスナーが遅かった場合の、誤差の演算をしておく*/
      this.begin = this.eventOffset + this.$frame.currentFrame - Math.floor( (Date.now() - evt.timeStamp) * this.fpms );
      var s = this.$activate;
      s.begin = this.begin;
      this.activeTime = s.call() || Number.MAX_VALUE;
      this.simpleDuration = s.simpleDur;
      s = void 0;
      this.$frame.addLine(this);
    }
    
  /*$activate オブジェクト
   * 活動継続時間などを計算するための計算実体
   * $begin オブジェクトからの継承*/
  } ).up("$activate").of( {
    
    /*単純継続時間のパースされる前の文字列*/
    dur: "indefinite",
    
    /*活動をストップさせるためのオブジェクト*/
    end: $frame.$begin.up("$end"),

    /*リピート回数*/
    repeatCount: null,
    
    /*繰り返し時間*/
    repeatDur: null,

    /*単純継続時間 (単位はフレーム数)*/
    simpleDur: function() {
      return ( (this.dur === "indefinite") || !this.dur ) ?
                null
              : Math.floor(this.offset(this.dur) * this.fpms) ;
    },

    /*最小値に制限される
     * 最小値 <= 活動継続時間 とならなければならない*/
     min: "0",
     
    /*最大値に制限される
     * 活動継続時間 <= 最大値 とならなければならない*/
     max: "indefinite",
    
    /*解決した(計算する)ときの時間*/
    resolvedTime: function() {
      return Date.now();
    },
    
    /*関数型の呼び出しメソッド
     * base.jsのofメソッドを活用して、関数型っぽい処理をする
     * 以下では、活動継続時間を算出
     * 計算方法はSMILアニメーション 3.3.4節を参照
     * http://www.w3.org/TR/smil-animation/#ComputingActiveDur
     */
    call: function() {
      var ind = "indefinite",
          dur = this.simpleDur,
          isIndefRepeatCount = (this.repeatCount === ind),
          isIndefRepeatDur = (this.repeatDur === ind),
          isIndefEnd = (this.end === ind),
          isDur = dur || (dur === 0),
          isEnd = this.end || (this.end === 0),
          isRepeatCount = this.repeatCount || (this.repeatCount === 0),
          isRepeatDur = this.repeatDur || (this.repeatDur === 0),
          actList = [],
          min = Math.floor(this.offset(this.min) * this.fpms),
          max = (this.max === ind) ? null : Math.floor(this.offset(this.max) * this.fpms),
          s;
      if (indef()) {
        return null;
      }
      if (isDur && this.repeatCount && !isIndefRepeatCount) {
        actList.push( dur * this.repeatCount );
      }
      if (isRepeatDur && !isIndefRepeatDur) {
        actList.push( Math.floor( this.offset(this.repeatDur) * this.fpms) );
      }
      if (isEnd && !isIndefEnd) {
        actList.push( this.end - this.begin );
      }
      if (isDur && !isRepeatCount && !isRepeatDur) {
        /*repeatCountやrepeatDur属性が指定されていない場合*/
        actList.push( dur );
      }

      /*長くなるため、インライン関数を活用
       * indef関数は活動継続時間が不定かどうか、もし、不定なら真を返す*/
      function indef() {
        if(isIndefEnd) {
          return true;
        } else if (isEnd) {
          return false;
        }
        return !!( (!isDur && !isRepeatDur)
                   || (isIndefRepeatCount && !isRepeatDur)
                   || (isIndefRepeatDur && !isRepeatCount)
                   || (isIndefRepeatCount && isIndefRepeatDur)
                 );
      };
      
      ind = dur = isIndefRepeatCount = isIndefRepeatDurindef = isDur = isEnd = isRepeatDur = isRepeatCount = indef = void 0;

      if (actList.length === 1) {
        s = actList[0];
      } else if(actList.length > 1) {
        /*属性が競合するときは、最小値をとること (SMILアニメーション 3.3.4節)*/
        s = Math.min.apply(Math, actList);
      } else {
        return null;
      }
      if ( max && (min > max) ) {
        return s;
      }
      min && (min > s) && (s = min);
      max && (max < s) && (s = max);
      return s;
    }
  } );
  $frame.$begin.$end.of( {
    call: function() {
      if (!this.string) {
        return null;
      }
      this.parse(this.string);
      return this.isResolved ? this.begin
                             : "indefinite";
    }
  } ).mix( {
    /*イベントリスナー用の関数*/
    listener: function(evt) {
      evt = evt || { timeStamp: this.startTime };
      if (!evt.timeStamp && (evt.timeStamp !== 0)) {
        throw new Error();
      }
      if (this.begin <= 0) {
        /*強制的に終了させる*/
        this.removeLine(this.$begin);
      }
      this.begin = this.eventOffset + this.$frame.currentFrame - Math.floor( (Date.now() - evt.timeStamp) * this.fpms );
      var s = this.$begin.$activate;
      s.end = this.begin;
      /*未解決だったendの値が、イベントの発生により、解決して再定義されたとき、
       * $activateオブジェクトを使って活動継続時間を再計算する*/
      this.$begin.activeTime = s.call();
      s = void 0;
    }
  } );
} );
/*$from オブジェクト
 * 呈示値 (presentation value)の計算をする。値そのものを返すための計算実体*/
base("$from").of( {
  /*呈示値が書かれた文字列*/
  string: "",
  
  /*呈示値の数値の部分だけを抜き出した配列を返す*/
  numList: function() {
    var s  = this.string.match(/[\-\+]?[\d\.]+(?:[eE][\-\+]?[\d\.]+)?/g)
             || [];
    if (s) {
      /*mapメソッドで代用してもよい*/
      for (var i=0;i<s.length;++i) {
        s[i] = parseFloat(s[i]);
      }
    }
    return s;
  },
  
  /*呈示値の文字部分だけを抜き出した配列を返す*/
  strList: function() {
    /*replaceメソッドで1E-10などの対策*/
    return this.string.replace(/\d[eE][\-\+\d]/g, "")
                      .match(/[^\d\-\+\.]+/g);
  },
  
  from: base("$from").up().mix( {
          from: null
        } ),
  
  /*$toオブジェクトにこのオブジェクトを適用させる関数*/
  call: function() {
    if (this.numList.length
          && (this.additive[0] === 0)
          && (this.accumulate[0] === 0)
          ) {
      /*配列の項目がundefinedだと困るので、配列を初期化する*/
      var additive = [],
          accumulate = [];
      for (var i=0;i<this.numList.length;++i) {
        /*0で配列を初期化しておく*/
        additive[i] = accumulate[i] = 0;
      }
      this.additive = additive;
      this.accumulate = accumulate;
    }
    /*文字部分の配置パターンは4通りあるので、ここでstrListを処理
     * (1) a 0 の場合
     * (2) 0 a
     * (3) a 0 a (ノーマルパターン)
     * (4) 0 a 0
     * これらのパターンのうち、(1)(2)(4)を(3)のパターンに統一したのが以下の処理*/
    /*文字列が1aのように、数値で始まるかどうか。始まったら真*/
    if (!this.string || !this.numList.length || !this.strList) {
      return this.numList;
    }
    var isNormal = (this.numList.length < this.strList.length);
    if (/^[\-\+]?[\d\.]/.test(this.string) && !isNormal) {
      /*文字列が1aのように、数値で始まる場合*/
      this.strList.unshift("");
    }
    if (/\d$/.test(this.string) && !isNormal) {
      /*文字列がa1のように、数値で終わる場合*/
      this.strList.push("");
    }
    return this.numList;
  }
    
} )
 .mix( {
   /*advanceメソッドで使われる有効数字の桁数 (小数点の桁数を決めるときに使う)*/
   degit: 0,
   
   /*additve属性やaccumulate属性が設定された、累積アニメーションか、加法アニメーションで使われる*/
   additive: [0],
   accumulate: [0],
   
   /*advance メソッド
    * アニメーションの進行具合を示す進捗率 t (0 <= t <= 1)をもとに、現在の呈示値を算出するためのもの
    * callメソッドが前もって呼び出されていることが前提となる*/
    advance: function(t) {
      if ( (t < 0) || (1 < t)) {
        throw new Error("An Invalid Number Error");
      }
      if (!this.string || !this.from.length) {
        return "";
      }
      var str = "",
          numList = this.numList,
          strList = this.strList,
          fromNumList = this.from,
          deg = this.degit,
          additive = this.additive,
          accumulate = this.accumulate;
      for (var i=0,nuli=numList.length;i<nuli;++i) {
        /*原点Oを(0,0,...0)とおく
         *$fromと$toを、原点Oからの二つのベクトル (n次空間のベクトル)、ベクトルOFとベクトルOTと考える
         *$fromと$toの二つの端の点FとTを結ぶ線分を、t : 1-t で内分する点をPとおく
         * このときのベクトルOPを求めたのが以下の式*/
        str += ( t * numList[i] + (1 - t) * fromNumList[i] + additive[i] + accumulate[i]).toFixed(deg);
        strList && ( str += strList[i+1] );
      }
      /*文字列はcallメソッドにより、a0aのパターンになっているので、aの部分を追加*/
      str = (strList ? strList[0] : "") + str;
      numList = strList = fromNumList = i = nuli = deg = additive = accumulate = void 0;
      return str;
    },
    
    /*distanceメソッド
     * fromベクトルから自分自身のベクトルへの距離 (ノルム)の数値を返す。callメソッドを使うので注意すること*/
     distance: function(from) {
       if (!from) {
          return 0;
       }
       var toList = this.call(),
           fromList = from.call ? from.call() : from,
           s = 0;
       if (!toList || !fromList) {
         return 0;
       }
       for (var i=0, tli=toList.length; i<tli; ++i) {
         s += (toList[i] - fromList[i])*(toList[i] - fromList[i]);
       }
       return Math.sqrt(s);
     },
     
     /*setAdditive メソッド
      * additve属性がsumのときに使われるメソッド
      * 引数は親要素の、現在の属性値*/
      setAdditive: function(str) {
        if (!str) {
          return 0;
        }
        var from = this.$from.up();
        from.string = str;
        return ( this.additive = from.call() );
      },
     
     /*setAccumulate メソッド
      * accumulate属性がsumのときに使われるメソッド
      * 引数は現在のリピート回数*/
      setAccumulate: function(num) {
        if (!num || isNaN(num)) {
          return 0;
        }
        return ( this.accumulate = this.numList.map( function(d) {
          return d * num;
        } ) );
      }
  } )
  /*fromプロパティの初期化*/
 .up("$to").from = null;
 
 /*計算モードを定めるための計算実体
  *補間の細かい制御などを行う*/
 base("$calcMode").mix({
   /*callメソッドで使う関数*/
   _f: function (t) {
         /*tは進捗率*/
         var tkey = this.keyTime;
         if ( (tkey === 0) && t) {
           t = 0; 
         } else if (!tkey || !isFinite(tkey) ) {
           return this.string;
         } else {
           t = t / tkey;
           t = (t > 1) ? Math.floor(t) : t;
         }
         tkey = void 0;
         return isNaN(t) ? this.string
                         : this.to.advance(t);
     }
 }).of( {

   /*計算モード　(calcMode属性の値)*/
   mode: "linear",

   /*keyTimesの区間
    * たとえば、"0, 0.5, 0.7, 1"の場合、時間の区間はそれぞれ、0.5 (=0.5-0)  0.2 (=0.7-0.5)  0.3 (=1-0.7)である
    * このうち、どれか一つが値として入力される*/
   keyTime: 1,
   
   /*keySpline属性の値を設定*/
   keySplines: null,
   
   /*全体の行列ノルム（距離）*/
   norm: 1,

   /*無効だった場合の呈示値*/
   string: "",
   
   /*与えられたアニメーションの進捗率を使った時間の圧縮率を計算して呈示値を返すための関数を作る*/
   call: function() {
     var f = this._f.bind(this);
     if (this.mode === "linear") {
       this.to.call();
       return f;
     } else if (this.mode === "paced") {
       /*keyTimes属性は無視され、ベクトルの距離の割合から計算される*/
       this.keyTime = this.to.distance(this.to.from) / this.norm;
       return f;
     } else if (this.mode === "spline") {
       var tk = this.keySplines,
           /*必ず関数を返すようにするため、円周率を返す関数tfを返して、nullの代わりとする*/
           tf = function(x) {
                 return Math.PI;
           };
         if (!tk) {
           return tf;
         }
        for (var i=0,tki = NaN;i<tk.length;++i) {
         tki = tk[i];
         if (isNaN(tki)) {
           return tf;
         }
         if ( (tki < 0) || (1 < tki)) {
           return tf;
         }
       }
       this.to.call();
       var x2 = tk[0],
           y2 = tk[1],
           x3 = tk[2],
           y3 = tk[3],
           x4 = 1,
           y4 = 1,
           Ax = x4-3*(x3-x2),
           Bx = 3*(x3-2*x2),
           Cx = 3*x2,
           Ay = y4-3*(y3-y2),
           By = 3*(y3-2*y2),
           Cy = 3*y2,
           _newton = Math.qubicnewton; //高速化のためのエイリアス
       if ( ( (x2 === 0) || (x2 === 1) )
            && (y2 === 0)
            && ( (x3 === 1) || (x3 === 0) )
            && (y3 === 1) ) {
              /*linearモードと同じ効果 (収束ではない可能性を考慮)*/
              this.to.call();
              return f;
       }
       var tkey = this.keyTime;
       if (tkey || isFinite(tkey) ) {
         /*keyTimeから時間の収縮率を3次ベジェ曲線に適用しておく*/
         Ax *= tkey;
         Bx *= tkey;
         Cx *= tkey;
         Ay *= tkey;
         By *= tkey;
         Cy *= tkey;
       }
       tkey = tk = x2 = y2 = x3 = y3 = x4 = y4 = void 0;
       return function (x) {
          /*3次ベジェ曲線は媒介曲線
           *x = (x4-3*(x3-x2)-x1)*t*t*t + 3*(x3-2*x2+x1)*t*t + 3*(x2-x1)*t + x1
           *y = (y4-3*(y3-y2)-y1)*t*t*t + 3*(y3-2*y2+y1)*t*t + 3*(y2-y1)*t + y1
           * ただし、0 <= t <= 1
           * スプラインモードの場合、x1 = y1 = 0, x4 = y4 = 1
           * ベジェ曲線のxの式が三次方程式であるため、その解 t から、ベジェ曲線の y を求める
           * なお、ニュートン法の初期値はxとする
           * なぜなら、xの式をみると、xが増加傾向となるスプラインモードでは、係数が負となる可能性が低いため*/
          var t = _newton(Ax, Bx, Cx, -x, x);
          return f(Ay*t*t*t + By*t*t + Cy*t);
        };
     } else if (this.mode === "discrete") {
       this.to.call();
       return function (t) {
         return isNaN(t) ? this.string
                         : this.to.advance(0);
       }.bind(this);
     }
   }
} ).to = base("$from").$to;


/*ニュートン法により、三次方程式 a0x^3 + a1x^2 + a2x + a3 の解を求める
 * 引数bは初期値*/
Math.qubicnewton = function(a0, a1, a2, a3, b) {
  var eps = 1e-10,                          //収束誤差
      fb = a0 *b*b*b + a1 *b*b + a2*b + a3; //方程式の結果
  if (fb === 0) {
    return b;
  }
  /*限界の収束回数は100回*/
  for (var i=0;i<100;++i) {
    /*数値nは与えられた三次方程式を微分したもの*/
    var n = 3* a0 *b*b + 2 * a1 *b + a2;
    if (!n || ( (fb < eps) && (fb > -eps) )) {
      fb = eps = void 0;
      return b;
    } else {
      /*以下は収束の漸化式*/
      b =  b - fb / n;
      fb = a0 *b*b*b + a1 *b*b + a2*b + a3;
    }
  }
  return b; //収束しなかった結果
};

/*$attribute オブジェクト
 * アニメーションの時間調整と、呈示値の調整を一つのオブジェクトにまとめて行うことで、
 * アニメーションサンドイッチの実装をする
 * $calcModeオブジェクトから継承*/
base("$calcMode").up("$attribute").mix( {
  
  /*アニメーションの対象となる要素。たとえば、animate要素の親要素*/
  element: null,
  
  /*$fromオブジェクトを作るためのひな形となるオブジェクト*/
  $from: base("$from").up(),
  
  /*attributeName属性の値*/
  attrName: "",
  
  /*指定した要素の属性値を取得するメソッド*/
  getAttr: function(/*string*/ name, def) {
    var nameSpace = null;
    if (name.indexOf("xlink:") > -1) {
      nameSpace = "http://www.w3.org/1999/xlink";
    }
    var s = this._ele.getAttributeNS(nameSpace, name);
    if (this.element) {
        var view = this.element.ownerDocument.defaultView;
      if (s === "inherit") {
        return view.getComputedStyle(this.element.parentNode, "").getPropertyValue(this.attrName);
      } else if (s === "currentColor") {
        return view.getComputedStyle(this._ele, "").getPropertyValue("color");
      }
    }
    /*DOM Level2やIE11では、getAttributeNSメソッドは空文字を返す。他のブラウザではnullを返すことが多い
     * 
     * >the empty string if that attribute does not have a specified or default value
     * http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-ElGetAttrNS*/
    return (s || def);
  },
  
  _ele: document.documentElement,
  
  /*指定された要素にvalues属性が付いているかどうかのチェックできるメソッド*/
  hasAttrValues: function () {
    var ele = this._ele;
    if (!ele) {
      return false;
    } else {
      return ( ele.hasAttribute("from") || ele.hasAttribute("to")
         || ele.hasAttribute("by") || ele.hasAttribute("values") );
    }
  },

  /*引数で指定した要素 ele の属性を解析して、フレームに追加する*/
  push: function(/*Element Node*/ ele) {
    if (!ele || !ele.hasAttribute) {
      return null;
    }
    this.element = ele.parentNode || null;
    var id;
    if ( id = ele.getAttributeNS(null, "targetElement") ) {
      this.element = ele.ownerDocument.getElementById(id);
    }
    /*getAttributeNSメソッドでうまくいかなかったため、NSなしで代用*/
    if ( id = ele.getAttribute("xlink:href") ) {
      this.element = ele.ownerDocument.getElementById(id.slice(1));
    }
   /*getAttrメソッドとhasAttrValuesメソッドで必要*/
    this._ele = ele;
    if (!this.hasAttrValues()) {
      /*from属性、to、by、values属性が指定されていない場合、アニメーションの効果が出ないように調整する
       *SMILアニメーションの仕様を参照
       *
       *>if none of the from, to, by or values attributes are specified, the animation will have no effect
       *「3.2.2. Animation function values」より引用
       *http://www.w3.org/TR/2001/REC-smil-animation-20010904/#AnimFuncValues
      */
      return null;
    }
     this.attrName = this.getAttr("attributeName", "");
    /*eleの属性の値を、それぞれオブジェクトに割り当て*/
    var $frame = base("$frame"),
        begin = $frame.$begin,
        frame = begin.up().mix( {
                  /*targetプロパティはbeginEventなどの発火で使う*/
                  target: ele,
                  eventTarget: (this.element || begin.eventTarget),
                  string: this.getAttr("begin", "0"),
                  $activate: begin.$activate.up().mix( {
                    dur: this.getAttr("dur", null),
                    end: begin.$end.up().mix( {
                          eventTarget: (this.element || begin.eventTarget),
                          string: this.getAttr("end", null)
                        } ),
                    repeatCount: this.getAttr("repeatCount", null),
                    repeatDur: this.getAttr("repeatDur", null),
                    min: this.getAttr("min", "0"),
                    max: this.getAttr("max", "indefinite")
                  } )
                } ).parse();
    frame.$activate.end.$begin = frame;
    /*beginElementメソッドを追加*/
    function eleMethod (obj, eventName) {
      return (obj.string !== "indefinite") ? function(){}
                        : function() {
                            obj.listener( {
                              /*アニメーションの開始をこのメソッドが呼ばれた時点とする*/
                              timeStamp: Date.now()
                            } );
                            var evt = this.ownerDocument.createEvent("MouseEvents");
                            evt.initMouseEvent(eventName + "Event" ,true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, this);
                            this.dispatchEvent(evt);
                          };
    };
    ele.beginElement = eleMethod(frame, "begin");
    /*endElementメソッドを追加*/
    ele.endElement = eleMethod(frame.$activate.end, "end");
    if (frame.isResolved) {
      /*開始時間が初期化されてしまうのを防ぐ*/
      var cacheBegin = frame.begin;
      frame.listener( {
        /*アニメーションの開始をこのメソッドが呼ばれた時点とする*/
        timeStamp: Date.now()
      } );
      frame.begin = cacheBegin;
    }
    /*setFrameメソッドを使ったときの、再帰スタックの使いすぎを防ぐため*/
    frame.timelines = [];
    begin = ele = id = void 0;
    return frame;
  },
  
  /*setValuesメソッド
   * values属性やfrom属性やto属性を処理するためのメソッド
   * valuesは配列、それ以外の引数は文字列
   * 返り値は、values属性は配列、それ以外の属性のときは、
   * 自分自身となる$attributeオブジェクトのコピーを返す*/
   setValues: function(values, from, to, by) {
     var $from = this.$from,
         s = [this.up().mix( {
               to: $from.up().mix( {
                 from: $from.up()
               } )
             } )],
         sto = s[0].to;
     values = values && values.split(";");
     /*from属性はオプションなので、条件には付け加えない*/
     if (values && values.length) {
       /*values属性が指定された場合、他の属性は無視される
        * W3C仕様　SMIL アニメーション 3.2.2. アニメーション関数の値*/
        s = [];
       for (var i=1;i<values.length;++i) {
         s.push( this.up().mix( {
               to: $from.up().mix( {
                 from: $from.up()
               } )
             } ) );
         sto = s[s.length-1].to;
         sto.string = values[i];
         sto.from.string = values[i-1];
       }
     } else if (to) {
       sto.string = to;
       sto.from.string = from || "0";
     } else if (by) {
       sto.string = by;
       sto.from.string = from || "0";
       var toNumList = sto.call(),
           fromNumList = sto.from;
       for (var i=0;i<toNumList.length;++i) {
         /*初期値と差分を足していく*/
         toNumList[i] += fromNumList[i];
       }
     } else {
       return null;
     }
     $from = sto = toNumList = fromNumList = void 0;
     return s;
   },
   
   /*setKeyメソッド
    * 引数の要素のkeyTimes属性やkeySplines属性を処理するためのメソッド
    * 必要な他の属性処理はsetValuesメソッドに任せている*/
   setKey: function(ele) {
     this._ele = ele;
     var to = this.setValues(this.getAttr("values", null),
          this.getAttr("from", null),
          this.getAttr("to", null),
          this.getAttr("by", null) ),
         keyTimes = this.getAttr("keyTimes", null),
         keySplines = this.getAttr("keySplines", null),
         keys,
         splines = keySplines && keySplines.split(";"),
         isDiscrete = (this.mode === "discrete"),
         toiKeySplines;
    if (!isDiscrete && keyTimes && to) {
      keys = this.$from.numList.call( {
        string: keyTimes
      } );
      /*toオブジェクトはtoとfromで一組となっているのでlengthが加算される*/
      if (keys.length && (keys.length !== (to.length+1))) {
        /*keyTimes属性とvalues属性のリストの個数が合致しない場合、アニメーションの効果がない
         * 仕様を参照 SMIL Animation 3.2.3. Animation function calculation modes
         * http://www.w3.org/TR/smil-animation/#AnimFuncCalcMode*/
        return null;
      }
      for (var i=0;i<to.length;++i) {
        to[i].keyTime = keys[i+1] - keys[i];
        if (splines) {
          toiKeySplines = this.$from.numList.call( {
            string: splines[i]
          } );
          /*空配列を返すため、nullに変えておく*/
          to[i].keySplines = toiKeySplines.length ? toiKeySplines : null;
        }
      }
    } else if (!isDiscrete && to) {
      var per = 1 / to.length;
      for (var i=0;i<to.length;++i) {
        to[i].keyTime = per;
        if (splines) {
          toiKeySplines = this.$from.numList.call( {
            string: splines[i]
          } );
          to[i].keySplines = toiKeySplines.length ? toiKeySplines : null;
        }
      }
    } else if (to) {
        /*discreteモードの処理*/
      if (keyTimes) {
        keys = this.$from.numList.call( {
          string: keyTimes
        } );
        if (keys.length && (keys.length !== (to.length+1))) {
          return null;
        }
        for (var i=0;i<to.length;++i) {
          to[i].keyTime = keys[i];
        }
      } else {
        var per = 1 / (to.length+1);
        for (var i=0;i<to.length;++i) {
          to[i].keyTime = per;
        }
      }
      /*toオブジェクトが足らないので、一つ追加しておく*/
      to.push( to[to.length-1].up().of( {
            call: function() {
              return function (t) {
                 return isNaN(t) ? this.string
                                 : this.to.advance(1);
              }.bind(this);
            }
      } ) );
    }
    if (this.mode === "paced") {
      /*ベクトル全体の距離を算出*/
      var norm = 0;
      to.forEach( function(x) {
        norm += x.to.distance(x.to.from);
      } );
      to.forEach( function(x) {
         x.norm = norm;
      } );
    }
    ele = keyTimes = keys = per = splines = void 0;
    return to;
   }
} ).up("$setElement").mix( {
  /*to属性の値、文字列*/
  to: "",
  
  /*指定された属性の規定値*/
  defaultValue: "",
  
  /*もともと属性がターゲットの要素につけられていたかどうか*/
  isDefault: false,
  
  /*属性の名前空間*/
  attrNameSpace: null,
  
  /*initメソッドで使われるアニメーション関数*/
  _setFrame: function (frame) {
    this.element.setAttributeNS(this.attrNameSpace, this.attrName, this.to);
  },
  
  /*アニメーションが終了したかどうか*/
  isEnd: false,
  
  /*開始を設定されたタイムライン ($beginオブジェクト)*/
  timeline: base("$frame").$begin,
  
  /*アニメが終了した際の後処理
   * 終了した後は、ひたすらtrueを値として返す*/
  _setEndFrame: function(frame) {
              var line = this.timeline;
              if (( frame < (line.begin + line.activeTime) ) || this.isEnd) {
                /*アニメーションが終了間近でなければ凍結の処理をしない*/
                line = frame = void 0;
                return true;
              } else if (!isNaN(line.begin + line.activeTime)) {
                /*イベントが設定されていないか、解決済みである場合*/
                this.isEnd = true;
                /*removeの場合、アニメーションを凍結せずに、もとに戻す*/
                if ((this.fill === "remove") && this.isDefault) {
                  this.element.setAttributeNS(this.attrNameSpace, this.attrName, this.defaultValue);
                } else if (this.fill === "remove"){
                  this.element.removeAttributeNS(this.attrNameSpace, this.attrName);
                }
                line = frame = void 0;
                return false;
              }
  },
  
  /*アニメーションの呈示値を呼び出す関数*/
  tocall: function() {},
  
  init: function(ele) {
    var line = this.push(ele);
    if (ele && ele.getAttributeNS) {
      this._ele = ele;
      this.to = this.getAttr("to", "");
      this.fill = this.getAttr("fill", "remove");
    }
    var thisele = this.element;
    if (line && thisele) {
      this.timeline = line;
      this._ele = thisele;
      if (this.attrName.indexOf("xlink") > -1) {
        this.attrNameSpace = "http://www.w3.org/1999/xlink";
      }
      this.isDefault = thisele.hasAttributeNS(this.attrNameSpace, this.attrName);
      this.defaultValue = this.getAttr(this.attrName,
       thisele.ownerDocument.defaultView.getComputedStyle(thisele, "").getPropertyValue(this.attrName) );
      /*ラインの中に、属性処理をするためのラインを追加*/
      line.addLine(
       { setFrame: this._setFrame.bind(this),
         begin: 1,
         activeTime: 1,
         rank: 0
       }
      );
      base("$frame").addLine(
        { setFrame: this._setEndFrame.bind(this),
          begin: 1,
          activeTime: 1,
          rank: Number.MAX_VALUE //最低ランクにすることで、一番最後にタイムラインを実行させる
        }
      );
    }
    /*アニメーションが再起動する可能性もあるため、isEndプロパティはここで初期化*/
    this.isEnd = false;
    line = thisele = void 0;
  }
}).up("$animateElement").mix( {
  /*アニメ関数の配列*/
  funcs: [],

  /*進捗率advanceから、呈示値を求める*/
  tocall: function(advance) {
    var tf = this.funcs;
    for (var i=0;i<tf.length;++i) {
      var tfi = tf[i];
      /*keyTime（keyTimes属性で指定されたような値）で実行するかどうかを判別*/
      if (tfi.endKeyTime >= advance) {
        return tfi(advance - tfi.startKeyTime);
      }
    }   
    tf = i = tfi = void 0;
    return "";
  },
  
  _setFrame: function(currentTime) {
    /*durationは単純継続時間
     *advanceは継続時間内での、進捗率
     * 　仕様を参照　http://www.w3.org/TR/smil-animation/#AnimFuncValues
     *進捗率advanceは、durationと進捗フレーム数とを割った余り(REMAINDER)で算出する
     * 仕様を参照　SMIL Animation 3.6.2　Interval timing
     * http://www.w3.org/TR/2001/REC-smil-animation-20010904/#IntervalTiming*/
    var line = this.timeline,
        duration = line.simpleDuration,
        /*単純継続時間が不定の場合、補間はせずに初期値が採用されるため、advanceは0となる
         * 仕様を参照　SMIL Animation 3.2.2. Animation function values のInterpolation and indefinite simple durations
         * http://www.w3.org/TR/2001/REC-smil-animation-20010904/#AnimFuncValues*/
        advance = duration ? ( (currentTime - line.begin) % duration ) / duration
                    : 0;
    this.element.setAttributeNS(this.attrNameSpace, this.attrName, this.tocall(advance));
    line = duration = advance = void 0;
  },
  
  _setEndFrame: function(frame) {
    /*上書きされたメソッドを呼び出してアニメーションの凍結作業をする*/
    if (!this.$setElement._setEndFrame.call(this, frame)
     && (this.fill === "freeze")) {
      var line = this.timeline,
          duration = line.simpleDuration;
      if (duration) {
        var advance = ( line.activeTime % duration ) / duration;
        /*例外が発生するため、進捗率が1を超えないように処理*/
        advance = (advance > 1) ? 1 : advance;
         /*活動継続時間と単純継続時間が一致すると、余りは0となるため以下の処理*/
        advance = advance || 1;
      } else {
        advance = 0;
      }
      this.element.setAttributeNS(this.attrNameSpace, this.attrName, this.tocall(advance));
      line = duration = advance = void 0;
    }
  },
  
  /*getAttrメソッドをオーバライド*/
  getAttr: function (name, def) {
    var s= this.$attribute.getAttr.apply(this, arguments);
    if ((name === "from") && !s && this.defaultValue) {
      /*from属性がない場合、対象要素の既定値を返す*/
      return this.defaultValue;
    }
    return s;
  },
  
  _keywords: {
    aliceblue:    [240,248,255],
    antiquewhite: [250,235,215],
    aqua:         [0,255,255],
    aquamarine:   [127,255,212],
    azure:        [240,255,255],
    beige:        [245,245,220],
    bisque:       [255,228,196],
    black:        [0,0,0],
    blanchedalmond:[255,235,205],
    blue:         [0,0,255],
    blueviolet:   [138,43,226],
    brown:        [165,42,42],
    burlywood:    [222,184,135],
    cadetblue:    [95,158,160],
    chartreuse:   [127,255,0],
    chocolate:    [210,105,30],
    coral:        [255,127,80],
    cornflowerblue:[100,149,237],
    cornsilk:     [255,248,220],
    crimson:      [220,20,60],
    cyan:         [0,255,255],
    darkblue:     [0,0,139],
    darkcyan:     [0,139,139],
    darkgoldenrod:[184,134,11],
    darkgray:     [169,169,169],
    darkgreen:    [0,100,0],
    darkgrey:     [169,169,169],
    darkkhaki:    [189,183,107],
    darkmagenta:  [139,0,139],
    darkolivegreen:[85,107,47],
    darkorange:    [255,140,0],
    darkorchid:   [153,50,204],
    darkred:      [139,0,0],
    darksalmon:   [233,150,122],
    darkseagreen: [143,188,143],
    darkslateblue:[72,61,139],
    darkslategray:[47,79,79],
    darkslategrey:[47,79,79],
    darkturquoise:[0,206,209],
    darkviolet:   [148,0,211],
    deeppink:     [255,20,147],
    deepskyblue:  [0,191,255],
    dimgray:      [105,105,105],
    dimgrey:      [105,105,105],
    dodgerblue:   [30,144,255],
    firebrick:    [178,34,34],
    floralwhite:  [255,250,240],
    forestgreen:  [34,139,34],
    fuchsia:      [255,0,255],
    gainsboro:    [220,220,220],
    ghostwhite:   [248,248,255],
    gold:         [255,215,0],
    goldenrod:    [218,165,32],
    gray:         [128,128,128],
    grey:         [128,128,128],
    green:        [0,128,0],
    greenyellow:  [173,255,47],
    honeydew:     [240,255,240],
    hotpink:      [255,105,180],
    indianred:    [205,92,92],
    indigo:       [75,0,130],
    ivory:        [255,255,240],
    khaki:        [240,230,140],
    lavender:     [230,230,250],
    lavenderblush:[255,240,245],
    lawngreen:    [124,252,0],
    lemonchiffon: [255,250,205],
    lightblue:    [173,216,230],
    lightcoral:   [240,128,128],
    lightcyan:    [224,255,255],
    lightgoldenrodyellow:[250,250,210],
    lightgray:    [211,211,211],
    lightgreen:   [144,238,144],
    lightgrey:    [211,211,211],
    lightpink:    [255,182,193],
    lightsalmon:  [255,160,122],
    lightseagree: [32,178,170],
    lightskyblue: [135,206,250],
    lightslategray:[119,136,153],
    lightslategrey:[119,136,153],
    lightsteelblue:[176,196,222],
    lightyellow:  [255,255,224],
    lime:         [0,255,0],
    limegreen:    [50,205,50],
    linen:        [250,240,230],
    magenta:      [255,0,255],
    maroon:       [128,0,0],
    mediumaquamarine:[102,205,170],
    mediumblue:    [0,0,205],
    mediumorchid:  [186,85,211],
    mediumpurple:  [147,112,219],
    mediumseagreen:[60,179,113],
    mediumslateblue:[123,104,238],
    mediumspringgreen:[0,250,154],
    mediumturquoise:[72,209,204],
    mediumvioletred:[199,21,133],
    midnightblue:  [25,25,112],
    mintcream:     [245,255,250],
    mistyrose:     [255,228,225],
    moccasin:      [255,228,181],
    navajowhite:   [255,222,173],
    navy:          [0,0,128],
    oldlace:       [253,245,230],
    olive:         [128,128,0],
    olivedrab:     [107,142,35],
    orange:        [255,165,0],
    orangered:     [255,69,0],
    orchid:        [218,112,214],
    palegoldenrod: [238,232,170],
    palegreen:     [152,251,152],
    paleturquoise: [175,238,238],
    palevioletred: [219,112,147],
    papayawhip:    [255,239,213],
    peachpuff:     [255,218,185],
    peru:          [205,133,63],
    pink:          [255,192,203],
    plum:          [221,160,221],
    powderblue:    [176,224,230],
    purple:        [128,0,128],
    red:           [255,0,0],
    rosybrown:     [188,143,143],
    royalblue:     [65,105,225],
    saddlebrown:   [139,69,19],
    salmon:        [250,128,114],
    sandybrown:    [244,164,96],
    seagreen:      [46,139,87],
    seashell:      [255,245,238],
    sienna:        [160,82,45],
    silver:        [192,192,192],
    skyblue:       [135,206,235],
    slateblue:     [106,90,205],
    slategray:     [112,128,144],
    slategrey:     [112,128,144],
    snow:          [255,250,250],
    springgreen:   [0,255,127],
    steelblue:     [70,130,180],
    tan:           [210,180,140],
    teal:          [0,128,128],
    thistle:       [216,191,216],
    tomato:        [255,99,71],
    turquoise:     [64,224,208],
    violet:        [238,130,238],
    wheat:         [245,222,179],
    white:         [255,255,255],
    whitesmoke:    [245,245,245],
    yellow:        [255,255,0],
    yellowgreen:   [154,205,50]
  },
  
  setAdd: function (ele, to) {
    /*additive属性がsum (加法アニメーション)の場合*/
    if (ele.getAttributeNS(null, "additive") === "sum") {
      var attrValue = ele.parentNode.getAttributeNS(null, this.attrName);
      ele.addEventListener("beginEvent", function(evt) {
        to.forEach( function(x) {
          x.to.setAdditive(attrValue);
        } )
      }, false);
    }
  },
  setAccum: function (ele, to) {
    /*accumulate属性がsum (蓄積アニメーション)の場合*/
    if (ele.getAttributeNS(null, "accumulate") === "sum") {
      ele.addEventListener("repeatEvent", function(evt) {
        to.forEach( function(x) {
          x.to.call();
          x.to.setAccumulate(evt.detail);
        } )
      }, false);
    }
  }

/*initメソッドに追加処理
 * onメソッドについては、base.jsを参照のこと*/
} ).on ("init", function(ele) {
  var isColor = /^fill|stroke|stop-color|color$/.test(this.attrName);
  if (isColor) {
    this.setValues = function() {
      /*RGB形式では補間に、小数を使わない*/
      var s = this.$attribute.setValues.apply(this, arguments);
      s.forEach(function(x) {
        x.to.degit = 0;
      } );
      return s;
    };
  }
  var to, 
      keyTime = 0,
      /*関数fはrgbColor形式への変換処理で使う*/
      toRGB = function(x) { return x; };
  if (ele) {
    this.mode = ele.getAttributeNS(null, "calcMode") || "linear";
    to = this.setKey(ele);
  }
  if (isColor) {
    this.setValues = this.$attribute.setValues;
    /*#から始まる文字列を、rgb(.., .., ..,)形式へと変換するための関数*/
    var keywords = this._keywords;
    toRGB = function(rgbColor) {
           var keyword = keywords[rgbColor];
           if (keyword) {
             return "rgb(" + keyword.join(", ") + ")";
           }
           if (rgbColor && (rgbColor[0] === "#")) {  //#を含む場合
              var s = "rgb(",
                  _parseInt = parseInt;
              if (rgbColor.length < 5) {
                var r = rgbColor[1],
                    g = rgbColor[2],
                    b = rgbColor[3],
                rgbColor = "#" + r + r + g + g + b + b;
              }
              rgbColor.match(/\#(\w{2})(\w{2})(\w{2})/);
              s += _parseInt(RegExp.$1, 16)
                + ", "
                + _parseInt(RegExp.$2, 16)
                + ", "
                + _parseInt(RegExp.$3, 16)
                + ")";
              r = g = b = void 0;
              return s;
           }
           return rgbColor;
        };
  }
  if (to) {
    this.funcs = to.map( function(x) {
      x.to.string = toRGB(x.to.string);
      x.to.from.string = toRGB(x.to.from.string);
      var s = x.call();
      /*x.keyTimeプロパティは区間を示しているため、区切り時刻に変換しておく
       * startKeyTimeプロパティは区間のスタート時点
       * endKeyTimeプロパティは区間のエンド地点*/
      s.startKeyTime = keyTime;
      keyTime = s.endKeyTime = keyTime + x.keyTime;
      return s;
    } )
     .filter( function(s) {
       /*splineモードで、かつ、円周率を返す関数の場合は配列からはねておく*/
       return (this.mode !== "spline")
               || (s(0.1) !== Math.PI);
    }, this );
    this.setAdd(ele, to);
    this.setAccum(ele, to);
  }
  keywords = toRGB = isColor = void 0;
} )
/*$animateTranformElementオブジェクト
 * animateTransform要素に関連するオブジェクト*/
 .up("$animateTransformElement")
 .mix({
   /*__transformListで何番目のアイテムかを示すプロパティ*/
   numberOfList: -1,
   
   /*type属性の値*/
   type: "translate",
   
   /*additive属性がsumなら真*/
   isSum: false,
   
   /*$animateElementオブジェクトのtocallメソッドをオーバライド*/
   tocall: function (advance) {
     if (this.numberOfList < 0) {
       throw new Error("Number of The List Error");
     }
     var list = this.element.__transformList;
     list[this.numberOfList] = this.type+ "(" +this.$animateElement.tocall.call(this, advance)+ ")";
     var d = this.defaultValue;
     d = d && (d + " ");
     /*他のanimateTransform要素がadditive属性の値にreplaceをすでに設定していた場合、
      *初期値であるdは反映されなくなる*/
     if (list.numberOfReplace >= 0) {
        d = "";
     }
     if (this.isSum) {
       /*replaceが指定されていた要素の変更は反映されないため、sliceメソッドを使う*/
       return d + list.slice(list.numberOfReplace || 0).join(" ");
     } else {
       /*numberOfReplaceプロパティはreplaceが指定されたanimateTransform要素の順番*/
       list.numberOfReplace = this.numberOfList;
       return list[this.numberOfList];
     }
   },
   
   /*setAddメソッドのオーバライド
    * additive属性のsumに対する振る舞いが異なるため*/
    setAdd: function() {}
  })
 .on("init", function (ele) {
   if (!ele || !ele.parentNode) {
     return;
   }
   this.getAttr = this.$attribute.getAttr;
   this.type = this.getAttr("type", "translate");
   var parent = this.element;
   this.isDefault = parent.hasAttributeNS(null, "transform");
   this.defaultValue = parent.getAttributeNS(null, "transform") || "";
   this.isSum = (this.getAttr("additive", "replace") === "sum");
   if (!parent.__transformList) {
     parent.__transformList = [];
   }
   if (this.hasAttrValues()
    && (this.numberOfList < 0) ) {
     /*もし、今まで、このオブジェクトで、initメソッドを実行していなければ*/
     this.numberOfList = parent.__transformList.length;
     parent.__transformList.push( "translate(0)" );
   }
} );

/*$svgEventオブジェクトは、SVGEvent発火を監視するためのオブジェクト*/
base("$frame").up("$svgEvent").mix( {
  /*イベントのスケジュール記録*/
  first: null,
  
  /*タイムラインの最後のキャッシュ*/
  lastTimeLine: null,
  
  /*setTimeTable メソッドはスケジュールの記録をつけるためのメソッド*/
  setTimeTable: function () {
    var timelines = this.timelines;
      for (var i=0, obj = null;i<timelines.length;++i) {
        if (!timelines[i].target) {
          /*target オブジェクトがないものは除外*/
          continue;
        }
        /*タイムラインから、beginEventとendEventを発火するスケジュールを作成*/
        var timeline = timelines[i],
            begin = timeline.begin,
            target = timeline.target,
            simpleDur = timeline.simpleDuration,
            activeTime = timeline.activeTime,
            first = {
              frame: begin,
              eventType: "begin",
              target: target,
              next: {
                frame: begin+activeTime,
                eventType: "end",
                target: target,
                next: null
              }
            };
        if (obj) {
          obj = obj.next.next = first;
        } else {
          obj = this.first = first;
        }
        if (simpleDur && (activeTime !== simpleDur)) {
          /*活動継続時間と単純持続時間が異なるとき、repeatイベントを設定
           * ただし、repeatイベントはendイベントが発生する前に起きるものと仮定*/
          first.next = {
            firstFrame: begin + simpleDur,
            frame: begin + simpleDur,
            eventType: "repeat",
            target: target,
            /*リピートの制限時間*/
            limit: begin + activeTime,
            /*リピートの回数 (n >= 1)*/
            count: 1,
            simpleDuration: simpleDur,
            next: first.next
          };
        }
      }
    timelines = obj = first = begin = target = simpleDur = activeTime = void 0;
  },
  
  $frame: base("$frame"),
  
  setFrame: function (num) {
    var timelines = this.timelines,
        lastTimeLine = timelines[timelines.length-1],
        s = this.$frame.setFrame(num);
    /*キャッシュのlastTimeLineプロパティを使って、再びスケジュールの計算をさせないようにする*/
    if (this.lastTimeLine !== lastTimeLine) {
      this.lastTimeLine = lastTimeLine;
      this.setTimeTable();
    }
    /*スケジュールに記録しておいたものを実行して、イベントを発火
     * また、発火した場合は記録から取り除いて、次回から再び発火しないようにする*/
    var obj = this.first,
        cobj = obj,
        floor = Math.floor;
    while(obj) {
      var frame = obj.frame,
          target = obj.target
          detail = 0;
      if (frame <= num) {
        /*IE11ではSVGEventsやDOMEventsを使うと問題が起きるため、MouseEventsで代用する*/
        if (obj.eventType === "repeat") {
          var simpleDuration = obj.simpleDuration;
          /*リピートイベントが、リピート制限内である場合
           *numの段階で、何回リピートしたかを求める*/
          detail = obj.count = floor( (num - obj.firstFrame) / simpleDuration) + 1;
          /*simpleDurationを足すことによって、リピートイベントが
           * 単純継続時間内に何度も繰り返されることを防ぐ*/
          frame += simpleDuration;
          obj.frame = frame;
        }
        /*obj.limitはrepeatイベントの制限で使われるもの*/
        if ((obj.eventType !== "repeat") || (frame >= obj.limit)) {
          /*ポインタの連結を変更することで、リストからobj を除去*/
          cobj.next = obj.next;
          if (this.first === obj) {
            cobj = this.first = obj.next;
          }
        } else {
          cobj = obj;
        }
        var evt = target.ownerDocument.createEvent("MouseEvents");
        evt.initMouseEvent(obj.eventType+"Event" ,true, true, window, detail, 0, 0, 0, 0, false, false, false, false, 0, target);
        target.dispatchEvent(evt);
      } else {
        /*next プロパティを書き換えるためのobj オブジェクトのキャッシュ*/
        cobj = obj;
      }
      obj = obj.next;
    }
    obj = num = first = frame = target = cobj = simpleDuration = detail = void 0;
    return s;
  }
} );

function getDocument() 
{
  var svg = document.getElementsByTagName("object"),
      svgns = "http://www.w3.org/2000/svg";
  if (svg) {
    for (var i=0;i<svg.length;++i) {
      getElement( svg[i].getSVGDocument() );
    }
  }
  /*SVG文書から呼び出されたときも処理する*/
  getElement(document);
  /*idはアニメの中止ハンドル*/
  var id = __step(),
      idstop = function() {
        /*アニメーションを中止する関数*/
        window.cancelAnimationRequest && cancelAnimationRequest(id);
      };
  base("$frame").on("pauseAnimation", idstop);
  window.addEventListener("unload", idstop);
  
  /*文書からアニメーション関連要素を取り出して、オブジェクトを初期化*/
  function getElement (svgDoc) {
      var $set = base("$calcMode").$attribute.$setElement;
      init($set, "set");
      init($set.$animateElement, "animate");
      init($set.$animateElement, "animateColor");
      init($set.$animateElement.$animateTransformElement, "animateTransform");
        /*リンクのハッシュ読み取りで、ハイパーリンクのイベント処理
       * たとえば、a要素のxlink:href="#hoge"で、<animate id="hoge"のとき、
       * animate要素がハイパーリンク作動と同時に動くようになる
       * 
       * ただし、SMIL アニメーションの仕様では、
       * animate要素の開始時刻まで、時を進める操作をするだけ*/
       svgDoc.defaultView.addEventListener("hashchange", function() {
           var hash = svgDoc.defaultView.location.hash.slice(1);
           svgDoc.getElementById(hash).beginElement();
         });

      function init (obj, name) {
        var eles = svgDoc.getElementsByTagNameNS(svgns, name)
        for (var i=0;i<eles.length;++i) {
          obj.up().init(eles.item(i));
        }
        eles = obj = void 0;
      };
  };
}

window.addEventListener && window.addEventListener("load", getDocument);

function __step() {
if (!document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#Animation", "1.1")) {
  if (window.requestAnimationFrame && requestAnimationFrame) {
    /*IE11などSMILアニメーションに対応していないブラウザ用*/
    /*cancelはアニメーションの中止ハンドル*/
    var cancel = {
       handle: null
      };
    (function(frame) {
      var $frame = base("$frame"),
          $f = $frame.$svgEvent,
          _cancel = cancel; /*cancelのエイリアス*/
      $f.startTime = Date.now();
      _cancel.handle = requestAnimationFrame(step);
      function step() {
        if (!$frame.isPaused) {
          frame++;
          try {
            $f.setFrame(frame);
          } catch(e) {
          }
          _cancel.handle = requestAnimationFrame(step);
        }
      };
    })(-1);
    return cancel;
  } else {
    setInterval( (function(frame) {
      var $f = base("$frame").$svgEvent;
      $f.startTime = Date.now();
      return function () {
        frame++;
        $f.setFrame(frame);
      };
    })(-1), 1 );
  }
}
}
//#endif // _SMIL_IDL_
