require 'amrita/parser'

module Amrita

  module AttrCommon
    def ==(x)
      return false unless x.kind_of?(AttrCommon)
      x.key_symbol == key_symbol and x.value == value
    end
  end

  module AttrArrayCommon
    # AttrArray#== concerns the order of Attr
    def ==(x)
      return true if id == x.id
      return false unless size == x.size
      each do |a|
        return false unless a.value == x.value_by_key(a.key_symbol)
      end
      true
    end
  end

  module ElementCommon
    # test if tag and attributes and body are equal to self.
    # doesn't concern the order of attributes
    def ==(x)
      return true if x.id == id
      return false unless x.kind_of?(ElementCommon)
      return false unless x.tag_symbol == tag_symbol
      return false unless x.attrs == attrs
      return false unless x.body == body
      true
    end
  end

  class NodeArray
    def ==(x)
      return false unless x.kind_of?(NodeArray)
      case x
      when NodeArray, Array
        return false unless x.size() == @array.size()
        @array.each_with_index do |n, i|
          return false unless n == x[i]
        end
        true
      else
        false
      end
    end
  end

  class SpecialElement
    def ==(x)
      return false unless x.kind_of?(SpecialElement)
      tag == x.tag and body.strip == x.body.strip
    end
  end

  $PARSER_FOR_TEST = HtmlParser
  def assert_equal_node(aa,bb)
    a, b = aa, bb
    a = $PARSER_FOR_TEST::parse_text(aa) unless a.kind_of?(Node)
    b = $PARSER_FOR_TEST::parse_text(bb) unless b.kind_of?(Node)
    ret = [a, b].collect do |x|
      nodes = []
      x.each_node do |x|
        case x
        when Element
          nodes << x.clone { Null }
        when TextElement
          ret = x.to_s.gsub(/[\s\n\r]+/, "")
          if ret.size > 0
            nodes << ret
          end
        when NodeArray
        else
          nodes << x
        end
      end
      nodes
    end
    unless ret[0] == ret[1]
      raise "not_equal_node expected<#{aa}> but was <#{bb}>"
    end
  end

end
