#----------------------------------------------------------------------------
#   block.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2003 August Nowake(野分) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア
#  財団によって発行された GNU一般公衆利用許諾契約書(バージョン2)の定める条件
#  の下で再頒布または改変することができます。
#  このプログラムは有用であることを願って頒布されますが、
#    *全くの無保証*
#  です。商業可能性の保証や特定の目的への適合性は、言外に示されたものも含め
#  全く存在しません。詳しくはGNU 一般公衆利用許諾契約書をご覧ください。
#  あなたはこのプログラムと共に、GNU 一般公衆利用許諾契約書の複製物を一部
#  受け取ったはずです。もし受け取っていなければ、フリーソフトウェア財団まで
#  請求してください。
#  (宛先は the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------

module Formatter
  class Block
    attr_reader( :source_on_show )
    @@edit_position = -1
    @@current_position = -1
    def initialize( variables )
      @variables =  variables
      @source_on_show = '^\n((?:(?>[^\n]*)|(?>\n[^\n]))+)\n'
    end
    def on_show( match_text, target_range, node )
      s = match_text.sub( /^\n+/, '' )
      @@current_position += 1
      range = target_range
      if @@current_position == @@edit_position
        fn = @variables.formatter_template_root + 'block/edit.html'
        template = Amrita::TemplateText.new(
            File.open( fn, "r+b" ) do | f | f.read.untaint end )
        data = {
          :cgi_uri => @variables.cgi_uri,
          :command => Command.base_name,
          :command_name => Command::Save.base_name,
          :node => Node::Target.base_name,
          :target_node => node.escaped_name,
          :edit => Command::Edit::EditData.base_name,
          :pre_edit => Command::Edit::PreEditData.base_name,
          :post_edit => Command::Edit::PostEditData.base_name,
          :original => CGI.unescapeHTML(Command::Edit::OriginalData.base_name),
          :content => CGI.unescapeHTML(node.escapeHTML_content[target_range]),
          :pre_edit_content => node.escapeHTML_content[0...target_range.begin],
          :post_edit_content =>
              node.escapeHTML_content[
                  target_range.end...node.escapeHTML_content.size],
          :html => Amrita::SanitizedString["<p id=\"target\">"+
              @variables.formatter.on_show( s, target_range, node )+
              "</p>"],
          :target => true,
        }
        template.expand( "", data )
      else
        "<p>#{@variables.formatter.on_show( s, target_range, node )}"+
        "<a  style=\"text-decoration:none;font-size:xx-small\" href=" + 
        "#{@variables.cgi_uri}\?" +
        "#{Command.base_name}=#{Command::Execute.base_name};" +
        "#{Node::Target.base_name}=#{node.escaped_name};" +
        "#{Formatter.base_name}=#{Formatter::Block.base_name};" +
        "No=#{@@current_position};#target" +
        ">" + "<>" + "</a></p>\n"
      end
    end
    def on_call( node )
      @@edit_position = @variables.cgi["No"].to_i
      @variables.use_cache = false
      cmd = @variables.command[Command::Show.base_name].new( @variables )
      cmd.execute( node )
    end
  end
end

