#----------------------------------------------------------------------------
#   link.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2003 August Nowake(ʬ) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  Υץϥե꡼եȥǤʤϤ򡢥ե꡼եȥ
#  ĤˤäȯԤ줿 GNU̸ѵ(С2)
#  βǺۤޤϲѤ뤳ȤǤޤ
#  ΥץͭѤǤ뤳Ȥäۤޤ
#    *̵ݾ*
#  ǤȲǽݾڤŪؤŬϡ˼줿Τޤ
#  ¸ߤޤ󡣾ܤGNU ̸ѵ
#  ʤϤΥץȶˡGNU ̸ѵʣʪ
#  äϤǤ⤷äƤʤСե꡼եȥĤޤ
#  ᤷƤ
#  ( the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------

module Formatter
  class Link
    attr_reader( :source_on_show )
    def initialize( variables )
      @variables =  variables
      @source_on_show = '\[\[([^\]\[]+)\]\]'
      @link_perse_regexp = /(.+)\s([^\s]+)/m
      @wikiname_perse_regexp=/^\/?((?>(?:(?:\.\/)|(?:\.\.\/)))*)(.*)$/
    end
    def self.format( content )
      "[[#{content}]]"
    end
    def on_show( match_text, target_range, node )
      n = l = nil
      is_no_exist_wikiname = false
      m = @link_perse_regexp.match( match_text[2...(match_text.size-2)] )
      if m and m[2]
        n = m[1].to_s
        l = m[2].to_s
      else
        n = l = match_text[2...(match_text.size-2)]
      end
      if ( ml = /^img\:(.+)/.match( l ) )
        if /([^:]*)\:(.*)/.match( ml[1] )
          l = ml[1]
        else
          l = "#{@variables.cgi_uri}" +
              "?#{Command.base_name}=#{Command::Show.base_name};" +
              "#{Node::Target.base_name}=#{CGI::escape( ml[1] )}"
        end
        "<img src=\"#{l}\" alt=\"#{n}\" />"
      elsif ( ml = /^inline\:(.+)/.match( l ) )
        @variables.use_cache = false
        Node::Reader.new( ml[1], @variables ).html_data
      elsif /\:/.match( l )
        "<a href=\"#{sanitize_uri( l )}\">#{n}</a>"
      else
        m = @wikiname_perse_regexp.match( l )
        if m[1].to_s != ''
          f = File.expand_path( m[0], "/#{node.name}/" )
          f.sub!( /[^\/]*\//, '')
        else
          f = m[2]
        end
        if n == l
          n = l = f
        else
          l = f
        end
        node = Node::Reader.new( l, @variables )
        if node.file_exist? then
          "<a href=\"#{@variables.cgi_uri}" +
          "?#{Command.base_name}=#{Command::Show.base_name};" +
          "#{Node::Target.base_name}=#{node.escaped_name}\">#{n}</a>"
        else
          "#{n}<a href=\"#{@variables.cgi_uri}" +
          "?#{Command.base_name}=#{Command::Edit.base_name};" +
          "#{Command::Edit::CacheClearNode.base_name}=" +
          "#{node.escaped_name};" +
          "#{Node::Target.base_name}=#{node.escaped_name}\">(?)</a>"
        end
      end
    end
  private
    def create_node( wiki_name )
      m = @wikiname_perse_regexp.match( wiki_name )
      if m[1].to_s != '' #with relative name space
        f = File.expand_path( m[0], "/#{@variables.node_name}/" )
        f.sub!( /[^\/]*\//, '')
      else #with absolute name space
        f = m[2]
      end
      v = @variables.clone
      v.node_name = link
      v.setup
      v.node
    end
    def sanitize_uri( uri )
      result = uri
      return '' if result.include?( "localhost")
      return '' if result.include?( "127.0.0.1")
      usable_string = Regexp.escape( ";/?:@&=+$,-.!~*'()%" )+'\w'
      return '' if not (result =~ /^[#{usable_string}]+$/mo)
      if (result =~ /^([A-Za-z][A-Za-z0-9\+\-\.]*)\:/)
        return '' if not (result.downcase =~ /^(http|https|mailto)/ )
      end
      result.gsub!( '&', '&amp;' )
      result.gsub!( "'", '&#39;' )
      result
    end
  end
end

