#----------------------------------------------------------------------------
#   unorderedlist.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2003 August Nowake(ʬ) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  Υץϥե꡼եȥǤʤϤ򡢥ե꡼եȥ
#  ĤˤäȯԤ줿 GNU̸ѵ(С2)
#  βǺۤޤϲѤ뤳ȤǤޤ
#  ΥץͭѤǤ뤳Ȥäۤޤ
#    *̵ݾ*
#  ǤȲǽݾڤŪؤŬϡ˼줿Τޤ
#  ¸ߤޤ󡣾ܤGNU ̸ѵ
#  ʤϤΥץȶˡGNU ̸ѵʣʪ
#  äϤǤ⤷äƤʤСե꡼եȥĤޤ
#  ᤷƤ
#  ( the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------

module Formatter
  class UnorderedList
    attr_reader( :source_on_show )
    def initialize( variables )
      @variables =  variables
      @source_on_show = '^[\-\+](?:(?>[^\n]*)|(?:\n[^\n]))+'
      @regexp_on_show = /^([\-\+]+)((?:(?>[^\n]*)|(?:\n[^+-]))+)/m
    end
    def self.delete( lists_string, target )
      lists_string.gsub( /^\-#{target}(?:\n|\Z)/, "" )
    end
    def self.push( lists_string, add_string )
      "-#{add_string}\n#{lists_string}"
    end
    def self.top20( lists_string )
      lists_string.split("\n")[0..20].join("\n")
    end
    def on_show( match_text, target_range, node )
      i = 0; j = 0; s = ""; t = ""; e = []
      match_text.scan( @regexp_on_show ) do | m |
        j = $~[1].size - i; i = $~[1].size.to_i #ä
        if j > 0
          t = ($~[1].include?( '-' )) ? 'ul' : 'ol'
          j.abs.times do s << "<#{t}>"; e.push( "</#{t}>" ) end
        else
          j.abs.times do s << e.pop end
        end
        r = FormatterTool.get_substring_range(target_range,$~.begin(2),$~[2])
        s << "<li>#{@variables.formatter.on_show( $~[2], r, node )}</li>\n"
      end
      s += e.reverse.join
    end
  end
end

