#----------------------------------------------------------------------------
#   initialize.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2003 August Nowake(野分) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア
#  財団によって発行された GNU一般公衆利用許諾契約書(バージョン2)の定める条件
#  の下で再頒布または改変することができます。
#  このプログラムは有用であることを願って頒布されますが、
#    *全くの無保証*
#  です。商業可能性の保証や特定の目的への適合性は、言外に示されたものも含め
#  全く存在しません。詳しくはGNU 一般公衆利用許諾契約書をご覧ください。
#  あなたはこのプログラムと共に、GNU 一般公衆利用許諾契約書の複製物を一部
#  受け取ったはずです。もし受け取っていなければ、フリーソフトウェア財団まで
#  請求してください。
#  (宛先は the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------

$: << File.dirname( __FILE__ ) + "/RAA"

module SikiTool
  require 'cgi'
  require '../lib/tool'
  require '../lib/node'
  require '../lib/formatter/index'
  require '../lib/command/index'
  require 'amrita/template'
  class Variables
    attr_accessor(
      :data_root,
      :formatter_set, :formatter_array,
      :command_set, :command_array,
      :template_set,
      :theme_name, :information_name, :help_name, :training_name,
      :command_name, :recency_name, :default_name,
      :protocol_type, :address, :cgi_path,
      :http_header_set, :content_set,
      :use_cache )
    attr_reader(
      :cgi,
      :global_root, :node_root, :container_root, :backup_root, :cache_root,
      :template_root,
      :formatter_template_root, :command_template_root,
      :cgi_uri, :theme_uri,
      :command, :formatter )
    def initialize
      @cgi = CGI.new("html4")
      @cgi_path = @cgi.script_name
      @data_root = File.expand_path(
          "#{File.dirname(__FILE__)}/../data/",
          File.dirname( $0 ) ) + '/'
      @formatter_set = 'wiki'
      @formatter_array = nil
      @command_set = 'siki'
      @command_array = nil
      @template_set = 'tDiary'
      @theme_name = 'siki-default'
      @information_name = 'Siki/Information'
      @help_name = 'Siki/Help'
      @training_name = 'Siki/Training'
      @recency_name = 'Siki/Recency'
      @default_name = 'Siki/Welcome'
      @command_name = cgi_value( Command.base_name )
      @node_name = CGI.unescape( cgi_value( Node::Target.base_name ) )
      @protocol_type = 'http'
      @address = @cgi.host
      @http_header_set = {'type' => 'text/html'}
      @content_set = {}
      @use_cache = true
    end
    def setup
      @node_root = "#{@data_root}node/"
      @container_root= "#{@data_root}container/"
      @backup_root = "#{@data_root}backup/"
      @cache_root = "#{@data_root}cache/"
      @template_root = "../lib/template/#{@template_set}/"
      @formatter_template_root="#{@template_root}formatter/#{@formatter_set}/"
      @command_template_root = "#{@template_root}command/#{@command_set}/"
      @formatter = FormatterTool::create_processor(
          @formatter_set, @formatter_array, self)
      @command = CommandTool::create_factory( @command_set, @command_array)
      @command_name = Command::Show.base_name if @command_name.to_s == ""
      @cgi_uri = "#{@protocol_type}://#{@address+@cgi_path}"
      @theme_uri = File.dirname( File.dirname( @cgi_uri ) ) +
          "/doc/html/siki/theme/tDiary/#{theme_name}/#{theme_name}.css"
      self
    end
    def execute
      require "../lib/command/#{command_set}/main"
    end
    def http_header
      @cgi.header( @http_header_set )
    end
    def cgi_value( key )
      return "" if not @cgi[key]
      @cgi.content_type =~ %r|multipart/form-data| ?
          @cgi[key].string : @cgi[key].to_s
    end
    def command_uri( command, target_node )
      "#{@cgi_uri}?#{Command.base_name}=#{command};" +
      "#{Node::Target.base_name}=#{target_node}"
    end
  end
end


$Variables = SikiTool::Variables.new