#----------------------------------------------------------------------------
#   tool.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2003 August Nowake(ʬ) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  Υץϥե꡼եȥǤʤϤ򡢥ե꡼եȥ
#  ĤˤäȯԤ줿 GNU̸ѵ(С2)
#  βǺۤޤϲѤ뤳ȤǤޤ
#  ΥץͭѤǤ뤳Ȥäۤޤ
#    *̵ݾ*
#  ǤȲǽݾڤŪؤŬϡ˼줿Τޤ
#  ¸ߤޤ󡣾ܤGNU ̸ѵ
#  ʤϤΥץȶˡGNU ̸ѵʣʪ
#  äϤǤ⤷äƤʤСե꡼եȥĤޤ
#  ᤷƤ
#  ( the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------

class Module
  def base_name; name.split("::")[-1] end
end

module SikiTool
  def SikiTool.create_factory( owner_module, dir_name, set_array )
    if set_array
      file_array = set_array
    else
      file_array = Dir.entries( dir_name )
    end
    file_array.each do | file |
      require ( (dir_name + file).untaint ) if file =~ /^(?!main).+\.rb$/
    end
    factory = Hash.new
    owner_module.constants.each do | n |
      c = owner_module.const_get( n ); s = c.to_s
      factory[ n ] = c if not factory.member?( s )
    end
    factory
  end
  
  require 'algorithm/diff'
  class TriDiff
    attr_reader( :diff, :integrate )
    def initialize( origin, before, after )
      if ((origin == before) or (not before))
        @diff = Diff.diff( origin.split(//), after.split(//) )
        @integrate = after
      elsif before == after
        @diff = []
        @integrate = origin
      elsif origin == after
        @diff = []
        @integrate = origin
      else
        so = origin.split(//)
        sb = before.split(//)
        sa = after.split(//)
        @unintended = Diff.diff( sb, so )
        @diff = Diff.diff( sb, sa )
        drc = DiffResultControler.new( @diff )
        @unintended.each do | i |
          if i[0] == :-
            drc.pos = i[1]
            drc.delete( i[2].size )
          end
        end
        @unintended.each do | i |
          if i[0] == :+
            drc.pos = i[1]
            drc.add( i[2].size )
          end
        end
        @integrate = so.patch( @diff ).join
      end
      @diff.each do | i |
        i[2] = i[2].join
      end
    end
    def TriDiff.patch( string, diff )
      str_ary = string.split(//)
      result = []
      minus_pos = 0; plus_pos = 0;
      diff.each do | action, position, elements |
        result << [ :== , "" ]
        if action == :-
          while minus_pos < position
            result[-1][1] << str_ary[minus_pos]
            minus_pos += 1; plus_pos += 1;
          end
          result << [:-, elements.join]
          minus_pos += elements.length
        elsif action == :+
          while plus_pos < position
            result[-1][1] << str_ary[minus_pos]
            minus_pos += 1; plus_pos += 1;
          end
          result << [:+, elements.join]
          plus_pos += elements.length
        else
          raise "Unknown diff action"
        end
      end
      result << [ :== , "" ]
      while minus_pos < str_ary.length
        result[-1][1] << str_ary[minus_pos]
        minus_pos += 1; plus_pos += 1;
      end
      result
    end
  end
  
  class DiffResultControler
    attr_reader( :diff, :plus_pos, :minus_pos )
    def initialize( diff )
      @diff = diff; @item = diff[0]
      @plus_pos = 0; @minus_pos = 0; @pos = 0
    end
    def pos=( pos )
      if pos < @minus_pos
        @plus_pos = 0; @minus_pos = 0; @pos = 0; @item = @diff[0]
        advance( pos )
      else
        advance( pos - @minus_pos )
      end
    end
    def advance( distance )
      distance.times do
        @minus_pos += 1;
        return nil if @item == nil
        if @item[0] == :-
          if @minus_pos <= @item[1]
            @plus_pos += 1
          elsif @minus_pos <= @item[1] + @item[2].size
          else
            @plus_pos += 1; 
            @pos += 1
            @item = @diff[@pos]
          end
        else
          @plus_pos += 1
          if @item[1] < @plus_pos
            @plus_pos += @item[2].size
            @pos += 1
            @item = @diff[@pos]
          end
        end
      end
      self
    end
    def add( length )
      index = @diff.size - 1
      while 0 <= index
        i = @diff[index]
        if i[0] == :+
          if @plus_pos <= i[1]
            i[1] += length
          end
        else
          if @minus_pos <= i[1]
            i[1] += length
          elsif @minus_pos <= i[1] + i[2].size
            j = [i[0], i[1], i[2][0...(@minus_pos - i[1])]]
            i[1] = @minus_pos + length
            i[2] = i[2][(@minus_pos - i[1])..i[2].size]
            @diff.insert( index, j )
          end
        end
        index -= 1
      end
      self
    end
    def delete( length )
      delp = delm = length
      @diff.each do | i |
        if i[0] == :-
          sp = i[1]; ep = i[1] + i[2].size
          dsp = @minus_pos; dep = @minus_pos + delm
          if ep < dsp
            # nothing to do
          elsif ep <= dep
            if sp < dsp
              delp -= ep - dsp
              i[2] = i[2][0...(dsp - sp)]
            else
              delp -= i[2].size
              i[2] = ""
            end
          else
            if sp <= dsp
              delp = 0
              i[2] = i[2][0...(dsp - sp)] + i[2][(dep - sp)..i[2].size]
            elsif sp <= dep
              delp -= dep - sp
              i[2] = i[2][(dep - sp)..i[2].size]
              i[1] = dsp
            else
              i[1] -= delm
            end
          end
        end
      end
      @diff.each do | i |
        if i[0] == :+
          if @plus_pos < i[1]
            i[1] -= delp
            i[1] = @plus_pos if i[1] < @plus_pos
          end
        end
      end
      @diff.each_index do | index |
        if @diff[index][2] == ""
          @diff[index] = nil
        end
      end
      @diff.compact!
      self
    end
  end
end
