
#include "ruby.h"

typedef struct {
    ID key ;
    VALUE value; 
} amrita_attr_t;

typedef struct {
    VALUE shared ;
    struct RArray *array; 
    VALUE body ;
} amrita_attrarray_t;

typedef struct {
    ID tag ;
    VALUE attrs ;
    unsigned int flags ;
    VALUE body ;
} amrita_element_t;

#define AMRITA_ELEM_HIDEHID 0x00000001

typedef struct {
    VALUE tagdict ;
    unsigned int flags ;
    ID amrita_id ;
    ID escaped_id ;
} amrita_element_processor_t ;

#define AMRITA_EP_DELETE_ID 0x00000001
#define AMRITA_EP_DELETE_ID_ON_COPY 0x00000002
#define AMRITA_EP_DELETE_PRAGMA 0x00000004


#define AMRITA_STACK_T struct RArray *
#define AMRITA_STACK_PUSH(stack, data) rb_ary_push(stack, data) 
#define AMRITA_STACK_POP(stack) rb_ary_pop(stack)

typedef VALUE (*amrita_bytecode_func_t)(VALUE self, VALUE register, AMRITA_STACK_T stack, VALUE out, VALUE vm) ;

typedef struct {
    unsigned int flags ;
    amrita_bytecode_func_t func ;
    VALUE data ;
    VALUE para1 ;
    VALUE para2 ;
} amrita_instruction_t ;

#define AMRITA_BYTECODE_DEBUG_MODE 0x00000001


/* output buffer */
/* using inline OUTBUF increase compile time decrease exec time */

/* #define AMRITA_OUTBUF_INLINE 1  */


#ifdef AMRITA_OUTBUF_INLINE

#define AMRITA_OUTBUF_BUFSIZE 4096

#define AMRITA_OUTBUF_DEFINE                \
struct {                                    \
    char *buf_start ;                       \
    char *buf_end ;                         \
    char *ptr ;                             \
    VALUE target ;                         \
} _amrita_outbuf ;

#define AMRITA_OUTBUF_INIT(target_out)                  \
_amrita_outbuf.buf_start = xmalloc(AMRITA_OUTBUF_BUFSIZE) ; \
_amrita_outbuf.buf_end = _amrita_outbuf.buf_start + AMRITA_OUTBUF_BUFSIZE ; \
_amrita_outbuf.ptr = _amrita_outbuf.buf_start ; \
_amrita_outbuf.target = target_out ;

#define AMRITA_OUTBUF_FLUSH                   \
{                   \
    int size = _amrita_outbuf.ptr - _amrita_outbuf.buf_start ;                 \
    if (size > 0) {                                                                \
        output(_amrita_outbuf.target, rb_str_new(_amrita_outbuf.buf_start, size), 0) ;\
    }                \
    _amrita_outbuf.ptr = _amrita_outbuf.buf_start ;  \
}

#define AMRITA_OUTBUF_PUTSTR(str, size) \
{                \
    if (_amrita_outbuf.ptr + size >= _amrita_outbuf.buf_end) AMRITA_OUTBUF_FLUSH \
    if (_amrita_outbuf.ptr + size < _amrita_outbuf.buf_end)  { \
        memcpy(_amrita_outbuf.ptr, str, size) ;  \
        _amrita_outbuf.ptr += size ;  \
    } else { \
        output(_amrita_outbuf.target, rb_str_new(str, size), 0) ;\
   } \
}

#define AMRITA_OUTBUF_PUTCONST(const_str) \
{ static char *str = const_str ; \
 static int size = 0 ; \
 if (size == 0) size = strlen(str) ; \
 AMRITA_OUTBUF_PUTSTR(str, size) ; \
}
 
#define AMRITA_OUTBUF_PUTOBJ(obj, sanitize_id) \
if (sanitize_id) { \
switch(TYPE(obj)) { \
case T_STRING: \
    AMRITA_OUTBUF_PUTSTR(RSTRING(obj)->ptr, RSTRING(obj)->len) ; break ;\
default : \
    AMRITA_OUTBUF_FLUSH ; \
    output(_amrita_outbuf.target, obj, sanitize_id) ; \
}} else { \
    AMRITA_OUTBUF_FLUSH ; \
    output(_amrita_outbuf.target, obj, sanitize_id) ; \
}

#define AMRITA_OUTBUF_CLOSE \
AMRITA_OUTBUF_FLUSH \
xfree(_amrita_outbuf.buf_start) ; 
  
#else /* AMRITA_OUTBUF_INLINE*/

#define AMRITA_OUTBUF_DEFINE
#define AMRITA_OUTBUF_INIT
#define AMRITA_OUTBUF_FLUSH
#define AMRITA_OUTBUF_PUTSTR(ptr, size) output(out, rb_str_new(ptr, size), 0) ;
#define AMRITA_OUTBUF_PUTCONST(ptr) output(out, rb_str_new2(ptr), 0) ;
#define AMRITA_OUTBUF_PUTOBJ(obj, sanitize_id) output(out, obj, sanitize_id) ;

#define AMRITA_OUTBUF_CLOSE


#endif /* AMRITA_OUTBUF_INLINE*/
