/*
 *
 * This source is used by amrita_accel.c and amritacc
 *
 */

#include "amrita_accel.h"

#define AMRITA_EXT_DEBUG 1
#if AMRITA_EXT_DEBUG
#define DEBUGINT(x) printf("%d:%d(%0x)\n",  __LINE__, x,x) ;
#define DEBUGSTR(x) printf("%d:%s\n",  __LINE__, x) ;
#define DEBUGOBJ(x) { printf("%d:%s:", __LINE__, rb_class2name(CLASS_OF(x))); rb_p(x); } 
#else
#define DEBUGINT(x)
#define DEBUGSTR(x)
#define DEBUGOBJ(x)
#endif

#define FLAG_TEST(i, f) (i & f)
#define FLAG_SET(i, f)    i |= f 
#define FLAG_RESET(i, f)  i &= ~f 

static VALUE mAmrita ;
static VALUE mNode ;
static VALUE mAmritaAccelerator ;
static VALUE cAmritaSanitizedString ;
static VALUE mAmritaDictionary ;
static VALUE mAmulet ;

static VALUE cAttr ;
static VALUE cAttrArray ;
static VALUE cElement ;
static VALUE cElementProcessor ;

static VALUE mByteCodeCommon ;
static VALUE mByteCode ;
static VALUE cInstruction ;

static VALUE cNull ;
static ID id_new ;
static ID id_to_s ;
static ID id_to_a ;
static ID id_each ;
static ID id_clone ;
static ID id_dup ;
static ID id_write ;
static ID id_to_node ;
static ID id_ep ;
static ID id_format_node ;
static ID id_putput ;
static ID id_execute ;
static ID id_debug ;
static ID id_span ;
static ID id_id ;
static ID id___id__ ;
static ID id_format_attr ;
static ID id_url_attr2 ;
static ID id_amrita_sanitize ;
static ID id_amrita_sanitize_as_attribute ;
static ID id_amrita_sanitize_as_url ;
static struct RString *null_str ;

static void 
init_static_constants()
{
    mNode = rb_const_get(mAmrita, rb_intern("Node")) ;
    cNull = rb_const_get(mAmrita, rb_intern("Null")) ;
    cAmritaSanitizedString = rb_const_get(mAmrita, rb_intern("SanitizedString")) ;
    mAmritaDictionary = rb_const_get(mAmrita, rb_intern("AmritaDictionary")) ;

    mAmulet = rb_const_get(mAmrita, rb_intern("Amulet")) ;
    cAttr = rb_const_get(mAmrita, rb_intern("Attr")) ;
    cAttrArray = rb_const_get(mAmrita, rb_intern("AttrArray")) ;
    cElement = rb_const_get(mAmrita, rb_intern("Element")) ;

    id_new = rb_intern("new") ;
    id_to_s = rb_intern("to_s") ;
    id_to_a = rb_intern("to_a") ;
    id_each = rb_intern("each") ;
    id_clone = rb_intern("clone") ;
    id_dup = rb_intern("dup") ;
    id_write = rb_intern("write") ;
    id_to_node = rb_intern("to_node") ;
    id_ep = rb_intern("ep") ;
    id_format_node = rb_intern("format_node") ;
    id_putput = rb_intern("<<") ;
    id_execute = rb_intern("execute") ;
    id_debug = rb_intern("debug") ;
    id_span = rb_intern("span") ;
    id_id = rb_intern("id") ;
    id___id__ = rb_intern("__id__") ;
    id_format_attr = rb_intern("format_attr") ;
    id_url_attr2 = rb_intern("url_attr2?") ;
    id_amrita_sanitize = rb_intern("amrita_sanitize")  ;
    id_amrita_sanitize_as_attribute = rb_intern("amrita_sanitize_as_attribute")  ;
    id_amrita_sanitize_as_url = rb_intern("amrita_sanitize_as_url")  ;

    null_str = (struct RString *) rb_str_new(0, 0) ;
    rb_str_freeze((VALUE)null_str) ;
}

/*
  convert to string and freeze it 
*/

static struct RString 
*obj2fstr(obj)
VALUE obj ;
{
    switch(TYPE(obj)) {
    case T_NIL:
        return null_str ;
    case T_SYMBOL:
        return (struct RString *)rb_str_freeze(rb_str_new2(rb_id2name(SYM2ID(obj)))) ;
    case T_STRING:
        if (CLASS_OF(obj) == rb_cString) {
            return RSTRING(rb_str_dup_frozen(obj)) ;
        } else {
            return RSTRING(rb_funcall(obj, id_dup, 0)) ;
        }
    default:
        return (struct RString *)rb_str_freeze(rb_funcall(obj, id_to_s, 0)) ;
    }
}

static VALUE
obj2sym(obj)
VALUE obj ;
{
    switch(TYPE(obj)) {
    case T_SYMBOL:
        return obj ;
    case T_STRING:
        return ID2SYM(rb_intern(((struct RString *)obj)->ptr)) ;
    default:
        return ID2SYM(rb_intern(obj2fstr(obj)->ptr)) ;
    }
}

static ID
obj2id(obj)
VALUE obj;
{
    switch(TYPE(obj)) {
    case T_SYMBOL:
        return SYM2ID(obj) ;
    case T_STRING:
        return rb_intern(((struct RString *)obj)->ptr) ;
    default:
        return rb_intern(obj2fstr(obj)->ptr) ;
    }
}

static void 
output(out, x, sanitize_id)
VALUE out, x ;
ID sanitize_id ;
{
    struct RString *str ;
    VALUE v ;

    switch(TYPE(x)) {
    case T_NIL:
    case T_FALSE:
        return ;
    }

    if (sanitize_id == 0) {
        str = RSTRING(rb_obj_as_string(x)) ;
    } else {
        if (CLASS_OF(x) == cAmritaSanitizedString) {
            str = RSTRING(x) ;
        } else {
            str = RSTRING(rb_funcall((VALUE) x, sanitize_id, 0)) ;
            if (!RTEST(str)) {
                return ;
            }
        }
    }
    switch(TYPE(out)) {
    case T_STRING:
        rb_str_concat(out, (VALUE)str) ;
        break ;
    case T_FILE:
        rb_funcall(out, id_write, 1, (VALUE)str) ;
        break ;
    default:
        rb_funcall(out, id_putput, 1, (VALUE)str) ;
        break ;
    }
}

