
require 'amrita/node'
require 'amrita/vm'
require 'amrita/compiler'

unless ENV['AmritaNoAccel']
  begin
    require 'amrita_accel.so'
    module Amrita
      @@accelerator_loaded = true
    end
  rescue LoadError
    STDERR.puts "can't load amrita_accelerator"
  end
end

if Amrita::accelerator_loaded?
  module AmritaAccelerator
    extend Amrita::ByteCodeCommon::SimpleSpanSupport
    module NodeMarshal
      def _dump(level)
        to_ruby
      end

      def NodeMarshal::append_features(mod)
        super
        def mod::_load(s)
          Amrita::module_eval s
        end
      end
    end
    class Element ; include NodeMarshal ; end

    module ByteCode
      class NullInstruction ; include ByteCodeCommon::InstructionMarshal ; end
      class GetDataByKey ; include ByteCodeCommon::InstructionMarshal ; end
      class ExtractData ; include ByteCodeCommon::InstructionMarshal ; end
      class PopData ; include ByteCodeCommon::InstructionMarshal ; end
      class SwapData ; include ByteCodeCommon::InstructionMarshal ; end
      class PrintStaticNode ; include ByteCodeCommon::InstructionMarshal ; end
      class PrintStaticText ; include ByteCodeCommon::InstructionMarshal ; end
      class PrintRegister ; include ByteCodeCommon::InstructionMarshal ; end
      class MergeElement ;  include ByteCodeCommon::InstructionMarshal ; end
      class GetDataFromAttrArray ; include ByteCodeCommon::InstructionMarshal ; end

      # These methods are not inplemented in accelerator now.
      #class PushElement ; include ByteCodeCommon::InstructionMarshal ; end
      #class GetDataFromAmulet ; include ByteCodeCommon::InstructionMarshal ; end
      #class ExecuteRegister ; include ByteCodeCommon::InstructionMarshal ; end

      class Sequence
        include ByteCodeCommon::SequenceMarshal
      end
      class PrintDynamicElement
        include ByteCodeCommon::PrintDynamicElementMarshal
      end
      class Loop
        include ByteCodeCommon::LoopMarshal
      end
      class SelectByType
        include ByteCodeCommon::SelectByTypeMarshal
      end
    end
  end
end

module Amrita
  def Amrita::replace_module(modname)
    remove_const(modname)
    const_set(modname, AmritaAccelerator.const_get(modname))
  end

  if Object::const_defined? :AmritaAccelerator
    STDERR.puts 'installing amrita accelerator to Amrita' if $VERVOSE

    AmritaAccelerator::ByteCode.extend Amrita

    Amrita::ByteCode.constants.each do |name|
      c = Amrita::ByteCode::const_get(name)
      next unless c.kind_of?(Class)
      next unless c.ancestors.include?(Amrita::ByteCode::Instruction)
      unless AmritaAccelerator::ByteCode.const_defined?(name)
        puts "borrow #{c} for AmritaAccelerator" if $VERVOSE
        AmritaAccelerator::ByteCode::const_set(name, c) 
      end
    end
    replace_module :Attr
    replace_module :AttrArray
    replace_module :Element
    replace_module :ElementProcessor

    replace_module :ByteCode

    ByteCodeCommon::SimpleSpanSupport::Methods.unshift [AmritaAccelerator::AttrArray, :do_attrarray]
  end
end

