
require 'amrita/node'
include Amrita::Sanitizer # use sanitizer of amrita

load 'make_data.rb'

def doit
  print <<END
<html>
<head>
<title>#{sanitize_text($data[:title])}</title>
</head>
<body>
<h1>#{sanitize_text($data[:title])}</h1>
<table border="1">
  <tr><th>name</th><th>author</th><th>webpage</tr>
END

  $data[:table].each do |items|
    print <<-END
    <tr>
      <td>#{sanitize_text(items[:name])}</td>
    <td>#{sanitize_text(items[:author])}</td>
    END

    if items[:webpage_name] and items[:webpage_name] != ""
      if items[:url] and items[:url] != ""
        print %Q[<td><a href="#{sanitize_url(items[:url])}">#{sanitize_text(items[:webpage_name])}</a></td>]
      else
        print %Q[<td>#{sanitize_text(items[:webpage_name])}</td>]
      end
    end
    puts "</tr>"
  end

  print <<END
</table>
</body>
</html>
END
end

def doit_no_sanitize
  print <<END
<html>
<head>
<title>#{$data[:title]}</title>
</head>
<body>
<h1>#{$data[:title]}</h1>
<table border="1">
  <tr><th>name</th><th>author</th><th>webpage</tr>
END

  $data[:table].each do |items|
    print <<-END
    <tr>
      <td>#{items[:name]}</td>
      <td>#{items[:author]}</td>
    END

    if items[:webpage_name] and items[:webpage_name] != ""
      if items[:url] and items[:url] != ""
        print %Q[<td><a href="#{items[:url]}">#{items[:webpage_name]}</a></td>]
      else
        print %Q[<td>#{items[:webpage_name]}</td>]
      end
    end
    puts "</tr>"
  end

  print <<END
</table>
</body>
</html>
END
end

# Which one do you think fair ?

$cnt.times { doit }
#$cnt.times { doit_no_sanitize }
