require "amrita/template"
include Amrita

TEMPLATE_TEXT = <<END
<html>
<span id=head></span>
<body>
<span id=contents></span>
<hr>
<span id=foottext></span>
</body>
</html>
END

PARTS_TEMPLATE_TEXT = <<END
<h1 id="h1" name="@anchor">@{title}</h1>

<span id="h2">
<hr>
<h2 name="@anchor">@{title}</h2>
</span>
<h3 id="h3" name="@anchor">@{title}</h3>
<h4 id="h4" name="@anchor">@{title}</h4>
<h5 id="h5" name="@anchor">@{title}</h5>
<h6 id="h6" name="@anchor">@{title}</h6>

<p id=textblock>@{content}</p>

<ul id=unorderedlist>
  <li id=items>@{content}</li>
</ul>

<ol id=orderedlist>
  <li id=items>@{content}</li>
</ol>

<dl id=desclist>
   <span id=items>
     <dt id=term>
     <dd id=description>
   </span>
</dl>

<em id=em></em>
<code id=code></code>
<var id=var></var>
<kbd id=kbd></kbd>

<span id=refwithurl><a href="@url">@{content}</a></span>

<span id="footnote">
  <a name="footmark:@{num}" href="#foottext:@{num}"><sup><small>*@{num}</small></sup></a>
</span>

<span id="foottext">
  <a name="foottext:@{seq}"><span  id="seq"></span></a>
  <p class="foottext">@{content}</p>
</span>

<span id=RAA>
  <a href="http://www.ruby-lang.org/en/raa-list.rhtml?name=@{name}">@{content}</a>
</span>

<span id=AMRITA>
  <a href="http://www.walrus-ruby.org/aswiki/?c=v;p=@{name}">@{content}</a>
</span>

<span id=CLASS>
  <a href="http://www.brain-tokyo.jp/research/amrita/rdocs/classes/Amrita/@{name}.html">@{content}</a>
</span>

<span id=AMRITADOC>
  <a href="docs/html/files/@{name}.html">@{content}</a>
</span>

<span id=AMRITADOC2>
  <a href="docs/html/rdocs/files/docs/@{name}.html">@{content}</a>
</span>

<span id=TARBALL>
  <a href="http://www.brain-tokyo.jp/research/amrita/@{name}-@{ver}.tar.gz">@{name}-@{ver}.tar.gz</a>
  (<a href="http://www.walrus-ruby.org/amrita/home/@{name}-@{ver}.tar.gz">mirror</a>)
</span>

END
AMULET_IDS=%w(h1 h2 h3 h4 h5 h6 textblock unorderedlist orderedlist desclist em code var kbd  refwithurl footnote foottext RAA AMRITA CLASS TARBALL).collect { |w| w.intern }

require "cgi"
require "rd/rdvisitor"
require "rd/version"

module RD
  class RD2HTMLAmritaVisitor < RDVisitor
    include Amrita
    include MethodParse

    # must-have constants
    OUTPUT_SUFFIX = "html"
    INCLUDE_SUFFIX = ["html"]
    
    METACHAR = { "<" => "&lt;", ">" => "&gt;", "&" => "&amp;" }

    attr(:css, true)
    attr(:charset, true)
    alias charcode charset
    alias charcode= charset=
    attr(:lang, true)
    attr(:title, true)
    attr(:html_link_rel, nil)
    attr(:html_link_rev, nil)
    attr(:use_old_anchor, true)
    # output external Label file.
    attr(:output_rbl, true)

    attr_reader :footnotes
    attr_reader :foottexts

    attr_reader :template, :pt

    def initialize
      @css = nil
      @charset = nil
      @lang = nil
      @title = nil
      @html_link_rel = {}
      @html_link_rev = {}

      @footnotes = []
      @index = {}

      #      @use_old_anchor = nil
      @use_old_anchor = true # MUST -> nil
      @output_rbl = nil
      super
    end
    
    def visit(tree)
      @template = TemplateText.new TEMPLATE_TEXT
      #@template.escaped_id = '__id'
      @pt = TemplateText.new PARTS_TEMPLATE_TEXT
      #@pt.define_amulet(*AMULET_IDS)
      @pt.define_amulet_all
      prepare_labels(tree, "label:")
      prepare_footnotes(tree)
      tmp = super(tree)
      make_rbl_file(@filename) if @output_rbl and @filename
      tmp
    end

    def apply_to_DocumentElement(element, content)
      ret = ""
      ft = make_foottext
      template.expand(ret,
               :head=>html_head,
               :contents=>content,
               :foottext=>ft
               )
      ret
    end

    def document_title
      return @title if @title
      return @filename if @filename
      return ARGF.filename if ARGF.filename != "-"
      "Untitled"
    end
    private :document_title

    def html_head
      e(:head) { html_title + link_to_css }
    end 
    private :html_head

    def html_title
      e(:title) { document_title }
    end
    private :html_title

    def html_content_type
      if @charset
        e(:meta, "http-equiv".intern=>"Content-type",
          :content=>"text/html; charset=#{@charset}")
      end
    end
    private :html_content_type

    def link_to_css
      if @css
        e(:link, :href=>@css, :type=>"text/css", :rel=>"stylesheet")
      end
    end
    private :link_to_css

    def html_body(contents)
      content = contents.join("\n")
      foottext = make_foottext
      %Q|<body>\n#{content}\n#{foottext}\n</body>|
    end
    private :html_body
    
    def apply_to_Headline(element, title)
      anchor = get_anchor(element)
      label = hyphen_escape(element.label)
      #%Q[<h#{element.level}><a name="#{anchor}" id="#{anchor}">#{title}</a>] +
      #%Q[</h#{element.level}><!-- RDLabel: "#{label}" -->]
      tag = "h#{element.level}"
      pt.create_amulet(tag.intern, :anchor=>anchor, :title=>title)
    end

    # RDVisitor#apply_to_Include 

    def apply_to_TextBlock(element, content)
      if (is_this_textblock_only_one_block_of_parent_listitem?(element) or
	  is_this_textblock_only_one_block_other_than_sublists_in_parent_listitem?(element))
	content
      else
        pt[:textblock][:content=>content]
      end
    end

    def is_this_textblock_only_one_block_of_parent_listitem?(element)
      (element.parent.is_a?(ItemListItem) or
       element.parent.is_a?(EnumListItem)) and
	consist_of_one_textblock?(element.parent)
    end

    def is_this_textblock_only_one_block_other_than_sublists_in_parent_listitem?(element)
      (element.parent.is_a?(ItemListItem) or
       element.parent.is_a?(EnumListItem)) and
	consist_of_one_textblock_and_sublists(element.parent)
    end

    def consist_of_one_textblock_and_sublists(element)
      i = 0
      element.each_child do |child|
	if i == 0
	  return false unless child.is_a?(TextBlock)
	else
	  return false unless child.is_a?(List)
	end
	i += 1
      end
      return true
    end

    def apply_to_Verbatim(element)
      content = []
      element.each_line do |i|
	content.push(apply_to_String(i))
      end
      SanitizedString[%Q[<pre>#{content.join("").chomp}</pre>]]
    end
  
    def apply_to_ItemList(element, items)
      items.collect! {|x| { :content=>x.flatten  } }
      pt[:unorderedlist][:items=>items]
    end
  
    def apply_to_EnumList(element, items)
      items.collect! {|x| { :content=>x.flatten  } }
      pt[:orderedlist][:items=>items]
    end
    
    def apply_to_DescList(element, items)
      pt[:desclist][:items=>items]
    end

    def apply_to_MethodList(element, items)
      raise "not implemented"
      %Q[<dl>\n#{items.join("\n").chomp}\n</dl>]
    end
    
    def apply_to_ItemListItem(element, content)
      content
    end
    
    def apply_to_EnumListItem(element, content)
      content
    end

    def consist_of_one_textblock?(listitem)
      listitem.content.size == 1 and listitem.content[0].is_a?(TextBlock)
    end
    private :consist_of_one_textblock?
    
    def apply_to_DescListItem(element, term, description)
      anchor = get_anchor(element.term)
      label = hyphen_escape(element.label)
      {
        :anchor=>anchor,
        :term=>term,
        :description=>description.empty? ? nil : description
      }
    end

    def apply_to_MethodListItem(element, term, description)
      raise "not implemented"
      term = parse_method(term)  # maybe: term -> element.term
      anchor = get_anchor(element.term)
      label = hyphen_escape(element.label)
      if description.empty?
	%Q[<dt><a name="#{anchor}" id="#{anchor}"><code>#{term}] +
        %Q[</code></a></dt><!-- RDLabel: "#{label}" -->]
      else
        %Q[<dt><a name="#{anchor}" id="#{anchor}"><code>#{term}] +
	%Q[</code></a></dt><!-- RDLabel: "#{label}" -->\n] +
	%Q[<dd>\n#{description.join("\n")}</dd>]
      end
    end
  
    def apply_to_StringElement(element)
      apply_to_String(element.content)
    end
    
    def apply_to_Emphasis(element, content)
      pt[:em][content]
    end
  
    def apply_to_Code(element, content)
      pt[:code][content]
    end
  
    def apply_to_Var(element, content)
      pt[:var][content]
    end
  
    def apply_to_Keyboard(element, content)
      pt[:kbd][content]
    end

    def apply_to_Index(element, content)
      eval(content.to_s)
    end
  
    def apply_to_Reference(element, content)
    end


    def apply_to_Reference_with_RDLabel(element, content)
      if element.label.filename
	apply_to_RefToOtherFile(element, content)
      else
	apply_to_RefToElement(element, content)
      end
    end

    def apply_to_Reference_with_URL(element, content)
      #%Q[<a href="#{meta_char_escape(element.label.url)}">] +
      #		%Q[#{content.join("")}</a>]
      pt[:refwithurl][:url=>element.label.url, :content=>content]
    end

    def apply_to_RefToElement(element, content)
      label = case element
      when RDElement
        element.to_label
      else
        element
      end
      if label =~ /(\w+):(\w+)/
        ext_type, name = $1, $2
        pt[ext_type.intern][:name=>name, :content=>content]
      else
        content
      end
    end

    def apply_to_RefToOtherFile(element, content)
      content = content.join("")
      filename = element.label.filename.sub(/\.(rd|rb)(\.\w+)?$/, "." +
					    OUTPUT_SUFFIX)
      anchor = refer_external(element)
      if anchor
	%Q[<a href="#{filename}\##{anchor}">#{content}</a>]
      else
	%Q[<a href="#{filename}">#{content}</a>]
      end
    end
    
    def apply_to_Footnote(element, content)
      num = get_footnote_num(element)
      raise ArgumentError, "[BUG?] #{element} is not registered." unless num
      
      add_foottext(num, content)
      #%Q|<a name="footmark:#{num}" id="footmark:#{num}" | +
      #%Q|href="#foottext:#{num}"><sup><small>| +
      #%Q|*#{num}</small></sup></a>|
      pt[:footnote][:num => num]
    end

    def get_footnote_num(fn)
      raise ArgumentError, "#{fn} must be Footnote." unless fn.is_a? Footnote
      i = @footnotes.index(fn)
      if i
	i + 1
      else
	nil
      end
    end

    def prepare_footnotes(tree)
      @footnotes = tree.find_all{|i| i.is_a? Footnote }
      @foottexts = []
    end
    private :prepare_footnotes

    def apply_to_Foottext(element, content)
      num = get_footnote_num(element)
      raise ArgumentError, "[BUG] #{element} isn't registered." unless num
      #%|<a name="foottext:#{num}" id="foottext:#{num}" href="#footmark:#{num}">|+
      #	%|<sup><small>*#{num}</small></sup></a>| +
      # %|<small>#{content}</small><br />|
      pt[:footnote][:seq => num]
    end

    def add_foottext(num, foottext)
      raise ArgumentError, "[BUG] footnote ##{num} isn't here." unless
	footnotes[num - 1]
      @foottexts[num - 1] = foottext
    end
    
    def apply_to_Verb(element)
      content = apply_to_String(element.content)
      %Q[#{content}]
    end

    def sp2nbsp(str)
      str.gsub(/\s/, "&nbsp;")
    end
    private :sp2nbsp
    
    def apply_to_String(element)
      element
    end
    
    def parse_method(method)
      klass, kind, method, args = MethodParse.analize_method(method)
      
      if kind == :function
	klass = kind = nil
      else
	kind = MethodParse.kind2str(kind)
      end
      
      args.gsub!(/&?\w+;?/){ |m|
	if /&\w+;/ =~ m then m else '<var>'+m+'</var>' end }

      case method
      when "self"
	klass, kind, method, args = MethodParse.analize_method(args)
	"#{klass}#{kind}<var>self</var> #{method}#{args}"
      when "[]"
	args.strip!
	args.sub!(/^\((.*)\)$/, '\\1')
	"#{klass}#{kind}[#{args}]"
      when "[]="
	args.tr!(' ', '')
	args.sub!(/^\((.*)\)$/, '\\1')
	ary = args.split(/,/)

	case ary.length
	when 1
	  val = '<var>val</var>'
	when 2
	  args, val = *ary
	when 3
	  args, val = ary[0, 2].join(', '), ary[2]
	end

	"#{klass}#{kind}[#{args}] = #{val}"
      else
	"#{klass}#{kind}#{method}#{args}"
      end
    end
    private :parse_method

    def meta_char_escape(str)
      str.gsub(/[<>&]/) {
	METACHAR[$&]
      }
    end
    private :meta_char_escape

    def hyphen_escape(str)
      str.gsub(/--/, "&shy;&shy;")
    end
    
    def make_foottext
      return nil if foottexts.empty?

      data = []
      foottexts.each_with_index do |ft, num|
        data << {
          :seq => num+1,
          :content=>ft.to_s
        }
      end
      pt[:foottext][data]
    end
    private :make_foottext
    
  end # RD2HTMLAmritaVisitor
end # RD


$Visitor_Class = RD::RD2HTMLAmritaVisitor
$RD2_Sub_OptionParser = "rd/rd2html-opt"
