require 'test/unit'
require 'amrita/template'
require 'amrita/testsupport'

class TestAmulet < Test::Unit::TestCase
  include Amrita

  def test_amulet1
    t = TemplateText.new '<xx><yy id=aaa><zz id=bbb></zz></yy></xx>'
    #t.debug_compiler = true
    t.define_amulet(:aaa)
    assert_equal_node(e(:xx) { e(:span, :id=>'aaa') }, t.template)
    assert_equal(AmuletSeed, t[:aaa].class)
    assert_equal_node(e(:yy,:id=>"aaa") { e(:zz,:id=>"bbb")  }, t[:aaa].element)
    assert_equal(InstructionSet, t[:aaa].iset.class)
    data = { :aaa=>t[:aaa][ { :bbb=>'aaa'} ] }
    result = ""
    t.expand(result, data)
    assert_equal('<xx><yy><zz>aaa</zz></yy></xx>', result)

    result = ""
    data = { :aaa=>t[:aaa]['xxx'] }
    t.expand(result, data)
    assert_equal('<xx><yy>xxx</yy></xx>', result)
  end

  def test_amulet2
    t = TemplateText.new '<span id=pre></span><xx><yy id=aaa><zz id=bbb></zz></yy></xx><span id=post></span>'
    t.define_amulet(:aaa)
    assert_equal_node(Node::to_node([ e(:span,:id=>"pre") , e(:xx) { e(:span,:id=>"aaa")  }, e(:span,:id=>"post")  ]),
                      t.template)
    assert_equal(AmuletSeed, t[:aaa].class)
    data = { :aaa=>t[:aaa][ { :bbb=>'aaa'} ] ,
      :pre=>111, :post=>999
    }
    result = ""
    #t.debug_compiler = true
    t.expand(result, data)
    assert_equal('111<xx><yy><zz>aaa</zz></yy></xx>999', result)
  end

  def test_amulet3 # from aswiki
    pt = TemplateText.new '<span id=Plaintext>+<span id=data></span>+</span>'

    #t.debug_compiler = true
    pt.define_amulet(:Plaintext)
    data = pt[:Plaintext] [ [ { :data=>%w(a b c) } ] ]
    result = ""
    t = TemplateText.new '*<span id="a"></span>*'
    t.expand(result, :a=>data)
    assert_equal('*+abc+*', result)
    
    d1 = pt[:Plaintext] [ [ { :data=>%w(x y z) } ] ]
    d2 = pt[:Plaintext] [ [ { :data=>['a', d1, 'b'] } ] ]
    result = ""
    t = TemplateText.new '*<span id="a"></span>*'
    t.expand(result, :a=>d2)
    assert_equal('*+a+xyz+b+*', result)

    pt = TemplateText.new <<-END
       <span id="H2">
       <h2><span id="data"><a name="@number"></a><span id="text">header</span></span></h2>
       </span>
    END
    #t.debug_compiler = true
    pt.define_amulet(:H2)
    data = pt[:H2] [ { :data=>{ :number=>1, :text=>"abc" } } ]
    result = ""
    t = TemplateText.new '*<span id="a"></span>*'
    t.expand(result, :a=>data)
    assert_equal_node('*<h2><a name="1"></a>abc</h2>*', result)
  end


  def test_amuletarray
    t = TemplateText.new '<xx><yy id=aaa><zz id=bbb></zz></yy></xx>'
    t.define_amulet(:aaa)
    assert_equal_node(e(:xx) { e(:span, :id=>'aaa') }, t.template)
    assert_equal(AmuletSeed, t[:aaa].class)
    data = { :aaa=>[
        t.create_amulet(:aaa, :bbb=>'aaa'),
        t[:aaa][ { :bbb=>'bbb'} ]
      ]
    }
    result = ""
    #t.debug_compiler = true
    t.expand(result, data)
    assert_equal('<xx><yy><zz>aaa</zz></yy><yy><zz>bbb</zz></yy></xx>', result)
  end

  def test_amulet_marshal
    return if RUBY_VERSION > "1.8" # marshal is not supported now with 1.8
    unless Amrita::accelerator_loaded?
      STDERR.puts 'pass test_amulet_marshal'
      return
    end

    t = TemplateText.new '<xx><yy id=aaa><zz id=bbb></zz></yy></xx>'
    #t.debug_compiler = true
    t.define_amulet(:aaa)
    assert_equal_node(e(:xx) { e(:span, :id=>'aaa') }, t.template)
    assert_equal(AmuletSeed, t[:aaa].class)
    assert_equal_node(e(:yy,:id=>"aaa") { e(:zz,:id=>"bbb")  }, t[:aaa].element)
    assert_equal(InstructionSet, t[:aaa].iset.class)
    data = { :aaa=>t[:aaa][ { :bbb=>'aaa'} ] }
    result = ""
    t.expand(result, data)
    assert_equal('<xx><yy><zz>aaa</zz></yy></xx>', result)

    result = ""
    data = { :aaa=>t[:aaa]['xxx'] }
    t.expand(result, data)
    assert_equal('<xx><yy>xxx</yy></xx>', result)

    t =  Marshal::load(Marshal::dump(t))
    data = { :aaa=>t[:aaa][ { :bbb=>'aaa'} ] }
    result = ""
    t.expand(result, data)
    assert_equal('<xx><yy><zz>aaa</zz></yy></xx>', result)

    result = ""
    data = { :aaa=>t[:aaa]['xxx'] }
    t.expand(result, data)
    assert_equal('<xx><yy>xxx</yy></xx>', result)
  end
end

#--- main program ----
if __FILE__ == $0
  require 'test/unit/ui/console/testrunner'

  if ARGV.size == 0
    Test::Unit::UI::Console::TestRunner.run(TestAmulet)
    require 'amrita/accel'
    Test::Unit::UI::Console::TestRunner.run(TestAmulet)
  else
    require 'amrita/accel'
    ARGV.each do |method|
      Test::Unit::UI::Console::TestRunner.run(TestAmulet.new(method))
    end
  end
end

