from Products.CMFCore.utils import getToolByName,manage_addTool

from Products.SimpleJournal.config import ELEMENTS

# カスタムインストール
def install(self):
    res = ''
    
    # setup metadata
    metadata_tool = getToolByName(self, 'portal_metadata')
    for element in ELEMENTS:
        name=element['name']
        vocabulary=element['vocabulary']
        try:
            metadata_tool.addElementSpec(
                element=name,
                is_multi_valued=0,
                REQUEST=None,
                )
            metadata_tool.updateElementPolicy(
                element=name,
                content_type='',
                is_required=0,
                supply_default=0,
                default_value='',
                enforce_vocabulary=0,
                allowed_vocabulary=vocabulary,
                REQUEST=None,
                )    
        except: pass
                
    # register the folderish items in portal_properties/site_properties for folder-contents views etc
    navtree_props = getToolByName(self, 'portal_properties').navtree_properties
    not_to_list = navtree_props.getProperty('metaTypesNotToList')
    if not 'Buy' in not_to_list:
        navtree_props._updateProperty('metaTypesNotToList', tuple(not_to_list) + ('Buy','Brought',))
    
    return res

# カスタムアンインストール
def uninstall(self):
    res = ''
    # delete metadata
    metadata_tool = getToolByName(self, 'portal_metadata')
    for element in ELEMENTS:
        name=element['name']
        try:
            metadata_tool.removeElementSpec(
                element=name,
                REQUEST=None,
                )  
        except:
            pass
        
    return res