/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class Food
extends Obj
implements Serializable {
    static final long serialVersionUID = 2L;
    public static final int FOOD_EMPTY = 0;
    public static final int FOOD_NOT_EMPTY_NORMAL = 1;
    public static final int FOOD_NOT_EMPTY_BITTER = 2;
    public static final int FOOD_NOT_EMPTY_LEMON = 3;
    public static final int FOOD_NOT_EMPTY_HOT = 4;
    public static final int FOOD_SHADOW = 5;
    public static final int NUM_OF_FOOD_STATE = 6;
    private type foodType;
    private int amount;
    private static final int foodSize = 64;
    private static Image[] images = new Image[6];

    public static void loadImages(ClassLoader loader) throws IOException {
        String path = "images/";
        Food.images[0] = ImageIO.read(loader.getResourceAsStream("images/gohan1.png"));
        Food.images[1] = ImageIO.read(loader.getResourceAsStream("images/gohan2.png"));
        Food.images[2] = ImageIO.read(loader.getResourceAsStream("images/gohan3.png"));
        Food.images[3] = ImageIO.read(loader.getResourceAsStream("images/gohan4.png"));
        Food.images[4] = ImageIO.read(loader.getResourceAsStream("images/gohan5.png"));
        Food.images[5] = ImageIO.read(loader.getResourceAsStream("images/gohan-shadow.png"));
        int i = 0;
        while (i < 6) {
            Food.images[i] = images[i].getScaledInstance(64, 32, 16);
            ++i;
        }
    }

    public Image getImage() {
        if (this.isEmpty()) {
            return images[0];
        }
        if (this.foodType == type.YUKKURIFOOD) {
            return images[1];
        }
        if (this.foodType == type.BITTER) {
            return images[2];
        }
        if (this.foodType == type.LEMONPOP) {
            return images[3];
        }
        if (this.foodType == type.HOT) {
            return images[4];
        }
        return images[1];
    }

    public Image getShadowImage() {
        return images[5];
    }

    public int getSize() {
        return 64;
    }

    public static int getSizeS() {
        return 64;
    }

    public Food(int initX, int initY, type initType) {
        this.objType = Obj.Type.FOOD;
        this.x = initX;
        this.y = initY;
        this.z = 0;
        this.foodType = initType;
        switch (initType) {
            case YUKKURIFOOD: {
                this.amount = 57600;
                break;
            }
            case BITTER: {
                this.amount = 57600;
                break;
            }
            default: {
                this.amount = 57600;
            }
        }
        this.removed = false;
    }

    public type getFoodType() {
        return this.foodType;
    }

    public boolean isEmpty() {
        return this.amount == 0;
    }

    public int getAmount() {
        return this.amount;
    }

    public void eatFood(int eatAmount) {
        if (this.isEmpty()) {
            return;
        }
        this.amount -= eatAmount;
        if (this.amount < 0) {
            this.amount = 0;
        }
    }

    @Override
    public Obj.Event clockTick() {
        if (this.removed) {
            return Obj.Event.REMOVED;
        }
        if (!this.grabbed && this.z > 0) {
            this.z -= 2;
            if (this.z <= 0) {
                this.z = 0;
            }
        }
        if (this.foodType == type.SELFFEEDER) {
            this.amount = 3600;
        }
        return Obj.Event.DONOTHING;
    }

    public static enum type {
        SHIT,
        YUKKURIFOOD,
        BITTER,
        SELFFEEDER,
        LEMONPOP,
        HOT,
        BODY;

    }
}

