/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class Food
extends Obj
implements Serializable {
    static final long serialVersionUID = 2L;
    public static final int FOOD_EMPTY = 0;
    public static final int FOOD_NOT_EMPTY_NORMAL = 1;
    public static final int FOOD_NOT_EMPTY_BITTER = 2;
    public static final int FOOD_NOT_EMPTY_LEMON = 3;
    public static final int FOOD_NOT_EMPTY_HOT = 4;
    public static final int FOOD_NOT_EMPTY_VIYUGRA = 5;
    public static final int FOOD_SHADOW = 6;
    public static final int NUM_OF_FOOD_STATE = 7;
    private type foodType;
    private int amount;
    private static final int foodSize = 64;
    private static final int[] value = new int[]{-100, 250, 250, 10000, 400, 400, 650, -100};
    private static Image[] images = new Image[7];

    public static void loadImages(ClassLoader loader) throws IOException {
        String path = "images/";
        Food.images[0] = ImageIO.read(loader.getResourceAsStream("images/gohan1.png"));
        Food.images[1] = ImageIO.read(loader.getResourceAsStream("images/gohan2.png"));
        Food.images[2] = ImageIO.read(loader.getResourceAsStream("images/gohan3.png"));
        Food.images[3] = ImageIO.read(loader.getResourceAsStream("images/gohan4.png"));
        Food.images[4] = ImageIO.read(loader.getResourceAsStream("images/gohan5.png"));
        Food.images[5] = ImageIO.read(loader.getResourceAsStream("images/gohan6.png"));
        Food.images[6] = ImageIO.read(loader.getResourceAsStream("images/gohan-shadow.png"));
        int i = 0;
        while (i < 7) {
            Food.images[i] = images[i].getScaledInstance(64, 32, 16);
            ++i;
        }
    }

    public Image getImage() {
        if (this.isEmpty()) {
            return images[0];
        }
        switch (this.foodType) {
            default: {
                return images[1];
            }
            case BITTER: {
                return images[2];
            }
            case LEMONPOP: {
                return images[3];
            }
            case HOT: {
                return images[4];
            }
            case VIYUGRA: 
        }
        return images[5];
    }

    public Image getShadowImage() {
        return images[6];
    }

    @Override
    public int getSize() {
        return 64;
    }

    public static int getSizeS() {
        return 64;
    }

    @Override
    public int getValue() {
        return value[this.foodType.ordinal()];
    }

    public Food(int initX, int initY, type initType) {
        this.objType = Obj.Type.FOOD;
        this.x = initX;
        this.y = initY;
        this.z = 0;
        this.foodType = initType;
        switch (initType) {
            case YUKKURIFOOD: {
                this.amount = 57600;
                break;
            }
            case BITTER: {
                this.amount = 57600;
                break;
            }
            default: {
                this.amount = 57600;
            }
        }
        this.removed = false;
    }

    public type getFoodType() {
        return this.foodType;
    }

    public boolean isEmpty() {
        return this.amount == 0;
    }

    public int getAmount() {
        return this.amount;
    }

    public void eatFood(int eatAmount) {
        if (this.isEmpty()) {
            return;
        }
        if (this.foodType == type.SELFFEEDER) {
            return;
        }
        this.amount -= eatAmount;
        if (this.amount < 0) {
            this.amount = 0;
        }
    }

    @Override
    public void kick() {
        this.kick(0, -8, -4);
    }

    public static enum type {
        SHIT,
        YUKKURIFOOD,
        BITTER,
        SELFFEEDER,
        LEMONPOP,
        HOT,
        VIYUGRA,
        BODY;

    }
}

