/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Terrarium {
    public static final int MAX_X = 300;
    public static final int MAX_Y = 300;
    public static final int MAX_Z = 100;
    public static ArrayList<Body> bodyList = new ArrayList();
    public static ArrayList<Food> foodList = new ArrayList();
    public static ArrayList<Shit> shitList = new ArrayList();
    public static ArrayList<Toilet> toiletList = new ArrayList();
    public static ArrayList<Toy> toyList = new ArrayList();
    public static ArrayList<Barrier> barrierList = new ArrayList();
    public static int operationTime = 0;
    public static final int TICK = 1;
    private static int[][] map = new int[301][301];
    private static Random rnd = new Random();
    private static int alarmPeriod = 0;
    private static boolean alarm = false;
    private static ArrayList<Body> babyList = new ArrayList();
    private static final int ALARM_PERIOD = 300;

    public static void saveState(File file) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            out.writeUTF(Terrarium.class.getCanonicalName());
            out.writeInt(alarmPeriod);
            out.writeBoolean(alarm);
            out.writeObject(rnd);
            out.writeObject(bodyList);
            out.writeObject(foodList);
            out.writeObject(shitList);
            out.writeObject(toiletList);
            out.writeObject(toyList);
            out.writeObject(barrierList);
            out.writeObject(Beltconveyor.objEXList);
            out.writeObject(BreedingPool.objEXList);
            out.writeObject(GarbageChute.objEXList);
            out.writeObject(FoodMaker.objEXList);
            out.writeObject(OrangePool.objEXList);
            out.writeObject(ProductChute.objEXList);
            out.writeObject(MachinePress.objEXList);
            out.writeObject(map);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public static void loadState(File file) throws IOException, ClassNotFoundException {
        int[][] map;
        ArrayList machinePressList;
        ArrayList productChuteList;
        ArrayList orangePoolList;
        ArrayList foodMakerList;
        ArrayList garbageChuteList;
        ArrayList breedingPoolList;
        ArrayList beltconveyorList;
        ArrayList barrierList;
        ArrayList toyList;
        ArrayList toiletList;
        ArrayList shitList;
        ArrayList foodList;
        ArrayList bodyList;
        Random rnd;
        boolean alarm;
        int alarmPeriod;
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            String s = in.readUTF();
            if (!Terrarium.class.getCanonicalName().equals(s)) {
                String errMsg = "Bad save: " + s;
                throw new IOException(errMsg);
            }
            alarmPeriod = in.readInt();
            alarm = in.readBoolean();
            rnd = (Random)in.readObject();
            bodyList = (ArrayList)in.readObject();
            foodList = (ArrayList)in.readObject();
            shitList = (ArrayList)in.readObject();
            toiletList = (ArrayList)in.readObject();
            toyList = (ArrayList)in.readObject();
            barrierList = (ArrayList)in.readObject();
            beltconveyorList = (ArrayList)in.readObject();
            breedingPoolList = (ArrayList)in.readObject();
            garbageChuteList = (ArrayList)in.readObject();
            foodMakerList = (ArrayList)in.readObject();
            orangePoolList = (ArrayList)in.readObject();
            productChuteList = (ArrayList)in.readObject();
            machinePressList = (ArrayList)in.readObject();
            map = (int[][])in.readObject();
        }
        finally {
            in.close();
        }
        Terrarium.rnd = rnd;
        Terrarium.alarmPeriod = alarmPeriod;
        Terrarium.alarm = alarm;
        Terrarium.bodyList = bodyList;
        Terrarium.foodList = foodList;
        Terrarium.shitList = shitList;
        Terrarium.toiletList = toiletList;
        Terrarium.toyList = toyList;
        Terrarium.barrierList = barrierList;
        Beltconveyor.objEXList = beltconveyorList;
        BreedingPool.objEXList = breedingPoolList;
        GarbageChute.objEXList = garbageChuteList;
        FoodMaker.objEXList = foodMakerList;
        OrangePool.objEXList = orangePoolList;
        ProductChute.objEXList = productChuteList;
        MachinePress.objEXList = machinePressList;
        Terrarium.map = map;
    }

    public static List<Obj> getObjList() {
        ArrayList<Obj> objList = new ArrayList<Obj>();
        objList.addAll(bodyList);
        objList.addAll(shitList);
        objList.addAll(foodList);
        objList.addAll(toyList);
        return objList;
    }

    public static List<ObjEX> getPlatformList() {
        ArrayList<ObjEX> objList = new ArrayList<ObjEX>();
        objList.addAll(Beltconveyor.objEXList);
        objList.addAll(BreedingPool.objEXList);
        objList.addAll(GarbageChute.objEXList);
        objList.addAll(FoodMaker.objEXList);
        objList.addAll(OrangePool.objEXList);
        objList.addAll(ProductChute.objEXList);
        return objList;
    }

    public static List<ObjEX> getFixObjList() {
        ArrayList<ObjEX> objList = new ArrayList<ObjEX>();
        objList.addAll(MachinePress.objEXList);
        return objList;
    }

    private static void setLine(int x1, int y1, int x2, int y2, boolean setFlag) {
        int distance = (int)Math.sqrt(Terrarium.distance(x1, y1, x2, y2));
        double deltaX = (double)(x2 - x1) / (double)distance;
        double deltaY = (double)(y2 - y1) / (double)distance;
        int sX = x1;
        int sY = y1;
        int t = 0;
        while (t <= distance) {
            int x = sX + (int)(deltaX * (double)t);
            int y = sY + (int)(deltaY * (double)t);
            Terrarium.setPoint(x, y, setFlag);
            Terrarium.setPoint(Math.min(x + 1, 300), y, setFlag);
            Terrarium.setPoint(x, Math.min(y + 1, 300), setFlag);
            ++t;
        }
    }

    private static void setPoint(int x, int y, boolean setFlag) {
        if (setFlag) {
            int[] nArray = map[x];
            int n = y;
            nArray[n] = nArray[n] + 1;
        } else {
            int[] nArray = map[x];
            int n = y;
            nArray[n] = nArray[n] - 1;
            if (map[x][y] < 0) {
                Terrarium.map[x][y] = 0;
            }
        }
    }

    public static void setBarrier(int x1, int y1, int x2, int y2) {
        x1 = Math.max(0, Math.min(x1, 300));
        x2 = Math.max(0, Math.min(x2, 300));
        y1 = Math.max(0, Math.min(y1, 300));
        y2 = Math.max(0, Math.min(y2, 300));
        Terrarium.setLine(x1, y1, x2, y2, true);
        barrierList.add(new Barrier(x1, y1, x2, y2));
    }

    public static void clearBarrier(Barrier b) {
        int x1 = b.getSX();
        int y1 = b.getSY();
        int x2 = b.getEX();
        int y2 = b.getEY();
        Terrarium.setLine(x1, y1, x2, y2, false);
        barrierList.remove(b);
    }

    public static ArrayList<Barrier> getBarriers() {
        return barrierList;
    }

    public static boolean onBarrier(int cx, int cy, int thx, int thy) {
        int sx = Math.max(0, cx - thx / 2);
        int sy = Math.max(0, cy - thy / 2);
        int ex = Math.min(cx + thx / 2, 300);
        int ey = Math.min(cy + thy / 2, 300);
        int x = sx;
        while (x < ex) {
            int y = sy;
            while (y < ey) {
                if (map[x][y] != 0) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    public static boolean onBarrier(int cx, int cy, int thickness) {
        return Terrarium.onBarrier(cx, cy, thickness, thickness);
    }

    public static Barrier getBarrier(int cx, int cy, int thickness) {
        for (Barrier b : barrierList) {
            int x1 = b.getSX();
            int y1 = b.getSY();
            int x2 = b.getEX();
            int y2 = b.getEY();
            int distance = (int)Math.sqrt(Terrarium.distance(x1, y1, x2, y2));
            double deltaX = (double)(x2 - x1) / (double)distance;
            double deltaY = (double)(y2 - y1) / (double)distance;
            int sX = x1;
            int sY = y1;
            int t = 0;
            while (t <= distance) {
                int x = sX + (int)(deltaX * (double)t);
                int y = sY + (int)(deltaY * (double)t);
                if (Math.abs(x - cx) <= thickness && Math.abs(y - cy) <= thickness) {
                    return b;
                }
                ++t;
            }
        }
        return null;
    }

    public static boolean acrossBarrier(int x1, int y1, int x2, int y2) {
        x1 = Math.max(0, Math.min(x1, 300));
        x2 = Math.max(0, Math.min(x2, 300));
        y1 = Math.max(0, Math.min(y1, 300));
        y2 = Math.max(0, Math.min(y2, 300));
        int distance = (int)Math.sqrt(Terrarium.distance(x1, y1, x2, y2));
        double deltaX = (double)(x2 - x1) / (double)distance;
        double deltaY = (double)(y2 - y1) / (double)distance;
        int sX = x1;
        int sY = y1;
        int t = 0;
        while (t <= distance) {
            int x = sX + (int)(deltaX * (double)t);
            int y = sY + (int)(deltaY * (double)t);
            if (map[x][y] != 0) {
                return true;
            }
            ++t;
        }
        return false;
    }

    private static int distance(int x1, int y1, int x2, int y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    private boolean checkPartner(Body b) {
        if (b.isDead() || b.isSleeping() || !b.isExciting() && !b.isRude() && b.wantToShit()) {
            return false;
        }
        boolean ret = false;
        Body found = null;
        int minDistance = b.getEyesight();
        if (b.isExciting() && b.partner != null && !b.partner.isDead() && !b.isRaper()) {
            found = b.partner;
            minDistance = Terrarium.distance(b.getX(), b.getY(), found.getX(), found.getY());
        } else {
            for (Body p : bodyList) {
                if (p == b || (!b.isExciting() ? p.isDead() && (!p.hasAccessory() || b.isIdiot()) : !b.isRaper() && (p.isDead() || !p.isAdult() || p.isChild(b) || p.isParent(b)))) continue;
                int dist = Terrarium.distance(b.getX(), b.getY(), p.getX(), p.getY());
                if (minDistance <= dist || !b.isRude() && Terrarium.acrossBarrier(b.getX(), b.getY(), p.getX(), p.getY())) continue;
                found = p;
                minDistance = dist;
            }
        }
        if (found != null) {
            if (minDistance <= Terrarium.distance(0, 0, b.getStep(), b.getStep())) {
                if (found.getZ() != 0) {
                    return false;
                }
                if (!found.isDead()) {
                    if (b.isExciting()) {
                        if (!b.isTalking()) {
                            b.doSukkiri(found);
                        }
                        ret = true;
                    } else if (!(found.hasAccessory() || !b.hasAccessory() || !b.isRude() && b.isMotherhood(found) || b.isDamaged())) {
                        if (!b.isTalking()) {
                            b.showHateYukkuri();
                            found.strike(b.getStrength());
                        }
                    } else if (b.isAdult() && !found.isAdult() && found.isDirty() && (found.isChild(b) || b.isMotherhood(found))) {
                        if (!b.isTalking()) {
                            b.doPeropero(found);
                        }
                    } else if (b.isParent(found) && !found.isAdult()) {
                        if (!b.isTalking()) {
                            b.doPeropero(found);
                        }
                    } else if (found.isPartner(b)) {
                        if (!b.isTalking()) {
                            b.doSurisuri(found);
                        }
                    } else if (!b.isAdult() && b.isSister(found) && !b.isTalking()) {
                        if (b.isElderSister(found)) {
                            b.doPeropero(found);
                        } else {
                            b.doSurisuri(found);
                        }
                    }
                } else if (b.isExciting()) {
                    if (!b.isTalking()) {
                        b.doSukkiri(found);
                    }
                    ret = true;
                } else if (b.isAdult()) {
                    if (!b.isTalking()) {
                        if (b.isParent(found)) {
                            b.showSadnessForChild();
                        } else if (b.isPartner(found)) {
                            b.showSadnessForPartner(found);
                        }
                    }
                } else if (b.isSister(found) && !b.isTalking()) {
                    b.showSadnessForSister(found);
                }
            } else if (!found.isDead()) {
                if (b.isExciting()) {
                    b.moveToSukkiri(found.getX(), found.getY());
                    ret = true;
                } else if (found.isRaper() && found.isExciting() && !b.isRaper()) {
                    b.runAway(found.getX(), found.getY());
                    if (!b.isTalking()) {
                        b.showScareRapist();
                    }
                } else if (!(found.hasAccessory() || !b.hasAccessory() || !b.isRude() && b.isMotherhood(found) || b.isDamaged())) {
                    if (rnd.nextInt(20) == 0) {
                        if (!b.isTalking()) {
                            b.showHateYukkuri();
                        }
                        b.moveTo(found.getX(), found.getY());
                    }
                } else if (b.isAdult() && !found.isAdult() && found.isDirty() && (found.isChild(b) || b.isMotherhood(found))) {
                    b.moveTo(found.getX(), found.getY());
                } else if (b.isChild(found) && !b.isAdult() && b.isDirty()) {
                    b.moveTo(found.getX(), found.getY());
                } else if (found.isPartner(b)) {
                    if (rnd.nextInt(100) == 0) {
                        b.moveTo(found.getX(), found.getY());
                    }
                } else if (!b.isAdult() && b.isSister(found) && rnd.nextInt(100) == 0) {
                    b.moveTo(found.getX(), found.getY());
                }
            } else if (b.isExciting()) {
                b.moveToSukkiri(found.getX(), found.getY());
                ret = true;
            } else if (rnd.nextInt(10) == 0) {
                if (b.isAdult()) {
                    if (b.isParent(found) || b.isPartner(found)) {
                        b.moveTo(found.getX(), found.getY());
                    } else {
                        b.lookTo(found.getX(), found.getY());
                    }
                } else if (b.isSister(found)) {
                    b.moveTo(found.getX(), found.getY());
                } else {
                    b.runAway(found.getX(), found.getY());
                }
                if (!b.isTalking()) {
                    b.showScare();
                }
            }
        }
        return ret;
    }

    private boolean checkFood(Body b) {
        int distance;
        boolean ret = false;
        if (b.isExciting() || b.isSleeping() || b.isDead() || b.isFull() || b.isScare() || b.isSick() || b.isFeelHardPain()) {
            return false;
        }
        if (!b.isRude() && !b.isIdiot() && b.wantToShit()) {
            return false;
        }
        Obj found = null;
        int minDistance = b.getEyesight();
        for (Food food : foodList) {
            if (food.isEmpty() || minDistance <= (distance = Terrarium.distance(b.getX(), b.getY(), food.getX(), food.getY())) || !b.isRude() && Terrarium.acrossBarrier(b.getX(), b.getY(), food.getX(), food.getY())) continue;
            found = food;
            minDistance = distance;
        }
        for (Shit shit : shitList) {
            if (!b.isTooHungry() && !b.isIdiot()) break;
            distance = Terrarium.distance(b.getX(), b.getY(), shit.getX(), shit.getY());
            if (minDistance <= distance || !b.isRude() && Terrarium.acrossBarrier(b.getX(), b.getY(), shit.getX(), shit.getY())) continue;
            found = shit;
            minDistance = distance;
        }
        for (Body body : bodyList) {
            if (b == body || !body.isDead() || body.hasAccessory() && !b.isIdiot() || minDistance <= (distance = Terrarium.distance(b.getX(), b.getY(), body.getX(), body.getY())) || !b.isRude() && Terrarium.acrossBarrier(b.getX(), b.getY(), body.getX(), body.getY())) continue;
            found = body;
            minDistance = distance;
        }
        if (found != null) {
            if (minDistance <= Terrarium.distance(0, 0, b.getStep(), b.getStep())) {
                if (found.getZ() != 0) {
                    return false;
                }
                if (!b.isTalking()) {
                    if (found instanceof Food) {
                        Obj obj = found;
                        b.eatFood(((Food)obj).getFoodType(), Math.min(b.getEatAmount(), ((Food)obj).getAmount()));
                        ((Food)obj).eatFood(Math.min(b.getEatAmount(), ((Food)obj).getAmount()));
                    } else if (found instanceof Shit) {
                        Shit shit = (Shit)found;
                        b.eatFood(Food.type.SHIT, b.getEatAmount());
                        shit.eatShit(b.getEatAmount());
                    } else if (found instanceof Body) {
                        Body body = (Body)found;
                        b.eatFood(Food.type.BODY, Math.min(b.getEatAmount(), body.getAmount()));
                        body.eatBody(Math.min(b.getEatAmount(), body.getAmount()));
                        if (body.isSick()) {
                            b.setSick();
                        }
                    }
                }
                ret = true;
            } else if (b.isHungry()) {
                if (!b.isTalking()) {
                    if (found instanceof Food) {
                        b.moveToFood(found.getX(), found.getY());
                    } else if (found instanceof Shit) {
                        b.moveToShit(found.getX(), found.getY());
                    } else if (found instanceof Body) {
                        b.moveToFood(found.getX(), found.getY());
                    }
                }
                ret = true;
            }
        } else if (b.isHungry() && !b.isTalking() && rnd.nextInt(10) == 0) {
            b.showNoFood();
        }
        return ret;
    }

    private boolean checkShit(Body b) {
        if (b.isDead() || b.isIdiot() || b.isSleeping() || b.isExciting()) {
            return false;
        }
        boolean ret = false;
        Obj found = null;
        int minDistance = b.getEyesight();
        for (Shit s : shitList) {
            int distance = Terrarium.distance(b.getX(), b.getY(), s.getX(), s.getY());
            if (minDistance <= distance || !b.isRude() && Terrarium.acrossBarrier(b.getX(), b.getY(), s.getX(), s.getY())) continue;
            found = s;
            minDistance = distance;
        }
        if (found != null) {
            if (found.getZ() != 0) {
                return false;
            }
            if (minDistance <= Terrarium.distance(0, 0, b.getStep(), b.getStep()) && !b.isTalking()) {
                b.showHateShit();
            }
        }
        return ret;
    }

    private boolean checkToilet(Body b) {
        if (b.isDead() || b.isIdiot() || b.isSleeping() || !b.wantToShit()) {
            return false;
        }
        boolean ret = false;
        Obj found = null;
        int minDistance = b.getEyesight();
        for (Toilet t : toiletList) {
            int distance;
            if (b.getZ() != t.getZ() || minDistance <= (distance = Terrarium.distance(b.getX(), b.getY(), t.getX(), t.getY() - t.getSize() / 6)) || !b.isRude() && Terrarium.acrossBarrier(b.getX(), b.getY(), t.getX(), t.getY() - t.getSize() / 6)) continue;
            found = t;
            minDistance = distance;
        }
        if (found != null) {
            b.moveToToilet(found.getX(), found.getY() - ((Toilet)found).getSize() / 6);
            ret = true;
        }
        return ret;
    }

    private boolean checkToy(Body b) {
        if (b.isDead() || b.isSleeping() || b.isExciting() || b.isScare() || !b.isRude() && (b.isAdult() || b.wantToShit())) {
            return false;
        }
        boolean ret = false;
        Obj found = null;
        int minDistance = b.getEyesight();
        for (Toy t : toyList) {
            int distance = Terrarium.distance(b.getX(), b.getY(), t.getX(), t.getY());
            if (minDistance <= distance || !b.isRude() && Terrarium.acrossBarrier(b.getX(), b.getY(), t.getX(), t.getY())) continue;
            found = t;
            minDistance = distance;
        }
        if (found != null) {
            if (minDistance <= Terrarium.distance(0, 0, b.getStep(), b.getStep())) {
                if (found.getZ() != 0) {
                    if (b.isOwner((Toy)found) && !((Toy)found).isOwned(b)) {
                        if (b.isRude()) {
                            b.setHappiness(Body.Happiness.VERY_SAD);
                        } else {
                            b.setHappiness(Body.Happiness.SAD);
                        }
                        if (!b.isTalking()) {
                            b.showLostTreasure();
                        }
                    }
                    return false;
                }
                int[] strength = new int[]{-1, -4, -6};
                b.setHappiness(Body.Happiness.HAPPY);
                if (!((Toy)found).isOwned(b)) {
                    ((Toy)found).setOwner(b);
                    b.setTreasure((Toy)found);
                    if (!b.isTalking()) {
                        b.showGetTreasure();
                    }
                }
                found.kick(b.getDirX() * b.getStep(), b.getDirY() * b.getStep(), strength[b.getAgeState().ordinal()]);
            } else {
                if (b.isOwner((Toy)found) && !((Toy)found).isOwned(b)) {
                    if (b.isRude()) {
                        b.setHappiness(Body.Happiness.VERY_SAD);
                    } else {
                        b.setHappiness(Body.Happiness.SAD);
                    }
                    if (!b.isTalking()) {
                        b.showLostTreasure();
                    }
                }
                b.moveTo(found.getX(), found.getY());
            }
        }
        return ret;
    }

    private boolean checkSleepy(Body b) {
        if (b.isDead() || b.isIdiot() || b.isSleeping() || b.wantToShit() || !b.isSleepy()) {
            return false;
        }
        boolean ret = false;
        Obj found = null;
        int minDistance = b.getEyesight();
        for (Toilet t : toiletList) {
            int distance;
            if (b.getZ() != t.getZ() || minDistance <= (distance = Terrarium.distance(b.getX(), b.getY(), t.getX(), t.getY() - t.getSize() / 6)) || !b.isRude() && Terrarium.acrossBarrier(b.getX(), b.getY(), t.getX(), t.getY() - t.getSize() / 6)) continue;
            found = t;
            minDistance = distance;
        }
        if (found != null) {
            b.moveToToilet(found.getX(), found.getY() - ((Toilet)found).getSize() / 6);
            ret = true;
        }
        return ret;
    }

    private void addBaby(int x, int y, int z, int type2, Body p1, Body p2) {
        babyList.add(this.makeBody(x, y, z + 1, type2, Body.AgeState.BABY, p1, p2));
        babyList.get(babyList.size() - 1).kick(0, 5, -2);
    }

    private void addBaby(int x, int y, int z, int vx, int vy, int vz, int type2, Body p1, Body p2) {
        babyList.add(this.makeBody(x, y, z + 1, type2, Body.AgeState.BABY, p1, p2));
        babyList.get(babyList.size() - 1).kick(vx, vy, vz);
    }

    public Body makeBody(int x, int y, int z, int type2, Body.AgeState age, Body p1, Body p2) {
        Body b;
        switch (type2) {
            case 0: {
                b = new Marisa(x, y, z, age, p1, p2);
                break;
            }
            case 1: {
                b = new Reimu(x, y, z, age, p1, p2);
                break;
            }
            case 2: {
                b = new Alice(x, y, z, age, p1, p2);
                break;
            }
            case 3: {
                b = new WasaReimu(x, y, z, age, p1, p2);
                break;
            }
            case 4: {
                b = new Tarinai(x, y, z, age, p1, p2);
                break;
            }
            case 10000: {
                b = new MarisaReimu(x, y, z, age, p1, p2);
                break;
            }
            case 10001: {
                b = new ReimuMarisa(x, y, z, age, p1, p2);
                break;
            }
            default: {
                throw new RuntimeException("Unknown yukkuri type.");
            }
        }
        return b;
    }

    public void addBody(int x, int y, int z, int type2, Body.AgeState age, Body p1, Body p2) {
        bodyList.add(this.makeBody(x, y, z, type2, age, p1, p2));
    }

    public void addBody(Body b) {
        bodyList.add(b);
    }

    public void addFood(int x, int y, Food.type type2) {
        foodList.add(new Food(x, y, type2));
    }

    public void addShit(int x, int y, int z, Body.AgeState ageState) {
        shitList.add(new Shit(x, y, z, ageState));
    }

    public void addToy(int x, int y) {
        toyList.add(new Toy(x, y));
        Cash.addCash(-toyList.get(toyList.size() - 1).getValue());
    }

    public void addCrushedShit(int x, int y, int z, Body.AgeState ageState) {
        Shit s = new Shit(x, y, z, ageState);
        s.crushShit();
        shitList.add(s);
    }

    public void addToilet(int x, int y) {
        toiletList.add(new Toilet(x, y));
        Cash.addCash(-toiletList.get(toiletList.size() - 1).getValue());
    }

    public void addObjEX(int addObjEX, int x, int y, ObjEX.Direction dir) {
        ObjEX objEX = null;
        switch (addObjEX) {
            case 9: {
                objEX = new Beltconveyor(x, y, dir);
                break;
            }
            case 10: {
                objEX = new BreedingPool(x, y, dir);
                break;
            }
            case 11: {
                objEX = new GarbageChute(x, y, dir);
                break;
            }
            case 12: {
                objEX = new MachinePress(x, y, dir);
                break;
            }
            case 13: {
                objEX = new FoodMaker(x, y, dir);
                break;
            }
            case 14: {
                objEX = new OrangePool(x, y, dir);
                break;
            }
            case 15: {
                objEX = new ProductChute(x, y, dir);
                break;
            }
        }
        objEX.buyObj();
    }

    public static void setAlarm() {
        alarm = true;
        alarmPeriod = 300;
    }

    public static boolean getAlarm() {
        return alarm;
    }

    public static void cleanAll() {
        for (Shit s : shitList) {
            s.remove();
        }
        for (Food f : foodList) {
            if (!f.isEmpty()) continue;
            f.remove();
        }
        for (Body b : bodyList) {
            if (!b.isDead()) continue;
            b.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void run() {
        if (alarmPeriod >= 0 && --alarmPeriod <= 0) {
            alarmPeriod = 0;
            alarm = false;
        }
        Obj.Event ret = Obj.Event.DONOTHING;
        Iterator<Obj> i = foodList.iterator();
        while (i.hasNext()) {
            Food f = i.next();
            ret = f.clockTick();
            if (ret != Obj.Event.REMOVED) continue;
            i.remove();
        }
        i = toiletList.iterator();
        while (i.hasNext()) {
            Toilet t = (Toilet)i.next();
            ret = t.clockTick();
            if (ret != Obj.Event.REMOVED) continue;
            i.remove();
        }
        List<ObjEX> platformList = Terrarium.getPlatformList();
        for (ObjEX oex : platformList) {
            ret = oex.clockTick();
            if (ret == Obj.Event.REMOVED) {
                oex.remove();
            }
            List<Obj> objList = Terrarium.getObjList();
            objList.addAll(toiletList);
            for (Obj o : objList) {
                int objType = 0;
                switch (o.getObjType()) {
                    case YUKKURI: {
                        objType = 1;
                        break;
                    }
                    case SHIT: {
                        objType = 2;
                        break;
                    }
                    case FOOD: {
                        objType = 4;
                        break;
                    }
                    case TOILET: {
                        objType = 8;
                        break;
                    }
                    case TOY: {
                        objType = 16;
                        break;
                    }
                    case PLATFORM: {
                        objType = 32;
                        break;
                    }
                    case FIX_OBJECT: {
                        objType = 64;
                        break;
                    }
                }
                if ((objType & oex.getHitCheckObjType()) == 0) continue;
                oex.checkHitObj(o);
            }
        }
        List<ObjEX> fixObjList = Terrarium.getFixObjList();
        Iterator<Obj> i2 = fixObjList.iterator();
        while (i2.hasNext()) {
            ObjEX oex = i2.next();
            ret = oex.clockTick();
            if (ret == Obj.Event.REMOVED) {
                i2.remove();
            }
            ArrayList<Body> objList = new ArrayList<Body>();
            objList.addAll(bodyList);
            for (Obj obj : objList) {
                oex.checkHitObj(obj);
            }
        }
        i2 = shitList.iterator();
        while (i2.hasNext()) {
            Shit s = (Shit)i2.next();
            ret = s.clockTick();
            if (ret != Obj.Event.REMOVED) continue;
            i2.remove();
        }
        i2 = toyList.iterator();
        while (i2.hasNext()) {
            Toy t = (Toy)i2.next();
            ret = t.clockTick();
            if (ret != Obj.Event.REMOVED) continue;
            i2.remove();
        }
        i2 = bodyList.iterator();
        block23: while (i2.hasNext()) {
            Body b = (Body)i2.next();
            b.putStress(bodyList.size());
            ret = b.clockTick();
            switch (ret) {
                case DEAD: {
                    if (b.getBabyTypes().size() < b.getMaxHaveBaby() / 120) continue block23;
                    int numOfBaby = b.getBabyTypes().size();
                    Iterator<Integer> iterator = b.getBabyTypes().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            b.getBabyTypes().clear();
                            if (b.isCrashed()) continue block23;
                            b.strikeByPress();
                            continue block23;
                        }
                        int n = iterator.next();
                        this.addBaby(b.getX(), b.getY(), b.getZ() + b.getSize() / 20, rnd.nextInt(numOfBaby / 4 + 1) - numOfBaby / 8, rnd.nextInt(numOfBaby / 4 + 1) - numOfBaby / 8, rnd.nextInt(numOfBaby / 4 + 1) - numOfBaby / 8 - 2, n, b, b.partner);
                    }
                }
                case BIRTHBABY: {
                    int babyType;
                    if (b.age % 10L != 0L || (babyType = b.getBabyTypesDequeue()) == -1) break;
                    this.addBaby(b.getX(), b.getY(), b.getZ() + b.getSize() / 15, babyType, b, b.partner);
                    break;
                }
                case DOSHIT: {
                    this.addShit(b.getX(), b.getY(), b.getZ(), b.getAgeState());
                    break;
                }
                case REMOVED: {
                    i2.remove();
                    continue block23;
                }
            }
            if (this.checkFood(b) || this.checkPartner(b) || this.checkShit(b) || this.checkToilet(b) || this.checkSleepy(b)) continue;
            this.checkToy(b);
        }
        if (!babyList.isEmpty()) {
            bodyList.addAll(babyList);
            babyList.clear();
        }
        ++operationTime;
    }
}

