/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import javax.imageio.ImageIO;

public class BreedingPool
extends ObjEX
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final int size = 128;
    private static final int images_num = 1;
    private static Image[] images = new Image[1];
    private boolean highDensity;
    private boolean rapidGrowth;
    private static int[] value = new int[]{1000, 4000, 4000, 10000};
    private static int[] cost = new int[]{100, 200, 200, 350};
    private int type = 0;
    private Random rnd = new Random();

    public static void loadImages(ClassLoader loader, String path) throws IOException {
        BreedingPool.images[0] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "breedingpool.png"));
        BreedingPool.images[0] = images[0].getScaledInstance(144, 96, 16);
    }

    @Override
    public Image getImage() {
        return images[0];
    }

    @Override
    public int getSize() {
        return 128;
    }

    @Override
    public boolean isTargetObj(Obj o) {
        switch (o.getObjType()) {
            case YUKKURI: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void objHitProcess(Obj o) {
        Body p;
        if (o.objType == Obj.Type.YUKKURI && !(p = (Body)o).isDead() && (int)this.age % (this.highDensity ? 4 : 10) == 0) {
            int idiotType = InitLoader.getIdiotType();
            int babyType = (p.isSick() || p.isDamaged() || !p.isChildbearingAge()) && idiotType != -1 ? idiotType : (p.getMutationType() != -1 && this.rnd.nextBoolean() ? p.getMutationType() : p.getType());
            p.addBaby(babyType);
            if (this.rapidGrowth) {
                p.rapidPregnantPeriod();
            }
            Cash.delCash(this.getCost());
        }
    }

    @Override
    public int getPrice(Obj.Price priceType) {
        if (priceType == Obj.Price.SELLING) {
            return value[this.type] / 2;
        }
        return value[this.type];
    }

    @Override
    public int getCost() {
        return cost[this.type];
    }

    public BreedingPool(int initX, int initY, PoolType poolType) {
        super(initX, initY);
        switch (poolType) {
            default: {
                this.highDensity = false;
                this.rapidGrowth = false;
                break;
            }
            case HIGHDENSITY: {
                this.highDensity = true;
                this.rapidGrowth = false;
                break;
            }
            case RAPIDGROWTH: {
                this.highDensity = false;
                this.rapidGrowth = true;
                break;
            }
            case BOTH: {
                this.highDensity = true;
                this.rapidGrowth = true;
            }
        }
        this.objType = Obj.Type.PLATFORM;
        this.type = poolType.ordinal();
    }

    public static enum PoolType {
        NONE,
        HIGHDENSITY,
        RAPIDGROWTH,
        BOTH;

    }
}

