/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.stream.JsonParser;

class InitLoader {
    private static String TITLE;
    private static String VERSION;
    private static String INITPATH;
    private static String IMAGEPATH;
    private static String FOUNDAGE;
    private static HashMap<String, String> MENU;
    private static HashMap<String, String> BUTTON;
    private static HashMap<String, String> STATUS;
    private static HashMap<String, String> QUERY;
    private static HashMap<String, String> AGE;
    private static HashMap<String, String> TYPE;
    private static HashMap<String, String> LOG;
    private static HashMap<String, String> YUKKURI;
    private static HashMap<String, String> PARAMETERS;
    private static HashMap<String, String> DIALOGUES;
    private static int idiotType;

    static {
        MENU = new HashMap();
        BUTTON = new HashMap();
        STATUS = new HashMap();
        QUERY = new HashMap();
        AGE = new HashMap();
        TYPE = new HashMap();
        LOG = new HashMap();
        YUKKURI = new HashMap();
        PARAMETERS = new HashMap();
        DIALOGUES = new HashMap();
        idiotType = -1;
    }

    InitLoader() {
    }

    public static void loadSystemInitFile(ClassLoader loader) {
        BufferedInputStream stream = new BufferedInputStream(loader.getResourceAsStream("inits/SimYukkuri_jp.json"));
        JsonReader reader = Json.createReader(stream);
        JsonObject obj = reader.readObject();
        TITLE = obj.getString("title");
        VERSION = obj.getString("version");
        INITPATH = obj.getString("initpath");
        IMAGEPATH = obj.getString("imagepath");
        FOUNDAGE = obj.getString("foundage");
        JsonArray menus = obj.getJsonObject("panel").getJsonArray("menu");
        int i = 0;
        for (JsonArray menu : menus.getValuesAs(JsonArray.class)) {
            int j = 0;
            for (JsonObject element : menu.getValuesAs(JsonObject.class)) {
                int k = 0;
                MENU.put(String.valueOf(Integer.toString(i)) + ":" + Integer.toString(j), element.getString("name"));
                JsonArray submenu = element.getJsonArray("submenu");
                if (submenu != null) {
                    for (JsonString subelement : submenu.getValuesAs(JsonString.class)) {
                        MENU.put(String.valueOf(Integer.toString(i)) + ":" + Integer.toString(j) + ":" + Integer.toString(k), subelement.getString());
                        ++k;
                    }
                }
                MENU.put(String.valueOf(Integer.toString(i)) + ":" + Integer.toString(j) + ":numOfSubMenu", Integer.toString(k));
                ++j;
            }
            MENU.put(String.valueOf(Integer.toString(i)) + ":numOfMenu", Integer.toString(j));
            ++i;
        }
        JsonArray log = obj.getJsonObject("panel").getJsonArray("log");
        i = 0;
        for (JsonObject title : log.getValuesAs(JsonObject.class)) {
            LOG.put(Integer.toString(i), title.getString("title"));
            JsonArray kinds = title.getJsonArray("kind");
            int j = 0;
            for (JsonString kind : kinds.getValuesAs(JsonString.class)) {
                LOG.put(String.valueOf(Integer.toString(i)) + ":" + Integer.toString(j), kind.getString());
                ++j;
            }
            ++i;
        }
        InitLoader.parseList(obj.getJsonObject("panel").getJsonArray("button"), BUTTON);
        InitLoader.parseList(obj.getJsonObject("panel").getJsonArray("status"), STATUS);
        InitLoader.parseList(obj.getJsonObject("panel").getJsonArray("query"), QUERY);
        InitLoader.parseList(obj.getJsonObject("panel").getJsonArray("age"), AGE);
        InitLoader.parseList(obj.getJsonObject("panel").getJsonArray("type"), TYPE);
        JsonArray types = obj.getJsonArray("yukkuri");
        i = 0;
        for (JsonObject type2 : types.getValuesAs(JsonObject.class)) {
            YUKKURI.put("name:" + Integer.toString(i), type2.getString("name"));
            YUKKURI.put("init:" + Integer.toString(i), type2.getString("init"));
            YUKKURI.put("image:" + Integer.toString(i), type2.getString("image"));
            ++i;
        }
        YUKKURI.put("numOfType", Integer.toString(i));
        reader.close();
    }

    private static void parseList(JsonArray array, HashMap<String, String> list) {
        int i = 0;
        for (JsonString element : array.getValuesAs(JsonString.class)) {
            list.put(Integer.toString(i), element.getString());
            ++i;
        }
    }

    public static String getTitle() {
        return TITLE;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getInitPath() {
        return INITPATH;
    }

    public static String getImagePath() {
        return IMAGEPATH;
    }

    public static int getFoundage() {
        if (FOUNDAGE == null) {
            return 0;
        }
        return Integer.parseInt(FOUNDAGE);
    }

    public static int getNumOfMenu(int menuId) {
        String s = MENU.get(String.valueOf(menuId) + ":numOfMenu");
        return s == null ? 0 : Integer.parseInt(s);
    }

    public static int getNumOfSubMenu(int menuId, int subMenuId) {
        String s = MENU.get(String.valueOf(menuId) + ":" + subMenuId + ":numOfSubMenu");
        return s == null ? 0 : Integer.parseInt(s);
    }

    public static String getMenu(int menuId, int itemId) {
        return MENU.get(String.valueOf(menuId) + ":" + itemId);
    }

    public static String getSubMenu(int menuId, int subMenuId, int itemId) {
        return MENU.get(String.valueOf(menuId) + ":" + subMenuId + ":" + itemId);
    }

    public static String getButton(int key) {
        return BUTTON.get(Integer.toString(key));
    }

    public static String getStatus(int key) {
        return STATUS.get(Integer.toString(key));
    }

    public static String getQuery(int key) {
        return QUERY.get(Integer.toString(key));
    }

    public static String getAge(int key) {
        return AGE.get(Integer.toString(key));
    }

    public static String getType(int key) {
        return TYPE.get(Integer.toString(key));
    }

    public static String getLogTitle(int titleId) {
        return LOG.get(Integer.toString(titleId));
    }

    public static String getLogKind(int titleId, int kindId) {
        return LOG.get(String.valueOf(titleId) + ":" + kindId);
    }

    public static int getNumOfType() {
        String s = YUKKURI.get("numOfType");
        return s == null ? 0 : Integer.parseInt(s);
    }

    public static String getYukkuriName(int type2) {
        return YUKKURI.get("name:" + type2);
    }

    public static String getYukkuriInitFile(int type2) {
        return YUKKURI.get("init:" + type2);
    }

    public static String getYukkuriImageFolder(int type2) {
        return YUKKURI.get("image:" + type2);
    }

    public static void loadInitFile(int type2, ClassLoader loader, String path) {
        int i = 0;
        BufferedInputStream stream = new BufferedInputStream(loader.getResourceAsStream(path));
        JsonReader reader = Json.createReader(stream);
        JsonObject obj = reader.readObject();
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":name", obj.getString("name"));
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":rapist", obj.getString("rapist"));
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":hybrid", obj.getString("hybrid"));
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":idiot", obj.getString("idiot"));
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":motherhood", obj.getString("motherhood"));
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":speed", obj.getString("speed"));
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":robustness", obj.getString("robustness"));
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":strength", obj.getString("strength"));
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":lifetime", obj.getString("lifetime"));
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":mutation", obj.getString("mutation"));
        PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":cleverness", obj.getString("cleverness"));
        i = 0;
        JsonArray hybrids = obj.getJsonArray("hybridtable");
        for (JsonString hybrid : hybrids.getValuesAs(JsonString.class)) {
            PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":hybridTable:" + Integer.toString(i), hybrid.getString());
            ++i;
        }
        i = 0;
        JsonArray values = obj.getJsonArray("value");
        for (JsonString value : values.getValuesAs(JsonString.class)) {
            PARAMETERS.put(String.valueOf(Integer.toString(type2)) + ":value:" + Integer.toString(i), value.getString());
            ++i;
        }
        if (obj.getString("idiot").equals("true")) {
            idiotType = type2;
        }
        reader.close();
        stream = new BufferedInputStream(loader.getResourceAsStream(path));
        JsonParser parser = Json.createParser(stream);
        boolean startParse = false;
        String key = null;
        int nest = 0;
        int row = 0;
        int column = 0;
        while (parser.hasNext()) {
            JsonParser.Event e = parser.next();
            if (!startParse) {
                if (e != JsonParser.Event.KEY_NAME || !parser.getString().equals("dialogue")) continue;
                startParse = true;
                continue;
            }
            if (e == JsonParser.Event.END_OBJECT) break;
            if (e == JsonParser.Event.KEY_NAME) {
                key = parser.getString();
                column = 0;
                row = 0;
                continue;
            }
            if (e == JsonParser.Event.START_ARRAY) {
                ++nest;
                continue;
            }
            if (e == JsonParser.Event.END_ARRAY) {
                --nest;
                column = 0;
                ++row;
                continue;
            }
            if (e != JsonParser.Event.VALUE_STRING || nest != 2 || key == null) continue;
            DIALOGUES.put(String.valueOf(Integer.toString(type2)) + ":" + key + ":" + Integer.toString(row) + ":" + Integer.toString(column), parser.getString());
            ++column;
        }
        parser.close();
    }

    public static String getMessage(int type2, String key, int age, int damage) {
        return DIALOGUES.get(String.valueOf(Integer.toString(type2)) + ":" + key + ":" + Integer.toString(damage) + ":" + Integer.toString(age));
    }

    private static String getParameter(int type2, String name) {
        return PARAMETERS.get(String.valueOf(Integer.toString(type2)) + ":" + name);
    }

    public static String getName(int type2) {
        return InitLoader.getParameter(type2, "name");
    }

    public static boolean getMotherhood(int type2) {
        return InitLoader.getParameter(type2, "motherhood").equals("true");
    }

    public static boolean getRapist(int type2) {
        return InitLoader.getParameter(type2, "rapist").equals("true");
    }

    public static boolean getHybrid(int type2) {
        return InitLoader.getParameter(type2, "hybrid").equals("true");
    }

    public static boolean getIdiot(int type2) {
        return InitLoader.getParameter(type2, "idiot").equals("true");
    }

    public static int getMutationType(int type2) {
        String s = InitLoader.getParameter(type2, "mutation");
        return s == null ? -1 : Integer.parseInt(s);
    }

    public static int getSpeed(int type2) {
        String s = InitLoader.getParameter(type2, "speed");
        return s == null ? 4 : Integer.parseInt(s);
    }

    public static Double getRobustness(int type2) {
        String s = InitLoader.getParameter(type2, "robustness");
        return s == null ? 1.0 : Double.parseDouble(s);
    }

    public static Double getStrength(int type2) {
        String s = InitLoader.getParameter(type2, "strength");
        return s == null ? 1.0 : Double.parseDouble(s);
    }

    public static Double getCleverness(int type2) {
        String s = InitLoader.getParameter(type2, "cleverness");
        return s == null ? 1.0 : Double.parseDouble(s);
    }

    public static int getHybridType(int papa, int mama) {
        return Integer.parseInt(PARAMETERS.get(String.valueOf(Integer.toString(papa)) + ":hybridTable:" + Integer.toString(mama)));
    }

    public static int getValue(int type2, int age) {
        String s = PARAMETERS.get(String.valueOf(Integer.toString(type2)) + ":value:" + Integer.toString(age));
        return s == null ? 0 : Integer.parseInt(s);
    }

    public static int getIdiotType() {
        return idiotType;
    }
}

