/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class OrangePool
extends ObjEX
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final int size = 128;
    private static final int images_num = 1;
    private static Image[] images = new Image[1];
    private boolean rescue;
    private static int[] value = new int[]{500, 10000};
    private static int[] cost = new int[]{10, 200};
    private int type = 0;

    public static void loadImages(ClassLoader loader, String path) throws IOException {
        OrangePool.images[0] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "orangepool.png"));
        OrangePool.images[0] = images[0].getScaledInstance(144, 96, 16);
    }

    @Override
    public Image getImage() {
        return images[0];
    }

    @Override
    public int getSize() {
        return 128;
    }

    @Override
    public boolean isTargetObj(Obj o) {
        switch (o.getObjType()) {
            case YUKKURI: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkHitObj(Obj o) {
        int objX = o.getX();
        int objY = o.getY();
        int objZ = o.getZ();
        int platformSize = this.getSize() / 2;
        int platformX = this.getX();
        int platformY = this.getY();
        int offsetX = (128 - this.getSize()) * 7 / 32 - 28;
        int offsetY = (128 - this.getSize()) * 6 / 16 - 40;
        if (objZ == 0 && platformX + offsetX <= objX && objX <= platformX + offsetX + platformSize && platformY + offsetY <= objY && objY <= platformY + offsetY + platformSize) {
            this.objHitProcess(o);
            return true;
        }
        return false;
    }

    @Override
    public void objHitProcess(Obj o) {
        if (this.age % 10L != 0L) {
            return;
        }
        if (o.objType == Obj.Type.YUKKURI) {
            Body b = (Body)o;
            if (this.rescue) {
                if (b.isDead() && !b.isCrashed()) {
                    b.revival();
                    b.giveJuice();
                    b.setDirty(false);
                    Cash.delCash(this.getCost());
                }
            } else if (!b.isDead()) {
                b.giveJuice();
                b.setDirty(false);
                Cash.delCash(this.getCost());
            }
        }
    }

    @Override
    public int getPrice(Obj.Price priceType) {
        if (priceType == Obj.Price.SELLING) {
            return value[this.type] / 2;
        }
        return value[this.type];
    }

    @Override
    public int getCost() {
        return cost[this.type];
    }

    public OrangePool(int initX, int initY, PoolType poolType) {
        super(initX, initY);
        switch (poolType) {
            default: {
                this.rescue = false;
                this.type = 0;
                break;
            }
            case RESCUE: {
                this.rescue = true;
                this.type = 1;
            }
        }
        this.objType = Obj.Type.PLATFORM;
    }

    public static enum PoolType {
        NORMAL,
        RESCUE;

    }
}

