<?php
include("siwiki.header.php");

$root = $_SERVER['DOCUMENT_ROOT'].dirname($_SERVER['PHP_SELF'])."/site/".$site;
ChkVal($site_root, 'site_root', $root);
ChkVal($install_step, 'install_step', 1);
ChkVal($install_dir, 'install_dir', '');
ChkVal($admin_id, 'admin_id', "admin");
ChkVal($admin_passwd, 'admin_passwd', "admin");
ChkVal($sub, 'sub', "");

$dbname = $_SIWIKI['dbname'];

if(!$dbname) $dbname="siwiki.db";

if(!$install_dir) $install_dir = dirname($_SERVER['DOCUMENT_ROOT'].$_SERVER['PHP_SELF']);

if($sub == "Init"){
  $install_step = 1;
  unlink($site_root."/".$dbname);
}else if($sub == "Init and Clear"){
  $install_step = 1;
  if($site == "default"){
    unlink($install_dir."/.htaccess");
    unlink($install_dir."/.htpasswd");
  }
  remove_dir_all($_SESSION['wiki_dir']);
}

$htaccess .=<<<_TXT
#
#  mod_rewrite definitions for Siwiki2.
#
RewriteEngine on
RewriteRule ^attachments/_([0-9A-Za-z\_\-]*)/(.*)/([0-9A-Za-z\_\-]*)/(.*)/download$		index.php?site=$1&file2=$4&category=$2&file=$3&sub=download
RewriteRule ^attachments/_([0-9A-Za-z\_\-]*)/(.*)/([0-9A-Za-z\_\-]*)/(.*)/delete_file$		admin.php?site=$1&file2=$4&category=$2&file=$3&sub=delete_file

RewriteRule ^(images|videos)/_([0-9A-Za-z\_\-]*)/(.*)/(.*)/(.*)$				index.php?site=$2&sub=$1&file=$5&category=$3&page=$4
RewriteRule ^(images|videos)/_([0-9A-Za-z\_\-]*)/(.*)/(.*)$					index.php?site=$2&sub=$1&file=$4&category=$3
RewriteRule ^(images|videos)/_([0-9A-Za-z\_\-]*)/(.*)$					index.php?site=$2&sub=$1&file=$3

RewriteRule ^_([0-9A-Za-z\_\-]*)/wp-content/themes/(.*)$					themes/$2
RewriteRule ^_([0-9A-Za-z\_\-]*)/$								index.php?site=$1
RewriteRule ^_([0-9A-Za-z\_\-]*)$								index.php?site=$1
RewriteRule ^_([0-9A-Za-z\_\-]*)/([A-Za-z_]+).php$						$2.php?site=$1

RewriteRule ^_([0-9A-Za-z\_\-]*)/([a-z]*)/([0-9A-Za-z\_\-]*)/(.*).html&(.*)$			index.php?site=$1&file=$4&category=$3&lang=$2&$5

RewriteRule ^_([0-9A-Za-z\_\-]*)/([a-z]*)/([0-9A-Za-z\_\-]*)/(.*).html/([A-Za-z]*)&(.*)$	admin.php?site=$1&file=$4&category=$3&lang=$2&sub=$5&$6
RewriteRule ^_([0-9A-Za-z\_\-]*)/([a-z]*)/([0-9A-Za-z\_\-]*)/(.*).html/(.*)$			admin.php?site=$1&file=$4&category=$3&lang=$2&sub=$5
RewriteRule ^_([0-9A-Za-z\_\-]*)/([a-z]*)/([0-9A-Za-z\_\-]*)/(.*).html$				index.php?site=$1&file=$4&category=$3&lang=$2
RewriteRule ^_([0-9A-Za-z\_\-]*)/([a-z]*)/([0-9A-Za-z\_\-]*)/(.*).html#(.*)$			index.php?site=$1&file=$4#$4&category=$3&lang=$2

#
# Access control.
#
<Files ~ "^.(htpasswd|htaccess)$">
deny from all
Satisfy all
</Files>

<Files ~ "^(admin.php|install.php)$">
AuthType Basic
AuthName "Siwiki: Member only"
AuthUserFile $install_dir/.htpasswd
Require valid-user

Satisfy any

order deny,allow
deny from all

allow from 127.0
</Files>

order allow,deny
allow from all
_TXT;

$crypt_passwd = crypt($admin_passwd, substr($admin_passwd,0,2));
$htpasswd .=<<<_TXT
$admin_id:$crypt_passwd

_TXT;

if(!file_exists($install_dir."/.htaccess") || !file_exists($install_dir."/.htpasswd")){
  if($install_step == 2){
    save_content($install_dir."/.htaccess", $htaccess);
    save_content($install_dir."/.htpasswd", $htpasswd);
  }else{
    $install_step = 1;
  }
}else if(!file_exists($site_root."/".$dbname)){
  if($install_step == 3){
     $site_root_top = $site_root."/documents/Home/index/";

     if(mkdir2($site_root_top, true) === false){
	$info = "<font color=\"red\">Fail to mkdir: $site_root </font><br>";
        $install_step = 2;
     }
     if(! init_siwiki_table($site_root) ){
	 $info = "<font color=\"red\">Fail to init database </font><br>";
         $install_step = 2;
     }
  }else{
    $install_step = 2;
  }
}else if(!file_exists($site_root."/documents/Home/index/content.".$_SESSION['lang'].".txt")){
  if($install_step == 4){
       $_SIWIKI['wiki_dir'] = $site_root;
       $stat = registerUser($admin_id, $admin_passwd, SYSTEM_ADMIN);
       if($stat){
          $stat = activateUser($admin_id);
          if($stat){
	       $info = "Fail to register administrator";
               $install_step = 3;
	  }else{
	       $info.= "OK";
	  }
       }else{
	  $info = "Fail to register administrator";
          $install_step = 3;
       }
  }else{
    $install_step = 3;
  }
}else{
  if($install_step == 4){
       $_SIWIKI['wiki_dir'] = $site_root;
       $stat = registerUser($admin_id, $admin_passwd, SYSTEM_ADMIN);
       if($stat){
          $stat = activateUser($admin_id);
          if($stat){
	       $info = "Fail to register administrator";
               $install_step = 3;
	  }else{
	       $info.= "OK";
	  }
       }else{
	  $info = "Fail to register administrator";
          $install_step = 3;
       }
  }
  $install_step = 5;
}

$content .= "<h2>Siwiki Install: Step ".$install_step."</h2>";
$content .= $info;

$content .=<<<_HTML
<form action="$thisFile" method="POST">
	<input type="hidden" name="site" value="$site"> 
_HTML;

switch( $install_step ){
  case 1:
       $content .=<<<_HTML
       Welcome to Siwiki Installer<hr>
       Please comfirm install dirctory.<br>
       <table>
       <tr><td> Install Directory </td><td> <input type="text" name="install_dir" value="$install_dir" size="80"> </td><tr>
       <tr><td> Admin ID </td><td> <input type="text" name="admin_id" value="$admin_id" size="50"> </td><tr>
       <tr><td> Admin Password </td><td> <input type="text" name="admin_passwd" value="$admin_passwd" size="50"> </td><tr>
       </table>

       OK? <br>
	<input type="hidden" name="install_step" value="2">
_HTML;
	break;
  case 2:
       $content .= init_step1($site, $site_root, $ERROR);
       $content .= " <input type=\"hidden\" name=\"install_step\" value=\"3\">";
       break;
  case 3:
       $_SESSION['wiki_dir'] = $site_root;
       $content .= init_step2($site, $site_root, $ERROR);
       $content .= " <input type=\"hidden\" name=\"install_step\" value=\"4\">";
       break;
  case 4:
       $lang = $_SESSION['lang'];
       $_Config['topLogo'] = $_SIWIKI['topLogo'];
       $_Config['template'] = $_SIWIKI['template'];
       $_Config['wiki_dir'] = $_SIWIKI['wiki_dir'];
       $_Config['dbname'] = $_SIWIKI['dbname'];
       save_config($_Config);

       $copy($_SIWIKI['wiki_dir']."/".$_SIWIKI['dbname'], $install_dir."/site/siwiki.db");
       $wiki = "TITLE:TopPage\n";
       $wiki .= "LANG:$lang\n";
       $wiki .= "*Welcome to Siwiki\nPlease login and edit this file.";

       $filename = $site_root."/documents/Home/index/content.".$lang.".txt";
       if(! file_exists($filename)) save_content($filename, $wiki);
       $content .= jumpUrl("index.php");

       break;
  default:
       break;
}

if ($install_step < 5){
  $content .=<<<_HTML
<input type="submit" name="sub" value="Next">
</form>
_HTML;
}else{
  $__dir = $_SESSION['wiki_dir'];
  $content .=<<<_HTML
  Confuraturation!! Now, you finish initializing Siwiki.<br>
  If you initialize the all configuration.<br>
  Go to <a href="index.php"> TopPage </a>.
 Please click:
<input type="submit" name="sub" value="Init and Clear">
<input type="submit" name="sub" value="Init">
  <hr> Install dir : $__dir
</form>
_HTML;

}

$content .="<br>";

include($_SIWIKI['template']);


function init_step1($site, $root, $ERROR=""){
  $content .=<<<_HTML
      Swiki Site root:<br>
  $ERROR
       <table style="border:1px solid black;">
	<tr><th>Site Name:</th><td> $site</td></tr>
	<tr><th>Document Root:</th><td><input type="text" name="site_root" value="$root" size="50"></td></tr>
       </table>
_HTML;
  return $content;
}

function init_step2($site, $root, $ERROR=""){
  $content .=<<<_HTML
	Register Administrator for this site:<br>
  $ERROR
       <table style="border:1px solid black;">
	<tr><th>Site Name:</th><td> $site</td></tr>
	<tr><th>Document Root:</th><td>$root</td></tr>
	<tr><th>Admin UID:</th><td><input type="text" name="admin_id" value="admin" size="50"></td></tr>
	<tr><th>Admin Passwd:</th><td><input type="password" name="admin_passwd" size="50" value="admin"></td></tr>
       </table>
_HTML;
  return $content;
}

function init_siwiki_table($site_root){
  global $init_tables, $_SIWIKI;

  $db = OpenDB($_SIWIKI['dbname'], $site_root);
  if(! $db) return false;
  $key = array_keys($init_tables);
  foreach($key as $k){
     $res = $db->createTable($k, $init_tables[$k]);
     if(! $res) return false;
  }
  $db->close();
  return true;
}

?>


