<?php
/*********************************************

 WISH(Web based Infomation SHaring system)
      =         =          ==  

   Copyright (C) 2003
        Isao Hara, Japan
                All rights recieved.

 *********************************************/
class SQLite_db
{
  var $con;
  var $dbname, $passwd, $username, $topdir ;

  function SQLite_db($name){
    $this->dbname = $name;
    $this->username = "root";
    $this->passwd = "";
    $this->topdir= "./db";
  }

  function setDB($db){ $this->dbname = $db; }
  function setPasswd($p){ $this->passwd = $p; }
  function setTopDir($p){ $this->topdir = $p; }

  function connect(){
    $con = sqlite_open($this->topdir."/".$this->dbname);
    if (!$con) {
        return $con;
    }
    $this->con = $con;

    return $con;
  }
  
/*********** Close DB ********/
  function close(){
	sqlite_close($this->con);
  }

  function begin(){ return sqlite_query($this->con, "begin;"); }
  function rollback(){ return sqlite_query($this->con, "Rollback;"); }
  function commit(){ return sqlite_query($this->con, "commit;"); }
  function end(){ return sqlite_query($this->con, "end;"); }

  function exec($str){ return sqlite_query($this->con, $str); }

  function sql_request($sqlstr){
   return new DB_Result($this->con, $sqlstr);
  }

  function createTable($name, $table){
    $query = "CREATE TABLE $name (";
    $query .= $table;
    $query .=")";

    return sqlite_query($this->con, $query);
  }

  function dropTable($name){
    $query = "DROP TABLE $name;";
    return sqlite_query($this->con, $query);
  }

  function getTableList(){
     $sql ="select name from sqlite_master where type='table' order by name;";
     $result = sqlite_query($this->con, $sql);
     
     $num = sqlite_num_rows($result);

     $res = array();

     for($i=0;$i<$num; $i++){
       sqlite_seek($result, $i);
       $res[] = sqlite_column($result, 'name');
     }
     return $res;
  }

  function tableExists2($tbl){
    $tbls = $this->getTableList();
    foreach($tbls as $x){
      if($tbl == $x) return true;
    }
    return false;
  }

  function tableExists($tbl){
    $sql ="select * from sqlite_master where type='table' and name='$tbl';";
    $result = sqlite_query($this->con,$sql);

    if (!$result) {
      return NULL;
    }
    $num = sqlite_num_rows($result);
    return $num;
  }

  function mkTable($name, $table){
    if($this->tableExists($name)) return true;
    return $this->createTable($name,$table);
  }


}

/***** SQL Query Result *********/
Class DB_Result{
  var $num, $val;

  function DB_Result($conn, $sqlstr, $alert=1){
    $result = sqlite_query($conn, $sqlstr);
    if (!$result) {
      if($alert){
        print "$sqlstr <br>";
        echo "<Script language=\"JavaScript\">\n";
        echo "alert('Fail to SQLite Query')\n";
        echo "</Script>\n";
      }
      return NULL;
    }
    $this->val = $result;
    $this->num = sqlite_num_rows($result);
  }

  function getValue($n, $colname){
    if ($n < $this->num){
	  sqlite_seek($this->val, $n);
      return sqlite_column($this->val, $colname);
    }
    return NULL;
  }

  function clear(){
    $this->val =NULL;
    $this->num = 0;
  }

  function fetchArray($n, $type=""){
    if ($n < $this->num){
      sqlite_seek($this->val, $n);
      return sqlite_fetch_array($this->val,SQLITE_ASSOC);
    }
    print "Error in fetchArray, $n, ".$this->num;
    return NULL;
  }

  function fetchAll($type=""){
    for($i=0; $i < $this->num;$i++){
       $array_out[] = sqlite_fetch_array($this->val);
    }
    return $array_out;
  }
}

/************************************************
  DB access
************************************************/

function OpenDB($dbname, $dir = "./db"){
  $_db = new SQLite_db($dbname);
  $_db->setTopDir($dir);

  if(!$_db->connect()){
    return NULL;
  }
  return $_db;
}

function CreateTable($db, $tbl_name, $tbl_schema){
  $res = $db->sql_request("select * from ".$tbl_name.";",0);
  if(!$res->val){
     $db->createTable($tbl_name, $tbl_schema);
  }
}
?>
