<?php

include_once('Archive/Tar.php');

/*
  Simple Wiki
*/
////////////////////////////////////////
//  Siwiki
//    Convert a wiki text to an html text.
//
function siwiki($str){
  $wiki_body = convert_to_body($str);
  return $wiki_body->toString();
}

function siwiki_element($str){
  $ele = new Element($str);
  return $ele->toString();
}

function convert_to_body($source){
  $lines = explode("\n", $source);
  $body= new Body($lines);
  $body->parse();

  return $body;
}

function convert_html($source){
  $lines = explode("\n", $source);
  $body= new Body($lines);
  $body->parse();

  return $body->toHTML();
}

////////////////////////////////////////
//  Siwiki Menu
//
function siwiki_menu($thisFile){
  global $_SIWIKI;
  $dir = $_SIWIKI['top'];
  $site = $_SIWIKI['site'];
  if(is_system_admin()) $check_user=SYSTEM_ADMIN;
  else $check_user = check_user();
  if($check_user > POWER_USER ){
  $str =<<<_HTML
<a href="$thisFile"><img src="$dir/images/back.png" title="Back"></a>
<a href="$thisFile/configure"><img src="$dir/images/config.png" title="Config"></a>
<a href="$thisFile/editUser"><img src="$dir/images/user.png" title="EditUser"></a>
<a href="$thisFile/list"><img src="$dir/images/list.png" title="List"></a>
<a href="$thisFile/new"><img src="$dir/images/new.png" title="New page"></a>
<a href="$thisFile/edit"><img src="$dir/images/edit.png" title="Edit page"></a>
<a href="$thisFile/upload_file"><img src="$dir/images/upload.png" title="Upload File"></a>
<a href="$thisFile/edit_menu"><img src="$dir/images/edit_menu.png" title="Edit menu"></a>
<a href="$thisFile/editComment"><img src="$dir/images/edit_news.png" title="Edit News"></a>
<a href="$thisFile/logview"><img src="$dir/images/log.png" title="Log Viewer"></a>
<a href="$thisFile/history"><img src="$dir/images/history.png" title="History"></a>
<a href="$thisFile/cms"><img src="$dir/images/cms.png" title="CMS"></a>
<a href="$thisFile/backup"><img src="$dir/images/backup.png" title="Backup"></a>
_HTML;
  }else if($check_user > LIMITED_USER ){
  $str =<<<_HTML
<a href="$thisFile"><img src="$dir/images/back.png" title="Back"></a>
<a href="$thisFile/list"><img src="$dir/images/list.png" title="List"></a>
<a href="$thisFile/new"><img src="$dir/images/new.png" title="New page"></a>
<a href="$thisFile/edit"><img src="$dir/images/edit.png" title="Edit page"></a>
<a href="$thisFile/upload_file"><img src="$dir/images/upload.png" title="Upload File"></a>
_HTML;
  }else{
  $str =<<<_HTML
<a href="$thisFile"><img src="$dir/images/back.png" title="Back"></a>
<a href="$thisFile/list"><img src="$dir/images/list.png" title="List"></a>
_HTML;
  }

  return $str;
}

//////////////////////////////////////////
// Functions for PHP 4.x
//
function str_shift(&$str){
  $res = $str{0};
  $str = substr($str,1);
  return $res;
}

function count_chr($c, $str){
 for($i=0, $count=0;$str{$i} == $c; $i++,$count++);
 return $count;
}

function array_last(&$str){
  return $str[count($str)-1];
}

function mkdir2($dir, $recursive=false){

 if(file_exists($dir)) return true;
 if($recursive){
   $dirs = explode('/',$dir);
   $xx = '';
   foreach($dirs as $x){
     $xx .= $x.'/';
     if(!file_exists($xx)) mkdir($xx);
   }
   return true;
 }else{
   return  mkdir($dir);
 }
}

//////////////////////////////////////////
// Miscellaneous functions...
//
function ChkVal(&$x,$name,$val){
  $x=$_POST[$name];
  if(!$x) $x=$_GET[$name];
  if(!$x) $x=$val;
}

function ChkVal2(&$x,$name,$val){
  $x=$_POST[$name];
  if(!$x) $x=$val;
}

function now($nospace=false){
  if($nospace) return date('Y-m-d_H:i:s');
  else return date('Y-m-d H:i:s');
}

function today($days=0){
  $tm = time()+86400 * $days;
  return date('Y-m-d', $tm);
}

function checkDay($w){
  if($w == 0) return "sun";
  else if($w == 6) return "sat";
  else return "wday";
}

function formatDate($dt){
  $tm = strtotime($dt);
  $dy = checkDay(date('w',$tm));
  $sm = substr(date('F',$tm),0,3);
  $y = date('Y',$tm);
  $d = date('d',$tm);
  $str = "<span class=\"date_m\"><span class=\"$dy\">$d</span>  <span class=\"month\">$sm</span> <span class=\"year\">$y</span></span>";
  return $str;
}

/////////////////////
// style <--> array
function array2style($styles){
  $style = "";
  if(is_array($styles)){
    $keys = array_keys($styles);
    foreach($keys as $k){ $style .= $k.":".$styles[$k].";"; }
  }
  return $style;
}

function style2array($styles){
  $ss = false;
  if($styles){
    $tmp1 = explode(";",$styles);
    foreach($tmp1 as $st){
      $tmp2 = explode(":",$st);
      $ss[$tmp2[0]] = $tmp2[1];
    }
  }
  return $ss;
}

///////////////////////////////////////////
//  get inline tag with $lp and $rp
function get_inline_tag($lp, $rp, &$str){
  $lpos=strpos($str, $lp);
  if($lpos === false) return "";

  $lpos+=strlen($lp);
  $rpos = strpos($str, $rp, $lpos);
  if($rpos === false) return "";
  
  return substr($str, $lpos, $rpos - $lpos);
}

///////////////////////////////////////////
//  check URL format
function isURL($page){
 $pattern = "((http|https):\/\/)([^\/]+)(\/.*$)?";
 $pattern2 = "^\/([^\/]+)(\/.*$)?";
 $count = preg_match("/".$pattern."/i", $page);
 if($count > 0) return true;

 $count = preg_match("/".$pattern2."/i", $page);
 if($count > 0) return true;
 return false;
}

///////////////////////////////////////////
// get WikiTitle from file
function getWikiName($filename){
  if(!file_exists($filename)) return 0;
  $cont = file_get_contents($filename);
  $lines = explode("\n", $cont);
  $body = new Body($lines);
  return $body->getTitle();
}

///////////////////////////////////////
// getWikiTitle from name 
function getWikiName2($name){
  global $_SIWIKI;
  $ffname=WikiDir("documents", $_SIWIKI['category'],$name).contentfile();
  $n = getWikiName($ffname);
  if(!$n) return $name;
  return $n;
}

///////////////////////////////////////
//  create WikiLink form 
function mkWikiLink($name){
  $wikiname = getWikiName2($name);
  return  siwiki_element("[[$wikiname>$name]]");
}

///////////////////////////////////////
//   create a static url string 
function getStaticPage($lang, $category, $fname, $sub=false){
  global $_SIWIKI;

  $site = $_SIWIKI['site'];
  if(strpos($fname, ".html") === false){
    $path =  $_SIWIKI['top']."/_$site/$lang/$category/$fname.html";
  }else{
    $path =  $_SIWIKI['top']."/_$site/$lang/$category/$fname";
  }
  if($sub) $path .= "/$sub";
  return $path;
}

function getCurrentPage(){
  global $_SIWIKI;
  return getStaticPage($_SESSION['lang'], $_SIWIKI['category'], $_SIWIKI['pagename']);
}

function getCurrentCategory(){
  global $_SIWIKI;
  return getStaticPage($_SESSION['lang'], $_SIWIKI['category']);
}

function getCurrentSite(){
  global $_SIWIKI;
  return getStaticPage($_SESSION['lang']);
}

///////////////////////////////////////
//   get other languages
function otherLangPage($langs, $lang, $category, $fname, $sub=false){
  global $_SIWIKI;

  foreach($langs as $l){
    if($l != $lang){
      $path = getStaticPage($l, $category, $fname);

      if($sub) $path .= "/$sub";

      $str =  "<a href=\"$path\">";
      $str .= "<img src=\"".$_SIWIKI['top']."/images/$l.png\">";
      $str .=  "</a>";
      $res[] = $str;
    }
  }
  return implode(' ', $res);
}

///////////////////////////////////////
//   get list of file on the directory
function get_file_list($dir){
  $res=array();

  if(is_dir($dir)){
    if($dh=opendir($dir)){
      while(($file=readdir($dh)) !== false){
       if($file{0} != "."  && !is_dir($dir."/".$file))
        array_push($res, $file);
      }
      closedir($dh);
    }
  }

  sort($res);
  return $res;
}

function get_dir_list($dir){
  $res=array();

  if(is_dir($dir)){
    if($dh=opendir($dir)){
      while(($file=readdir($dh)) !== false){
       if($file{0} != "."  && is_dir($dir."/".$file))
        array_push($res, $file);
      }
      closedir($dh);
    }
  }

  sort($res);
  return $res;
}

///////////////////////////////////////
//   get list of page in the category
function pagelist($cat, $lang){
  $dir=WikiDir('documents', $cat);

  $files =array();
  $fp = opendir($dir);
  while(false !== ($fname = readdir($fp))){
    if($fname{0} != '.' && is_dir($dir."/".$fname) && file_exists($dir."/".$fname.contentfile($lang)) ){
      $files[]=$fname;
    }
  }
  closedir($fp);

  sort($files);
  return $files;
}

///////////////////////////////////////
//   get list of category in the directory
function getCategoryList($dir=""){
  if(!$dir) $dir=WikiDir();
  $res = array();
  if(!is_dir($dir)) return false;

  $dh = opendir($dir);
  while(false !== ($file = readdir($dh))){
    if( $file != "." && $file != ".." && is_dir($dir."/".$file)){
      $flist = getFileList($dir, $file);
      if(count($flist) > 0) $res[] = $file;
    }
  }
  closedir($dh);
  return $res;
}

///////////////////////////////////////
//   get list of themes
function getThemeList($dir=""){
  global $_SIWIKI;
  if(!$dir) $dir=WikiDir('themes');
  if(!is_dir($dir)) return false;

  return get_dir_list($dir);
}

///////////////////////////////////////
//   get file type from file extension
function getFileType($fname){
  if( preg_match('/((.png)|(.jpg)|(.jpeg)|(.gif)|(.ico))$/', $fname) > 0){
    $type="images";
  }else if( preg_match('/((.swf)|(.flv)|(.mpg)|(.mpeg)|(.wmv))$/', $fname) > 0){
    $type="videos";
  }else{
    $type="attachments";
  }
  return $type;
}

///////////////////////////////////////
//   get list of attached files on the current page
function get_attached_files($type=""){
  global $_SIWIKI;
  $_dir = WikiDir("attachments", $_SIWIKI['category'], $_SIWIKI['pagename']);

  if(is_dir($_dir)){
    return get_file_list($_dir);
  }
  return array();
}

//////////////////////////////////////
//  make reference path 
function mkReferenceUrl($fname, $type=""){
  global $_SIWIKI;

  if(!$type) $type = getFileType($fname);

  if($fname{0} == '/' && $fname{1} == '/'){
    $_file = substr($fname,1);
  }else if($fname{0} == '/' ){
    $_file = $_SIWIKI['top']."/".$type."/_".$_SIWIKI['site'].$fname;
  }else if(isURL($fname)){
    $_file = $fname;
  }else{
    $ff = explode(':', $fname);
    if(count($ff) > 1){
      $_file = $_SIWIKI['top']."/".$type."/_".$_SIWIKI['site']."/".$_SIWIKI['category']."/".$ff[1]."/".$ff[0];
    }else{
      $_file = $_SIWIKI['top']."/".$type."/_".$_SIWIKI['site']."/".$_SIWIKI['category']."/".$_SIWIKI['pagename']."/".$fname;
    }
  }
  return $_file;
}

//////////////////////////////////////
//  get a side menufile
function getMenuFile(){
  global $_SIWIKI;

  $menufile="/menu.".$_SESSION['lang'].".txt";
  $menufile1=WikiDir('documents', $_SIWIKI['category'], $_SIWIKI['pagename']).$menufile;
  $menufile2=WikiDir('documents', $_SIWIKI['category']).$menufile;
  $menufile3=WikiDir().$menufile;


  if(file_exists($menufile1)){
    return $menufile1;
  }else if(file_exists($menufile2)){
    return $menufile2;
  }else if(file_exists($menufile3)){
    return $menufile3;
  }
  return false;
}

//////////////////////////////////////
//  get a side menu
function getMenu(){
  global $_SIWIKI;

  $menufile=getMenufile();

  if($menufile){
    return siwiki(file_get_contents($menufile));
  }else{
    return "<ul><li><a href=\"".$_SIWIKI['top']."\">Top</a></li></ul>";
  }
}

//////////////////////////////////////
//  content file name
function contentfile($lang=""){
  if(!$lang) $lang=$_SESSION['lang'];
  if(!$lang) $lang="ja";
  
  return "/content.".$lang.".txt";
}

//////////////////////////////////////
//   get content file list
function getFileList($_dir, $category){
  $dir = $_dir."/".$category;
  $handle = opendir($dir);

  $filenames=array();
  while(false !== ($file = readdir($handle))){
    if( $file != "." && $file != ".." && is_dir($dir."/".$file)){
     $ffname=$dir."/".$file.contentfile();
     if(file_exists($ffname)){
       $filenames[getWikiName($ffname)]=$file;
     }
   }
  }
  closedir($handle);
  return $filenames;
}

////////////////////////////////////////////
//// create category selector for list.php
function mkCategoryList($categories = ""){
  global $_SIWIKI;

  $top_dir = $_SIWIKI['top'];
  $lang = $_SESSION['lang'];
  $site = $_SESSION['site'];

  if(!$categories) $categories=getCategoryList();

  $categorylist = "<table class=\"category\"> <tr>";
  if($_SIWIKI['category'] == "Home") $class="class=\"selected\""; 
  else $class=""; 

  $categorylist .=<<<_HTML
  <td $class><a href="$top_dir/_$site/$lang/Home/index.html">Home</a></td>
_HTML;

  if($categories){
    foreach($categories as $c){
      if($c == "Home") continue;
      if($c == $_SIWIKI['category']) $class="class=\"selected\""; 
      else $class=""; 
      $name = $c;
      $categorylist .=<<<_HTML
    <td $class><a href="$top_dir/_$site/$lang/$c/index.html">$name</a></td>
_HTML;
    }
  }
  $categorylist .= "</tr></table>";

  return $categorylist;
}

////////////////////////////////////////////
// Save content
function save_content($filename, $wiki){
  $res = false;
  $fp = fopen($filename, "w+");
  if(! $fp){ return $res; }
  if(flock($fp, LOCK_EX)){
     $res = fwrite($fp, $wiki);
     flock($fp,LOCK_UN);
  }
  fclose($fp);
  return $res;
}


////////////////////////////////////////////
// Check administrator (not use...)
//
function is_admin_site($ip_list){
  if(!is_array($ip_list)) return false;
  foreach($ip_list as $ip){
    if(strncmp($_SERVER['REMOTE_ADDR'], $ip, strlen($ip)) == 0) return true;
  }
  return false;
}

////////////////////////////////////////////
// return absolute path
//
function WikiDir($type="documents", $category="", $page=""){
  global $_SIWIKI;

  if(!$category){
    if($type=="images"){
      $dir = $_SERVER['DOCUMENT_ROOT'].$_SIWIKI['top']."/images";
    }else if($type=="themes"){
      $dir = $_SERVER['DOCUMENT_ROOT'].$_SIWIKI['top']."/themes";
    }else if($type=="top"){
      $dir = $_SERVER['DOCUMENT_ROOT'].$_SIWIKI['top'];
    }else{
      $dir = $_SIWIKI['wiki_dir']."/$type";
    }
  }else if(!$page){
    $dir = $_SIWIKI['wiki_dir']."/$type/$category";
  }else{
    $dir = $_SIWIKI['wiki_dir']."/$type/$category/$page";
  }

  return $dir;
}

function SiWikiDir($dir=""){
  global $_SIWIKI;
  if(!$dir)
    return $_SERVER['DOCUMENT_ROOT'].$_SIWIKI['top'];
  else
    return $_SERVER['DOCUMENT_ROOT'].$_SIWIKI['top']."/".$dir;
}

///////////////////////////////////////////
///  Configuration
//
function save_config($_Config, $conf="siwiki.conf"){
  global $_SIWIKI;

  $top = SiwikiDir("etc");
  $conf = $top."/".$_SIWIKI['site'].".".$conf;

  $s = serialize($_Config);
  $fp = fopen($conf, "w");
  if( !$fp ){
     print "File Open Error:".$conf;
     return;
  }
  $res = fwrite($fp, $s);
  fclose($fp);
}

function load_config($conf="siwiki.conf"){
  global $_SIWIKI;

  $top = SiwikiDir("etc");
  $conf = $top."/".$_SIWIKI['site'].".".$conf;
  if(file_exists($conf)){
    $s = implode("", @file($conf));
    $_Config = unserialize($s);
    foreach(array_keys($_Config) as $key){
      $_SIWIKI[$key] = $_Config[$key];
    }
  }
}

function delete_config($conf="siwiki.conf"){
  global $_SIWIKI;

  $top = SiwikiDir("etc");
  $conf = $top."/".$_SIWIKI['site'].".".$conf;

  if(file_exists($conf)){
    unlink($conf);
  }
}

////////////////////////////////////////////
////// load/save array
function save_array_to_file($array, $file){
  $fp = fopen($file, "w");
  if( !$fp ){
     print "File Open Error:".$file;
     return;
  }
  $res = fwrite($fp, serialize($array));
  fclose($fp);
}

function load_array_from_file($file){
  if(file_exists($file)){
    $s = implode("", @file($file));
    return unserialize($s);
  }
  return false;
}

///////////////////////////////////////////
////// News and Comment
//
// create comment form for News
function comment_form($pagename, $x, $type="comment", $data=""){
  global $_SIWIKI;
  $postdate = $x;
  $id="";
  if($data['title'])
    $comment_title= $data['title'];
  if($data['postdate'])
    $postdate= $data['postdate'];
  if($data['owner'])
    $owner = $data['owner'];
  if($data['contents'])
    $comment = $data['contents'];
  if($data['type'])
    $type = $data['type'];
  if($data['page'])
    $pagename = $data['page'];
  if($data['rowid'])
    $id= $data['rowid'];

  if(!$pagename)  $pagename=$_SIWIKI['category']."/".$_SIWIKI['pagename'];

  $str =<<<_HTML
<form action="$thisFile" method="post">
_HTML;

  if(!$postdate){
    $postdate = date('Y-m-d');
    $str .= "<input type=\"hidden\" name=\"postdate\" value=\"$postdate\">";
  }else{
    $str .= "Date:<input type=\"text\" name=\"postdate\" value=\"$postdate\" size=\"10\">";
  }
  $str .=<<<_HTML
Title:<input type="text" name="comment_title" value="$comment_title">
_HTML;

   $str .=<<<_HTML
Name:<input type="text" name="uid" value="$owner"><br>
<textarea name="comment" cols="80" rows="10">$comment</textarea><br>
<input type="text" name="pagename" value="$pagename">
<input type="hidden" name="type" value="$type">
<input type="hidden" name="id" value="$id">
<input type="hidden" name="sub" value="editComment">
<input type="submit" name="cmd" value="Input">
<input type="reset" name="cmd" value="Clear">
</form>
_HTML;

  return $str;
}

/////////////////////////////////////////////
// News selector...
function show_comment_form($page){
   $str .=<<<_HTML
<form action="$thisFile" method="post">
<input type="hidden" name="page" value="$page">
<input type="hidden" name="sub" value="editComment">
<input type="submit" name="cmd" value="show news">
<input type="submit" name="cmd" value="show comment">
</form>
_HTML;

  return $str;
 }

//////////////////////////////////////////////////////////
// News view ( for '#news' command)
function getNews($db, $page="index", $lang="",  $start=0, $upto=5, $limit='', $editable=true, $close=false){
  global $_SIWIKI, $thisFile;

  if(!$start) $start=0;
  if($lang){
     $sel_lang = " and lang='".$_SESSION['lang']."'";
  }else{
     $sel_lang = "";
  }
  if(!$limit) $limit = date('Y-m-d H:i:s', time() - 31536000);
  $now = date('Y-m-d H:i:s');

  if($page == "all"){
    $sqlstr = "select rowid,* from news where type='news' $sel_lang and uptime > '$limit' order by postdate DESC ;";
  }else{
    $sqlstr = "select rowid,* from news where type='news' $sel_lang and page='$page' and uptime > '$limit' order by postdate DESC ;";
    $sqlstr2 = "select rowid,* from news where type='news' $sel_lang and page='$page' and uptime > '$limit' and postdate > '$now' order by postdate DESC ;";
  }

  $result = $db->sql_request($sqlstr);
  $result2 = $db->sql_request($sqlstr2);
  $num = $result->num -$result2->num;

  if(!$upto) $upto=5;
  $pages = ceil($num / $upto);
  $str = "";
  $page_index = pageIndex($start, $pages, 10, $editable);
  $str = $page_index."<p>";
  $s_idx = $start*$upto+$result2->num;
  $end = $s_idx+$upto;

  if($result2->num){
    $str .= "<div style=\";width:100%;\">";
    $str .= "<!-- getNews -->\n";
    $str .= "<div style=\"float:left;width:49%;\"> <b>News</b><hr>";
    $str .= "<!-- News(left column) -->\n";
  }
  for($i=$s_idx;$i<$result->num && $i<$end;$i++){
    $data=$result->fetchArray($i);
    $str .= showNews($data, $editable, $close);
  }

  if($result2->num){
    $str .= "</div>";
    $str .= "<!--END: News(left column) -->\n";
    $str .= "<div style=\"float:right;width:49%;margin-left:-20px;\"><b>Upcoming Events</b><hr>";
    $str .= "<!-- Upcoming Event(right column) -->\n";
    for($i=$result2->num;$i>0;$i--){
      $data=$result2->fetchArray($i-1);
      $str .= showNews($data, $editable, $close);
    }
    $str .= "</div>";
    $str .= "<!-- END: Upcoming Event(right column) -->\n";
    $str .= "<div style=\"clear:both;\"></div>\n";
    $str .= "</div>";
    $str .= "<!-- END:getNews -->\n";
  }
   return $str;
}

/////////////////////////////////////////////////////////////
//   create page index ....
//
function pageIndex($s_page, $pages, $max_entry=10, $editable=false){
  global $_SIWIKI;

  if($pages < 2) return "";
  $page_index ="";
  if($pages - $s_page > $max_entry) $start_idx = $s_page;
  else $start_idx = $pages - $max_entry;

  if($start_idx < 0) $start_idx = 0;
  if($start_idx > 0){
    $n=$s_page-1;
    if($n < 0) $n = 0;
    if($editable)
      $link = "$thisFile?page=$n&pagename=".$_SIWIKI['category']."/".$_SIWIKI['pagename'];
    else
      $link = getStaticPage($_SESSION['lang'], $_SIWIKI['category'], $_SIWIKI['pagename'].".html&page=$n");
    $page_index .=" <a href=\"$link\">Prev</a> ";
  }

  for($i=$start_idx;$i<$pages && $i < $max_entry;$i++){
    $x=$i+1;
    if($s_page == $i)  $page_index .=" $x ";
    else{
      if($editable)
        $link = "$thisFile?page=$i&pagename=".$_SIWIKI['category']."/".$_SIWIKI['pagename'];
      else
        $link = getStaticPage($_SESSION['lang'], $_SIWIKI['category'], $_SIWIKI['pagename'].".html&page=$i");
       $page_index .=" <a href=\"$link\">$x</a> ";
     }
  }

  if($start_idx < $pages && $pages > $s_page+1){
    $n = $s_page+1;

    if($editable)
      $link = "$thisFile?page=$n&pagename=".$_SIWIKI['category']."/".$_SIWIKI['pagename'];
    else
      $link = getStaticPage($_SESSION['lang'], $_SIWIKI['category'], $_SIWIKI['pagename'].".html&page=$n");
    $page_index .=" <a href=\"$link\">Next</a> ";
  }
   return "<div align=\"right\">$page_index</div>";
}

/////////////////////////////////////////////////////////////////
// News view: called by getNews()
//
function showNews($data, $editable=true, $close=false){
  global $_SIWIKI;

  $thisFile = getStaticPage($_SESSION['lang'], $_SIWIKI['category'], $_SIWIKI['pagename'], 'editComment');
  $str="";
  $id=$data['rowid'];
  $str .= "<h2 class=\"date\">".formatDate($data['postdate']);
  if($editable){
    $str .= "<a href=\"$thisFile&cmd=edit_comment&id=$id\"><img src=\"".$_SIWIKI['top']."/images/pencil-small.png\"></a>";
   }
   $str .= "<span style=\"line-height:10px;margin-left:20;\">".$data['title']."</span>";
   $str .= "</h2>";
   if($close) $disp = " style=\"display:none;\" ";
   else $disp = "";
   $str .= "<div class=\"news\" $disp>";
   if($editable) $str .= "<br><b>記載日:".$data['uptime'].", 投稿者:".$data['owner']."</b>";
   $str .= siwiki($data['contents']);
   $str .= "</div>";

  return $str;
}

///////////////////////////////////////////////////////////////////////
// getComment : This is an old version of 'getNews'.
//      Not use...
function getComments($db, $type='', $page="", $lang = "", $start=0, $upto=10, $limit=''){
  global $_SIWIKI, $thisFile;
  $editable=true;
  $page_sel="";

  if($lang) $sel_lang = " and lang='".$_SESSION['lang']."'";
  else $sel_lang = "";

  if(!$limit) $limit = date('Y-m-d H:i:s', time() - 86400*365);
  if($page) $page_sel = " and page='$page' ";
  if(!$type)
    $sqlstr = "select rowid,* from news where uptime > '$limit' $page_sel $sel_lang order by postdate DESC ;";
  else
    $sqlstr = "select rowid,* from news where type='$type' $page_sel $sel_lang and uptime > '$limit' order by postdate DESC ;";

  $result = $db->sql_request($sqlstr);
  $num = $result->num;
  $str = "";
  $end = $start+$upto;
  for($i=$start;$i<$num && $i<$end;$i++){
    $data=$result->fetchArray($i);
    $str .= showComment($data, $editable);
  }
  return $str;
}

/////////////////////////////////////////////////////////////////////////
// create comments view, but not used...
function getPageComments($db, $page, $lang=""){
  global $_SIWIKI, $thisFile;
  $editable=true;

  if($lang) $sel_lang = " and lang='".$_SESSION['lang']."'";
  else $sel_lang = "";

  $sqlstr = "select rowid,* from news where type='comment' and page='$page' $sel_lang and uptime > '$limit' order by postdate ASC ;";

  $result = $db->sql_request($sqlstr);
  $num = $result->num;
  $str = "";
  $end = $start+$upto;
  for($i=$start;$i<$num && $i<$end;$i++){
    $data=$result->fetchArray($i);
    $str .= showComment($data, $editable);
  }
  return $str;
}

/////////////////////////////////////////////////////////////////////
//  show Comment.
function showComment($data, $editable=true){
  $str="";
  $id=$data['rowid'];
  if($data['type']=="news") {
    $str .= "<h2 class=\"date\">".formatDate($data['postdate']);
    if($editable){
      $str .= "<a href=\"$thisFile?sub=edit_comment&id=$id\"><img src=\"images/pencil-small.png\"></a>";
    }
    $str .= "</h2>";
    $str .= "<div class=\"news\"><h4>".$data['title']."</h4>";
  }else{
    $str .= "<div class=\"comment\"><h4>".$data['title'];
    if($editable){
      $str .= "<a href=\"$thisFile?sub=edit_comment&id=$id\"><img src=\"images/pencil-small.png\"></a>";
    }
    $str .= "</h4>";
  }
  $str .= "<b>記載日:".$data['uptime'].", 投稿者:".$data['owner']."</b>";
  $str .= siwiki($data['contents']);
  $str .= "</div>";

  return $str;
}

/////////////////////////////////////////////////////////////////////
//  show Comment (old version)
function showComment2($data, $compact=ture, $editable=true){
  $id=$data['rowid'];
  $str = "<h2 class=\"date\">".formatDate($data['postdate']);
  if($editable){
    $str .= "<a href=\"$thisFile?sub=edit_comment&id=$id\"><img src=\"images/pencil-small.png\"></a>";
  }
  $str .= "</h2>";
  $str .= "<div class=\"comment\"><h4>".$data['title']."</h4>";
  $str .= "<b>記載日:".$data['uptime'].", 投稿者:".$data['owner']."</b><br>";
  $lines = explode("\n",$data['contents']);
  $str .= siwiki($lines[0]);
  if(count($lines) > 1){
    $str .= "<a href=\"#\">[[続きを見る]]</a>";
  }
  $str .= "</div>";

  return $str;
}

/////////////////////////////////////////////////////////////////////
// database access helper function for 'news' table
//
//  data input
function insertComment($db, $type, $owner, $postdate, $page, $referer, $title, $comment, $id=""){
  $now = date('Y-m-d H:i:s');
  $postdate = date('Y-m-d', strtotime($postdate));
  $lang = $_SESSION['lang'];
  if($owner && $title && $type){
    if($id){
      if(!$comment){
        $sqlstr = "delete from news where rowid=$id;";
      }else{
        $sqlstr = "update news set type='$type',owner='$owner',postdate='$postdate',uptime='$now', page='$page',referer='$referer', title='$title',contents='$comment', lang='$lang' where rowid=$id;";
      }
    }else{
      $sqlstr = "insert into news values('$type','$owner','$postdate', '$now','$lang','$page','$referer', '$title', '$comment');";
    }
    $db->sql_request($sqlstr);
  }
}

/// get data by oid.
function getCommentById($db, $id){
  if(!$id) return "";
   $sqlstr = "select rowid,* from news where rowid='$id';";
   $result = $db->sql_request($sqlstr);
   if($result){
     $data=$result->fetchArray(0);
     return $data;
   }
   return "";
}

//////////////////////////////////////////////////////////////
// Access Log
//
function logfilelist($cat, $page, $lang){
  $dir=WikiDir('documents', $cat, $page);
  $logdir = $dir."/log_".$lang;

  $files = array();
  if(!file_exists($logdir)) return array($logdir,$files);
  $fp = opendir($logdir);
  while( $fname = readdir($fp)){
    if($ff = getDateFromLogname($fname)){
      $files[] = $fname;
    }
  }
  closedir($fp);

  sort($files);
  return array($logdir,$files);
}

function getDateFromLogname($fname, $flag=false){
   $pattern = '/access_([\w\-]+)\.log/';
   $count = preg_match_all($pattern , $fname, $match);
   if($count){
      return  $match[1][0];
   }
   return "";
}

//////////////
function historyfilelist($cat, $page, $lang){
  $dir=WikiDir('documents', $cat, $page);
  $histdir = $dir."/hist_".$lang;

  $files = array();
  if(!file_exists($histdir)) return array($histdir,$files);
  $fp = opendir($histdir);
  while( $fname = readdir($fp)){
    if($fname{0} != '.') $files[] = $fname;
  }
  closedir($fp);

  sort($files);
  return array($histdir,$files);
}
///////////////////////////////////////
// AccessCounter
//
function access_counter($dirname, $date="all", $maxcount=10){
  $today = date('Y-m-d');
  $lang = $_SESSION['lang'];

  $logdir =  $dirname."/log_$lang";
  if(!file_exists($logdir)) return "NO_LOG";

  $countfile =  $logdir."/access_total.txt";

  switch($date){
    case "today":
      $date = date('Y-m-d');
      $logfile =  $logdir."/access_$date.log";
      if(!file_exists($logfile)){
        $no = 0;
      }else{
        $d = file($logfile);
	$no = count($d);
      }
      break;
    case "yesterday":
      $date = date('Y-m-d', time() - 86400);
      $logfile =  $logdir."/access_$date.log";
      if(!file_exists($logfile)){
        $no = 0;
      }else{
        $d = file($logfile);
	$no = count($d);
      }
      break;
    default:
      $logfile =  $countfile;
      $d = file($countfile);
      $no=trim($d[0]);
      break;
  }


  $ct = "$no";
  for($e =0; $e < $maxcount; $e++){
    if($ct[$e] == ""){
      $no = "0$no";
    }
  }
  return "$no";
}

function record_access_count($dirname){
  $today = date('Y-m-d');
  $lang = $_SESSION['lang'];

  $logdir =  $dirname."/log_$lang/";
  if(!file_exists($logdir)) mkdir($logdir);

  $logfile =  $logdir."/access_$today.log";
  $countfile =  $logdir."/access_total.txt";

  $getip = $_SERVER['REMOTE_ADDR'];
  $agent = $_SERVER['HTTP_USER_AGENT'];

  $recorded = false;
  if(file_exists($countfile)){
    $counts = file($countfile);
    $no=trim($counts[0]);
  }else{
    $no=0;
  }

  if(file_exists($logfile)){
    $fp = fopen($logfile, "r");
    while(($d = fgets($fp))){
      $data = explode("|", $d);
      if(!$recorded){
        if( !strcmp($today,$data[3]) && !strcmp($getip,$data[2]) && !strncmp($agent,$data[6],strlen($agent))){
          $recorded = true;
	  break;
        }
      }
    }
    fclose ($fp);
  }

  if(!$recorded){
    $no++;
    $tt = date('H;i;s');
    $dat = "|$no|$getip|".date('Y-m-d')."|".$tt."|".$_SERVER['HTTP_REFERER']."|"
.$_SERVER['HTTP_USER_AGENT']."|\n";
    $fp = fopen($logfile, "a+");
    flock($fp,LOCK_EX);
    fwrite($fp,$dat);
    flock($fp,LOCK_UN);
    fclose ($fp);

    $fp = fopen($countfile, "w+");
    flock($fp,LOCK_EX);
    fwrite($fp,$no);
    flock($fp,LOCK_UN);
    fclose ($fp);

  }
  return $no;
}
///////////////////////////////////////
//
function mkContentTree($data){
  $fnames = array_keys($data);
  foreach($fnames as $f){
    $tree[$data[$f]['parent']][$f] = $data[$f]['weight'];
  }
  $p = array_keys($tree);
  foreach($p as $f){
   asort($tree[$f]);
  }
  return $tree;
}

///////////////////////////////////////
//
function getContentTree($data, $pagename){
  global $_SIWIKI;
  $n = count($data);
  $tree = mkContentTree($data);
  $stack[] = $f = $pagename;
  $str = getWikiName2($f);

  for($i=0;$i < $n;$i++){
    if($data[$f]['parent'] == '/' || !$data[$f] || array_search($data[$f]['parent'], $stack) !== false) break;
    $f=$data[$f]['parent'];

    $str = mkWikiLink($f)." >> ".$str;

    $stack[] = $f;
  }
  return $str;
}

///////////////////////////////////////
//
function getContentIndex($data, $pagename){
  $tree = mkContentTree($data);
  $up = $data[$pagename]['parent'];
  $lst = $tree[$up];
  $prev = $next = "";

  while($lst){
    if(key($lst) == $pagename){
      next($lst);
      if($lst) $next = key($lst);
      break;
    }
    $prev = key($lst);
    next($lst);
  }
  if($up == "/") $up ="";

  $res['up']   = $up;
  $res['prev'] = $prev;
  $res['next'] = $next;

  return $res;

}

///////////////////////////////////////
//
function load_contexts_tree($category = ""){
  global $_SIWIKI;
  if(!$category) $category = $_SIWIKI['category'];

  $filenames =  getFileList(WikiDir(), $category);
  $ff = WikiDir('documents', $category)."/tree.txt";
  $data =load_array_from_file($ff);
  foreach($filenames as $k){
    if(!$data[$k]['weight']) $data[$k]['weight'] = 10;
    if(!$data[$k]['parent']) $data[$k]['parent'] = 'index';
  }

  return $data;
}

///////////////////////////////////////
//
function save_context_tree($data, $category=""){
  global $_SIWIKI;
  if(!$category) $category = $_SIWIKI['category'];
  $filenames =  getFileList(WikiDir(), $category);
  $ff = WikiDir('documents', $category)."/tree.txt";

  if(!file_exists($ff)){
    foreach($filenames as $k){
      $data[$k]['weight'] = 10;
      $data[$k]['parent'] = 'index';
    }
  }
  save_array_to_file($data, $ff);
}


///////////////////////////////////////
// getUserLevel
define("SYSTEM_ADMIN", 10);
define("SITE_ADMIN", 9);
define("POWER_USER", 8);
define("AVARAGE_USER", 7);
define("LIMITED_USER", 6);
define("GUEST_USER", 5);

function str2level($str){
  if($str=="SYSTEM_ADMIN") return SYSTEM_ADMIN;
  if($str=="SITE_ADMIN") return SITE_ADMIN;
  if($str=="POWER_USER") return POWER_USER;
  if($str=="AVARAGE_USER") return AVARAGE_USER;
  if($str=="LIMITED_USER") return LIMITED_USER;
  if($str=="GUEST_USER") return GUEST_USER;

  return 0;
}

function get_user_level($uid=""){
  if(is_system_admin($uid)) return SYSTEM_ADMIN;
  else return check_user($uid);
}
///////////////////////////////////////
// Check systemm admin passwd
function is_system_admin($uid=""){
  if(!$uid) $uid=$_SESSION['uid'];
  if(!$uid) return false;
  $val = check_user($uid, "", "system");
  if($val == SYSTEM_ADMIN) return true;
  return false;
}


///////////////////////////////////////
// Check login user
//
function check_user($uid="", $passwd="", $db_pos="site"){
  global $_SIWIKI;

  $res = 0;
  if(!$uid) { $uid = $_SESSION['uid']; }
  if(!$uid) return 0;

  $db = open_database($db_pos);
  if(!$db->tableExists("user_table")) return -3;

  $result = $db->sql_request("select * from user_table where uid='$uid';");

  if($result->num > 0){
    $__tally = $result->getValue(0, 'session');
    $type = $result->getValue(0, 'type');
    if($_SESSION['tally'] && ($_SESSION['tally'] == $__tally)){
      $res = $type;
    }else{

      if($passwd){

        $__passwd = $result->getValue(0, 'passwd');
        $crypt_passwd = md5($passwd);
        if(!$result->getValue(0,'name')){
          $res = -1;
	}else if($__passwd == $crypt_passwd){
          $_SESSION['tally'] = $tally = md5($_SERVER['REMOTE_ADDR'].$_SERVER['USER_AGENT'].$uid.$crypt_passwd);
          $result = $db->sql_request("update user_table set session='$tally' where uid='$uid';");
          $_SESSION['uid'] = $uid;
          $res = $type;
        }

      }

    }
  }else{
    $res = -2;
  }
  $db->connect();

  return $res;
}

//////////////////////////////////
//  get_user from sitedb
function get_user($type=""){
  global $_SIWIKI;

  $res=false;
  $sqlstr = "select * from user_table";
  if($type) $sqlstr .= " where type='$type';";
  else $sqlstr .= ";";

  $db = open_database('site');
  $result = $db->sql_request($sqlstr);
  if(!$result) return $res;

  for($i=0;$i < $result->num; $i++){
    $res[$i] = $result->fetchArray($i);
  }
  $db->connect();

  return $res;
}

//////////////////////////////////
// registrerUser to default sitedb
function registerUser($uid, $passwd,$level=0){
  global $_SIWIKI;

  $res=false;
  $db = open_database('site');
  $date = date('Y-m-d H:i:d');
  $crypt_passwd=md5($passwd);
  if($uid && $passwd){
    $result = $db->sql_request("delete from user_table where uid='$uid';");
    $result = $db->sql_request("insert into user_table values('$uid', '', '$crypt_passwd', '','$level','','$date');");
    $res = true;
  }
  $db->close();

  return $res;
}

//////////////////////////////////
// activateUser to default sitedb
function activateUser($uid){
  global $_SIWIKI;

  $db = open_database('site');
  $date = date('Y-m-d H:i:d');
  if($uid){
    $result = $db->sql_request("update user_table set name='$uid' where uid='$uid';");
  }
  $db->close();
}

//////////////////////////////////
// set_user_type to default sitedb
function set_user_type($uid,$type){
  global $_SIWIKI;

  $db = open_database('site');
  $date = date('Y-m-d H:i:d');
  if($uid){
    $result = $db->sql_request("update user_table set type='$type' where uid='$uid';");
  }
  $db->close();
}

//////////////////////////////////
// delete_user 
function del_user_id($uid){
  global $_SIWIKI;

  $db = open_database('site');
  $date = date('Y-m-d H:i:d');
  if($uid){
    $result = $db->sql_request("delete from user_table where uid='$uid';");
  }
  $db->close();
}

//////////////////////////////////////
//  Login Prompt: this function doesn't use...
function loginPrompt($action, $uid, $passwd, $stat=0,$type=1){
  $site = $_SESSION['site'];
  $str = "";
  if($stat > 0){
    $str =<<<_HTML
<form action="$action" method="post" name="loginPrompt">
<input type="hidden" name="site" value="$site">
<input type="hidden" name="ajax" value="1">
Type:<input type="text" name="type" value="$type"><br>
<input type="submit" name="cmd" value="logout">
<input type="submit" name="cmd" value="list">
<input type="submit" name="cmd" value="set_type">
  </form>
_HTML;
  }else{

    $str =<<<_HTML
<form action="$action" method="post" name="loginPrompt">
<input type="hidden" name="site" value="$site">
<input type="hidden" name="ajax" value="1">
<input type="text" name="uid" value="$uid"><br>
<input type="password" name="passwd" value="$passwd"><br>
<input type="submit" name="cmd" value="login">
<input type="submit" name="cmd" value="list">
_HTML;

    if($stat == -2){
      $str .= "<input type=\"submit\" name=\"cmd\" value=\"register\">";
    }else if($stat == -1){
      $str .= "<input type=\"submit\" name=\"cmd\" value=\"activate\">";
    }
   $str .= "</form>";
  }

  return $str;
}

//////////////////////////////////////
//  Login Prompt for editUser.php
function loginPrompt2($action, $uid, $passwd, $stat=0,$type=1){
  $site = $_SESSION['site'];
  $str = "";
  if($stat > 0){
    $str =<<<_HTML
<form action="$action" method="post" name="loginPrompt">
<input type="hidden" name="site" value="$site">
<input type="hidden" name="sub" value="editUser">
Type:<input type="text" name="type" value="$type"><br>

<input type="submit" name="cmd" value="logout">
<input type="submit" name="cmd" value="list">
<input type="submit" name="cmd" value="set_type">
<input type="submit" name="cmd" value="delete">
  </form>
_HTML;
  }else{

   if($type == 10) $select1=" selected";
   else if($type == 9) $select2=" selected";
   else if($type == 8) $select3=" selected";
   else if($type == 7) $select4=" selected";
   else if($type == 6) $select5=" selected";
   else if($type == 5) $select6=" selected";
   else $select7=" selected";

    $str =<<<_HTML
<form action="$action" method="post" name="loginPrompt">
<input type="hidden" name="site" value="$site">
<input type="hidden" name="sub" value="editUser">
<table style="border: 1px solid black;">
<tr><td class="config">UID:</td><td><input type="text" name="uid" value="$uid"></td></tr>
<tr><td class="config">PASSWD:</td><td><input type="password" name="passwd" value="$passwd"></td></tr>
<tr><td class="config">Type:</td><td>
<select name="type">
<option value="10" $select1>System Admin
<option value="9" $select2>Site Admin
<option value="8" $select3>Power User
<option value="7" $select4>Average User
<option value="6" $select5>Limited User
<option value="5" $select6>Guest User
<option value="0" $select7>Disactivate
</select>
</td></tr>
</table>
<input type="submit" name="cmd" value="login">
<input type="submit" name="cmd" value="logout">
<br>
<input type="submit" name="cmd" value="list">
<input type="submit" name="cmd" value="set_type">
<input type="submit" name="cmd" value="delete">
_HTML;

//    if($stat == -2){
      $str .= "\n<input type=\"submit\" name=\"cmd\" value=\"register\">";
//    }else if($stat == -1){
      $str .= "\n<input type=\"submit\" name=\"cmd\" value=\"activate\">";
//    }

   $str .= "</form>";
  }

  return $str;
}

//////////////////////////////////
// loginPrompt_ajex
function loginPrompt_ajax($url, $uid, $passwd, $stat=0){
  global $_SIWIKI;

  $fname=$_SIWIKI['pagename'];
  $category=$_SIWIKI['category'];
  $site = $_SIWIKI['site'];

  $str = "";
  if($stat >0){
    $str =<<<_HTML
<center>
  <form name="loginPrompt">
  <input type="button" name="cmd" value="logout" onClick="logoutSiwiki('$url','login','$fname','$category','$site');">
  </form>
</center>
_HTML;
  }else{
    $str =<<<_HTML
<center>
<form name="loginPrompt">
Login Siwiki<br>
<input type="text" id="uid" value="$uid"><br>
<input type="password" id="passwd" value="$passwd"><br>
<input type="button" value="Login" onClick="loginSiwiki('$url',getElementValueById('uid') ,getElementValueById('passwd'), 'login','$fname','$category','$site');" >
</form>
</center>
_HTML;
  }
  return $str;
}

/////////////////////////////////
// login form for ajax
function login_form(){
  global $_SIWIKI;

  $loginScript=$_SIWIKI['top']."/loginout.php";
  $uid = $_SESSION['uid'];
  $page = $_SIWIKI['pagename'];
  $cate = $_SIWIKI['category'];
  $site = $_SIWIKI['site'];

  $login =<<< _HTML
  <script type="text/javascript">
    window.onload=function(){ loginSiwiki('$loginScript','$uid','','login','$page','$cate','$site'); }
 </script>
_HTML;

  return $login;
}

/////////////////////////////////
// load all plugin files
function load_plugins(){
  global $_SIWIKI;
  $dir=$_SERVER['DOCUMENT_ROOT'].$_SIWIKI['top']."/programs/plugins";

  $fp = opendir($dir);
  while( $fname = readdir($fp)){
   $pattern = '/^([\w\-]+)\.php$/';
   $count = preg_match($pattern , $fname, $match);
   if($count){
      include_once($dir."/".$fname);
    }
  }
  closedir($fp);
}

/////////////////////////////////
//  jump page
function jumpUrl($url){
  $str = <<<_HTML
Click <a href="$url">here</a>
<script type="text/javascript"> location.href = "$url"; </script>
_HTML;
  return $str;
}

/////////////////////////////////
//  open database 
function open_database($path = "page"){
  global $_SIWIKI;

  if($path=="system"){
    $dir = $_SERVER['DOCUMENT_ROOT'].$_SIWIKI['top']."/site";
    return OpenDB("siwiki.db", $dir);
  }
  if($path=="site"){
    $dir = $_SIWIKI['wiki_dir'];
  }else if($path=="category"){
    $dir = WikiDir('documents', $_SIWIKI['category']);
  }else{
    $dir = WikiDir('documents', $_SIWIKI['category'], $_SIWIKI['pagename']);
  }

  return OpenDB($_SIWIKI['dbname'], $dir);
}

/////////////////////////////////
//  tag of post form 
function form_post($page=""){
  $action=getCurrentPage($page);
  $str =<<<_HTML
<form action="$action" method="POST">

_HTML;
  return $str;
}

/////////////////////////////////
//  tag of textarea form 
function form_textarea($name, $info, $cols=80,$rows=10){
  $str =<<<_HTML
<textarea name="$name" cols="$cols" rows="$rows">$info</textarea>

_HTML;
  return $str;
}

/////////////////////////////////
//  tag of input form 
function form_input($name, $val, $type="text", $size=0, $src=""){
  $sizestr="";
  if($size > 0) $sizestr = " size=\"$size\"";
  if($src) $srcstr = " src=\"$src\"";

  $str =<<<_HTML
<input type="$type" name="$name" value="$val"$sizestr$srcstr>

_HTML;
  return $str;
}

/////////////////////////////////
//  tag of select form 
function form_select($name, $vals, $default_val=""){
  $str ="<select name=\"$name\">\n";
  while($x = current($vals)){
     $k = key($vals);
     if(is_int($k)){ $k = $x; }
     if($default_val == $k) $selected=" selected";
     else $selected ="";
       
     $str .="<option value=\"$k\"$selected>$x\n";
     next($vals);
  }
  $str .="</select>\n";

  return $str;
}

///////////////////////////////////////
//
function mkSelector(&$info, $name, $val=""){
  $form = "<select name=\"$name\">";
  foreach($info as $v){
    if($val == $v) $form .= "<option value=\"".$v."\" selected>".getWikiName2($v);
    else $form .= "<option value=\"".$v."\">".getWikiName2($v);
  }
  $form .= "</select>";
  return $form;
}

///////////////////////////////////////
//
function mkSelector2(&$info, $name, $val="", $nosel=""){
  $form = "<select name=\"$name\">";
  $form .= "<option value=\"$nosel\">".$nosel;
  foreach($info as $v){
    if($val == $v) $form .= "<option value=\"".$v."\" selected>".getWikiName2($v);
    else $form .= "<option value=\"".$v."\">".getWikiName2($v);
  }
  $form .= "</select>";
  return $form;
}

///////////////////////////////////////
// shorten a long string
function str_shorten($str, $len=10){
  $res = $str;
  $ll = strlen($str);
  if($ll > $len + 12){
    $res = substr($str,0, $len)."_[".$ll."]_".substr($str, $ll-6, 5);
   } 
  return $res;
}

///////////////////////////////////////
// remove directory
function remove_dir_all($dir){
  if(!file_exists($dir)) return;
  if(!is_dir($dir)){
    if(!unlink($dir)) print "ERROR: unlink ".$dir;
    return;
  }
  $fp = opendir($dir);
  while( $fname = readdir($fp)){
    if($fname != "." && $fname != ".."){
      remove_dir_all($dir."/".$fname);
    }
  }
  closedir($fp);
  rmdir($dir); 
}

///////////////////////////////////////
// get maximum weight for a content tree...
function getMaxWeight($tree, $parent){
  $val=0;
  $keys = array_keys($tree);
  foreach($keys as $k){
    if($tree[$k]['parent'] == $parent){
      $val = max($val, $tree[$k]['weight']);
    }
  }
  return $val+10;
}

///////////////////////////////////////
//  download file
function download_file($file,$fname){
  if(!file_exists($file)) return 0;
  if(!($fp = fopen($file,"r"))) return 0;
  fclose($fp);
  if(($content_len = filesize($file)) == 0) return 0;

  header("Pragma: private");
  header("Cache-control: private, must-revalidate");

  $k_code="UTF-8";

  if(chkBrowser() == "windows"){
   $k_code="SJIS";
  }else{
   $k_code="UTF-8";
  }

  if(chkBrowser() == "safari"){
    header("Content-Disposition: attachment; filename=\"\"");
  }else if(chkBrowser() == "osx"){
    header("Content-Disposition: attachment; filename=\"".mb_convert_encoding($fname,$k_code,"UTF-8,EUC-JP,SJIS")."\"");
  }else{
    header("Content-Disposition: attachment; filename=\"".mb_convert_encoding($fname,$k_code,"SJIS,UTF-8,EUC-JP")."\"");
  }
  header("Content-Type: applicaion/octet-stream");
  header("Content-Length: ".$content_len);

  if(! readfile($file)) return 0;

  return 1;
}

///////////////////////////////////////
//  check the Browser, not enough...
function chkBrowser(){
  if (preg_match("/^DoCoMo/",$_SERVER['HTTP_USER_AGENT'])){
    return "imode";
  }else if(preg_match("/NetFront/",$_SERVER['HTTP_USER_AGENT'])){
    return "netfront";
  }else if(preg_match("/Windows/",$_SERVER['HTTP_USER_AGENT'])){
    return "windows";
  }else if(preg_match("/Mac OS X/",$_SERVER['HTTP_USER_AGENT'])){
    return "osx";
  }else if(preg_match("/Safari/",$_SERVER['HTTP_USER_AGENT'])){
    return "safari";
  }else return "unix";
}

///////////////////////////////////////
//   multi-byte basename ?
function mb_basename($file){
  return end(mb_split("/",$file));
}

///////////////////////////////////////
//   get file list and directory list 
function getFileListAll($dir){
  $files=array();
  $dirs=array();
  if(!file_exists($dir)) return array($files, $dirs);
  $dh = opendir($dir);
  while( $fname = readdir($dh)){
    if($fname != "." &&  $fname != ".."){
      if(is_dir($dir."/".$fname)) array_push($dirs,$fname);
      else array_push($files,$fname);
    }
  }
  closedir($dh);
  return array($files, $dirs);
}

///////////////////////////////////////
//   OpenTable in page.db
function OpenTable($name, $tbl){
  $db = open_database();
  if(!$db->tableExists($name)){ $db->createTable($name,$tbl); }
  return $db;
}

function getTableData($db, $name, $lang="ja", $order="rowid"){
  $sqlstr = "select rowid,* from $name where lang='$lang' order by $order";
  $result = $db->sql_request($sqlstr);
  return $result;
}

function getNextID($db, $name){
  $sqlstr = "select max(rowid)+1 as nextid from $name;";
  $result = $db->sql_request($sqlstr);
  if(!$result) return false;
  if(!$result->getValue(0, 'nextid')) return 1;
  return $result->getValue(0, 'nextid');
}

function existsTableData($db, $name, $data){
  $sqlstr = "select * from $name where $data ;";
  $result = $db->sql_request($sqlstr);
  if($result->num > 0) return true;
  return false;
}

function insertTableData($db, $name, $data){
  $sqlstr = "insert into $name values ($data);";
  $result = $db->sql_request($sqlstr);
  return $result;
}

function updateTableData($db, $name, $data, $id){
 if(!$data) return false;
  $sqlstr = "update $name set $data where rowid=$id;";
  $result = $db->sql_request($sqlstr);
  return $result;
}

function deleteTableData($db, $name, $data){
  $sqlstr = "delete from $name";
  if($data) $sqlstr .= " where ".$data;
  $result = $db->sql_request($sqlstr);
  return $result;
}

///////////////////////////////////////
//   for comment plugin
function OpenCommentDB(){
  $db = open_database();
  $table = "name text, info text, lang text, mdate date, ipaddr text";
  if(!$db->tableExists("comment")){
    $db->createTable("comment",$table);
  }
  return $db;
}

function getCommentData($db, $lang="ja"){
  $sqlstr = "select rowid,* from comment where lang='$lang' order by mdate";
  $result = $db->sql_request($sqlstr);
  return $result;
}

function insertCommentData($db, $uid, $info, $addr, $lang="ja"){
  $now = date('Y-m-d H:i:s');
  $sqlstr = "select * from comment where name='$uid' and info='$info' and lang='$lang' and ipaddr='$addr';";
  $result = $db->sql_request($sqlstr);
  if($result->num > 0) return null;
  $sqlstr = "insert into  comment values ('$uid','$info', '$lang', '$now', '$addr');";
  $result = $db->sql_request($sqlstr);
  return $result;
}

function updateCommentData($db, $oid, $uid, $info, $addr, $lang="ja"){
  $sqlstr = "update comment set name='$uid',info='$info',lang='$lang',ipaddr='$addr' where rowid=$oid;";
  $result = $db->sql_request($sqlstr);
  return $result;
}

function deleteCommentData($db,$oid, $uid, $addr, $lang="ja"){
  if($oid > 0){
    $sqlstr = "delete from comment where rowid='$oid';";
    $result = $db->sql_request($sqlstr);
  }else{
    $sqlstr = "select rowid,* from comment where name='$uid' and lang='$lang' and ipaddr='$addr';";
    $result = $db->sql_request($sqlstr);
    if($result->num > 0){
      $id = $result->getValue($result->num-1, "rowid");
      $sqlstr = "delete from comment where rowid='$id';";
      $result = $db->sql_request($sqlstr);
    }
  }
  return $result;

}

function deleteCommentData2($db, $uid, $lang="ja", $num=1){
  $sqlstr = "select rowid,* from comment where name='$uid' and lang='$lang';";
  $result = $db->sql_request($sqlstr);
  if($result->num > 0){
    for($i=1; $i <= $num ; $i++){
      $id = $result->getValue($result->num-$i, "rowid");
      $sqlstr = "delete from comment where rowid='$id';";
      $result = $db->sql_request($sqlstr);
    }
  }
  return $result;
}

////////////////////////////////
// for downloader plugin 
function OpenDownloadDB(){
  $db = open_database();
  $table = "name text, affiliation text, email text, fname text, mdate date, ipaddr text";
  if(!$db->tableExists("download_log")){
    $db->createTable("download_log",$table);
  }
  return $db;
}

function dropDownloadTable(){
  $db = open_database();
  if($db->tableExists("download_log")){
    $db->dropTable("download_log");
  }
  return $db;
}

function getDownloadData($db){
  $sqlstr = "select rowid,* from download_log order by mdate";
  $result = $db->sql_request($sqlstr);
  return $result;
}

function insertDownloadData($db, $uname, $aff, $email, $fname, $addr){
  $now = date('Y-m-d H:i:s');
  $sqlstr = "insert into download_log values ('$uname','$aff', '$email', '$fname', '$now', '$addr');";
  $result = $db->sql_request($sqlstr);
  return $result;
}


////////////////////////////////
//  ZipArchiver
if(class_exists("ZipArchive")){ include_once("zipfunc.php"); }

////////////////////////////////
//  Archive Tar
if(class_exists("Archive_Tar")){ include_once("tarfunc.php"); }

?>
