<?php

function zipdir($dir, $zipfname, $skip_files=array()){
  $zip = new ZipArchive();

  if(($res=$zip->open($zipfname, ZIPARCHIVE::CREATE) !== TRUE)){
    print "ERROR:".$res. "   fname:".$zipfname;
    return -1;
  }

  $zip->addEmptyDir(basename($dir));
  zipfiles($dir, $zip, basename($dir), $skip_files);

  $zip->close();
  return 1;
}

function match_files($fname, $files){
  foreach($files as $f){
    if(strncmp($fname, $f, strlen($f)) == 0) {
     return true;
    }
  }
  return false;
}

function zipfiles($dir, &$zip, $path, $skip_files=array()){
  $list = getFileListAll($dir);
  $files = $list[0];
  $dirs = $list[1];
  foreach($files as $fname){
    $zip->addFile($dir."/".$fname, $path."/".$fname);
  }
  foreach($dirs as $dname){
    $zip->addEmptyDir($path."/".$dname);
    if(!match_files($dname, $skip_files))
      zipfiles($dir."/".$dname, $zip, $path."/".$dname, $skip_files);
  }
}

function unzip_file($file, $dir){
  $zip = new ZipArchive;
  if($zip->open($file) === TRUE){
    $res = $zip->extractTo($dir);
    $zip->close();
    return $res;
  }
  return false;
}


?>
