<?php
////////////////////
function getDirList ($dirName) {
  global $html,$topDir,$thisFile;
  $d = dir($topDir."/".$dirName);
  while($entry = $d->read()) {
    if ($entry != "." && $entry != "..") {
      if (is_dir($topDir."/".$dirName."/".$entry)) {
        $dir=$dirName.$entry."/";
        $str = "";
        $str .= "[". $html->textLink($thisFile."?sub=rmdir&dirname=$entry","<img src=\"images/DEL_F.png\" border=\"0\" title=\"Delete folder\">","")."]";
        $str .= $html->textLink($thisFile."?dir=$dir", "&nbsp;".$entry,"");
        $dirList[]= $str;
      } else {
        $fname = $entry;
        $thisFile2 = $thisFile."/".$entry;
        $str = "";

        $str .= "[". $html->textLink($thisFile."?sub=delete&file=$fname","<img src=\"images/DEL.png\" border=\"0\" title=\"Delete file\">","")."]";
        $str .= "[". $html->textLink($thisFile."?sub=move&file=$fname","<img src=\"images/MV.png\" border=\"0\" title=\"Move or Rename file\">","")."]";
        $str .= $html->textLink($thisFile2."?sub=download&file=$fname", $entry,"");
        $fileList[]=$str;
      }
    }
  }
  $d->close();
  return array($dirList,$fileList);
} 



//////////////////////////////////////////////////

function download_file($file,$fname){
  if(!file_exists($file)) return 0;
  if(!($fp = fopen($file,"r"))) return 0;
  fclose($fp);
  if(($content_len = filesize($file)) == 0) return 0;

  header("Pragma: private");
  header("Cache-control: private, must-revalidate");

  $k_code="UTF-8";

  if(chkBrowser() == "windows"){
   $k_code="SJIS";
  }

  if(chkBrowser() == "safari"){
    header("Content-Disposition: attachment; filename=\"\"");
  }else{
    header("Content-Disposition: attachment; filename=\"".mb_convert_encoding($fname,$k_code,"SJIS,UTF-8,EUC-JP")."\"");
  }
  header("Content-Type: applicaion/octet-stream");
  header("Content-Length: ".$content_len);

  if(! readfile($file)) return 0;

  return 1;
}

function chkBrowser(){
  if (ereg("^DoCoMo",$_SERVER['HTTP_USER_AGENT'])){
    return "imode";
  }else if(ereg("NetFront",$_SERVER['HTTP_USER_AGENT'])){
    return "netfront";
  }else if(ereg("Windows",$_SERVER['HTTP_USER_AGENT'])){
    return "windows";
  }else if(ereg("Safari",$_SERVER['HTTP_USER_AGENT'])){
    return "safari";
  }else return "unix";
}

function file_upload_error_message($error_code) {
    switch ($error_code) { 
        case UPLOAD_ERR_INI_SIZE: 
            return 'The uploaded file exceeds the upload_max_filesize directive in php.ini'; 
        case UPLOAD_ERR_FORM_SIZE: 
            return 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form'; 
        case UPLOAD_ERR_PARTIAL: 
            return 'The uploaded file was only partially uploaded'; 
        case UPLOAD_ERR_NO_FILE: 
            return 'No file was uploaded'; 
        case UPLOAD_ERR_NO_TMP_DIR: 
            return 'Missing a temporary folder'; 
        case UPLOAD_ERR_CANT_WRITE: 
            return 'Failed to write file to disk'; 
        case UPLOAD_ERR_EXTENSION: 
            return 'File upload stopped by extension'; 
        default: 
            return 'Unknown upload error'; 
    } 
} 

function mb_basename($file){
  return end(mb_split("/",$file));
}


?>
