import java.io.*;
import java.util.*;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

/**
 * ޻̾Ѵơ֥(RomanKanaTable.java)ޤ<BR>
 * ޤơ֥UnicodeͤǥȤԤޤ<BR>
 * <BR>
 * Ȥ: java fuku.skk4j.devel.MakeRomanKanaTable <> <>
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class MakeRomanKanaTable {

    /** ޻̾Ѵơ֥ܳϥإå */
    private static final String _KANA = ";; roman-kana table.";
    /** ȾѴơ֥ܳϥإå */
    private static final String _SYMBOL = ";; half-full width table.";

    /** ޻̾Ѵơ֥ */
    private List _kanaTable = new ArrayList();
    /** ȾѴơ֥ */
    private List _symTable = new ArrayList();


    /**
     * ᥤ᥽åɡ
     *
     * @param args ޥɹ԰
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            return;
        }
        String templateName = args[0] + "/RomanKanaTable.vm";
        String kanatableName = args[0] + "/kanatable.txt";
        String fileName = args[1] + "/RomanKanaTable.java";
        MakeRomanKanaTable myself = new MakeRomanKanaTable();
        myself._load(kanatableName);
        myself._sort();
        myself._prepare();
        myself._store(templateName, fileName);
    }


    /**
     * ǥեȥ󥹥ȥ饯
     *
     */
    private MakeRomanKanaTable() {
        super();
    }


    /**
     * ե뤫Ѵơ֥ɤ߹ߤޤ
     *
     * @param fileName ե̾
     */
    private void _load(String fileName) {
        _kanaTable.clear();
        _symTable.clear();
        List tmp = _kanaTable;
        BufferedReader in = null;
        String line = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(fileName), "EUC_JP"));
            while ((line=in.readLine()) != null) {
                if (line.startsWith(";;") || line.length() == 0) {
                    if (line.equals(_SYMBOL)) {
                        tmp = _symTable;
                    }
                    continue;
                }
                tmp.add(line);
            }
        } catch (IOException e) {
            System.err.println(e.getMessage());
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
    }

    /**
     * ơ֥ޤ
     *
     */
    private void _prepare() {
        List tmp = new ArrayList();
        StringBuffer buff = new StringBuffer();
        Iterator it = _kanaTable.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            StringTokenizer st = new StringTokenizer(str);
            if (st.countTokens() != 3) {
                continue;
            }
            buff.delete(0, buff.length());
            buff.append('{');
            buff.append("\"").append(st.nextToken()).append("\", ");
            buff.append("\"").append(st.nextToken()).append("\", ");
            buff.append("\"").append(st.nextToken()).append("\"");
            buff.append('}');
            if (it.hasNext()) {
                buff.append(',');
            }
            tmp.add(buff.toString());
        }
        _kanaTable.clear();
        _kanaTable = tmp;

        tmp = new ArrayList();
        it = _symTable.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            StringTokenizer st = new StringTokenizer(str);
            if (st.countTokens() != 2) {
                continue;
            }
            buff.delete(0, buff.length());
            buff.append('{');
            buff.append("'").append(st.nextToken()).append("', ");
            buff.append("'").append(st.nextToken()).append("'");
            buff.append('}');
            if (it.hasNext()) {
                buff.append(',');
            }
            tmp.add(buff.toString());
        }
        _symTable.clear();
        _symTable = tmp;
    }

    /**
     * ȷ̤ե˽񤭽Фޤ
     *
     * @param templateName ƥץ졼ȥե̾
     * @param fileName ϥե̾
     */
    private void _store(String templateName, String fileName) {
        // Ϥʤ
        Velocity.setProperty("runtime.log.logsystem.class",
                             "org.apache.velocity.runtime.log.NullLogSystem");
        // Velocityν
        try {
            Velocity.init();
        } catch (Exception e) {
            System.err.println(e);
        }
        // ƥȾκ
        VelocityContext context = new VelocityContext();
        context.put("kanaTable", _kanaTable);
        context.put("symTable", _symTable);

        // ƥȤƤƥץ졼Ȥ˥ޡ¸
        BufferedWriter bw = null;
        try {
            // ƥץ졼Ȥμ
            Template template = Velocity.getTemplate(templateName, "EUC_JP");
            // ϥե
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName), "EUC_JP"));
            if (template != null) {
                template.merge(context, bw);
            }
        } catch (ResourceNotFoundException e) {
            System.err.println(e);
        } catch (ParseErrorException e) {
            System.err.println(e);
        } catch (MethodInvocationException e) {
            System.err.println(e);
        } catch (FileNotFoundException e) {
            System.err.println(e);
        } catch (UnsupportedEncodingException e) {
            System.err.println(e);
        } catch (IOException e) {
            System.err.println(e);
        } catch (Exception e) {
            System.err.println(e);
        } finally {
            if (bw != null) {
                try {
                    bw.flush();
                    bw.close();
                } catch (IOException e) {
                }
            }
        }
    }

    /**
     * ɤ߹Ѵơ֥UnicodeǥȤޤ
     *
     */
    private void _sort() {
        _quickSort(_kanaTable, 0, _kanaTable.size()-1);
        _quickSort(_symTable, 0, _symTable.size()-1);
    }

    /**
     * ɤ߹Ѵơ֥UnicodeǥȤޤ
     *
     * @param list Ѵơ֥
     * @param start ȳϰ
     * @param end Ƚλ
     */
    private void _quickSort(List list, int start, int end) {
        int i = start;
        int j = end;

        if (end > start) {
            String middle = _getRoman(list, (start+end)/2);

            while (i <= j) {
                String low = _getRoman(list, i);
                while (i < end && low.compareTo(middle) < 0) {
                    i++;
                    low = _getRoman(list, i);
                }
                String high = _getRoman(list, j);
                while (j > start && high.compareTo(middle) > 0) {
                    j--;
                    high = _getRoman(list, j);
                }
                if (i <= j) {
                    Collections.swap(list, i, j);
                    i++;
                    j--;
                }
            }

            if (start < j) {
                _quickSort(list, start, j);
            }
            if (i < end) {
                _quickSort(list, i, end);
            }
        }
    }

    /**
     * ǥåǻꤵͤ޻ڤФޤ
     *
     * @param list Ѵơ֥
     * @param idx ǥå
     * @return ǥåǻꤵͤΥ޻
     */
    private String _getRoman(List list, int idx) {
        String str = (String)list.get(idx);
        int i = str.indexOf("\t");
        return str.substring(0, i);
    }
}

// end of MakeRomanKanaTable.java
