package fuku.skk4j.dic;

import java.io.*;

/**
 * 桼ƥƥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class DicUtil {

    /**
     * ǥեȥ󥹥ȥ饯
     *
     */
    private DicUtil() {
        super();
    }


    /**
     * '/', ';'򥨥ʸִޤ
     *
     * @param word ִʸ
     * @return ִ줿ʸ
     */
    public static String replaceEscChar(String word) {
        StringBuffer buf = new StringBuffer(word);
        boolean flag = false;
        int idx = word.indexOf('/');
        while (idx != -1) {
            buf.replace(idx, idx+1, "\\057");
            flag = true;
            idx = buf.toString().indexOf('/', idx+4);
        }
        idx = buf.toString().indexOf(';');
        while (idx != -1) {
            buf.replace(idx, idx+1, "\\073");
            flag = true;
            idx = buf.toString().indexOf(';', idx+4);
        }
        if (flag) {
            buf.insert(0, "(concat \"");
            buf.append("\")");
            return buf.toString();
        }
        return word;
    }

    /**
     * 겾̵̾ͭȽ̤ޤ
     *
     * @param word Ƚ̤ʸ
     * @return ͭξtrue̵ξfalse
     */
    public static boolean isOkuriAri(String word) {
        int i = word.indexOf(' ');
        char lastchar;
        if (i == -1) {
            lastchar = word.charAt(word.length()-1);
        } else {
            lastchar = word.charAt(i-1);
        }
        // ǽʸASCIIʳǡǸʸa-zʤ겾̾ͭ
        if (word.charAt(0) > 0x00ff && lastchar >= 'a' && lastchar <= 'z') {
            return true;
        }
        return false;
    }

    /**
     * ʸ򥨥󥳡ǥ󥰤˽äƼ񼰤Ӥޤ
     *
     * @param str1 ʸ
     * @param str2 ʸ
     * @param enc ʸ󥳡ǥ󥰤̾
     * @return 񼰤˾(str1<str2): -1ʲ
     *                 (str1=str2): 0
     *                 礭(str1>str2): 1ʾ
     */
    public static int compare(String str1, String str2, String enc) {
        int len1 = str1.length();
        int len2 = str2.length();
        int len = Math.min(len1, len2);
        for (int i=0; i<len; i++) {
            String s1 = str1.substring(i, i+1);
            String s2 = str2.substring(i, i+1);
            byte[] v1 = null;
            byte[] v2 = null;
            if (enc != null) {
                try {
                    v1 = s1.getBytes(enc);
                    v2 = s2.getBytes(enc);
                } catch (UnsupportedEncodingException e) {
                    v1 = s1.getBytes();
                    v2 = s2.getBytes();
                }
            } else {
                v1 = s1.getBytes();
                v2 = s2.getBytes();
            }
            int n1 = v1.length;
            int n2 = v2.length;
            if (n1 != n2) {
                return n1 - n2;
            }
            for (int j=0; j<n1; j++) {
                if (v1[j] != v2[j]) {
                    return v1[j] - v2[j];
                }
            }
        }
        return len1 - len2;
    }
}

// end of DicUtil.java
