package fuku.skk4j.dic;

import java.io.*;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;

/**
 * SKKм񥯥饹Ǥ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class ServerDic implements SKKDic {

    /** ǥޥ (ޥ) */
    private static final String _CLIENT_END = "0";
    /** ׵ᥳޥ (ޥ) */
    private static final String _CLIENT_REQUEST = "1";
    /** С׵ᥳޥ (ޥ) */
    private static final String _CLIENT_VERSION = "2";
    /** ۥȾ׵ᥳޥ (ޥ) */
    private static final String _CLIENT_HOST = "3";

    /** Х顼 (ޥ) */
    private static final int _SERVER_ERROR = '0';
    /** ̤ (ޥ) */
    private static final int _SERVER_FOUND = '1';
    /** ̤ʤ (ޥ) */
    private static final int _SERVER_NOT_FOUND = '4';
    /** Хӥ (ޥ) */
    private static final int _SERVER_FULL = '9';

    /** ФΥۥ̾ */
    private InetSocketAddress _address = null;
    /** ̿ѥåȥͥ */
    private SocketChannel _sc = null;
    /** Хåե */
    private ByteBuffer _buffer = null;

    /** ФλѲǽ֤򼨤ե饰 */
    private boolean _exist = false;


    /**
     * 󥹥ȥ饯
     *
     * @param host ФΥۥ̾
     * @param port ݡֹ
     */
    public ServerDic(String host, int port) {
        super();
        try {
            _address = new InetSocketAddress(host, port);
        } catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            _exist = false;
        }
    }


    /**
     * ȥ꡼򳫤ޤ
     *
     */
    private synchronized void _open() {
        if (_sc != null) {
            try {
                if (_exist) {
                    _send(_CLIENT_END);
                }
                _sc.close();
                _sc = null;
            } catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }

        if (_address == null || _address.isUnresolved()) {
            _exist = false;
            return;
        }

        try {
            _sc = SocketChannel.open();
            _sc.connect(_address);
            _exist = true;
            _buffer = ByteBuffer.allocateDirect(1024);
        } catch (UnknownHostException e) {
            System.err.println(e.getMessage());
            _exist = false;
        } catch (IOException e) {
            _exist = false;
        }
    }

    /**
     * Ĥƥ꥽ޤ
     *
     */
    public synchronized void close() {
        if (_sc == null) {
            return;
        }
        try {
            if (_exist) {
                _send(_CLIENT_END);
            }
            _sc.close();
            _sc = null;
        } catch (IOException e) {
            System.err.println(e.getMessage());
        }
        _exist = false;
        _buffer = null;
    }

    /**
     * Ǥμ񸡺򥵡Ф˰ꤷޤ
     *
     * @param key  (Ф+" ")
     * @return η (ʤnull)
     */
    public synchronized String search(String key) {
        if (_sc == null) {
            _open();
        } else {
            if (!_sc.isConnected()) {
                _open();
            }
        }

        if (!_exist) {
            return null;
        }

        _send(_CLIENT_REQUEST + key);
        String cmd = _receive();
        if (cmd == null) {
            return null;
        }
        String result = null;
        switch (cmd.charAt(0)) {
            case _SERVER_ERROR:
            case _SERVER_FULL:
                close();
                break;
            case _SERVER_FOUND:
                result = cmd.substring(1).trim();
                break;
            case _SERVER_NOT_FOUND:
                break;
            default:
                break;
        }
        return result;
    }

    /**
     * ʸޤ
     *
     * @param str ʸ
     */
    private void _send(String str) {
        try {
            _buffer.clear();
            _buffer.put(str.getBytes("EUC_JP"));
            _buffer.flip();
            _sc.write(_buffer);
        } catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        } catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    /**
     * ʸޤ
     *
     * @return ʸ
     */
    private String _receive() {
        _buffer.clear();
        int len = 0;
        while (len == 0) {
            try {
                len = _sc.read(_buffer);
            } catch (IOException e) {
                System.err.println(e.getMessage());
            }
            if (len == -1) {
                return null;
            }
        }
        _buffer.flip();
        byte[] tmp = new byte[_buffer.limit()];
        _buffer.get(tmp);
        String str = null;
        try {
            str = new String(tmp, "EUC_JP");
        } catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
        return str;
    }
}

// end of ServerDic.java
