package fuku.skk4j.im;

import java.awt.event.*;
import java.awt.font.*;
import java.awt.im.*;
import java.text.*;

/**
 * ϥ⡼ɤν饹Ǥ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
class Controller {

    /** ưѴ򳫻Ϥ륭 */
    private static final char[] _AUTO_KEY = {
        '', '', '', '', '', '', '', '', '',
        '', '', '', '', '', '', '', '', '', '',
        '.', ',', '?', '!', ';', ':', ')', '}', ']'};

    /** Ƭ/Ѵ򳫻Ϥ륭 */
    private static final char[] _PREFIX_KEY = {'>', '<', '?'};

    /** ϥ⡼ɼ (̾) */
    static final int KANA = 10;
    /** ϥ⡼ɼ () */
    static final int WIDE = 11;
    /** ϥ⡼ɼ (ASCII) */
    static final int LATIN = 12;

    /** /ʥ⡼ɻѴ⡼ɼ (̵Ѵ) */
    private static final int _NONE = 0;
    /** /ʥ⡼ɻѴ⡼ɼ (⡼) */
    private static final int _START = 1;
    /** /ʥ⡼ɻѴ⡼ɼ (⡼ (ɽ)) */
    private static final int _CONVERT = 2;
    /** /ʥ⡼ɻѴ⡼ɼ (⡼ (ɽ)) */
    private static final int _CANDIDATE = 3;
    /** /ʥ⡼ɻѴ⡼ɼ (Ͽ⡼) */
    private static final int _REGIST = 4;

    /** 䥦ɥɽޤǤѴ */
    private static int _maxConvertCount = -1;
    /** ⡼ɤBS򲡤εư */
    private static boolean _deleteKakutei = false;
    /** ꤢѴ򥭥󥻥뤷겾̾εư */
    private static boolean _deleteOkuri = false;

    /**  */
    private SKKDictionary _dic = null;

    /** ץåȥ᥽åɤΥ󥹥 */
    private SKKInputMethod _skk = null;
    /** ååץɥ */
    private LookupWindow _lookupWindow = null;

    /** ߤϥ⡼ */
    private int _inputMode = KANA;
    /** ߤѴ⡼ */
    private int _convertMode = _NONE;
    /** ߤβ̾⡼ɤ򼨤ե饰 (true:/false:) */
    private boolean _hiraganaMode = true;
    /** Abbreviation⡼ɤǤ뤳Ȥ򼨤ե饰 */
    private boolean _abbrevMode = false;
    /** 겾̾뤫ɤ򼨤ե饰 */
    private boolean _okuriMode = false;
    /** ߤѴоʸ䴰Ϥ줿ɤ򼨤ե饰 */
    private boolean _compMode = false;
    /** ɥ⡼ɤǤ뤳Ȥ򼨤ե饰 */
    private boolean _kanjiCodeMode = false;

    /** Ϥ줿ʸѥХåե (޻ʸʤ) */
    private StringBuffer _rawText = null;
    /** Ϥ줿ѴʸѥХåե (޻̾Ѵ줿̤ʤ) */
    private StringBuffer _convertText = null;

    /** Ϥ줿겾̾λҲ */
    private int _okuriChar = -1;
    /** Ѵоʸνλ */
    private int _convertPoint = 0;
    /** Ѵ䥪֥ */
    private Candidate _candidate = null;


    /**
     * 󥹥ȥ饯
     *
     * @param skk ץåȥ᥽å
     */
    Controller(SKKInputMethod skk) {
        this(skk, KANA);
    }

    /**
     * 󥹥ȥ饯
     *
     * @param skk ץåȥ᥽å
     * @param mode ϥ⡼
     */
    Controller(SKKInputMethod skk, int mode) {
        super();
        _skk = skk;
        _rawText = new StringBuffer();
        _convertText = new StringBuffer();
        _inputMode = mode;

        _dic = new SKKDictionary(_skk);

        if (_maxConvertCount < 0) {
            _maxConvertCount = _skk.getInt("skk4j.im.convert.count");
            if (_maxConvertCount < 0) {
                _maxConvertCount = 0;
            }
            _deleteKakutei = _skk.getBoolean("skk4j.im.delete.implies.kakutei");
            _deleteOkuri = _skk.getBoolean("skk4j.im.delete.okuri.when.quit");
        }
    }


    /**
     * ϥ⡼ɤꤷޤ
     *
     * @param mode ϥ⡼
     */
    void setMode(int mode) {
        if (_inputMode != mode) {
            if (_inputMode == KANA) {
                endComposition();
            }
            _inputMode = mode;
        }
    }

    /**
     * ߤϥ⡼ɤ֤ޤ
     *
     */
    int getMode() {
        return _inputMode;
    }

    /**
     * ơɽʸ֤ޤ
     *
     * @return ʸ
     */
    String getModeLine() {
        String line = "";
        switch (_inputMode) {
            case KANA:
                if (_abbrevMode) {
                    line = "a";
                } else {
                    if (_hiraganaMode) {
                        line = "";
                    } else {
                        line = "";
                    }
                }
                break;
            case WIDE:
                line = "";
                break;
            case LATIN:
                line = "SKK";
                break;
            default:
                line = "SKK";
                break;
        }
        return line;
    }

    /**
     * ϥ⡼ɤ˴ơΥ֥ȤѤ꥽ޤ
     *
     */
    void dispose() {
        endComposition();
        _dic = null;
        _rawText = null;
        _convertText = null;
        _skk = null;
    }

    /**
     * ϥ⡼ɤνλԤޤ
     *
     */
    void endComposition() {
        if (_inputMode != KANA) {
            return;
        }

        switch (_convertMode) {
            case _NONE:
            case _START:
            case _CONVERT:
                decision();
                break;
            case _CANDIDATE:
            case _REGIST:
                _lookupWindow.dispose();
                _lookupWindow = null;
            default:
                _rawText.delete(0, _rawText.length());
                _convertText.delete(0, _convertText.length());
                _sendText();
                break;
        }
    }

    /**
     * ϥ⡼ɤ򥢥ƥ֤ˤޤ
     *
     */
    void activate() {
        if (_inputMode != KANA) {
            return;
        }
        if (_lookupWindow != null) {
            _lookupWindow.show();
        }
    }

    /**
     * ϥ⡼ɤǥƥ֤ˤޤ
     *
     */
    void deactivate() {
        if (_inputMode != KANA) {
            return;
        }
        // Ͽϱʤ (̵¥롼פ˴٤)
        if (_lookupWindow != null && _convertMode == _CANDIDATE) {
            _lookupWindow.hide();
        }
    }

    /**
     * ٥ȤνԤޤ
     *
     * @param evt ٥
     */
    void dispatchKeyEvent(KeyEvent evt) {
        int id = evt.getID();
        int code = evt.getKeyCode();
        int mod  = evt.getModifiers();
        int key = code | evt.getModifiersEx();
        char ch = evt.getKeyChar();

        // Ͽ⡼ɤǤΥϤ̵
        if (_inputMode == KANA && _convertMode == _REGIST) {
            evt.consume();
            return;
        }

        // ץ쥹٥
        if (id == KeyEvent.KEY_PRESSED) {
            if (_inputMode == KANA && _convertMode != _NONE) {
                evt.consume(); // Ѵ⡼ɤǤϤ٤ƥ֥å
            }
            return;
        }

        // ꡼٥
        if (id == KeyEvent.KEY_RELEASED) {
            // ASCII/ѥ⡼ (C-jΤ߽)
            if (_inputMode != KANA) {
                if (key == (KeyEvent.VK_J|InputEvent.CTRL_DOWN_MASK)) { // C-j
                    _inputMode = KANA; // ʥ⡼ɤ
                    _skk.updateStatusWindow();
                    evt.consume();
                }
                return;
            }

            // /ʥ⡼

            // 䥦ɥƤ
            if (_convertMode == _CANDIDATE) {
                switch (key) {
                    case KeyEvent.VK_G | InputEvent.CTRL_DOWN_MASK: // C-g
                        if (_kanjiCodeMode) {
                            if (_lookupWindow.exitKanjiCodeMode()) {
                                cancel();
                            }
                        } else {
                            cancel();
                        }
                        break;
                    default:
                        // SHIFTʳȹ礻̵
                        if ((mod & ~InputEvent.SHIFT_MASK) == 0) {
                            _selectCandidate(code); // 
                        }
                        break;
                }
                evt.consume();
                return;
            }

            switch (key) {
                case KeyEvent.VK_J | InputEvent.CTRL_DOWN_MASK: // C-j
                case KeyEvent.VK_ENTER:
                    if (_convertMode == _NONE) {
                        if (_rawText.length() > 0) {
                            decision();
                            evt.consume();
                        }
                    } else {
                        decision();
                        evt.consume();
                    }
                    break;
                case KeyEvent.VK_G | InputEvent.CTRL_DOWN_MASK: // C-g
                    if (_convertMode == _NONE) {
                        if (_rawText.length() > 0) {
                            cancel();
                            evt.consume();
                        }
                    } else {
                        cancel();
                        evt.consume();
                    }
                    break;
                case KeyEvent.VK_Q | InputEvent.CTRL_DOWN_MASK: // C-q
                    if (_convertMode == _NONE) {
                        break;
                    }
                    if (_abbrevMode && _convertMode == _START) {
                        _narrow2wide(); // Ѵ
                    }
                    evt.consume();
                    break;
                default:
                    if (_convertMode != _NONE) {
                        evt.consume(); // Ѵ⡼ɤǤϤ٤ƥ֥å
                    }
                    break;
            }
            return;
        }

        // ץ٥
        if (id == KeyEvent.KEY_TYPED) {
            // ASCII⡼
            if (_inputMode == LATIN) {
                return;
            }

            // ѥ⡼
            if (_inputMode == WIDE) {
                // SHIFTʳȹ礻̵
                if ((mod & ~InputEvent.SHIFT_MASK) != 0) {
                    return;
                }
                int wide = Converter.narrow2wide(ch, false);
                if (wide != -1) {
                    AttributedString as =
                        new AttributedString(String.valueOf((char)wide));
                    _skk.sendText(as, 1, 1);
                    evt.consume();
                }
                return;
            }

            // /ʥ⡼

            // ԲǽʸΥ
            if (ch < 0x20 || ch > 0x7e) {
                switch (ch) {
                    case KeyEvent.VK_BACK_SPACE:
                        switch (_convertMode) {
                            case _CANDIDATE:
                                if (_kanjiCodeMode) {
                                    _lookupWindow.prevKanjiCode();
                                } else {
                                    _prevCandidate();
                                }
                                evt.consume();
                                break;
                            case _CONVERT:
                                if (_deleteKakutei) {
                                    _convertText.deleteCharAt(_convertText.length()-1);
                                    decision();
                                } else {
                                    _prevConvert();
                                }
                                evt.consume();
                                break;
                            default:
                                if (_handleCharacter('\b')) {
                                    evt.consume();
                                }
                                break;
                        }
                        break;
                    case KeyEvent.VK_TAB:
                        if (_convertMode == _NONE) {
                            break;
                        }
                        if (_convertMode == _START) {
                            if (_compMode) {
                                _nextComplement();
                            } else {
                                _complement(); // ʸ䴰Ԥ
                            }
                        }
                        evt.consume();
                        break;
                    default:
                        if (_convertMode != _NONE) {
                            evt.consume(); // Ѵ⡼ɤǤϤ٤ƥ֥å
                        }
                        break;
                }
                return;
            }

            // SHIFTʳȹ礻̵
            if ((mod & ~InputEvent.SHIFT_MASK) != 0) {
                if (_convertMode != _NONE) {
                    evt.consume(); // Ѵ⡼ɤǤϤ٤ƥ֥å
                }
                return;
            }

            // 䥦ɥƤ
            if (_convertMode == _CANDIDATE) {
                switch (ch) {
                    case ' ':
                        if (_kanjiCodeMode) {
                            _lookupWindow.nextKanjiCode();
                        } else {
                            _nextCandidate();
                        }
                        break;
                    case 'x':
                    case 'X':
                        if (_kanjiCodeMode) {
                            _lookupWindow.prevKanjiCode();
                        } else {
                            _prevCandidate();
                        }
                        break;
                    case '<':
                        if (_kanjiCodeMode) {
                            _lookupWindow.backKanjiCode();
                        }
                        break;
                    case '>':
                        if (_kanjiCodeMode) {
                            _lookupWindow.forwardKanjiCode();
                        }
                        break;
                    default:
                        break;
                }
                evt.consume();
                return;
            }

            // ǽʸΥ
            switch (ch) {
                case 'q':
                case 'Q':
                    if (mod == InputEvent.SHIFT_MASK && !_abbrevMode) {
                        _startConvertMode();
                    } else {
                        if (_convertMode == _START) {
                            if (_abbrevMode) {
                                _handleCharacter(ch);
                            } else {  // ʿ̾/Ҳ̾Ѵ
                                if (_hiraganaMode) {
                                    _hiragana2katakana(); // Ҳ̾Ѵ
                                } else {
                                    _katakana2hiragana(); // ʿ̾Ѵ
                                }
                            }
                        } else {
                            decision();
                            if (!_abbrevMode) { // /ʥ⡼ɤΥȥ
                                _hiraganaMode = !_hiraganaMode;
                                _skk.updateStatusWindow();
                            }
                        }
                    }
                    evt.consume();
                    break;
                case 'l':
                case 'L':
                    if (mod == InputEvent.SHIFT_MASK && !_abbrevMode) {
                        decision();
                        _inputMode = WIDE; // ѥ⡼ɤ
                        _skk.updateStatusWindow();
                    } else {
                        if (_abbrevMode) {
                            if (_convertMode == _CONVERT) {
                                decision();
                            } else {
                                _handleCharacter(ch);
                            }
                        } else {
                            if (_rawText.toString().equals("z")) {
                                if (_convertMode != _CONVERT) {
                                    _handleCharacter(ch);
                                }
                            } else {
                                decision();
                                _inputMode = LATIN; // ASCII⡼ɤ
                                _skk.updateStatusWindow();
                            }
                        }
                    }
                    evt.consume();
                    break;
                case 'x':
                case 'X':
                    if (mod == InputEvent.SHIFT_MASK) {
                        if (_convertMode == _CONVERT) { // 񤫤
                            _candidate.delete();
                            _convertText.delete(0, _convertText.length());
                            _sendText();
//                          } else {
//                              if (!_abbrevMode) {
//                                  if (_convertMode == _START) {
//                                      _startOkuriMode(); // 겾̾
//                                  } else {
//                                      _startConvertMode();
//                                  }
//                              }
//                              _handleCharacter(ch);
                        }
                    } else {
                        if (_convertMode == _CONVERT) {
                            _prevConvert();
                        } else {
                            _handleCharacter(ch);
                        }
                    }
                    evt.consume();
                    break;
                case ',':
                    if (_compMode) {
                        _prevComplement();
                        evt.consume();
                        break;
                    }
                    if (_convertMode == _CONVERT) {
                        decision();
                    }
                    if (_handleCharacter(ch)) {
                        evt.consume();
                    }
                    break;
                case '.':
                    if (_compMode) {
                        _nextComplement();
                        evt.consume();
                        break;
                    }
                    if (_convertMode == _CONVERT) {
                        decision();
                    }
                    if (_handleCharacter(ch)) {
                        evt.consume();
                    }
                    break;
                case '/':
                    if (_rawText.toString().equals("z")) {
                        if (_convertMode != _CONVERT) {
                            _handleCharacter(ch);
                        }
                    } else {
                        if (_convertMode == _START) {
                            if (_abbrevMode) {
                                _handleCharacter(ch);
                            }
                        } else {
                            decision();
                            _startAbbrevMode();
                            _skk.updateStatusWindow();
                        }
                    }
                    evt.consume();
                    break;
                case '\\':
                    if (!_abbrevMode) {
                        decision();
                        startKanjiCodeMode();
                    } else {
                        _handleCharacter(ch);
                    }
                    evt.consume();
                    break;
                case ' ':
                    switch (_convertMode) {
                        case _CONVERT:
                            _nextConvert();
                            evt.consume();
                            break;
                        case _START:
                            _appendN();
                            if (!_okuriMode) {
                                _convertPoint = _convertText.length();
                            }
                            _convert();
                            evt.consume();
                            break;
                        default:
                            break;
                    }
                    break;
                default:
                    if (_convertMode == _CONVERT) {
                        decision();
                        if (_checkPrefixKey(ch)) { // Ѵ뤫ɤ
                            _startConvertMode();
                            _convertText.append('>');
                            _sendText();
                            evt.consume();
                            break;
                        }
                    }
                    if (mod == InputEvent.SHIFT_MASK && !_abbrevMode
                        && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                        if (_convertMode == _START) {
                            _startOkuriMode(); // 겾̾
                        } else {
                            _startConvertMode();
                        }
                    }
                    if (_handleCharacter(ch)) {
                        evt.consume();
                    }
                    break;
            }
            return;
        }
    }

    /**
     * ̾ϽԤޤ
     *
     * @param ch ʸ
     * @return ͭʸɤ
     */
    private boolean _handleCharacter(char ch) {
        if (ch == '\b') { // Хåڡν
            if (_rawText.length() > 0) { // ޻Ǥ˴
                _rawText.delete(0, _rawText.length());
                if (_okuriMode) { // '*'ơ겾̾⡼ɤȴ
                    _convertText.deleteCharAt(_convertText.length()-1);
                    _okuriMode = false;
                    _okuriChar = -1;
                }
                _sendText();
                return true;
            }
            if (_convertMode == _START) { // 1ʸ
                _convertText.deleteCharAt(_convertText.length()-1);
                _compMode = false; // 䴰ʸǤʤʤ
                _sendText();
                return true;
            }
            return false;
        }

        // Abbreviation⡼ɤǤʸ򤽤ΤޤޥХåե¸
        if (_abbrevMode) {
            _convertText.append(ch);
            _compMode = false; // 䴰ʸǤʤʤ
            _sendText();
            return true;
        }

        // ޻̾Ѵ
        ch = Character.toLowerCase(ch); // ʸѴ
        _rawText.append(ch);
        String kana = Converter.roman2kana(_rawText.toString(), _hiraganaMode);

        // 1ʸϳ
        if (kana != null) {
            if (_okuriMode) { // 겾̾ν
                switch (_convertText.charAt(_convertText.length()-1)) {
                    case '*':
                        // ޻κǽʸ겾̾
                        _okuriChar = _rawText.charAt(0);
                        break;
                    case '': // "ʤˤ*ä"ξ
                    case '':
                        _okuriChar = 't';
                        break;
                    case '': // "ʤˤ*"ξ
                    case '':
                        _okuriChar = 'n';
                        break;
                    default:
                        break;
                }
            }
            _rawText.delete(0, _rawText.length());
            // "nk", "kk""k","k"ν
            if (kana.charAt(kana.length()-1) <= 'z') {
                _rawText.append(kana.charAt(kana.length()-1));
                _convertText.append(kana.substring(0,kana.length()-1));
            } else {
                _convertText.append(kana);
                if (_checkAutoKey()) { // ưѴ뤫ɤ
                    _convertPoint = _convertText.length() - 1;
                    _convert();
                    return true;
                }
                if (_okuriMode) { // 겾̾ꤷΤѴ
                    _convert();
                    return true;
                }
            }
            _compMode = false; // 䴰ʸǤʤʤ
            _sendText();
            return true;
        }

        // ޻
        if (Converter.checkRoman(_rawText.toString())) {
            _sendText();
            return true;
        }

        // ľλҲ̵뤷ƽ (̵ʻҲ+Ҳ/Ҳ+첻ȹ礻)
        if ((ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z')) {
            // ̵ʥ޻ʤΤǥХåե򥯥ꥢ
            _rawText.delete(0, _rawText.length());
            kana = Converter.roman2kana(String.valueOf(ch), _hiraganaMode);
            if (kana != null) { // ̵ʻҲ+첻 -> 첻
                _convertText.append(kana);
                if (_okuriMode) { // 겾̾ꤷΤѴ
                    _okuriChar = ch;
                    _convert();
                    return true;
                }
                _compMode = false; // 䴰ʸǤʤʤ
            } else { // ̵ʻҲ+Ҳ -> Ҳ
                _rawText.append(ch);
            }
            _sendText();
            return true;
        }

        // Ѵ (/Ҳ+ȹ礻)
        _rawText.deleteCharAt(_rawText.length()-1);
        _appendN();
        int sym = Converter.narrow2wide(ch, true);
        if (sym != -1) { // 
            _convertText.append((char)sym);
            if (_checkAutoKey()) { // ưѴ뤫ɤ
                _convertPoint = _convertText.length() - 1;
                _convert();
                return true;
            }
            // 겾̾ˤ礬뤫⤷ʤΤ
            // ȤꤢбƤ
            if (_okuriMode) {
                _okuriChar = ch;
                _convert();
                return true;
            }
            _compMode = false; // 䴰ʸǤʤʤ
            _sendText();
            return true;
        }

        // Ѵ⡼ɤǤϤ٤ƤΥϤ֥å
        if (_convertMode == _START) {
            if (_checkPrefixKey(ch)) { // ƬѴ뤫ɤ
                _convertText.append('>');
                _convertPoint = _convertText.length();
                _convert();
                return true;
            }
            _convertText.append(ch);
            if (_checkAutoKey()) { // ưѴ뤫ɤ
                _convertPoint = _convertText.length() - 1;
                _convert();
                return true;
            }
            _compMode = false; // 䴰ʸǤʤʤ
            _sendText();
            return true;
        }

        // ޻̾Ѵ
        _sendText();

        // оʸǤϤʤ
        return false;
    }

    /**
     * ưѴ򳫻Ϥ뤫ɤȽ̤ޤ
     *
     * @return ưѴ뤫ɤ
     */
    private boolean _checkAutoKey() {
        if (_okuriMode) { // 겾̾Ѵξ̵
            return false;
        }
        int len = _convertText.length();
        if (len < 2) { // ưѴ٤ʸʤ
            return false;
        }
        char ch = _convertText.charAt(len-1);
        for (int i=_AUTO_KEY.length-1; i>=0; i--) {
            if (ch == _AUTO_KEY[i]) {
                return true;
            }
        }
        return false;
    }

    /**
     * Ƭ/Ѵ򳫻Ϥ뤫ɤȽ̤ޤ
     *
     * @param ch Ϥ줿
     * @return Ƭ/Ѵ뤫ɤ
     */
    private boolean _checkPrefixKey(char ch) {
        if (_okuriMode) { // 겾̾Ѵξ̵
            return false;
        }
        for (int i=_PREFIX_KEY.length-1; i>=0; i--) {
            if (ch == _PREFIX_KEY[i]) {
                return true;
            }
        }
        return false;
    }

    /**
     * Ҳ̾ʿ̾Ѵޤ
     *
     */
    private void _katakana2hiragana() {
        _appendN();
        if (_convertText.length() > 1) {
            String tmp = Converter.katakana2hiragana(_convertText.toString());
            tmp = Converter.narrow2wide(tmp);
            _convertText.delete(0, _convertText.length());
            _convertText.append(tmp);
            _convertText.deleteCharAt(0); // ''κ
        } else { // Ƭ''ХåեäƤʤΤǤ٤˴
            _convertText.delete(0, _convertText.length());
        }
        _sendText();
    }

    /**
     * ʿ̾Ҳ̾Ѵޤ
     *
     */
    private void _hiragana2katakana() {
        _appendN();
        if (_convertText.length() > 1) {
            String tmp = Converter.hiragana2katakana(_convertText.toString());
            tmp = Converter.narrow2wide(tmp);
            _convertText.delete(0, _convertText.length());
            _convertText.append(tmp);
            _convertText.deleteCharAt(0); // ''κ
        } else { // Ƭ''ХåեäƤʤΤǤ٤˴
            _convertText.delete(0, _convertText.length());
        }
        _sendText();
    }

    /**
     * ȾʸʸѴޤ
     *
     */
    private void _narrow2wide() {
        if (_convertText.length() > 1) {
            String tmp = Converter.narrow2wide(_convertText.toString());
            _convertText.delete(0, _convertText.length());
            _convertText.append(tmp);
            _convertText.deleteCharAt(0); // ''κ
        } else { // Ƭ''ХåեäƤʤΤǤ٤˴
            _convertText.delete(0, _convertText.length());
        }
        _sendText();
    }

    /**
     * n̾ѴޤޤΥ޻˴ޤ
     *
     */
    private void _appendN() {
        if (_rawText.toString().equals("n")) {
            if (_hiraganaMode) {
                _convertText.append('');
            } else {
                _convertText.append('');
            }
            _compMode = false; // 䴰ʸǤʤʤ
        }
        _rawText.delete(0, _rawText.length());
        _sendText();
    }

    /**
     * Ѵ⡼ɤڤؤޤ
     *
     */
    private void _startConvertMode() {
        _convertMode = _START;
        _convertText.append(''); // ''ɲ
        _sendText();
    }

    /**
     * 겾̾ϥ⡼ɤڤؤޤ
     *
     */
    private void _startOkuriMode() {
        if (_convertText.length() < 2) { // ""Τߤ̵
            return;
        }
        _convertPoint = _convertText.length();
        _convertText.append('*'); // '*'ɲ
        _compMode = false; // 䴰ʸǤʤʤ
        _okuriMode = true;
        _sendText();
    }

    /**
     * Abbreviation⡼ɤڤؤޤ
     *
     */
    private void _startAbbrevMode() {
        _convertMode = _START;
        _abbrevMode = true;
        _convertText.append(''); // ''ɲ
        _sendText();
    }

    /**
     * ɥ⡼ɤڤؤޤ<BR>
     * <P>
     *   ϥϥɥɽ
     *   2ܰʹߤϰɽ
     * </P>
     *
     * @param mode ⡼
     */
    void startKanjiCodeMode() {
        if (_kanjiCodeMode) {
            _convertMode = _CANDIDATE;
        } else {
            _kanjiCodeMode = true;
            _convertMode = _REGIST;
            _lookupWindow = new LookupWindow(_skk);
            _lookupWindow.setupInputWindow();
        }
        _lookupWindow.show();
    }

    /**
     * ѴγԤޤ
     *
     */
    void decision() {
        switch (_convertMode) {
            case _NONE:
                _appendN();
                break;
            case _START:
                _appendN();
                _convertText.deleteCharAt(0); // ''κ
                if (_okuriMode) {
                    _convertText.deleteCharAt(_convertPoint); // '*'κ
                }
                break;
            case _REGIST:
                if (_kanjiCodeMode) {
                    _convertText.append(_lookupWindow.getChar());
                } else {
                    String str = _candidate.getCandidate();
                    _convertText.replace(1, _convertPoint, str);
                    _convertPoint = str.length() + 1;
                    // Ѵη̡ʣθ䤬Ѵ⡼ɤ
                    if (_candidate.hasNextCandidate()) {
                        _lookupWindow.dispose();
                        _lookupWindow = null;
                        _convertMode = _CONVERT;
                        break;
                    }
                }
            case _CANDIDATE:
                _lookupWindow.dispose();
                _lookupWindow = null;
                if (_kanjiCodeMode) {
                    _sendText();
                    break;
                }
            case _CONVERT:
                _candidate.regist();
                _convertText.deleteCharAt(0); // ''κ
                break;
            default:
                break;
        }
        _sendText();
    }

    /**
     * ѴμäԤޤ
     *
     */
    void cancel() {
        String yomi = null;
        switch (_convertMode) {
            case _CANDIDATE:
                _lookupWindow.dispose();
                _lookupWindow = null;
                if (_kanjiCodeMode) {
                    _convertMode = _NONE;
                    _kanjiCodeMode = false;
                    break;
                }
            case _CONVERT:
                yomi = _candidate.getYomi();
                if (!_hiraganaMode) {
                    yomi = Converter.hiragana2katakana(yomi);
                }
                if (_okuriMode) {
                    int len = _convertPoint;
                    if (_deleteOkuri) {
                        len = _convertText.length();
                    }
                    _convertText.replace(1, len, yomi);
                } else {
                    _convertText.replace(1, _convertPoint, yomi);
                }
                _convertText.replace(0, 1, ""); // ''''֤
                _convertMode = _START; // ⡼ɤ᤹
                _okuriMode = false;
                _okuriChar = -1;
                _sendText();
                break;
            case _REGIST:
                _lookupWindow.dispose();
                if (_kanjiCodeMode) {
                    _lookupWindow = null;
                    _convertMode = _NONE;
                    _kanjiCodeMode = false;
                    break;
                }
                if (_lookupWindow.hasCandidate()) {
                    // 䥦ɥг
                    _convertMode = _CANDIDATE;
                    _lookupWindow.setupSelectionWindow();
                    _lookupWindow.show();
                } else {
                    _lookupWindow = null;
                    if (_candidate.hasCandidate()) { // 䤬Т⡼ɤ
                        _convertMode = _CONVERT;
                    } else { // ⡼ɤ᤹
                        yomi = _candidate.getYomi();
                        if (!_hiraganaMode) {
                            yomi = Converter.hiragana2katakana(yomi);
                        }
                        if (_okuriMode) {
                            int len = _convertPoint;
                            if (_deleteOkuri) {
                                len = _convertText.length();
                            }
                            _convertText.replace(1, len, yomi);
                        } else {
                            _convertText.replace(1, _convertPoint, yomi);
                        }
                        _convertText.replace(0, 1, ""); // ''''֤
                        _convertMode = _START;
                        _okuriMode = false;
                        _okuriChar = -1;
                        _sendText();
                    }
                }
                break;
            default:
                _rawText.delete(0, _rawText.length());
                _convertText.delete(0, _convertText.length());
                _sendText();
                break;
        }
    }

    /**
     * ϤƤʸ䴰Ԥޤ()
     *
     */
    private void _complement() {
        if (!_abbrevMode) {
            _appendN();
        }
        String yomi = null;
        if (_convertText.length() > 1) {
            yomi = _convertText.substring(1, _convertText.length());
            if (!_hiraganaMode) {
                yomi = Converter.katakana2hiragana(yomi);
            }
        }
        _candidate = new Candidate(_dic, yomi);
        if (_candidate.hasNextComplement()) {
            String str = _candidate.getNextComplement();
            if (!_hiraganaMode) {
                str = Converter.hiragana2katakana(str);
            }
            _convertText.replace(1, _convertText.length(), str);
        }
        _convertPoint = _convertText.length();
        _compMode = true;
        _sendText();
    }

    /**
     * 䴰Ԥޤ(2ܰʹ)
     *
     */
    private void _prevComplement() {
        if (_candidate.hasPrevComplement()) {
            String str = _candidate.getPrevComplement();
            if (!_hiraganaMode) {
                str = Converter.hiragana2katakana(str);
            }
            _convertText.replace(1, _convertText.length(), str);
            _convertPoint = _convertText.length();
        }
        _sendText();
    }

    /**
     * 䴰Ԥޤ(2ܰʹ)
     *
     */
    private void _nextComplement() {
        if (_candidate.hasNextComplement()) {
            String str = _candidate.getNextComplement();
            if (!_hiraganaMode) {
                str = Converter.hiragana2katakana(str);
            }
            _convertText.replace(1, _convertText.length(), str);
            _convertPoint = _convertText.length();
        }
        _sendText();
    }

    /**
     * ѴԤޤ()
     *
     */
    private void _convert() {
        _convertMode = _CONVERT;
        _convertText.replace(0, 1, ""); // ''''֤

        // 䴰Ϥ줿ΤϤǤ˸䥪֥Ȥ¸ߤ
        if (!_compMode) {
            if (_okuriMode) {
                // 겾̾ꤷƤʤ ("ʤˤ*","ʤˤ*k"ξ)
                if (_convertText.charAt(_convertText.length()-1) == '*') {
                    _sendText();
                    return;
                }
            }

            // ѴоݤʤΤѴ⡼ɤλ (""ξ)
            if (_convertText.length() < 2) {
                _convertText.delete(0, _convertText.length());
                _sendText();
                return;
            }

            // ɤ
            String yomi = _convertText.substring(1, _convertPoint);

            if (!_hiraganaMode) { // Ҳ̾ʿ̾Ѵ
                yomi = Converter.katakana2hiragana(yomi);
            }

            // 겾̾
            String okuri = null;
            if (_okuriMode) {
                _convertText.deleteCharAt(_convertPoint); // '*'
                okuri = _convertText.substring(_convertPoint, _convertText.length());
            }

            // 
            _candidate = new Candidate(_dic, yomi, okuri, _okuriChar);
        }

        if (_candidate.hasCandidate()) {
            String str = _candidate.getNextCandidate();
            _convertText.replace(1, _convertPoint, str);
            _convertPoint = str.length() + 1;
            _sendText();
        } else { // ˸䤬ϿƤʤ
            _convertMode = _REGIST;
            _sendText();
            _lookupWindow = new LookupWindow(_skk, _candidate);
            _lookupWindow.setupInputWindow();
            _lookupWindow.show();
        }
    }

    /**
     * θᤷޤ(2ܰʹ)
     *
     */
    private void _prevConvert() {
        if (_candidate.hasPrevCandidate()) {
            String str = _candidate.getPrevCandidate();
            _convertText.replace(1, _convertPoint, str);
            _convertPoint = str.length() + 1;
            _sendText();
        } else {
            cancel();
        }
    }

    /**
     * θѴޤ(2ܰʹ)
     *
     */
    private void _nextConvert() {
        if (_candidate.hasNextCandidate()) {
            if (_candidate.getIndex() < _maxConvertCount) {
                String str = _candidate.getNextCandidate();
                _convertText.replace(1, _convertPoint, str);
                _convertPoint = str.length() + 1;
                _sendText();
            } else { // 䥦ɥ򳫤
                _convertMode = _CANDIDATE;
                _convertText.delete(1, _convertPoint);
                _convertPoint = 1;
                _sendText();
                _lookupWindow = new LookupWindow(_skk, _candidate);
                _lookupWindow.setupSelectionWindow();
                _lookupWindow.show();
            }
        } else { // 䤬ʤΤϿ⡼ɤ
            _convertMode = _REGIST;
            _lookupWindow = new LookupWindow(_skk, _candidate);
            _lookupWindow.setupInputWindow();
            _lookupWindow.show();
        }
    }

    /**
     * θɽޤ
     *
     */
    private void _prevCandidate() {
        if (_lookupWindow.hasPrevCandidate()) {
            _lookupWindow.prevCandidate();
        } else {
            _lookupWindow.dispose();
            _lookupWindow = null;
            _convertMode = _CONVERT;
            _candidate.setIndex(_maxConvertCount+1);
            _prevConvert();
        }
    }

    /**
     * θɽޤ
     *
     */
    private void _nextCandidate() {
        if (_lookupWindow.hasNextCandidate()) {
            _lookupWindow.nextCandidate();
        } else { // 䤬ʤϿ⡼ɤڤؤ
            _convertMode = _REGIST;
            _lookupWindow.setupInputWindow();
            _lookupWindow.show();
        }
    }

    /**
     * 䤫򤷤ޤ
     *
     * @param index ֹ
     * @return ͭʸֹ椫ɤ
     */
    private boolean _selectCandidate(int index) {
        if (_lookupWindow.selectCandidate(index)) {
            // 򤷤֤Ƴ
            if (_kanjiCodeMode) {
                _convertText.append(_lookupWindow.getChar());
            } else {
                String str = _candidate.getCandidate();
                _convertText.replace(1, _convertPoint, str);
                _convertPoint = str.length() + 1;
            }
            decision();
            return true;
        }
        return false;
    }

    /**
     * ƥȤޤ
     *
     */
    private void _sendText() {
        boolean init = false;
        String str = _convertText.toString() + _rawText.toString();
        AttributedString as = new AttributedString(str);
        if (_convertText.length() > 0) { // ̾ʸ/
            if (_convertText.charAt(0) == '') { // ⡼
                if (str.length() > 1) {
                    as.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT,
                                    InputMethodHighlight.UNSELECTED_RAW_TEXT_HIGHLIGHT,
                                    1, str.length());
                }
                _skk.sendText(as, 0, str.length());
            } else if (_convertText.charAt(0) == '') { // ⡼
                if (str.length() > 1) {
                    if (_convertPoint > 1) { // ʬ
                        as.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT,
                                        InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT,
                                        1, _convertPoint);
                        if (_convertPoint < str.length()) { // 겾̾ʬ
                            as.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT,
                                            InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT,
                                            _convertPoint, str.length());
                        }
                    } else { // 겾̾Τ
                        as.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT,
                                        InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT,
                                        1, str.length());
                    }
                }
                _skk.sendText(as, 0, str.length());
            } else { // ѴоݤǤʤ̾ʸ/ (̾Τ߳)
                init = true;
                _skk.sendText(new AttributedString(_convertText.toString()),
                               _convertText.length(), _convertText.length());
                _skk.sendText(new AttributedString(_rawText.toString()),
                               0, _rawText.length());
            }
        } else { // ̾ʸ/ʤ
            init = true;
            _skk.sendText(new AttributedString(_rawText.toString()),
                           0, _rawText.length());
        }

        if (init) {
            _convertText.delete(0, _convertText.length());
            _convertMode = _NONE;
            _compMode = false;
            _okuriMode = false;
            _kanjiCodeMode = false;
            _okuriChar = -1;
            _convertPoint = 0;
            _candidate = null;
            if (_abbrevMode) {
                _abbrevMode = false;
                _skk.updateStatusWindow();
            }
        }
    }
}

// end of Controller.java
