package fuku.skk4j.resource;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 * ץѥƥ饹γĥǡ<BR>
 * ץѥƥͤ${key}ǻȤͤޤ뤳ȤǤޤ<BR>
 * ʤҤˤбƤޤ<BR>
 * <BR>
 * ץѥƥեθ <BR>
 * 1. ${java.class.path}/resourcePath/fileName <BR>
 * 2. ${java.home}/lib/fileName <BR>
 * 3. ${user.home}/.java/fileName <BR>
 * 4. ${user.dir}/fileName <BR>
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class SKKProperties extends Properties {

    /** ץѥƥե̾ */
    private String _fileName = null;
    /** ꥽ѥ */
    private String _resourcePath = null;


    /**
     * 󥹥ȥ饯
     *
     * @param fileName ץѥƥե̾
     */
    public SKKProperties(String fileName) {
        this(fileName, null);
    }

    /**
     * 󥹥ȥ饯
     *
     * @param fileName ץѥƥե̾
     * @param resourcePath ꥽ѥ
     */
    public SKKProperties(String fileName, String resourcePath) {
        super(new Properties(System.getProperties()));
        _fileName = "/" + fileName;
        _resourcePath = resourcePath;
    }

    /**
     * ץѥƥե̾ꤷޤ
     *
     * @param fileName ץѥƥե̾
     */
    public void setFileName(String fileName) {
        _fileName = "/" + fileName;
    }

    /**
     * ꥽ѥꤷޤ
     *
     * @param resourcePath ꥽ѥ
     */
    public void setResourcePath(String resourcePath) {
        _resourcePath = resourcePath;
    }

    /**
     * ե뤫ץѥƥꥹȤɤ߹ߤޤ
     *
     */
    public void load() {
        if (_fileName == null) {
            return;
        }

        // ǥեȥץѥƥɤ߹
        String resource = null;
        if (_resourcePath == null) {
            resource = _fileName;
        } else {
            resource = _resourcePath + _fileName;
        }
        _load(ClassLoader.getSystemResource(resource));

        // $JAVA_HOME/lib˥ץѥƥե뤬ɤ߹
        resource = System.getProperty("java.home") + "/lib" + _fileName;
        _load(new File(resource));

        // $USER_HOME/.java˥ץѥƥե뤬ɤ߹
        resource = System.getProperty("user.home") + "/.java" + _fileName;
        _load(new File(resource));

        // $USER_DIR˥ץѥƥե뤬ɤ߹
        resource = System.getProperty("user.dir") + _fileName;
        _load(new File(resource));
    }

    /**
     * ꤵ줿ե뤫ץѥƥɤ߹ߤޤ
     *
     * @param file ץѥƥե
     */
    private void _load(File file) {
        if (file != null && file.exists() && file.canRead()) {
            try {
                _load(file.toURL());
            } catch (MalformedURLException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    /**
     * ꤵ줿URLץѥƥɤ߹ߤޤ
     *
     * @param url ץѥƥեURL
     */
    private void _load(URL url) {
        if (url == null) {
            return;
        }
        InputStream input = null;
        try {
            input = url.openStream();
            load(input);
        } catch (IOException e) {
            System.err.println(e.getMessage());
        } finally {
            if (input != null) {
                try {
                    input.close();
                    input = null;
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
    }

    /**
     * ץѥƥ֤ޤ<BR>
     * ץѥƥĤʤϡnull֤ޤ
     *
     * @param key ץѥƥ̾
     * @return ץѥƥ
     */
    public String getProperty(String key) {
        return getProperty(key, null);
    }

    /**
     * ץѥƥ֤ޤ<BR>
     * ץѥƥĤʤϡǥեͤΰ֤ޤ
     *
     * @param key ץѥƥ̾
     * @param defaultValue ǥե
     * @return ץѥƥ
     */
    public String getProperty(String key, String defaultValue) {
        String p = super.getProperty(key);
        if (p == null) {
            return defaultValue;
        }

        StringBuffer buf = new StringBuffer(p);
        int i = buf.toString().indexOf("${");
        while (i != -1) {
            if (buf.toString().charAt(i-1) == '\\') {
                i = buf.toString().indexOf("${", i+2);
                continue;
            }
            int j = buf.toString().indexOf('}', i+2);
            if (j == -1) {
                break;
            }
            String ref = buf.substring(i+2, j).trim();
            if (ref.equals(key)) { // ʻȤ̵
                i = j + 1;
            } else {
                String str = super.getProperty(ref);
                if (str != null) {
                    buf.replace(i, j+1, str);
                } else {
                    i = j;
                }
            }
            i = buf.toString().indexOf("${", i);
        }
        return buf.toString();
    }

    /**
     * intΥץѥƥ֤ޤ<BR>
     * ץѥƥĤʤintǤʤϡ-1֤ޤ
     *
     * @param key ץѥƥ̾
     * @return ץѥƥ
     */
    public int getInt(String key) {
        return getInt(key, -1);
    }

    /**
     * intΥץѥƥ֤ޤ<BR>
     * ץѥƥĤʤintǤʤϡ
     * ǥեͤΰ֤ޤ
     *
     * @param key ץѥƥ̾
     * @param defaultValue ǥե
     * @return ץѥƥ
     */
    public int getInt(String key, int defaultValue) {
        String p = getProperty(key);
        if (p == null) {
            return defaultValue;
        }

        int ret;
        try {
            ret = Integer.parseInt(p);
        } catch (NumberFormatException e) {
            ret = defaultValue;
        }
        return ret;
    }

    /**
     * booleanΥץѥƥ֤ޤ<BR>
     * ץѥƥĤʤϡfalse֤ޤ
     *
     * @param key ץѥƥ̾
     * @return ץѥƥ
     */
    public boolean getBoolean(String key) {
        return getBoolean(key, false);
    }

    /**
     * booleanΥץѥƥ֤ޤ<BR>
     * ץѥƥĤʤϡǥեͤΰ֤ޤ
     *
     * @param key ץѥƥ̾
     * @param defaultValue ǥե
     * @return ץѥƥ
     */
    public boolean getBoolean(String key, boolean defaultValue) {
        String p = getProperty(key);
        if (p == null) {
            return defaultValue;
        }
        return Boolean.valueOf(p).booleanValue();
    }

    /**
     * ץѥƥꥹȤ֤ޤ<BR>
     * ꤵ줿ץѥƥ̾ + ".N" (NϿ) ֤ͤޤ<BR>
     * ץѥƥĤʤϡnull֤ޤ<BR>
     * <BR>
     *  <BR>
     * my.prop.0 = prop0 <BR>
     * my.prop.1 = prop1
     *
     * @param key ץѥƥ̾
     * @return ץѥƥ
     */
    public String[] getList(String key) {
        List list = new ArrayList();
        Enumeration enum = propertyNames();
        for (int i=0; enum.hasMoreElements(); i++) {
            String str = (String)enum.nextElement();
            if (str.startsWith(key) && !str.equals(key)) {
                String num = str.substring(key.length()+1);
                try {
                    Integer.parseInt(num);
                } catch (NumberFormatException e) {
                    continue;
                }
                list.add(str);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        String[] keys = (String[])list.toArray(new String[0]);
        Arrays.sort(keys, new PropComparator());
        String[] vals = new String[keys.length];
        for (int i=0; i<keys.length; i++) {
            vals[i] = getProperty(keys[i]);
        }
        return vals;
    }


    /**
     * ץѥƥѥ졼
     *
     */
    private class PropComparator implements Comparator {
        /**
         * ǥեȥ󥹥ȥ饯
         *
         */
        public PropComparator() {
        }

        /**
         * դΤ2ĤΰӤޤ
         *
         * @param o1 оݤκǽΥ֥
         * @param o2 оݤ2ܤΥ֥
         * @return ǽΰ2ܤΰ꾮
         *         ξ0
         *         ǽΰ2ܤΰ礭
         */
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            int idx = s1.lastIndexOf('.');
            if (idx <= 0) {
                return -1;
            }
            String s11 = s1.substring(idx+1);
            idx = s2.lastIndexOf('.');
            if (idx <= 0) {
                return 1;
            }
            String s22 = s2.substring(idx+1);

            int n1;
            try {
                n1 = Integer.parseInt(s11);
            } catch (NumberFormatException e) {
                return -1;
            }
            int n2;
            try {
                n2 = Integer.parseInt(s22);
            } catch (NumberFormatException e) {
                return 1;
            }
            return n1-n2;
        }
    }
}

// end of SKKProperties.java
