package fuku.skk4j.server;

import java.io.*;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;
import java.util.*;
import java.util.logging.*;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

import fuku.skk4j.Version;
import fuku.skk4j.dic.SKKDic;
import fuku.skk4j.dic.CacheDic;
import fuku.skk4j.dic.CollectedDic;
import fuku.skk4j.resource.SKKProperties;

/**
 * Javaskkservץࡣ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class SKKServ {

    /** ץ֥̾ */
    private static final String _PROGRAM = "fuku.skk4j.server.SKKServ";

    /** ץѥƥե̾ */
    private static final String _PROPERTY = "skk4j.server.properties";
    /** ꥽ѥ */
    private static final String _PATH = "fuku/skk4j/resource";

    /** ǥޥ (ޥ) */
    private static final int _CLIENT_END = '0';
    /** ׵ᥳޥ (ޥ) */
    private static final int _CLIENT_REQUEST = '1';
    /** С׵ᥳޥ (ޥ) */
    private static final int _CLIENT_VERSION = '2';
    /** ۥȾ׵ᥳޥ (ޥ) */
    private static final int _CLIENT_HOST = '3';

    /** Х顼 (ޥ) */
    private static final String _SERVER_ERROR = "0";
    /** ̤ (ޥ) */
    private static final String _SERVER_FOUND = "1";
    /** ̤ʤ (ޥ) */
    private static final String _SERVER_NOT_FOUND = "4";
    /** Хӥ (ޥ) */
    private static final String _SERVER_FULL = "9";

    /** Х󥹥 */
    private static SKKServ _instance = null;

    /** ץѥƥ */
    private static SKKProperties _prop = null;

    /** λޥɼݡ */
    private static int _kill = -1;

    /** 񥪥֥ */
    private static SKKDic _dic = null;

    /** 쥯 */
    private Selector _selector = null;

    /** ե */
    private static Logger _logger = null;

    /** ޥɥ饤󥪥ץ */
    private static final LongOpt[] _LONGOPT = {
        new LongOpt("help", LongOpt.NO_ARGUMENT, null, 'h'),
        new LongOpt("version", LongOpt.NO_ARGUMENT, null, 'v'),
        new LongOpt("quit", LongOpt.NO_ARGUMENT, null, 'q')
    };


    /**
     * ᥤ᥽åɡ
     *
     * @param args ޥɹ԰
     */
    public static void main(String[] args) {
        boolean shutdown = false;
        Getopt g = new Getopt(_PROGRAM, args, "q", _LONGOPT);
        int c;
        while ((c=g.getopt()) != -1) {
            switch (c) {
                case 'h':
                    _usage(0);
                    break;
                case 'v':
                    _version();
                    break;
                case 'q':
                    shutdown = true;
                    break;
                default:
                    _usage(1);
            }
        }

        if (g.getOptind() != args.length) {
            System.err.println(_PROGRAM + ": too many arguments");
            _usage(1);
        }


        if (_prop == null) {
            _prop = new SKKProperties(_PROPERTY, _PATH);
            _prop.load();
        }
        // λޥɼݡ
        _kill = _prop.getInt("skk4j.server.port.kill");
        if (_kill < 0) {
            System.err.println(_PROGRAM + ": illegal port number: "
                               + _prop.getProperty("skk4j.server.port.kill"));
            System.exit(1);
        }

        if (shutdown) { // Фλ
            SocketChannel sc = null;
            try {
                InetSocketAddress address =
                    new InetSocketAddress(InetAddress.getLocalHost(), _kill);
                sc = SocketChannel.open();
                sc.connect(address);
                byte[] cmd = {(byte)0xfe, (byte)0x0f};
                ByteBuffer buf = ByteBuffer.wrap(cmd);
                sc.write(buf);
            } catch (IOException e) {
                System.err.println(_PROGRAM + ": " + e.getMessage());
            } finally {
                if (sc != null) {
                    try {
                        sc.close();
                        sc = null;
                    } catch (IOException e) {
                        System.err.println(_PROGRAM + ": " + e.getMessage());
                    }
                }
            }
        } else {
            SKKServ._getInstance()._startServer();
        }
    }


    /**
     * ˡɽޤ
     *
     * @param status λơ
     */
    private static final void _usage(int status) {
        if (status != 0) {
            System.out.println("Try `java " + _PROGRAM + " --help' for more information");
        } else {
            System.out.println("Usage: java " + _PROGRAM + " [OPTION]");
            System.out.println("");
            System.out.println("SKK dictionary server for Java.");
            System.out.println("");
            System.out.println("  -q, --quit      shutdown the SKKServ");
            System.out.println("      --help      display this help and exit");
            System.out.println("      --version   output version information and exit");
            System.out.println("");
            System.out.println("Report bugs to <" + Version.EMAIL + ">.");
        }
        System.exit(status);
    }

    /**
     * Сɽޤ
     *
     */
    private static final void _version() {
        System.out.println(_PROGRAM + " " + Version.VERSION);
        System.out.println(Version.COPYRIGHT);
        System.out.println("All right reserved.");
        System.exit(0);
    }


    /**
     * ǥեȥ󥹥ȥ饯
     *
     */
    private SKKServ() {
        super();
        // ν
        _logger = Logger.getLogger("local.skk4j.server");
        String logLevel = _prop.getProperty("skk4j.server.log.level");
        try {
            _logger.setLevel(Level.parse(logLevel.toUpperCase()));
        } catch (IllegalArgumentException e) {
            System.err.println(_PROGRAM + ": illegal log level: " + logLevel);
            System.exit(1);
        }
        String logFile = _prop.getProperty("skk4j.server.log.file");
        String logEncoding = _prop.getProperty("skk4j.server.log.encoding");
        int logLimit = 0;
        int logCount = 0;
        logLimit = _prop.getInt("skk4j.server.log.limit");
        logCount = _prop.getInt("skk4j.server.log.count");
        if (logLimit < 0) {
            logLimit = 0;
        }
        if (logCount < 1) {
            logCount = 1;
        }
        // ٥뤬OFFǤեϺΤ
        // ٥뤬OFFϥեϥɥѤʤ
        if (_logger.getLevel() != Level.OFF && logFile.length() > 0) {
            FileHandler handler = null;
            try {
                handler = new FileHandler(logFile, logLimit, logCount);
                handler.setLevel(_logger.getLevel());
                handler.setFormatter(new SimpleFormatter());
                if (logEncoding != null && logEncoding.length() > 0) {
                    try {
                        handler.setEncoding(logEncoding);
                    } catch (UnsupportedEncodingException e) {
                        System.err.println(_PROGRAM + ": " + e.getMessage());
                        System.exit(1);
                    }
                }
                _logger.setUseParentHandlers(false);
                _logger.addHandler(handler);
            } catch (IOException e) {
                System.err.println(_PROGRAM + ": " + e.getMessage());
                System.exit(1);
            }
        }

        // 񥪥֥Ȥκ
        String[] list = _prop.getList("skk4j.server.skkdic");
        if (list == null) {
            System.err.println(_PROGRAM + ": skkdic not defined.");
            System.exit(1);
        }
        String enc = _prop.getProperty("skk4j.server.skkdic.encoding");
        String cachedir = _prop.getProperty("skk4j.server.cachedir");

        SKKDic[] dic = new SKKDic[list.length];
        for (int i=0; i<list.length; i++) {
            String indexname;
            if (cachedir != null && cachedir.length() > 0) {
                int idx = list[i].lastIndexOf('/') + 1;
                indexname = cachedir + "/" + list[i].substring(idx) + ".ser";
            } else {
                indexname = list[i] + ".ser";
            }
            _logger.config("load dictionary: " + list[i]);
            dic[i] = new CacheDic(list[i], indexname, enc);
        }
        _dic = new CollectedDic(dic);

        // ӥ󶡥ݡ
        int port = _prop.getInt("skk4j.server.port");
        if (port < 0) {
            System.err.println(_PROGRAM + ": illegal port number: "
                               + _prop.getProperty("skk4j.server.port"));
            System.exit(1);
        }
        // Хåȥͥ
        try {
            _selector = Selector.open();
            ServerSocketChannel ssc1 = ServerSocketChannel.open();
            ssc1.configureBlocking(false);
            ssc1.socket().bind(new InetSocketAddress(port));
            ssc1.register(_selector, SelectionKey.OP_ACCEPT);
            // shutdownޥɼͥ
            ServerSocketChannel ssc2 = ServerSocketChannel.open();
            ssc2.configureBlocking(false);
            ssc2.socket().bind(new InetSocketAddress(_kill));
            ssc2.register(_selector, SelectionKey.OP_ACCEPT);
        } catch (ClosedChannelException e) {
            System.err.println(_PROGRAM + ": " + e.getMessage());
            System.exit(1);
        } catch (IOException e) {
            System.err.println(_PROGRAM + ": " + e.getMessage());
            System.exit(1);
        }
    }


    /**
     * 󥹥󥹤֤ޤ
     *
     * @return SKKServΥ󥹥
     */
    private static SKKServ _getInstance() {
        if (_instance == null) {
            _instance = new SKKServ();
        }
        return _instance;
    }

    /**
     * ӥ򳫻Ϥޤ
     *
     */
    private void _startServer() {
        boolean exitFlag = false;
        String str = "startup: " + _PROGRAM + " " + Version.VERSION;
        _logger.info(str);
        System.out.println(str);
        while (!exitFlag) {
            try {
                if (_selector.select() < 1) {
                    continue;
                }
                Iterator iterator = _selector.selectedKeys().iterator();
                while (iterator.hasNext() && !exitFlag) {
                    SelectionKey key = (SelectionKey)iterator.next();
                    iterator.remove();
                    if (key.isAcceptable()) {
                        _accept((ServerSocketChannel)key.channel());
                    } else if (key.isReadable()) {
                        exitFlag = _receive((SocketChannel)key.channel());
                    }
                }
            } catch (IOException e) {
                _logger.log(Level.WARNING, "I/O Error", e);
                continue;
            }
        }

        // ͥ/쥯Ĥ
        Iterator iterator = _selector.keys().iterator();
        try {
            while (iterator.hasNext()) {
                SelectableChannel ch =
                    ((SelectionKey)iterator.next()).channel();
                ch.close();
            }
            _selector.close();
        } catch (IOException e) {
            _logger.log(Level.WARNING, "can't close channel and selector", e);
        }

        // Ϥߤ
        str = "shutdown: " + _PROGRAM + " " + Version.VERSION;
        _logger.info(str);
        System.out.println(str);
        Handler[] handlers = _logger.getHandlers();
        for (int i=handlers.length-1; i>=0; i--) {
            handlers[i].flush();
            handlers[i].close();
        }

        // Ĥ
        _dic.close();
    }

    /**
     * ³׵Ԥޤ
     *
     * @param ssc Хåȥͥ
     * @exception IOException åȥͥκȯI/O㳰
     */
    private void _accept(ServerSocketChannel ssc) throws IOException {
        SocketChannel sc = ssc.accept();
        InetAddress client = sc.socket().getInetAddress();
        _logger.info("accept: " + client.getCanonicalHostName()
                     + " (" + client.getHostAddress() + ")");
        sc.configureBlocking(false);
        sc.register(_selector, SelectionKey.OP_READ);
    }

    /**
     * Ԥޤ
     *
     * @param sc åȥͥ
     * @return λޥɤɤ
     * @exception IOException ȯI/O㳰
     */
    private boolean _receive(SocketChannel sc) throws IOException {
        InetAddress client = sc.socket().getInetAddress();
        _logger.info("receive: " + client.getCanonicalHostName()
                     + " (" + client.getHostAddress() + ")");

        ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
        buffer.clear();
        if (sc.read(buffer) < 0) {
            sc.close();
            return false;
        }
        buffer.flip();

        byte[] tmp = new byte[buffer.limit()];
        buffer.get(tmp);

        if (sc.socket().getLocalPort() == _kill) {
            // λޥɤγǧ
            if (tmp.length != 2 || (tmp[0]&0xff) != 0xfe || (tmp[1]&0xff) != 0x0f) {
                StringBuffer buf = new StringBuffer();
                for (int i=0; i<tmp.length; i++) {
                    buf.append(Integer.toHexString(tmp[i]));
                }
                _logger.warning("it is not shutdown command: " + buf.toString());
                sc.close();
                return false;
            }
            // Фȥ饤ȤƱʤ齪λ
            String serverAddr = InetAddress.getLocalHost().getHostAddress();
            String clientAddr = sc.socket().getInetAddress().getHostAddress();
            if (serverAddr.compareTo(clientAddr) != 0) {
                _logger.warning("shutdown command failed: "
                             + sc.socket().getInetAddress().getCanonicalHostName()
                             + "(" + clientAddr + ")");
                sc.close();
                return false;
            }
            _logger.fine("shutdown command");
            sc.close();
            return true;
        } else {
            String cmd = new String(tmp, "EUC_JP");
            String str = null;
            switch (cmd.charAt(0)) {
                case _CLIENT_END: // 
                    _logger.fine("exit command");
                    sc.close();
                    break;
                case _CLIENT_REQUEST: // 
                    _logger.fine("search command");
                    String word = cmd.substring(1);
                    String cand = _dic.search(word);
                    if (cand != null) {
                        str = _SERVER_FOUND + cand;
                    } else {
                        str = _SERVER_NOT_FOUND + word;
                    }
                    if (str.charAt(str.length()-1) != '\n') {
                        str = str + "\n";
                    }
                    break;
                case _CLIENT_VERSION: // С
                    _logger.fine("version info command");
                    str = Version.VERSION;
                    break;
                case _CLIENT_HOST: // о
                    _logger.fine("server info command");
                    try {
                        str = InetAddress.getLocalHost().getHostName();
                    } catch (UnknownHostException e) {
                        str = "localhost";
                    }
                    break;
                default:
                    _logger.warning("unknown command: " + cmd.charAt(0));
                    break;
            }
            if (str != null) {
                buffer.clear();
                buffer.put(str.getBytes("EUC_JP"));
                buffer.flip();
                sc.write(buffer);
            }
        }
        return false;
    }
}

// end of SKKServ.java
