package fuku.skk4j.tool;

import java.io.*;
import java.util.*;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

import fuku.skk4j.Version;
import fuku.skk4j.dic.SKKDic;
import fuku.skk4j.dic.DicUtil;

/**
 * Javaskkdic-sortࡣ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class SKKDicSort {

    /** ץ֥̾ */
    private static final String _PROGRAM = "fuku.skk4j.tool.SKKDicSort";

    /** ޥɥ饤󥪥ץ */
    private static final LongOpt[] _LONGOPT = {
        new LongOpt("help", LongOpt.NO_ARGUMENT, null, 'h'),
        new LongOpt("version", LongOpt.NO_ARGUMENT, null, 'v'),
        new LongOpt("input-encoding", LongOpt.REQUIRED_ARGUMENT, null, 'i'),
        new LongOpt("output-encoding", LongOpt.REQUIRED_ARGUMENT, null, 'o')
    };

    /** ǡ */
    private List _dic = new ArrayList();


    /**
     * ᥤ᥽åɡ
     *
     * @param args ޥɹ԰
     */
    public static void main(String[] args) {
        String enc_in = "EUC_JP";
        String enc_out = "EUC_JP";
        Getopt g = new Getopt(_PROGRAM, args, "i:o:hv", _LONGOPT);
        int c;
        while ((c=g.getopt()) != -1) {
            switch (c) {
                case 'h':
                    _usage(0);
                    break;
                case 'v':
                    _version();
                    break;
                case 'i':
                    enc_in = g.getOptarg();
                    if (enc_in == null) {
                        enc_in = "EUC_JP";
                    }
                    break;
                case 'o':
                    enc_out = g.getOptarg();
                    if (enc_out == null) {
                        enc_out = "EUC_JP";
                    }
                    break;
                default:
                    _usage(1);
            }
        }

        String infile = null;
        String outfile = null;
        int idx = g.getOptind();
        if (idx+2 == args.length) {
            infile = args[idx];
            outfile = args[idx+1];
        } else if (idx+2 > args.length) {
            System.err.println(_PROGRAM + ": don't specified filename");
            _usage(1);
        } else {
            System.err.println(_PROGRAM + ": too many arguments");
            _usage(1);
        }

        SKKDicSort myself = new SKKDicSort();
        myself._load(infile, enc_in);
        myself._sort(enc_out);
        myself._store(outfile, enc_out);
    }


    /**
     * ˡɽޤ
     *
     * @param status λơ
     */
    private static final void _usage(int status) {
        if (status != 0) {
            System.out.println("Try `java " + _PROGRAM + " --help' for more information");
        } else {
            System.out.println("Usage: java " + _PROGRAM + " [option...] input-file output-file");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("  -i ENCODING, --input-encoding=ENCODING");
            System.out.println("                             encoding of input file (default: EUC_JP)");
            System.out.println("  -o ENCODING, --output-encoding=ENCODING");
            System.out.println("                             encoding of output file (default: EUC_JP)");
            System.out.println("  -h, --help                 display this help and exit");
            System.out.println("  -v, --version              output version information and exit");
            System.out.println("");
            System.out.println("Argument:");
            System.out.println("  input-file                 input file name");
            System.out.println("  output-file                output file name");
            System.out.println("");
            System.out.println("Report bugs to <" + Version.EMAIL + ">.");
        }
        System.exit(status);
    }

    /**
     * Сɽޤ
     *
     */
    private static final void _version() {
        System.out.println(_PROGRAM + " " + Version.VERSION);
        System.out.println(Version.COPYRIGHT);
        System.out.println("All right reserved.");
        System.exit(0);
    }


    /**
     * ǥեȥ󥹥ȥ饯
     *
     */
    private SKKDicSort() {
        super();
    }


    /**
     * Ƥɤ߹ߤޤ
     *
     * @param filename ɤ߹߸ե̾ (nullɸ)
     * @param enc ʸ󥳡ǥ󥰤̾
     */
    private void _load(String filename, String enc) {
        _dic.clear();
        BufferedReader in = null;
        String line = null;
        try {
            if (filename == null) {
                in = new BufferedReader(new InputStreamReader(System.in,enc));
            } else {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(filename),enc));
            }
            while ((line=in.readLine()) != null) {
                // ȡԤ̵
                if (line.startsWith(";;") || line.length() == 0) {
                    continue;
                }
                _dic.add(line);
            }
        } catch (IOException e) {
            System.err.println(_PROGRAM + ": " + e.getMessage());
            _dic.clear();
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    System.err.println(_PROGRAM + ": " + e.getMessage());
                }
            }
        }
    }

    /**
     * ȷ̤񤭽Фޤ
     *
     * @param filename ν񤭽Фե̾ (nullɸ)
     * @param enc ʸ󥳡ǥ󥰤̾
     */
    private void _store(String filename, String enc) {
        boolean okuriAri = true;
        BufferedWriter out = null;
        try {
            if (filename == null) {
                out = new BufferedWriter(new OutputStreamWriter(System.out,enc));
            } else {
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename),enc));
            }
            out.write(SKKDic.OKURI_ARI+"\n");
            int size = _dic.size();
            for (int i=0; i<size; i++) {
                String str = (String)_dic.get(i);
                if (okuriAri) {
                    int idx = str.indexOf(' ');
                    String yomi = null;
                    if (idx != -1) {
                        yomi = str.substring(0, idx);
                    } else {
                        yomi = str;
                    }
                    if (!DicUtil.isOkuriAri(yomi)) {
                        out.write(SKKDic.OKURI_NASI+"\n");
                        okuriAri = false;
                    }
                }
                out.write(str+"\n");
            }
        } catch (IOException e) {
            System.err.println(_PROGRAM + ": " + e.getMessage());
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                    System.err.println(_PROGRAM + ": " + e.getMessage());
                }
            }
        }
    }

    /**
     * ɤ߹ꤵ줿󥳡ɷǥȤޤ
     *
     * @param enc ʸ󥳡ǥ󥰤̾
     */
    private void _sort(String enc) {
        _quickSort(0, _dic.size()-1, enc);
    }

    /**
     * ɤ߹ꤵ줿󥳡ɷǥȤޤ
     *
     * @param start ȳϰ
     * @param end Ƚλ
     * @param enc ʸ󥳡ǥ󥰤̾
     */
    private void _quickSort(int start, int end, String enc) {
        int i = start;
        int j = end;

        if (end > start) {
            String middle = _getYomi((start+end)/2);

            // ͤ礭ͤȾءͤȾذư
            while (i <= j) {
                String low = _getYomi(i);
                while (i < end && _compare(low,middle,enc) < 0) {
                    i++;
                    low = _getYomi(i);
                }
                String high = _getYomi(j);
                while (j > start && _compare(high,middle,enc) > 0) {
                    j--;
                    high = _getYomi(j);
                }
                if (i <= j) {
                    Collections.swap(_dic, i, j);
                    i++;
                    j--;
                }
            }

            // ƵŪ˽
            if (start < j) {
                _quickSort(start, j, enc);
            }
            if (i < end) {
                _quickSort(i, end, enc);
            }
        }
    }

    /**
     * ǥåǻꤵͤɤߤڤФޤ
     *
     * @param i ǥå
     * @return ǥåǻꤵͤɤ
     */
    private String _getYomi(int i) {
        String str = (String)_dic.get(i);
        int j = str.indexOf(' ');
        if (j != -1) {
            return str.substring(0, j);
        }
        return str;
    }

    /**
     * ĤʸӤޤ
     *
     * @param str1 ʸ1
     * @param str2 ʸ2
     * @param enc ʸ󥳡ǥ󥰤̾
     * @return Ĥʸ0
     *         str1str2꼭񼰤˾0꾮͡
     *         str1star2꼭񼰤礭0礭֤ͤ
     *         ʤ겾̾ͭʸΤۤ񼰤˾
     *         겾̾ͭʸӤϼ񼰤˵դͤˤʤ롣
     */
    private int _compare(String str1, String str2, String enc) {
        if (DicUtil.isOkuriAri(str1)) {
            if (DicUtil.isOkuriAri(str2)) {
                return DicUtil.compare(str2, str1, enc); // reverse
            } else {
                return -1;
            }
        }

        if (DicUtil.isOkuriAri(str2)) {
            return 1;
        }

        return DicUtil.compare(str1, str2, enc);
    }
}

// end of SKKDicSort.java
