/* # skkinput (Simple Kana-Kanji Input)
 * commondef.h
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef commondef_h
#define commondef_h

/*
 * $BDj?t$NDj5A!#(B
 */
/* skkinput $B$,4IM}$7$F$$$k%P%C%U%!$NMFNL!#(B*/
#define TEXTBUFSIZE		(512)
#define BUFSIZE			(TEXTBUFSIZE)
/* skkserv $B$H$N%3%_%e%K%1!<%7%g%s$K;H$&%P%C%U%!$NMFNL!#(B*/
#define TRANSBUFSIZE		(TEXTBUFSIZE)
/* skkinput $B$,4IM}$G$-$k:GBg$NJ8;zNs!#$3$NCf$GJQ49:n6H$r$9$k$3$H$K$J$k!#(B*/
#define TEXTMAXLEN		(TEXTBUFSIZE-1)
/* skkinput $B$,(B X11 $B$+$i(B XLookupString $B$r;H$C$F!"FI$_9~$`:]$N%P%C%U%!$NMFNL!#(B*/
#define STRBUFSIZE		(10)
/* $B%m!<%^;z2>L>JQ49$r9T$&;~$K2DG=$J%m!<%^;z$ND9$5$N:GBgCM!#(B*/
#define MAX_PREFIX_LENGTH	(4)
/* $B;HMQ2DG=$J:GBg$N%^!<%+$N?t!#(B*/
#define MAXMARKERNUM		(15)

#ifndef True
#define True	(1)
#define False	(0)
#endif
#define ENDOFTBL	(0)
#ifndef ERR
#define	ERR	(-1)
#endif

/*
 * file-coding-system
 */
enum {
  CODING_SYSTEM_IS_EUC = 0, CODING_SYSTEM_IS_JIS,
} ;

/*
 * $B6&DL$KMxMQ$5$l$k%^%/%m!#(B
 */
#define baisuu(a,b)	((a) - ((a)%(b)))
#define swap_int(a,b)	do { int tmp ; tmp = (b) ; (b) = (a) ; (a) = tmp ; } while( 0 )
#endif
