/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (TLispClient_h)
#define	TLispClient_h

#include "lmachine.h"
#include "lispmgr.h"

/*
 *	LispMachine  Client ñ̤Ǥ¸ߤʤ
 *	Frame ̤ Client ñ̤¸ߤȤ櫓ǤϤʤ
 *	Minibuffer Window Ȥ Frame Ϥ줾졣
 */
struct tagTLispClient {
	struct tagTLispMachine*	m_pLM ;		/* Lisp Machine */
	Boolean					m_fModify ;
	struct tagTLispClient*	m_pNext ;
} ;

typedef	struct tagTLispClient	TLispClient ;

typedef struct tagTLispClientArg {
	TLispManager*	m_pLispMgr ;
	TLispMachine*	m_pLM ;
	void*			m_pvClient ;
	void			(*m_pKeyNotify)() ;
	void			(*m_pTextNotify)() ;
	void			(*m_pEndNotify)() ;
	Widget			m_wgFrame ;
	Widget			m_wgMinibufFrame ;
}	TLispClientArg ;

void	TLispClient_MainLoop			(XtAppContext, TLispMachine*, int (*)(void)) ;
Boolean	TLispClient_ClassInitialize		(TLispManager**, TLispMachine**, const char*, const char*, int, Boolean) ;
void	TLispClient_ClassFinalize		(TLispMachine*) ;
void	TLispClient_PreInitialize 		(TLispClient*) ;
Boolean	TLispClient_Initialize 			(TLispClient*, TLispClientArg*) ;
void	TLispClient_Uninitialize 		(TLispClient*) ;
void	TLispClient_Reinitialize		(TLispClient*) ;
Boolean	TLispClient_Tick				(TLispClient*) ;
Boolean	TLispClient_Modifiedp			(TLispClient*) ;
void	TLispClient_Activate			(TLispClient*, Boolean) ;
void	TLispClient_SetModificationFlag	(TLispClient*, Boolean) ;

#endif

